/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.sib.wsn;

import com.ibm.websphere.sib.wsn.ElementAndText;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.wsn.WSNConstants;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;

public class TopicExpression {
    public static final URI SIMPLE_TOPIC_EXPRESSION = TopicExpression.getURI("http://docs.oasis-open.org/wsn/t-1/TopicExpression/Simple");
    public static final URI CONCRETE_TOPIC_PATH_EXPRESSION = TopicExpression.getURI("http://docs.oasis-open.org/wsn/t-1/TopicExpression/Concrete");
    public static final URI FULL_TOPIC_PATH_EXPRESSION = TopicExpression.getURI("http://docs.oasis-open.org/wsn/t-1/TopicExpression/Full");
    protected URI dialect;
    protected String topic;
    protected SOAPElement elementContent;
    protected ElementAndText mixedContent;
    protected Map prefixNSMappings = new HashMap();
    protected Map attributes = new HashMap();

    public TopicExpression() {
    }

    public TopicExpression(URI uRI, String string) {
        this(uRI, string, null);
    }

    public TopicExpression(URI uRI, String string, Map map) {
        this.dialect = uRI;
        this.topic = string;
        if (map != null) {
            this.prefixNSMappings.putAll(map);
        }
    }

    public TopicExpression(URI uRI, SOAPElement sOAPElement) {
        this(uRI, sOAPElement, null);
    }

    public TopicExpression(URI uRI, SOAPElement sOAPElement, Map map) {
        this.dialect = uRI;
        this.elementContent = sOAPElement;
        if (map != null) {
            this.prefixNSMappings.putAll(map);
        }
    }

    public TopicExpression(URI uRI, ElementAndText elementAndText) {
        this(uRI, elementAndText, null);
    }

    public TopicExpression(URI uRI, ElementAndText elementAndText, Map map) {
        this.dialect = uRI;
        this.mixedContent = elementAndText;
        if (map != null) {
            this.prefixNSMappings.putAll(map);
        }
    }

    public URI getDialect() {
        return this.dialect;
    }

    public void setDialect(URI uRI) {
        this.dialect = uRI;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String string, Map map) {
        this.topic = string;
        this.elementContent = null;
        this.mixedContent = null;
        if (map != null) {
            this.prefixNSMappings.clear();
            this.prefixNSMappings.putAll(map);
        }
    }

    public SOAPElement getTopicIfElement() {
        return this.elementContent;
    }

    public void setTopicAsElement(SOAPElement sOAPElement, Map map) {
        this.elementContent = sOAPElement;
        this.topic = null;
        this.mixedContent = null;
        if (map != null) {
            this.prefixNSMappings.clear();
            this.prefixNSMappings.putAll(map);
        }
    }

    public ElementAndText getTopicIfMixed() {
        return this.mixedContent;
    }

    public void setTopicAsMixed(ElementAndText elementAndText, Map map) {
        this.mixedContent = elementAndText;
        this.topic = null;
        this.elementContent = null;
        if (map != null) {
            this.prefixNSMappings.clear();
            this.prefixNSMappings.putAll(map);
        }
    }

    public Iterator getNamespacePrefixes() {
        return this.prefixNSMappings.keySet().iterator();
    }

    public Map getNamespacePrefixesMap() {
        return this.prefixNSMappings;
    }

    public String getNamespaceForPrefix(String string) {
        return (String)this.prefixNSMappings.get(string);
    }

    public void addPrefixMapping(String string, String string2) {
        this.prefixNSMappings.put(string, string2);
    }

    public void addAttribute(Name name, String string) throws Exception {
        this.attributes.put(name, string);
    }

    public Iterator getAttributes() {
        return this.attributes.keySet().iterator();
    }

    public String getAttributeValue(Name name) {
        return (String)this.attributes.get(name);
    }

    private static URI getURI(String string) {
        try {
            return new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            FFDCFilter.processException((Throwable)uRISyntaxException, (String)"com.ibm.websphere.sib.wsn.TopicExpression.getURI", (String)"183");
            throw new IllegalArgumentException(WSNConstants.TRACE_NLS.getFormattedMessage("INVALID_URI_CWSJN5002", new Object[]{string}, "Invalid URI " + string + " when initializing Dialect constants"));
        }
    }

    public int hashCode() {
        int n = 0;
        if (this.topic != null) {
            n += 11 * this.topic.hashCode();
        }
        if (this.dialect != null) {
            n += 13 * this.dialect.hashCode();
        }
        if (this.attributes != null) {
            n += 17 * ((Object)this.attributes).hashCode();
        }
        if (this.prefixNSMappings != null) {
            n += 19 * ((Object)this.prefixNSMappings).hashCode();
        }
        if (this.elementContent != null) {
            n += 23 * this.elementContent.hashCode();
        }
        if (this.mixedContent != null) {
            n += 29 * this.mixedContent.hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof TopicExpression) {
            TopicExpression topicExpression = (TopicExpression)object;
            if (this.dialect != null ? !this.dialect.equals(topicExpression.dialect) : topicExpression.dialect != null) {
                return false;
            }
            boolean bl = true;
            if (this.topic == null) {
                if (topicExpression.topic != null) {
                    return false;
                }
                if (this.elementContent != topicExpression.elementContent) {
                    return false;
                }
                if (this.mixedContent != topicExpression.mixedContent) {
                    return false;
                }
            } else if (!this.topic.equals(topicExpression.topic)) {
                bl = false;
            }
            String string = null;
            String string2 = null;
            int n = -1;
            if (this.topic != null) {
                n = this.topic.indexOf(":");
                if (n != -1) {
                    string = this.topic.substring(0, n);
                    string2 = this.topic.substring(n + 1);
                } else {
                    string = "";
                    string2 = this.topic;
                }
            } else {
                string = "";
                string2 = "";
            }
            String string3 = (String)this.prefixNSMappings.get(string);
            String string4 = null;
            if (bl) {
                string4 = (String)topicExpression.prefixNSMappings.get(string);
            } else {
                String string5 = null;
                String string6 = null;
                if (topicExpression.topic != null) {
                    int n2 = -1;
                    n2 = topicExpression.topic.indexOf(":");
                    if (n2 != -1) {
                        string5 = topicExpression.topic.substring(0, n2);
                        string6 = topicExpression.topic.substring(n2 + 1);
                    } else {
                        string5 = "";
                        string6 = topicExpression.topic;
                    }
                } else {
                    string5 = "";
                    string6 = "";
                }
                if (string2 == null || !string2.equals(string6)) {
                    return false;
                }
                string4 = (String)topicExpression.prefixNSMappings.get(string5);
            }
            if (!(string3 == null && string4 == null || "".equals(string3) && string4 == null || "".equals(string3) && "".equals(string4) || string3 == null && "".equals(string4) || string3 != null && string3.equals(string4))) {
                return false;
            }
            return ((Object)this.attributes).equals(topicExpression.attributes);
        }
        return false;
    }

    public String toString() {
        return this.getClass().getName() + "{" + "topic=" + this.topic + ", " + "dialect=" + this.dialect + ", " + "elementContent=" + this.elementContent + ", " + "mixedContent=" + this.mixedContent + ", " + "prefixMappings=" + this.prefixNSMappings + ", " + "attributes=" + this.attributes + "}";
    }
}

