/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.sib.wsn;

import com.ibm.websphere.sib.wsn.ElementAndText;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.wsn.WSNConstants;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.soap.SOAPElement;

public class QueryExpression {
    public static final URI XPATH_VERSION_1 = QueryExpression.getURI("http://www.w3.org/TR/1999/REC-xpath-19991116");
    protected URI dialect;
    protected SOAPElement expression;
    protected String textExpression;
    protected ElementAndText mixedExpression;
    protected Map prefixNSMappings = new HashMap();

    public QueryExpression() {
    }

    public QueryExpression(URI uRI, String string) {
        this(uRI, string, null);
    }

    public QueryExpression(URI uRI, String string, Map map) {
        this.dialect = uRI;
        this.textExpression = string;
        if (map != null) {
            this.prefixNSMappings.putAll(map);
        }
    }

    public QueryExpression(URI uRI, SOAPElement sOAPElement) {
        this(uRI, sOAPElement, null);
    }

    public QueryExpression(URI uRI, SOAPElement sOAPElement, Map map) {
        this.dialect = uRI;
        this.expression = sOAPElement;
        if (map != null) {
            this.prefixNSMappings.putAll(map);
        }
    }

    public QueryExpression(URI uRI, ElementAndText elementAndText) {
        this(uRI, elementAndText, null);
    }

    public QueryExpression(URI uRI, ElementAndText elementAndText, Map map) {
        this.dialect = uRI;
        this.mixedExpression = elementAndText;
        if (map != null) {
            this.prefixNSMappings.putAll(map);
        }
    }

    public URI getDialect() {
        return this.dialect;
    }

    public void setDialect(URI uRI) {
        this.dialect = uRI;
    }

    public SOAPElement getExpressionContents() {
        return this.expression;
    }

    public void setExpressionContents(SOAPElement sOAPElement) {
        this.expression = sOAPElement;
        this.textExpression = null;
        this.mixedExpression = null;
    }

    public String getExpressionContentsIfText() {
        return this.textExpression;
    }

    public void setExpressionContentsAsText(String string) {
        this.textExpression = string;
        this.expression = null;
        this.mixedExpression = null;
    }

    public ElementAndText getExpressionContentsIfMixed() {
        return this.mixedExpression;
    }

    public void setExpressionContentsAsMixed(ElementAndText elementAndText) {
        this.mixedExpression = elementAndText;
        this.textExpression = null;
        this.expression = null;
    }

    public Iterator getNamespacePrefixes() {
        return this.prefixNSMappings.keySet().iterator();
    }

    public Map getNamespacePrefixesMap() {
        return this.prefixNSMappings;
    }

    public String getNamespaceForPrefix(String string) {
        return (String)this.prefixNSMappings.get(string);
    }

    public void addPrefixMapping(String string, String string2) {
        this.prefixNSMappings.put(string, string2);
    }

    private static URI getURI(String string) {
        try {
            return new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            FFDCFilter.processException((Throwable)uRISyntaxException, (String)"com.ibm.websphere.sib.wsn.QueryExpression.getURI", (String)"1:305:1.9");
            throw new IllegalArgumentException(WSNConstants.TRACE_NLS.getFormattedMessage("INVALID_URI_CWSJN5098", new Object[]{string}, "Invalid URI " + string + " when initializing Dialect constant"));
        }
    }
}

