/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.sib.api.jms;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.api.jms.JmsConnectionFactory;
import com.ibm.websphere.sib.api.jms.JmsQueue;
import com.ibm.websphere.sib.api.jms.JmsQueueConnectionFactory;
import com.ibm.websphere.sib.api.jms.JmsTopic;
import com.ibm.websphere.sib.api.jms.JmsTopicConnectionFactory;
import javax.jms.ConnectionMetaData;
import javax.jms.JMSException;

public abstract class JmsFactoryFactory {
    private static TraceComponent tcInt = Tr.register(JmsFactoryFactory.class, "SIBJms_Internal", "com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    private static TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    private static JmsFactoryFactory instance;

    public static synchronized JmsFactoryFactory getInstance() throws JMSException {
        if (tcInt.isEntryEnabled()) {
            Tr.entry(tcInt, "getInstance");
        }
        if (instance == null) {
            try {
                Class<?> clazz = Class.forName("com.ibm.ws.sib.api.jms.impl.JmsFactoryFactoryImpl");
                instance = (JmsFactoryFactory)clazz.newInstance();
            }
            catch (Exception exception) {
                if (tcInt.isDebugEnabled()) {
                    Tr.debug(tcInt, "Unable to instantiate JmsFactoryFactory", exception);
                }
                if (tcInt.isEntryEnabled()) {
                    Tr.exit(tcInt, "getInstance");
                }
                instance = null;
                JMSException jMSException = new JMSException(nls.getFormattedMessage("UNABLE_TO_CREATE_FACTORY_CWSIA0001", new Object[]{"JmsFactoryFactoryImpl", "sib.api.jmsImpl.jar"}, "!!!Unable to instantiate JmsFactoryFactoryImpl"));
                jMSException.setLinkedException(exception);
                jMSException.initCause(exception);
                throw jMSException;
            }
        }
        if (tcInt.isEntryEnabled()) {
            Tr.exit(tcInt, "getInstance");
        }
        return instance;
    }

    public abstract JmsConnectionFactory createConnectionFactory() throws JMSException;

    public abstract JmsQueueConnectionFactory createQueueConnectionFactory() throws JMSException;

    public abstract JmsTopicConnectionFactory createTopicConnectionFactory() throws JMSException;

    public abstract JmsQueue createQueue(String var1) throws JMSException;

    public abstract JmsTopic createTopic(String var1) throws JMSException;

    public abstract ConnectionMetaData getMetaData() throws JMSException;

    static {
        if (tcInt.isDebugEnabled()) {
            Tr.debug(tcInt, "Source info: @(#)SIB/ws/code/sib.api.jms/src/com/ibm/websphere/sib/api/jms/JmsFactoryFactory.java, SIB.api.jms, WAS70.SIB, o0833.54 1.32");
        }
        instance = null;
    }
}

