/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.servlet.response;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.websphere.servlet.error.ServletErrorReport;
import com.ibm.websphere.servlet.response.DummyResponse;
import com.ibm.websphere.servlet.response.HttpServletResponseProxy;
import com.ibm.websphere.servlet.response.IResponse;
import com.ibm.websphere.servlet.response.ResponseErrorReport;
import com.ibm.websphere.servlet.response.StoredHeader;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.servlet.IncludedResponse;
import com.ibm.ws.webcontainer.srt.SRTOutputStream;
import com.ibm.ws.webcontainer.srt.SRTServletResponse;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.servlet.IExtendedResponse;
import com.ibm.wsspi.webcontainer.servlet.IOutputMethodListener;
import com.ibm.wsspi.webcontainer.util.ByteBufferOutputStream;
import com.ibm.wsspi.webcontainer.util.EncodingUtils;
import com.ibm.wsspi.webcontainer.util.IOutputStreamObserver;
import com.ibm.wsspi.webcontainer.util.IResponseOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoredResponse
extends HttpServletResponseWrapper
implements HttpServletResponse,
Serializable,
IResponseOutput,
IExtendedResponse,
IOutputStreamObserver {
    private static final long serialVersionUID = 3257847662609707832L;
    protected static Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.websphere.servlet.response");
    private static final String CLASS_NAME = "com.ibm.websphere.servlet.response.StoredResponse";
    protected static final NLS nls = new NLS("com.ibm.ws.webcontainer.resources.Messages");
    private static final int DEFAULT_STATUS_CODE = 200;
    protected PrintWriter _writer;
    protected SRTOutputStream _out;
    protected ByteBufferOutputStream _bbOut;
    private boolean _isFinished;
    private byte[] _outputBuffer;
    private int _statusCode = 200;
    private String _statusMessage;
    private String _redirectURI;
    private Cookie[] _cookies = new Cookie[0];
    private long _lastModified;
    private ResponseErrorReport _error;
    private StoredHeader _header;
    protected boolean _writerObtained = false;
    protected boolean _outputStreamObtained = false;
    private static final String _defaultEncoding = "ISO-8859-1";
    private String _contentType = null;
    private String _encoding;
    private Locale _locale;
    private Locale _defaultLocale;
    protected int bufferSize = 4096;
    private boolean isCommitted = false;
    private List<WsByteBuffer> _bbList = null;
    private IOutputMethodListener outputMethodListener;
    private boolean isInclude = false;
    private Vector[] headerTable;
    protected boolean outputWritten;
    private boolean internalHeaderSettable;
    private boolean outputFlushed;
    private boolean finishedOutput;
    private boolean dummyResponse = true;
    private IExtendedResponse extResponse;

    public StoredResponse() {
        super(new DummyResponse());
        this.init();
    }

    public StoredResponse(boolean bl) {
        super(new DummyResponse());
        this.isInclude = bl;
        this.init();
    }

    public StoredResponse(IExtendedResponse iExtendedResponse, boolean bl) {
        super((HttpServletResponse)((Object)iExtendedResponse));
        this.extResponse = iExtendedResponse;
        this.dummyResponse = false;
        this.isInclude = bl;
        this.init();
    }

    private void init() {
        if (this.dummyResponse) {
            this._header = new StoredHeader();
        }
        if (!this.isInclude) {
            this.setContentType("text/html");
            this._encoding = _defaultEncoding;
            this._locale = this._defaultLocale = Locale.getDefault();
        }
    }

    private void initOutputStream() {
        this._bbOut = new ByteBufferOutputStream();
        this._out = new SRTOutputStream();
        this._out.init(this._bbOut);
        this._bbOut.setObserver(this);
    }

    @Override
    public boolean writerObtained() {
        return this._writerObtained;
    }

    @Override
    public boolean outputStreamObtained() {
        return this._outputStreamObtained;
    }

    @Override
    public void addCookie(Cookie cookie) {
        if (!this.dummyResponse) {
            super.addCookie(cookie);
        } else if (this.isInclude) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "addCookie", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "addCookie cookie --> " + cookie.getName());
            }
        } else {
            Cookie[] cookieArray = new Cookie[this._cookies.length + 1];
            System.arraycopy(this._cookies, 0, cookieArray, 0, this._cookies.length);
            cookieArray[this._cookies.length] = cookie;
            this._cookies = cookieArray;
        }
    }

    @Override
    public IResponse getIResponse() {
        if (!this.dummyResponse) {
            return this.extResponse.getIResponse();
        }
        return null;
    }

    @Override
    public ServletOutputStream getOutputStream() throws IllegalStateException, IOException {
        if (this._writerObtained) {
            throw new IllegalStateException("Writer as already been obtained for this Response object");
        }
        if (this._outputStreamObtained) {
            return this._out;
        }
        this.initOutputStream();
        this._outputStreamObtained = true;
        this.fireOutputStreamRetrievedEvent(this._out);
        return this._out;
    }

    @Override
    public void setContentLength(int n) {
        if (!this.dummyResponse) {
            super.setContentLength(n);
        } else if (this.isInclude) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setContentLength", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "setContentLength length --> " + n);
            }
        } else {
            this.setIntHeader("content-length", n);
        }
    }

    @Override
    public void setContentType(String string) {
        if (!this.dummyResponse) {
            super.setContentType(string);
        } else if (this.isInclude) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setContentType", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "setContentType type --> " + string);
            }
        } else {
            this.setHeader("content-type", string);
        }
    }

    @Override
    public void setBufferSize(int n) throws IllegalStateException {
        if (this._writer != null) {
            this._writer.flush();
        }
        if (this._bbOut != null) {
            this._bbOut.reset();
        }
        if (this.outputWritten) {
            throw new IllegalStateException("Cannot set buffer size after write");
        }
        if (!this.dummyResponse) {
            super.setBufferSize(n);
        } else {
            this.bufferSize = n;
        }
    }

    @Override
    public int getBufferSize() {
        if (!this.dummyResponse) {
            return super.getBufferSize();
        }
        return this.bufferSize;
    }

    @Override
    public void flushBuffer() throws IOException {
        this.flushBuffer(true);
    }

    @Override
    public void flushBuffer(boolean bl) throws IOException {
        if (this._writer != null) {
            this._writer.flush();
        }
        if (this._out != null) {
            this._out.flush();
        }
        this.isCommitted = true;
    }

    @Override
    public boolean isCommitted() {
        return this.isCommitted;
    }

    @Override
    public void reset() throws IllegalStateException {
        if (this.isCommitted) {
            throw new IllegalStateException("Response cannot be reset after it has been committed");
        }
        if (!this.dummyResponse) {
            super.reset();
        }
        if (this._writer != null) {
            this._writer.flush();
        }
        if (this._bbOut != null) {
            this._bbOut.reset();
        }
        this.isCommitted = false;
    }

    @Override
    public Vector[] getHeaderTable() {
        if (!this.dummyResponse) {
            return this.extResponse.getHeaderTable();
        }
        return this.headerTable;
    }

    @Override
    public void addSessionCookie(Cookie cookie) {
        if (this.dummyResponse) {
            if (this.isInclude) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "addSessionCookie", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "addSessionCookie cookie --> " + cookie);
                }
                throw new IllegalStateException("cannot add session from a stored/async response");
            }
            throw new IllegalStateException("This method is not supported, use HttpServletResponse.addCookie(Cookie cookie) instead");
        }
        this.extResponse.addSessionCookie(cookie);
    }

    @Override
    public void setLocale(Locale locale) {
        if (!this.dummyResponse) {
            super.setLocale(locale);
        } else if (this.isInclude) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setLocale", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "setLocale locale --> " + locale);
            }
        } else {
            this._locale = locale;
            this.setCharacterEncoding(EncodingUtils.getEncodingFromLocale(this._locale));
        }
    }

    @Override
    public void setCharacterEncoding(String string) {
        if (!this.dummyResponse) {
            super.setCharacterEncoding(string);
        } else if (this.isInclude) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setCharacterEncoding", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "setCharacterEncoding encoding --> " + string);
            }
        } else {
            if (string != null) {
                if (string.startsWith("\"") || string.startsWith("'")) {
                    string = string.substring(1);
                }
                if (string.endsWith("\"") || string.endsWith("'")) {
                    string = string.substring(0, string.length() - 1);
                }
            }
            this._encoding = string;
        }
    }

    @Override
    public Locale getLocale() {
        if (!this.dummyResponse) {
            return super.getLocale();
        }
        return this._locale;
    }

    @Override
    public void addDateHeader(String string, long l) {
        if (!this.dummyResponse) {
            super.addDateHeader(string, l);
        } else if (this.isInclude && TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "addDateHeader", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "name->" + string + ", date->" + l);
        }
    }

    @Override
    public void addHeader(String string, String string2) {
        if (!this.dummyResponse) {
            super.addHeader(string, string2);
        } else if (this.isInclude && TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "addHeader", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "name->" + string + ", value->" + string2);
        }
    }

    @Override
    public void addIntHeader(String string, int n) {
        if (!this.dummyResponse) {
            super.addIntHeader(string, n);
        } else if (this.isInclude && TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "addIntHeader", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "name->" + string + ", value->" + n);
        }
    }

    @Override
    public void setHeader(String string, String string2) {
        this.setHeader(string, string2, true);
    }

    @Override
    public void setInternalHeader(String string, String string2) {
        if (!this.internalHeaderSettable) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setInternalHeader", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "name->" + string + ", value->" + string2);
            }
        } else {
            this.setHeader(string, string2, false);
        }
    }

    @Override
    public void setHeader(String string, String string2, boolean bl) {
        if (bl && this.isInclude) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setHeader", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "name->" + string + ", value->" + string2 + ", checkInclude->" + bl);
            }
        } else if (!this.dummyResponse) {
            this.extResponse.setHeader(string, string2, false);
            if (string.equalsIgnoreCase("content-type")) {
                this._encoding = super.getCharacterEncoding();
            }
        } else {
            this._header.setHeader(string, string2);
            if (string.toLowerCase().equals("content-type")) {
                String string3;
                int n;
                if (string2 != null && (n = (string3 = string2.toLowerCase()).indexOf("charset=")) != -1) {
                    String string4 = string3.substring(n + 8);
                    if (string4.startsWith("\"") || string4.startsWith("'")) {
                        string4 = string4.substring(1);
                    }
                    if (string4.endsWith("\"") || string4.endsWith("'")) {
                        string4 = string4.substring(0, string4.length() - 1);
                    }
                    this.setCharacterEncoding(string4);
                    string2 = string3.substring(0, n + 8) + string4;
                }
                this._contentType = string2;
            }
        }
    }

    @Override
    public void setIntHeader(String string, int n) {
        if (this.isInclude) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setIntHeader", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "name->" + string + ", value->" + n);
            }
        } else {
            this._header.setIntHeader(string, n);
        }
    }

    @Override
    public void setDateHeader(String string, long l) {
        if (this.isInclude) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setDateHeader", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "name->" + string + ", value->" + l);
            }
        } else {
            this._header.setDateHeader(string, l);
        }
    }

    @Override
    public boolean containsHeader(String string) {
        if (!this.dummyResponse) {
            return super.containsHeader(string);
        }
        if (!this.isInclude && this._header != null) {
            return this._header.containsHeader(string);
        }
        if (this.headerTable != null) {
            for (int i = 0; i < this.headerTable.length; ++i) {
                if (!this.headerTable[i].contains(string)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public PrintWriter getWriter() throws IOException, IllegalStateException {
        if (this._outputStreamObtained) {
            throw new IllegalStateException("OutputStream already obtained for this Response object");
        }
        if (this._writerObtained) {
            return this._writer;
        }
        this.initOutputStream();
        OutputStreamWriter outputStreamWriter = null;
        try {
            String string = this.getCharacterEncoding();
            outputStreamWriter = string == null ? new OutputStreamWriter(this._out) : new OutputStreamWriter((OutputStream)this._out, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.websphere.servlet.response.StoredResponse.getWriter", (String)"248", (Object)this);
            outputStreamWriter = new OutputStreamWriter(this._out);
        }
        this._writer = new PrintWriter(outputStreamWriter);
        outputStreamWriter = null;
        this._writerObtained = true;
        this.fireWriterRetrievedEvent(this._writer);
        return this._writer;
    }

    @Override
    public void setStatus(int n) {
        if (this.isInclude) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setStatus", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "status->" + n);
            }
        } else {
            this._statusCode = n;
        }
    }

    @Override
    public void setStatus(int n, String string) {
        if (this.isInclude) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setStatus", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "status->" + n + ", message->" + string);
            }
        } else {
            this._statusCode = n;
            this._statusMessage = string;
        }
    }

    @Override
    public void sendError(int n) throws IOException {
        if (!this.dummyResponse) {
            super.sendError(n);
        } else if (this.isInclude) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "sendError", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "status->" + n);
            }
        } else {
            this._error = new ResponseErrorReport();
            this._error.setErrorCode(n);
        }
    }

    @Override
    public void sendError(int n, String string) throws IOException {
        if (!this.dummyResponse) {
            super.sendError(n, string);
        } else if (this.isInclude) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "sendError", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "status->" + n + ", message->" + string);
            }
        } else {
            this._error = new ResponseErrorReport(string);
            this._error.setErrorCode(n);
        }
    }

    @Override
    public String encodeURL(String string) {
        if (!this.dummyResponse) {
            return super.encodeURL(string);
        }
        return string;
    }

    @Override
    public String encodeUrl(String string) {
        if (!this.dummyResponse) {
            return super.encodeUrl(string);
        }
        return this.encodeUrl(string);
    }

    @Override
    public void sendRedirect(String string) throws IOException {
        if (this.isInclude) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "sendRedirect", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "uri->" + string);
            }
        } else {
            this._redirectURI = string;
        }
    }

    @Override
    public void sendRedirect303(String string) throws IOException {
        if (this.isInclude) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "sendRedirect303", nls.getString("Illegal.from.included.servlet", "Illegal from included servlet"), "uri->" + string);
            }
        } else {
            this._redirectURI = string;
        }
    }

    @Override
    public String encodeRedirectURL(String string) {
        if (!this.dummyResponse) {
            return super.encodeRedirectURL(string);
        }
        return string;
    }

    @Override
    public String encodeRedirectUrl(String string) {
        if (!this.dummyResponse) {
            return super.encodeRedirectUrl(string);
        }
        return string;
    }

    protected void finishOutput(boolean bl) throws IOException {
        if (!this.finishedOutput) {
            this.finishedOutput = true;
            if (this._writer != null) {
                this._writer.flush();
            }
            if (this._out != null) {
                this._out.close();
                this._bbOut.flushBuffer();
                if (bl) {
                    this._outputBuffer = this._bbOut.toByteArray();
                }
                this._bbList = this._bbOut.getByteBufferList();
            }
        }
    }

    @Override
    public void finish() throws IOException {
        this._finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _finish() throws IOException {
        if (this._isFinished) {
            return;
        }
        StoredResponse storedResponse = this;
        synchronized (storedResponse) {
            if (this._isFinished) {
                return;
            }
            this._isFinished = true;
            this.finishOutput(true);
            if (!this.isInclude && this._outputBuffer != null) {
                this.setContentLength(this._outputBuffer.length);
            }
            if (this._header != null) {
                this._lastModified = this._header.getDateHeader("last-modified");
            }
            this._writer = null;
            this._out = null;
            this._bbOut = null;
        }
    }

    public void close() throws IOException {
        this._finish();
    }

    public byte[] getOutputBuffer() throws IOException {
        this.finishOutput(true);
        return this._outputBuffer;
    }

    public List<WsByteBuffer> getByteBufferList() throws IOException {
        this.finishOutput(false);
        return this._bbList;
    }

    public String getOutputBufferAsString() throws IOException {
        byte[] byArray = this.getOutputBuffer();
        if (byArray != null) {
            return new String(byArray, this.getCharacterEncoding());
        }
        return null;
    }

    public Enumeration getHeaderNames() {
        if (this._header != null && this.headerTable != null) {
            InnerEnumeration innerEnumeration = new InnerEnumeration(this._header.getHeaderNames(), this.headerTable[0].elements());
            return innerEnumeration;
        }
        if (this.headerTable != null) {
            return this.headerTable[0].elements();
        }
        if (this._header != null) {
            return this._header.getHeaderNames();
        }
        return null;
    }

    public Enumeration getAddedHeaderNames() {
        if (this._header != null) {
            return this._header.getHeaderNames();
        }
        return null;
    }

    public String getHeader(String string) {
        if (this._header != null) {
            return this._header.getHeader(string);
        }
        return null;
    }

    public int getIntHeader(String string) {
        if (this._header != null) {
            return this._header.getIntHeader(string);
        }
        return -1;
    }

    public long getDateHeader(String string) {
        if (this._header != null) {
            return this._header.getDateHeader(string);
        }
        return -1L;
    }

    public boolean containsError() {
        return this._error != null;
    }

    public ServletErrorReport getError() {
        return this._error;
    }

    public String getErrorMessage() {
        if (this.containsError()) {
            return this.getError().getMessage();
        }
        return null;
    }

    public int getErrorStatusCode() {
        if (!this.containsError()) {
            throw new IllegalStateException("sendError() was not called");
        }
        return this.getError().getErrorCode();
    }

    @Override
    public int getStatusCode() {
        return this._statusCode;
    }

    public String getStatusMessage() {
        return this._statusMessage;
    }

    public String getRedirectURI() {
        if (!this.isRedirected()) {
            throw new IllegalStateException("sendRedirect() was not called");
        }
        return this._redirectURI;
    }

    public boolean isRedirected() {
        return this._redirectURI != null;
    }

    @Override
    public String getCharacterEncoding() {
        if (!this.dummyResponse) {
            return super.getCharacterEncoding();
        }
        return this._encoding;
    }

    @Override
    public String getContentType() {
        if (!this.dummyResponse) {
            return super.getContentType();
        }
        return this._contentType;
    }

    public Cookie[] getCookies() {
        return this._cookies;
    }

    public long getLastModified() {
        return this._lastModified;
    }

    public boolean isExpired() {
        return false;
    }

    public void transferResponse(HttpServletResponse httpServletResponse) throws IOException {
        this._finish();
        if (this.containsError()) {
            String string = this.getErrorMessage();
            int n = this.getErrorStatusCode();
            if (string == null) {
                httpServletResponse.sendError(n);
            } else {
                httpServletResponse.sendError(n, string);
            }
        } else if (this.isRedirected()) {
            Cookie[] cookieArray = this.getCookies();
            for (int i = 0; i < cookieArray.length; ++i) {
                httpServletResponse.addCookie(cookieArray[i]);
            }
            httpServletResponse.sendRedirect(this.getRedirectURI());
        } else {
            ServletOutputStream servletOutputStream;
            if (this.getStatusMessage() == null) {
                httpServletResponse.setStatus(this.getStatusCode());
            } else {
                httpServletResponse.setStatus(this.getStatusCode(), this.getStatusMessage());
            }
            this._header.transferHeader(httpServletResponse);
            Cookie[] cookieArray = this.getCookies();
            for (int i = 0; i < cookieArray.length; ++i) {
                httpServletResponse.addCookie(cookieArray[i]);
            }
            try {
                servletOutputStream = httpServletResponse.getOutputStream();
            }
            catch (IllegalStateException illegalStateException) {
                while (!(httpServletResponse instanceof StoredResponse)) {
                    while (httpServletResponse instanceof HttpServletResponseWrapper) {
                        httpServletResponse = (HttpServletResponse)((HttpServletResponseWrapper)httpServletResponse).getResponse();
                    }
                    while (httpServletResponse instanceof HttpServletResponseProxy) {
                        httpServletResponse = ((HttpServletResponseProxy)httpServletResponse).getProxiedHttpServletResponse();
                    }
                    while (httpServletResponse instanceof IncludedResponse) {
                        httpServletResponse = ((IncludedResponse)httpServletResponse).getProxiedHttpServletResponse();
                    }
                    if (!(httpServletResponse instanceof SRTServletResponse)) continue;
                    httpServletResponse.getWriter().write(this.getOutputBufferAsString().toCharArray());
                    return;
                }
                StoredResponse storedResponse = (StoredResponse)httpServletResponse;
                servletOutputStream = storedResponse._out;
            }
            servletOutputStream.write(this.getOutputBuffer());
        }
    }

    @Override
    public void resetBuffer() {
        if (this._writer != null) {
            this._writer.flush();
        }
        if (this._bbOut != null) {
            this._bbOut.reset();
        }
    }

    @Override
    public void fireOutputStreamRetrievedEvent(ServletOutputStream servletOutputStream) {
        if (this.outputMethodListener != null) {
            this.outputMethodListener.notifyOutputStreamRetrieved(servletOutputStream);
        }
    }

    @Override
    public void fireWriterRetrievedEvent(PrintWriter printWriter) {
        if (this.outputMethodListener != null) {
            this.outputMethodListener.notifyWriterRetrieved(printWriter);
        }
    }

    @Override
    public void registerOutputMethodListener(IOutputMethodListener iOutputMethodListener) {
        this.outputMethodListener = iOutputMethodListener;
    }

    @Override
    public void destroy() {
    }

    @Override
    public void initForNextResponse(IResponse iResponse) {
    }

    @Override
    public void start() {
    }

    public void setInclude(boolean bl) {
        this.isInclude = true;
    }

    public void setInternalHeaderSettable(boolean bl) {
        this.internalHeaderSettable = bl;
    }

    public void buildResponseData(IExtendedResponse iExtendedResponse) {
        this.headerTable = (Vector[])iExtendedResponse.getHeaderTable().clone();
        this.buildWriterData(iExtendedResponse);
        this._contentType = iExtendedResponse.getContentType();
        this._locale = iExtendedResponse.getLocale();
        this._statusCode = iExtendedResponse.getStatusCode();
    }

    public void buildWriterData(IExtendedResponse iExtendedResponse) {
        this.isCommitted = iExtendedResponse.isCommitted();
        this._encoding = iExtendedResponse.getCharacterEncoding();
    }

    @Override
    public void alertClose() {
    }

    @Override
    public void alertException() {
    }

    @Override
    public void alertFirstFlush() {
        this.isCommitted = true;
    }

    @Override
    public void alertFirstWrite() {
        this.outputWritten = true;
    }

    private class InnerEnumeration
    implements Enumeration {
        private Enumeration enum1;
        private Enumeration enum2;

        public InnerEnumeration(Enumeration enumeration, Enumeration enumeration2) {
            this.enum1 = enumeration;
            this.enum2 = enumeration2;
        }

        public boolean hasMoreElements() {
            return this.enum1.hasMoreElements() || this.enum2.hasMoreElements();
        }

        public Object nextElement() {
            if (this.enum1.hasMoreElements()) {
                return this.enum1.nextElement();
            }
            if (this.enum2.hasMoreElements()) {
                return this.enum2.nextElement();
            }
            throw new NoSuchElementException();
        }
    }
}

