/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.servlet.event;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.servlet.event.ServletEvent;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.util.ServletUtil;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class ServletInvocationEvent
extends ServletEvent {
    protected static Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.websphere.servlet.event");
    private static final String CLASS_NAME = "com.ibm.websphere.servlet.event.ServletInvocationEvent";
    private ServletRequest _req;
    private ServletResponse _resp;

    public ServletInvocationEvent(Object object, ServletContext servletContext, String string, String string2, ServletRequest servletRequest, ServletResponse servletResponse) {
        super(object, servletContext, string, string2);
        this._req = servletRequest;
        this._resp = servletResponse;
    }

    public String getRequestURL() {
        HttpServletRequest httpServletRequest = this.getRequest();
        if (httpServletRequest == null) {
            return null;
        }
        return httpServletRequest.getRequestURL().toString();
    }

    public abstract long getResponseTime();

    public HttpServletRequest getRequest() {
        ServletRequest servletRequest = null;
        if (this._req == null) {
            return null;
        }
        try {
            servletRequest = ServletUtil.unwrapRequest(this._req);
        }
        catch (RuntimeException runtimeException) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getRequest", "Caught RuntimeException unwrapping the request", runtimeException);
            }
            return null;
        }
        if (servletRequest instanceof HttpServletRequest) {
            return (HttpServletRequest)servletRequest;
        }
        return null;
    }

    public HttpServletResponse getResponse() {
        ServletResponse servletResponse = null;
        if (this._resp == null) {
            return null;
        }
        try {
            servletResponse = ServletUtil.unwrapResponse(this._resp);
        }
        catch (RuntimeException runtimeException) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getResponse", "Caught RuntimeException unwrapping the response", runtimeException);
            }
            return null;
        }
        if (servletResponse instanceof HttpServletResponse) {
            return (HttpServletResponse)servletResponse;
        }
        return null;
    }

    public void setRequest(HttpServletRequest httpServletRequest) {
        this._req = httpServletRequest;
    }

    public void setResponse(HttpServletResponse httpServletResponse) {
        this._resp = httpServletResponse;
    }
}

