/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.security.auth.callback;

import com.ibm.ISecurityL13SupportImpl.SecurityMessages;
import com.ibm.ISecurityUtilityImpl.RealmSecurityName;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.security.auth.callback.WSRealmNameCallbackImpl;
import com.ibm.ws.security.auth.WSLoginHelperImpl;
import com.ibm.ws.security.common.auth.util.WSStdinLoginPrompt;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class WSStdinCallbackHandlerImpl
implements CallbackHandler {
    private static final String realmNamePrompt = SecurityMessages.getMsgOrUseDefault((String)"RealmName", (String)"Realm (Cell) Name");
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static int stdinRetry = 0;
    private String userName = "";
    private String password = "";
    private String realmName = "";
    private String userNamePrompt = "";
    private String passwordPrompt = "";
    private boolean passwordEcho = false;
    private static final TraceComponent tc = Tr.register(WSStdinCallbackHandlerImpl.class, null, "com.ibm.ejs.resources.security");

    public WSStdinCallbackHandlerImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSStdinCallbackHandlerImpl()");
        }
        this.realmName = WSLoginHelperImpl.getDefaultRealmName();
        if (this.realmName == null || this.realmName.length() == 0) {
            this.realmName = "<default>";
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Realm Name: " + this.realmName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSStdinCallbackHandlerImpl()");
        }
    }

    public WSStdinCallbackHandlerImpl(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSStdinCallbackHandlerImpl(r_name) " + string);
        }
        if (string != null && string.length() != 0) {
            this.realmName = string;
        } else {
            this.realmName = WSLoginHelperImpl.getDefaultRealmName();
            if (this.realmName == null || this.realmName.length() == 0) {
                this.realmName = "<default>";
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSStdinCallbackHandlerImpl(r_name) " + this.realmName);
        }
    }

    public WSStdinCallbackHandlerImpl(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSStdinCallbackHandlerImpl(String, String)", new Object[]{"Default realm: " + string});
        }
        if (string != null && string.length() != 0) {
            this.realmName = string;
        } else {
            this.realmName = WSLoginHelperImpl.getDefaultRealmName();
            if (this.realmName == null || this.realmName.length() == 0) {
                this.realmName = "<default>";
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSStdinCallbackHandlerImpl(String, String) ");
        }
    }

    public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
        int n;
        StringBuffer stringBuffer;
        int n2 = 0;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handle(callbacks)");
        }
        if (callbackArray == null || (n2 = callbackArray.length) == 0) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "handle(callbacks = \"{ }\")");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handle(callbacks)");
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Number of callbacks: " + n2);
            stringBuffer = new StringBuffer();
            stringBuffer.append("{ ");
            for (n = 0; n < n2; ++n) {
                stringBuffer.append(callbackArray[n].getClass().getName());
                if (n >= n2 - 1) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append(" }");
        }
        if (this.userName == null || this.userName.length() == 0 || this.password == null || this.password.length() == 0) {
            if (tc.isEntryEnabled()) {
                stringBuffer = new StringBuffer();
                stringBuffer.append("{ ");
                for (n = 0; n < n2; ++n) {
                    stringBuffer.append(callbackArray[n].getClass().getName());
                    if (n >= n2 - 1) continue;
                    stringBuffer.append(", ");
                }
                stringBuffer.append(" }");
                Tr.entry(tc, "handle(callbacks = \"" + stringBuffer.toString() + "\")");
            }
            for (int i = 0; i < n2; ++i) {
                Callback callback = callbackArray[i];
                if (callback instanceof NameCallback) {
                    this.userNamePrompt = ((NameCallback)callback).getPrompt();
                    this.userName = ((NameCallback)callback).getDefaultName();
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    this.passwordPrompt = ((PasswordCallback)callback).getPrompt();
                    this.passwordEcho = ((PasswordCallback)callback).isEchoOn();
                    continue;
                }
                if (!(callback instanceof WSRealmNameCallbackImpl)) continue;
                this.realmName = ((WSRealmNameCallbackImpl)callback).getRealmName();
                if (this.realmName != null && !this.realmName.equals("")) continue;
                this.realmName = ((WSRealmNameCallbackImpl)callback).getDefaultRealmName();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Realm Name: " + this.realmName);
            }
            String[] stringArray = null;
            try {
                if (stdinRetry < 1) {
                    System.out.print(realmNamePrompt + ": " + this.realmName + NEW_LINE);
                    System.out.flush();
                    WSStdinLoginPrompt wSStdinLoginPrompt = new WSStdinLoginPrompt(this.userNamePrompt, this.passwordPrompt);
                    stringArray = wSStdinLoginPrompt.getUidAndPassword();
                    if (stringArray != null) {
                        this.password = stringArray[1];
                        this.userName = RealmSecurityName.getSecurityName((String)stringArray[0]);
                        stdinRetry = 0;
                    } else {
                        ++stdinRetry;
                        this.userName = null;
                        this.password = null;
                    }
                } else {
                    stdinRetry = 0;
                    this.userName = null;
                    this.password = null;
                }
            }
            catch (Exception exception) {
                Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.websphere.security.auth.callback.WSStdinCallbackHandlerImpl.handle", "197", new Object[]{this});
                Tr.error(tc, "security.jaas.SystemInputError", new Object[]{exception});
            }
        }
        for (int i = 0; i < n2; ++i) {
            Callback callback = callbackArray[i];
            if (callback instanceof NameCallback) {
                ((NameCallback)callback).setName(this.userName);
                continue;
            }
            if (callback instanceof PasswordCallback) {
                ((PasswordCallback)callback).setPassword(this.password == null ? new char[]{} : this.password.toCharArray());
                continue;
            }
            if (callback instanceof WSRealmNameCallbackImpl) {
                ((WSRealmNameCallbackImpl)callback).setRealmName(this.realmName);
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Un-use handle(callbacks = \"" + callbackArray[i].getClass().getName() + "\")");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handle(callbacks) " + callbackArray);
        }
    }
}

