/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.security;

import com.ibm.ISecurityUtilityImpl.RealmSecurityName;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.ws.portletcontainer.portlet.PortletUtils;
import com.ibm.ws.security.config.AuthMechanismConfig;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.config.SingleSignonConfig;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.util.Base64Coder;
import com.ibm.ws.security.util.StringUtil;
import com.ibm.wsspi.security.token.PropagationToken;
import com.ibm.wsspi.security.token.WSSecurityPropagationHelper;
import java.lang.reflect.Method;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletSession;
import javax.security.auth.AuthPermission;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class WSSecurityHelper {
    private static final TraceComponent tc = Tr.register(WSSecurityHelper.class, null, "com.ibm.ejs.resources.security");
    private static final AuthPermission GETPROPATTRIBUTE_PERM = new AuthPermission("wssecurity.getPropagationAttributes");
    private static final AuthPermission SETPROPATTRIBUTE_PERM = new AuthPermission("wssecurity.addPropagationAttribute");
    private static Class webAttributesClass = null;
    private static Method createLogoutCookiesMethod = null;
    private static boolean isSSOEnabled = false;

    public static boolean isServerSecurityEnabled() {
        return ContextManagerFactory.getInstance().isServerSecurityEnabled();
    }

    public static boolean isGlobalSecurityEnabled() {
        return ContextManagerFactory.getInstance().isCellSecurityEnabled();
    }

    public static String getFirstCaller() {
        WSSecurityPropagationHelper wSSecurityPropagationHelper;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFirstCaller");
        }
        if (!((wSSecurityPropagationHelper = WSSecurityPropagationHelper.getInstance()).isRMIInboundPropagationEnabled() || wSSecurityPropagationHelper.isRMIOutboundPropagationEnabled() || wSSecurityPropagationHelper.isWebInboundPropagationEnabled())) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getFirstCaller: Outbound propagation is disabled.");
            }
            return null;
        }
        String[] stringArray = WSSecurityHelper.getCallerList();
        if (stringArray != null && stringArray.length > 0) {
            String string = stringArray[0];
            if (string != null) {
                int n = string.indexOf(":");
                n = string.indexOf(":", n + 1);
                n = string.indexOf(":", n + 1);
                string = string.substring(n + 1);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getFirstCaller() returns " + string);
                }
                return RealmSecurityName.getSecurityName((String)string);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getFirstCaller() returns null.");
            }
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFirstCaller() returns null.");
        }
        return null;
    }

    public static String getFirstServer() {
        WSSecurityPropagationHelper wSSecurityPropagationHelper;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFirstServer");
        }
        if (!((wSSecurityPropagationHelper = WSSecurityPropagationHelper.getInstance()).isRMIInboundPropagationEnabled() || wSSecurityPropagationHelper.isRMIOutboundPropagationEnabled() || wSSecurityPropagationHelper.isWebInboundPropagationEnabled())) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getFirstCaller: Outbound propagation is disabled.");
            }
            return null;
        }
        String[] stringArray = WSSecurityHelper.getServerList();
        if (stringArray != null && stringArray.length > 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getFirstServer() returns " + stringArray[0]);
            }
            return stringArray[0];
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFirstServer() returns null.");
        }
        return null;
    }

    public static String[] getCallerList() {
        WSSecurityPropagationHelper wSSecurityPropagationHelper;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCallerList");
        }
        if (!((wSSecurityPropagationHelper = WSSecurityPropagationHelper.getInstance()).isRMIInboundPropagationEnabled() || wSSecurityPropagationHelper.isRMIOutboundPropagationEnabled() || wSSecurityPropagationHelper.isWebInboundPropagationEnabled())) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getFirstCaller: Outbound propagation is disabled.");
            }
            return null;
        }
        try {
            PropagationToken propagationToken = ContextManagerFactory.getInstance().getPropagationToken("com.ibm.ws.security.token.PropagationTokenImpl:1");
            if (propagationToken != null) {
                String[] stringArray = propagationToken.getAttributes("com.ibm.wsspi.security.propagation.callers");
                if (stringArray != null && stringArray.length > 0) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getCallerList() returns " + stringArray);
                    }
                    return stringArray;
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getCallerList() returns null, attribute not present.");
                }
                return null;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCallerList() returns null, token not present.");
            }
            return null;
        }
        catch (Exception exception) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "The following exception occurred calling getCallerList().", new Object[]{exception});
            }
            Manager.Ffdc.log((Throwable)exception, WSSecurityHelper.class, "com.ibm.websphere.security.WSSecurityHelper.getCallerList", "254");
            return null;
        }
    }

    public static String[] getServerList() {
        WSSecurityPropagationHelper wSSecurityPropagationHelper;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerList");
        }
        if (!((wSSecurityPropagationHelper = WSSecurityPropagationHelper.getInstance()).isRMIInboundPropagationEnabled() || wSSecurityPropagationHelper.isRMIOutboundPropagationEnabled() || wSSecurityPropagationHelper.isWebInboundPropagationEnabled())) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getFirstCaller: Outbound propagation is disabled.");
            }
            return null;
        }
        try {
            PropagationToken propagationToken = ContextManagerFactory.getInstance().getPropagationToken("com.ibm.ws.security.token.PropagationTokenImpl:1");
            if (propagationToken != null) {
                String[] stringArray = propagationToken.getAttributes("com.ibm.wsspi.security.propagation.hosts");
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getServerList() returns " + stringArray);
                }
                return stringArray;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getServerList() returns null, token not present.");
            }
            return null;
        }
        catch (Exception exception) {
            Tr.error(tc, "The following exception occurred calling getServerList().", new Object[]{exception});
            Manager.Ffdc.log((Throwable)exception, WSSecurityHelper.class, "com.ibm.websphere.security.WSSecurityHelper.getServerList", "308");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "The following exception occurred calling getServerList().", new Object[]{exception});
            }
            return null;
        }
    }

    public static String[] getPropagationAttributes(String string) throws WSSecurityException {
        PropagationToken propagationToken;
        WSSecurityPropagationHelper wSSecurityPropagationHelper;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPropagationAttributes: " + string);
        }
        if (!((wSSecurityPropagationHelper = WSSecurityPropagationHelper.getInstance()).isRMIInboundPropagationEnabled() || wSSecurityPropagationHelper.isRMIOutboundPropagationEnabled() || wSSecurityPropagationHelper.isWebInboundPropagationEnabled())) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getFirstCaller: Outbound propagation is disabled.");
            }
            return null;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(GETPROPATTRIBUTE_PERM);
        }
        if ((propagationToken = ContextManagerFactory.getInstance().getPropagationToken("com.ibm.ws.security.token.PropagationTokenImpl:1")) != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPropagationAttributes: success");
            }
            return propagationToken.getAttributes(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPropagationAttributes: no PropagationToken found on thread");
        }
        return null;
    }

    public static String[] addPropagationAttribute(String string, String string2) throws WSSecurityException {
        ContextManager contextManager;
        PropagationToken propagationToken;
        WSSecurityPropagationHelper wSSecurityPropagationHelper;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addPropagationAttribute");
        }
        if (!((wSSecurityPropagationHelper = WSSecurityPropagationHelper.getInstance()).isRMIInboundPropagationEnabled() || wSSecurityPropagationHelper.isRMIOutboundPropagationEnabled() || wSSecurityPropagationHelper.isWebInboundPropagationEnabled())) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getFirstCaller: Outbound propagation is disabled.");
            }
            return null;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SETPROPATTRIBUTE_PERM);
        }
        if ((propagationToken = (contextManager = ContextManagerFactory.getInstance()).getPropagationToken("com.ibm.ws.security.token.PropagationTokenImpl:1")) == null && (propagationToken = contextManager.createPropagationToken(null)) != null) {
            contextManager.setPropagationToken("com.ibm.ws.security.token.PropagationTokenImpl:1", propagationToken);
        }
        if (propagationToken != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addPropagationAttribute: success");
            }
            return propagationToken.addAttribute(string, string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addPropagationAttribute: attribute not set");
        }
        return null;
    }

    public static byte[] convertCookieStringToBytes(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertCookieStringToBytes");
        }
        try {
            return StringUtil.getBytes((String)Base64Coder.base64Decode((String)string));
        }
        catch (Exception exception) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "convertCookieStringToBytes: failed", new Object[]{exception});
            }
            Manager.Ffdc.log((Throwable)exception, WSSecurityHelper.class, "com.ibm.websphere.security.WSSecurityHelper.convertCookieStringToBytes", "475");
            return null;
        }
    }

    public static void revokeSSOCookies(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "revokeSSOCookies");
        }
        if (!WSSecurityHelper.isGlobalSecurityEnabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No action because global security was not enabled");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "revokeSSOCookies");
            }
            return;
        }
        if (webAttributesClass == null) {
            try {
                SingleSignonConfig singleSignonConfig;
                webAttributesClass = Class.forName("com.ibm.ws.security.web.WebAttributes");
                createLogoutCookiesMethod = webAttributesClass.getMethod("createLogoutCookiesStatic", HttpServletRequest.class, HttpServletResponse.class);
                SecurityConfig securityConfig = SecurityObjectLocator.getSecurityConfig();
                AuthMechanismConfig authMechanismConfig = securityConfig.getAuthMechanism("LTPA");
                if (authMechanismConfig == null) {
                    Tr.warning(tc, "ltpa is null");
                }
                if ((singleSignonConfig = authMechanismConfig.getSingleSignon()) == null) {
                    Tr.warning(tc, "ltpa's sso is null");
                }
                isSSOEnabled = singleSignonConfig.getBoolean("enabled");
            }
            catch (Exception exception) {
                Tr.error(tc, "Initialization revokeSSOCookies failed with Exception:", new Object[]{exception});
                throw new RuntimeException(exception.getMessage());
            }
        }
        if (isSSOEnabled) {
            if (createLogoutCookiesMethod == null) {
                Tr.error(tc, "revokeSSOCookies init condition incorrect.");
            } else {
                try {
                    createLogoutCookiesMethod.invoke(null, httpServletRequest, httpServletResponse);
                }
                catch (Exception exception) {
                    Tr.error(tc, "Invoke createLogoutCookie failed with Exception:", new Object[]{exception});
                    throw new RuntimeException(exception.getMessage());
                }
            }
        }
    }

    public static void revokeSSOCookiesForPortlets(ActionRequest actionRequest, ActionResponse actionResponse) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "revokeSSOCookiesForPortlets");
        }
        HttpServletRequest httpServletRequest = PortletUtils.getHttpServletRequest((ActionRequest)actionRequest);
        HttpServletResponse httpServletResponse = PortletUtils.getHttpServletResponse((ActionResponse)actionResponse);
        WSSecurityHelper.revokeSSOCookies(httpServletRequest, httpServletResponse);
        PortletSession portletSession = actionRequest.getPortletSession(false);
        if (portletSession != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "invalidating existing portlet Session");
            }
            portletSession.invalidate();
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Existing portlet Session does not exist, nothing to invalidate");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "revokeSSOCookiesForPortlets");
        }
    }
}

