/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.scheduler;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.scheduler.TaskStatus;
import java.io.Serializable;
import java.util.Date;

public class TaskNotificationInfo
implements Serializable {
    private static final TraceComponent tc = Tr.register(TaskNotificationInfo.class, "Scheduler", "com.ibm.ws.scheduler.resources.SchedulerMessages");
    private static final long serialVersionUID = -2347092596945854301L;
    public static final int SCHEDULED = 1;
    public static final int PURGED = 2;
    public static final int SUSPENDED = 4;
    public static final int RESUMED = 8;
    public static final int COMPLETE = 16;
    public static final int CANCELLED = 32;
    public static final int FIRED = 64;
    public static final int FIRE_FAILED = 128;
    public static final int FIRE_DELAYED = 256;
    public static final int FIRING = 512;
    public static final int ALL_EVENTS = Integer.MAX_VALUE;
    protected TaskStatus taskStatus = null;
    protected int eventType = -1;
    protected Date time = null;

    public TaskNotificationInfo(TaskStatus taskStatus, int n) {
        Tr.entry(tc, "TaskNotificationInfo(init)");
        this.taskStatus = taskStatus;
        this.eventType = n;
        this.time = new Date(System.currentTimeMillis());
        Tr.exit(tc, "TaskNotificationInfo(init)");
    }

    public TaskStatus getTaskStatus() {
        return this.taskStatus;
    }

    public int getEventType() {
        return this.eventType;
    }

    public Date getTime() {
        return this.time;
    }

    static {
        Tr.debug(tc, "Loading TaskNotifiationInfo.class");
    }
}

