/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.rsadapter;

import com.ibm.ejs.cm.logger.TraceWriter;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.appprofile.accessintent.AccessIntent;
import com.ibm.websphere.ce.cm.DuplicateKeyException;
import com.ibm.websphere.ce.cm.StaleConnectionException;
import com.ibm.websphere.ce.cm.StaleStatementException;
import com.ibm.websphere.rsadapter.GenericDataStoreHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.resource.ResourceException;

public class InformixDataStoreHelper
extends GenericDataStoreHelper {
    private static final TraceComponent tc = Tr.register(InformixDataStoreHelper.class, "RRA", "com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    private static final TraceComponent infxTc = Tr.register("com.ibm.ws.informix.logwriter", "WAS.database", null);
    private HashMap infxErrorMap = new HashMap(17);
    private HashMap userNewMap = null;
    private static final int HASHSIZE = 17;
    private int informixLockModeWait = 0;
    private boolean informixAllowNewLine = false;

    public InformixDataStoreHelper(Properties properties) {
        super(properties);
        if (properties != null) {
            String string = properties.getProperty("informixLockModeWait");
            if (string != null) {
                this.informixLockModeWait = Integer.parseInt(string);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "DSConfigurationHelper.INFORMIX_LOCK_MODE_WAIT is not set, using default: 0");
            }
            string = properties.getProperty("informixAllowNewLine");
            boolean bl = this.informixAllowNewLine = string != null && new Boolean(string) != false;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "the INFORMIX_ALLOW_NEWLINE datasource customer property is set to: ", string);
            }
        }
        this.addInitialMaps();
        this.dshMd.setHelperType(14);
        this.dshMd.setDatabaseDefaultIsolationLevel(4, this.customDefinedWasDefaultIsoLevel);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "the metadata for the informix helper is", this.dshMd);
            Tr.debug(tc, "done constructing Infx helper: InformixLockModeWait is: ", new Integer(this.informixLockModeWait));
        }
    }

    private void addInitialMaps() {
        this.infxErrorMap.put(new Integer(43012), StaleConnectionException.class);
        this.infxErrorMap.put(new Integer(-908), StaleConnectionException.class);
        this.infxErrorMap.put(new Integer(-25580), StaleConnectionException.class);
        this.infxErrorMap.put(new Integer(-27002), StaleConnectionException.class);
        this.infxErrorMap.put(new Integer(-43207), StaleConnectionException.class);
        this.infxErrorMap.put(new Integer(-79716), StaleConnectionException.class);
        this.infxErrorMap.put(new Integer(-79735), StaleConnectionException.class);
        this.infxErrorMap.put(-710, StaleStatementException.class);
        this.infxErrorMap.put(new Integer(-268), DuplicateKeyException.class);
        this.infxErrorMap.put(new Integer(-239), DuplicateKeyException.class);
    }

    public final Class findMappingClass(SQLException sQLException) {
        Object var2_2 = null;
        String string = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findMappingClass for: " + sQLException);
        }
        if (tc.isEventEnabled()) {
            Tr.event(tc, "the DataStoreHelper is: ", this);
        }
        if (sQLException != null) {
            if (this.userNewMap != null) {
                var2_2 = this.userNewMap.get(new Integer(sQLException.getErrorCode()));
                if (var2_2 != null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "findMappingClass return: ", var2_2);
                    }
                    return var2_2;
                }
                string = sQLException.getSQLState();
                if (string != null && (var2_2 = this.userNewMap.get(string)) != null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "findMappingClass return: ", var2_2);
                    }
                    return var2_2;
                }
            }
            if ((var2_2 = this.infxErrorMap.get(new Integer(sQLException.getErrorCode()))) != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "findMappingClass: return ", var2_2);
                }
                return var2_2;
            }
            string = sQLException.getSQLState();
            if (string != null) {
                var2_2 = this.infxErrorMap.get(string);
            }
            if (var2_2 == null) {
                SQLException sQLException2 = sQLException.getNextException();
                if (sQLException2 != null && sQLException2 != sQLException) {
                    return this.findMappingClass(sQLException2);
                }
                return super.findMappingClass(sQLException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findMappingClass: return ", var2_2);
        }
        return var2_2;
    }

    public int getIsolationLevel(AccessIntent accessIntent) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getIsolationLevel, intent: ", accessIntent);
        }
        int n = this.dshMd.getDatabaseDefaultIsolationLevel();
        if (accessIntent != null) {
            if (accessIntent.getConcurrencyControl() == 2) {
                n = 2;
            } else if (accessIntent.getAccessType() == 2) {
                n = 4;
            } else {
                int n2 = accessIntent.getPessimisticUpdateLockHint();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The hint_value is: ", new Integer(n2));
                }
                switch (n2) {
                    case 2: 
                    case 3: {
                        n = 4;
                        break;
                    }
                    case 1: {
                        n = 2;
                        break;
                    }
                    case 4: {
                        n = 8;
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getIsolationLevel, return:", AdapterUtil.getIsolationLevelString((int)n));
        }
        return n;
    }

    public int getResultSetConcurrency(AccessIntent accessIntent) throws ResourceException {
        int n = 1007;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getResultSetConcurrency, return:ResultSet.CONCUR_READ_ONLY, intent:", accessIntent);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doConnectionSetup(Connection connection) throws SQLException {
        Statement statement = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setDefaultConnectionProperties", this);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "the informixLockModeWait to be set is " + this.informixLockModeWait);
            Tr.debug(tc, "the informixAllowNewLine to be set is " + this.informixAllowNewLine);
        }
        try {
            statement = connection.createStatement();
            if (this.informixLockModeWait > 0) {
                statement.execute("SET LOCK MODE TO WAIT " + this.informixLockModeWait);
            } else if (this.informixLockModeWait < 0) {
                statement.execute("SET LOCK MODE TO WAIT");
            } else {
                statement.execute("SET LOCK MODE TO NOT WAIT");
            }
            if (this.informixAllowNewLine) {
                statement.execute("EXECUTE PROCEDURE IFX_ALLOW_NEWLINE('T')");
            }
        }
        finally {
            block16: {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.websphere.rsadapter.InformixDataStoreHelper.doConnectionSetup", (String)"231", (Object)this);
                    if (!tc.isDebugEnabled()) break block16;
                    Tr.debug(tc, "SQLException occured in closing the statement ", sQLException);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setDefaultConnectionProperties");
        }
    }

    public void doStatementCleanup(PreparedStatement preparedStatement) throws SQLException {
        preparedStatement.setFetchDirection(1000);
        preparedStatement.setMaxFieldSize(0);
        preparedStatement.setMaxRows(0);
    }

    public final void setUserDefinedMap(Map map) {
        this.userNewMap = new HashMap(map);
    }

    public PrintWriter getPrintWriter() {
        if (infxTc.isDebugEnabled()) {
            Tr.debug(tc, "Informix logging is enabled");
            return new PrintWriter((Writer)new TraceWriter(infxTc));
        }
        return null;
    }
}

