/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.rsadapter;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.appprofile.accessintent.AccessIntent;
import com.ibm.websphere.ce.cm.DuplicateKeyException;
import com.ibm.websphere.ce.cm.PortableSQLException;
import com.ibm.websphere.ce.cm.StaleConnectionException;
import com.ibm.websphere.rsadapter.DataStoreHelper;
import com.ibm.websphere.rsadapter.DataStoreHelperMetaData;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.security.util.AccessController;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLRecoverableException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.resource.ResourceException;
import javax.security.auth.Subject;
import javax.transaction.xa.XAException;

public class GenericDataStoreHelper
implements DataStoreHelper {
    protected static final String resBundle = "com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS";
    private static final TraceComponent tc = Tr.register(GenericDataStoreHelper.class, "RRA", "com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    private boolean reauthEnabled = false;
    private boolean useTrustedCtxWithAuth = false;
    protected int customDefinedWasDefaultIsoLevel = -1;
    protected static final String EOLN = System.getProperty("line.separator");
    final DataStoreHelperMetaData dshMd = new DataStoreHelperMetaData();
    protected HashMap genErrorMap = null;
    private static final int HASHSIZE = 17;
    private HashMap userNewMap = null;

    public GenericDataStoreHelper(Properties properties) {
        boolean bl = TraceComponent.isAnyTracingEnabled();
        this.genErrorMap = new HashMap(17);
        this.addInitialMaps();
        if (properties != null) {
            String string = properties.getProperty("webSphereDefaultIsolationLevel");
            if (string != null && !string.equals("")) {
                this.customDefinedWasDefaultIsoLevel = Integer.parseInt(string);
                if (bl && tc.isDebugEnabled()) {
                    Tr.debug(tc, "the was default isolation level is customized to: ", AdapterUtil.getIsolationLevelString((int)this.customDefinedWasDefaultIsoLevel));
                }
                this.dshMd.setDatabaseDefaultIsolationLevel(2, this.customDefinedWasDefaultIsoLevel);
            }
            this.reauthEnabled = (string = properties.getProperty("reauthentication")) != null && new Boolean(string) != false;
            string = properties.getProperty("useTrustedContextWithAuthentication");
            boolean bl2 = this.useTrustedCtxWithAuth = string != null && new Boolean(string) != false;
        }
        if (bl && tc.isDebugEnabled()) {
            Tr.debug(tc, "init ", this);
        }
    }

    public DataStoreHelperMetaData getMetaData() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "returning: ", this.dshMd);
        }
        return this.dshMd;
    }

    public boolean isDuplicateKey(SQLException sQLException) {
        Class clazz;
        boolean bl;
        boolean bl2 = TraceComponent.isAnyTracingEnabled();
        if (bl2 && tc.isEntryEnabled()) {
            Tr.entry(tc, "isDuplicateKey: ", sQLException);
        }
        boolean bl3 = bl = sQLException instanceof DuplicateKeyException || (clazz = this.findMappingClass(sQLException)) != null && DuplicateKeyException.class.isAssignableFrom(clazz);
        if (bl2 && tc.isEntryEnabled()) {
            Tr.exit(tc, "isDuplicateKey: ", bl);
        }
        return bl;
    }

    private void addInitialMaps() {
        this.genErrorMap.put("55032", StaleConnectionException.class);
        this.genErrorMap.put("08001", StaleConnectionException.class);
        this.genErrorMap.put("08003", StaleConnectionException.class);
        this.genErrorMap.put("40003", StaleConnectionException.class);
        this.genErrorMap.put("S1000", StaleConnectionException.class);
        this.genErrorMap.put("08006", StaleConnectionException.class);
        this.genErrorMap.put("08S01", StaleConnectionException.class);
        this.genErrorMap.put(new Integer(23505), DuplicateKeyException.class);
    }

    public int getIsolationLevel(AccessIntent accessIntent) throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getIsolationLevel, intent is:", accessIntent);
        }
        return this.dshMd.getDatabaseDefaultIsolationLevel();
    }

    public int getResultSetType(AccessIntent accessIntent) throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getResultSetType, return: ResultSet.TYPE_FORWARD_ONLY");
        }
        return 1003;
    }

    public int getResultSetConcurrency(AccessIntent accessIntent) throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getResultSetConcurrency, default (CONCUR_READ_ONLY) is returned. intent is:", accessIntent);
        }
        return 1007;
    }

    public boolean isConnectionError(SQLException sQLException) {
        Class clazz;
        boolean bl;
        boolean bl2 = TraceComponent.isAnyTracingEnabled();
        if (bl2 && tc.isEntryEnabled()) {
            Tr.entry(tc, "isConnectionError: ", sQLException);
        }
        boolean bl3 = bl = sQLException instanceof SQLRecoverableException || sQLException instanceof SQLNonTransientConnectionException || sQLException instanceof StaleConnectionException;
        if (sQLException != null && !bl && (clazz = this.findMappingClass(sQLException)) != null) {
            bl = StaleConnectionException.class.isAssignableFrom(clazz);
        }
        if (bl2 && tc.isEntryEnabled()) {
            Tr.exit(tc, "isConnectionError: ", new Boolean(bl));
        }
        return bl;
    }

    public String hasLostUpdateOrDeadLockOccurred(int n, boolean bl) {
        switch (n) {
            case 1: 
            case 2: {
                return "MSG_CONM_7008W";
            }
        }
        if (!bl) {
            return "MSG_CONM_7010W";
        }
        return null;
    }

    public Class findMappingClass(SQLException sQLException) {
        boolean bl = TraceComponent.isAnyTracingEnabled();
        Object var3_3 = null;
        String string = null;
        if (bl) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "findMappingClass for exception", sQLException);
            }
            if (tc.isEventEnabled()) {
                Tr.event(tc, "the DataStoreHelper is: ", this);
            }
        }
        if (sQLException != null) {
            if (this.userNewMap != null) {
                var3_3 = this.userNewMap.get(new Integer(sQLException.getErrorCode()));
                if (var3_3 != null) {
                    if (bl && tc.isEntryEnabled()) {
                        Tr.exit(tc, "findMappingClass return: ", var3_3);
                    }
                    return var3_3;
                }
                string = sQLException.getSQLState();
                if (string != null && (var3_3 = this.userNewMap.get(string)) != null) {
                    if (bl && tc.isEntryEnabled()) {
                        Tr.exit(tc, "findMappingClass return: ", var3_3);
                    }
                    return var3_3;
                }
            }
            if ((var3_3 = this.genErrorMap.get(new Integer(sQLException.getErrorCode()))) == null && (string = sQLException.getSQLState()) != null) {
                var3_3 = this.genErrorMap.get(string);
            }
        }
        if (bl && tc.isEntryEnabled()) {
            Tr.exit(tc, "findMappingClass, returning", var3_3);
        }
        return var3_3;
    }

    private SQLException mapExceptionHelper(SQLException sQLException) {
        Class clazz;
        boolean bl = TraceComponent.isAnyTracingEnabled();
        if (bl && tc.isEntryEnabled()) {
            Tr.entry(tc, "mapExceptionHelper");
        }
        if ((clazz = this.findMappingClass(sQLException)) != null && !clazz.equals(Void.class)) {
            try {
                final Class[] classArray = new Class[]{SQLException.class};
                Constructor constructor = (Constructor)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return clazz.getDeclaredConstructor(classArray);
                    }
                });
                PortableSQLException portableSQLException = (PortableSQLException)constructor.newInstance(sQLException);
                if (bl && tc.isEntryEnabled()) {
                    Tr.exit(tc, "mapExceptionHelper: Mapping was done returning:", portableSQLException);
                }
                return portableSQLException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.rsadapter.GenericDataStoreHelper.mapExceptionHelper", (String)"313", (Object)this);
                Tr.warning(tc, "NO_EXCPT_MAP", exception);
                return sQLException;
            }
        }
        if (bl && tc.isEntryEnabled()) {
            Tr.exit(tc, "mapExceptionHelper: No Mapping was done.");
        }
        return sQLException;
    }

    public SQLException mapException(SQLException sQLException) {
        if (sQLException instanceof PortableSQLException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception does not need to be mapped, returning the same exception", sQLException);
            }
            return sQLException;
        }
        return this.mapExceptionHelper(sQLException);
    }

    public void doConnectionSetup(Connection connection) throws SQLException {
    }

    public boolean doConnectionCleanup(Connection connection) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "doConnectionCleanup(): no cleanup is done return false");
        }
        return false;
    }

    public void doStatementCleanup(PreparedStatement preparedStatement) throws SQLException {
        preparedStatement.setCursorName(null);
        preparedStatement.setFetchDirection(1000);
        preparedStatement.setMaxFieldSize(0);
        preparedStatement.setMaxRows(0);
        preparedStatement.setQueryTimeout(0);
    }

    public String showLockInfo(Properties properties) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "showLockInfo() is not supported for GenericDataStoreHelper");
        }
        return AdapterUtil.getNLSMessage((String)"GENERIC_HELPER_NO_LOCK_INFO");
    }

    public void setUserDefinedMap(Map map) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setUserDefinedMap: ", map);
        }
        this.userNewMap = new HashMap(map);
    }

    public int getLockType(AccessIntent accessIntent) {
        int n;
        boolean bl = TraceComponent.isAnyTracingEnabled();
        int n2 = 1;
        if (bl && tc.isEntryEnabled()) {
            Tr.entry(tc, "getLockType", new Object[]{this, accessIntent});
        }
        if (accessIntent != null && accessIntent.getAccessType() == 1 && accessIntent.getConcurrencyControl() == 1 && ((n = accessIntent.getPessimisticUpdateLockHint()) == 3 || n == 4)) {
            n2 = 2;
        }
        if (bl && tc.isEntryEnabled()) {
            Tr.exit(tc, "getLockType", AdapterUtil.getLockTypeAsString((int)n2));
        }
        return n2;
    }

    public short calcPartitionNumber(String string, Properties properties) throws ResourceException {
        return -1;
    }

    public PrintWriter getPrintWriter() {
        return null;
    }

    public String getXAExceptionContents(XAException xAException) {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("The cause is               : ").append(xAException.getCause());
        return stringBuffer.toString();
    }

    public int modifyXAFlag(int n) {
        return n;
    }

    public boolean isBatchUpdateSupportedWithAccessIntent(AccessIntent accessIntent) {
        return true;
    }

    public void doConnectionSetupPerTransaction(Subject subject, String string, Connection connection, boolean bl, Object object) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "doConnectionSetupPerTxn: is not implemented", object);
        }
        if (this.reauthEnabled) {
            throw new SQLException(AdapterUtil.getNLSMessage((String)"AUTHENTICATION_IMPLEMENTATION_WARNING"));
        }
    }

    public boolean doConnectionSetupPerGetConnection(Connection connection, boolean bl, Object object) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "doConnectionSetupPerGetConnection is not implemented", new Object[]{connection, new Boolean(bl), object});
        }
        return false;
    }

    public boolean doConnectionCleanupPerCloseConnection(Connection connection, boolean bl, Object object) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "doConnectionCleanupPerCloseConnection is not implemented", new Object[]{connection, new Boolean(bl), object});
        }
        return false;
    }

    public String getPasswordForUseWithTrustedContextWithAuthentication(String string, String string2) throws SQLException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getPasswordForUseWithTrustedContextWithAuthentication is not implemented. returning null");
        }
        if (this.useTrustedCtxWithAuth) {
            throw new SQLException(AdapterUtil.getNLSMessage((String)"TRUSTED_WITH_AUTHENTICATION_IMPLEMENTATION_ERROR"));
        }
        return null;
    }
}

