/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.rsadapter;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.appprofile.accessintent.AccessIntent;
import com.ibm.websphere.ce.cm.StaleConnectionException;
import com.ibm.websphere.rsadapter.DB2DataStoreHelper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Properties;

public class DB2AS400DataStoreHelper
extends DB2DataStoreHelper {
    private static final TraceComponent tc = Tr.register(DB2AS400DataStoreHelper.class, "RRA", "com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");

    public DB2AS400DataStoreHelper(Properties properties) {
        super(properties);
        this.db2ErrorMap.put("HY017", StaleConnectionException.class);
        this.dshMd.setGetTypeMapSupport(false);
        this.dshMd.setHelperType(2);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "the metadata for the AS400 is", this.dshMd);
            Tr.debug(tc, "done constructing the DB2As400Helper", this);
        }
    }

    public boolean doConnectionCleanup(Connection connection) throws SQLException {
        block8: {
            SQLWarning sQLWarning;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "doConnectionCleanup");
            }
            if ((sQLWarning = connection.getWarnings()) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "doConnectionCleanup(): no warnings to cleanup");
                }
            } else {
                try {
                    connection.clearWarnings();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "doConnectionCleanup(): cleanup of warnings done");
                    }
                }
                catch (SQLException sQLException) {
                    if (!tc.isDebugEnabled()) break block8;
                    Tr.debug(tc, "doConnectionCleanup(): cleanup of warnings failed", sQLException);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doConnectionCleanup");
        }
        return false;
    }

    public void doStatementCleanup(PreparedStatement preparedStatement) throws SQLException {
        preparedStatement.setCursorName(null);
        preparedStatement.setFetchDirection(1000);
        preparedStatement.setMaxFieldSize(0);
        preparedStatement.setMaxRows(0);
        preparedStatement.setQueryTimeout(0);
    }

    public boolean isBatchUpdateSupportedWithAccessIntent(AccessIntent accessIntent) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isBatchUpdateSupportedWithAccessIntent(): returning true");
        }
        return true;
    }
}

