/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.rsadapter;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.appprofile.accessintent.AccessIntent;
import com.ibm.websphere.rsadapter.DataDirectDataStoreHelper;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.jdbc.WSJdbcTracer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Properties;
import javax.resource.ResourceException;

public class ConnectJDBCDataStoreHelper
extends DataDirectDataStoreHelper {
    private static final TraceComponent tc = Tr.register(ConnectJDBCDataStoreHelper.class, "RRA", "com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    private int longDataCacheSize = 2048;
    private int queryTimeout = 0;
    private Method methodSetLongDataCacheSize;
    private boolean supportsSetLongDataCacheSize = true;

    public ConnectJDBCDataStoreHelper(Properties properties) {
        super(properties);
        if (properties != null && properties.containsKey("longDataCacheSize")) {
            try {
                this.longDataCacheSize = Integer.parseInt(properties.getProperty("longDataCacheSize"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Default longDataCacheSize = " + this.longDataCacheSize);
        }
        if (properties != null && properties.containsKey("queryTimeout")) {
            try {
                this.queryTimeout = Integer.parseInt(properties.getProperty("queryTimeout"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Default queryTimeout = " + this.queryTimeout);
        }
        this.dshMd.setSelectForUpdateSupport(false);
        this.dshMd.setHelperType(7);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Done constructing ConnectJDBCDataStoreHelper", (Object)this);
        }
    }

    public void doStatementCleanup(PreparedStatement preparedStatement) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doStatementCleanup", AdapterUtil.toString((Object)preparedStatement));
        }
        preparedStatement.setFetchDirection(1000);
        preparedStatement.setMaxFieldSize(0);
        preparedStatement.setMaxRows(0);
        preparedStatement.setQueryTimeout(this.queryTimeout);
        preparedStatement = (PreparedStatement)WSJdbcTracer.getImpl((Object)preparedStatement);
        if (this.supportsSetLongDataCacheSize && this.methodSetLongDataCacheSize == null) {
            try {
                this.methodSetLongDataCacheSize = preparedStatement.getClass().getMethod("setLongDataCacheSize", Integer.TYPE);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "LongDataCacheSize not supported.");
                }
                this.supportsSetLongDataCacheSize = false;
            }
        }
        if (this.supportsSetLongDataCacheSize) {
            try {
                this.methodSetLongDataCacheSize.invoke((Object)preparedStatement, this.longDataCacheSize);
            }
            catch (InvocationTargetException invocationTargetException) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "doStatementCleanup", invocationTargetException.getCause());
                }
                throw (SQLException)invocationTargetException.getCause();
            }
            catch (IllegalAccessException illegalAccessException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "LongDataCacheSize not supported.");
                }
                this.supportsSetLongDataCacheSize = false;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doStatementCleanup");
        }
    }

    public int getResultSetConcurrency(AccessIntent accessIntent) throws ResourceException {
        return super.getResultSetConcurrency(accessIntent);
    }

    public int getIsolationLevel(AccessIntent accessIntent) throws ResourceException {
        return super.getIsolationLevel(accessIntent);
    }

    public boolean isDuplicateKey(SQLException sQLException) {
        return super.isDuplicateKey(sQLException);
    }

    public String showLockInfo(Properties properties) throws Exception {
        return super.showLockInfo(properties);
    }
}

