/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.resource;

import com.ibm.websphere.resource.WASResourceFactoryRegistryImpl;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public class WASResourceSetImpl
extends ResourceSetImpl {
    public static final boolean RELOAD = true;
    public static final boolean NO_RELOAD = false;
    public static final boolean UNLOAD = true;
    public static final boolean NO_UNLOAD = false;
    public static final boolean LOAD_ON_DEMAND = true;
    public static final boolean NO_LOAD_ON_DEMAND = false;
    public static final String DEBUG_PROPERTY_NAME = "com.ibm.websphere.resource.resourceDebug";
    public static boolean debug;
    protected static boolean attemptedInitialization;
    public static final String MODEL_MGR_CLASS_NAME = "com.ibm.ws.config.ModelMgr";

    public WASResourceSetImpl() {
        if (this.resourceFactoryRegistry == null) {
            this.resourceFactoryRegistry = WASResourceFactoryRegistryImpl.INSTANCE;
        }
    }

    public Resource.Factory.Registry getResourceFactoryRegistry() {
        if (this.resourceFactoryRegistry == null) {
            this.resourceFactoryRegistry = WASResourceFactoryRegistryImpl.INSTANCE;
        }
        return this.resourceFactoryRegistry;
    }

    private synchronized Resource getExistingResource(URI uri) {
        if (debug) {
            WASResourceSetImpl.debug("getExistingResource : entry : " + uri);
        }
        Resource selectedResource = null;
        URIConverter theURIConverter = this.getURIConverter();
        URI normalizedURI = theURIConverter.normalize(uri);
        EList thisResources = this.getResources();
        BasicEList resourceList = new BasicEList(thisResources);
        int noOfRes = resourceList.size();
        for (int resourceNo = 0; resourceNo < noOfRes && selectedResource == null; ++resourceNo) {
            Resource resource = (Resource)resourceList.get(resourceNo);
            if (!theURIConverter.normalize(resource.getURI()).equals(normalizedURI)) continue;
            selectedResource = resource;
        }
        if (selectedResource != null && !selectedResource.isLoaded()) {
            try {
                this.demandLoad(selectedResource);
            }
            catch (Resource.IOWrappedException exception) {
                throw new WrappedException(exception.getWrappedException());
            }
            catch (IOException exception) {
                throw new WrappedException(exception);
            }
        }
        if (debug) {
            WASResourceSetImpl.debug("getExistingResource : exit : " + selectedResource);
        }
        return selectedResource;
    }

    public synchronized Resource createResource(URI uri) {
        Resource resource;
        Resource.Factory resourceFactory;
        if (debug) {
            WASResourceSetImpl.debug("createResource : entry : " + uri);
        }
        if ((resourceFactory = this.getResourceFactoryRegistry().getFactory(uri)) != null) {
            resource = this.getExistingResource(uri);
            if (resource == null) {
                resource = resourceFactory.createResource(uri);
                this.getResources().add(resource);
            }
        } else {
            resource = null;
        }
        if (debug) {
            WASResourceSetImpl.debug("createResource : exit : " + resource);
        }
        return resource;
    }

    public synchronized Resource getResource(URI uri, boolean loadOnDemand, boolean reload) {
        Resource resource;
        if (debug) {
            WASResourceSetImpl.debug("getResource (uri, loadOnDemand, reload) : entry : " + uri + ", loadOnDemand = " + loadOnDemand + ", reload = " + reload);
        }
        if (reload) {
            if (debug) {
                WASResourceSetImpl.debug("getResource: reload chosen ... checking for loaded resource");
            }
            if ((resource = this.getResource(uri, false)) != null) {
                if (debug) {
                    WASResourceSetImpl.debug("getResource: unloading resource to force a reload");
                }
                resource.unload();
            }
            loadOnDemand = true;
        }
        resource = this.getResource(uri, loadOnDemand);
        if (debug) {
            WASResourceSetImpl.debug("getResource: exit : " + resource);
        }
        return resource;
    }

    public synchronized Resource getResource(URI uri, boolean loadOnDemand) {
        if (debug) {
            WASResourceSetImpl.debug("WASRSI: getResource (uri, loadOnDemand) : entry : " + uri + ", loadOnDemand = " + loadOnDemand);
        }
        Resource resource = super.getResource(uri, loadOnDemand);
        if (debug) {
            if (resource == null) {
                WASResourceSetImpl.debug("getResource: resource not found");
                WASResourceSetImpl.dumpStack("getResource: resource not found");
            }
            WASResourceSetImpl.debug("getResource : exit : " + resource);
        }
        return resource;
    }

    public synchronized List getResourceElements(URI uri, boolean loadOnDemand) {
        BasicEList elements;
        Resource resource;
        if (debug) {
            WASResourceSetImpl.debug("getResourceElements : entry: " + uri + ", loadOnDemand = " + loadOnDemand);
        }
        if ((resource = this.getResource(uri, loadOnDemand)) != null) {
            EList elist = resource.getContents();
            elements = new BasicEList(elist);
        } else {
            elements = null;
        }
        if (debug) {
            int size = elements != null ? elements.size() : 0;
            WASResourceSetImpl.debug("getResourceElements : exit : size = " + size + ", list = " + elements);
        }
        return elements;
    }

    public synchronized void removeResource(Resource resource, boolean unload) {
        if (debug) {
            WASResourceSetImpl.debug("removeResource : entry : " + resource + ", unload = " + unload);
        }
        this.removeResource(resource);
        if (unload) {
            resource.unload();
        }
        if (debug) {
            WASResourceSetImpl.debug("removeResource : exit");
        }
    }

    public synchronized void removeResource(Resource resource) {
        if (debug) {
            WASResourceSetImpl.debug("removeResource : entry : " + resource);
        }
        this.getResources().remove(resource);
        if (debug) {
            WASResourceSetImpl.debug("removeResource : exit");
        }
    }

    public synchronized void removeAllResources(boolean unload) {
        if (debug) {
            WASResourceSetImpl.debug("removeAllResources : entry : unload = " + unload);
        }
        EList rawResources = this.getResources();
        Resource[] resources = rawResources.toArray(new Resource[rawResources.size()]);
        rawResources.clear();
        if (unload) {
            for (int resourceNo = 0; resourceNo < resources.length; ++resourceNo) {
                resources[resourceNo].unload();
            }
        }
        if (debug) {
            WASResourceSetImpl.debug("removeAllResources : exit");
        }
    }

    public static void debug(String text) {
        System.out.println("WASRSI: " + WASResourceSetImpl.class.getName() + ": " + text);
    }

    public static void dumpStack(String text) {
        System.out.println("WASRSI: " + WASResourceSetImpl.class.getName() + ": " + text);
        new Throwable("Dummy for WASResourceSetImpl: " + text).printStackTrace(System.out);
    }

    public static void dumpStack(String text, Throwable th) {
        System.out.println("WASRSI: " + WASResourceSetImpl.class.getName() + ": " + text);
        th.printStackTrace(System.out);
    }

    public EPackage.Registry getPackageRegistry() {
        if (this.packageRegistry == null) {
            this.packageRegistry = new DeferredRegistry(EPackage.Registry.INSTANCE);
        }
        return this.packageRegistry;
    }

    protected synchronized boolean initModelMgr() {
        boolean initialized;
        block6: {
            if (debug) {
                WASResourceSetImpl.debug("initModelMgr ENTRY: attemptedInitialization [ " + attemptedInitialization + " ]");
            }
            if (attemptedInitialization) {
                initialized = false;
            } else {
                initialized = true;
                attemptedInitialization = true;
                try {
                    Class<?> clazz = Class.forName(MODEL_MGR_CLASS_NAME);
                    Class[] params = new Class[]{String.class};
                    Method init = clazz.getMethod("initialize", params);
                    String[] input = new String[]{"ws-server"};
                    init.invoke(null, (Object[])input);
                }
                catch (Exception e) {
                    if (!debug) break block6;
                    WASResourceSetImpl.dumpStack("Failed to initialize model manager", e);
                }
            }
        }
        if (debug) {
            WASResourceSetImpl.debug("initModelMgr RETURN [ " + initialized + " ]");
        }
        return initialized;
    }

    static {
        if (debug) {
            WASResourceSetImpl.debug("Class Initialization");
        }
        debug = false;
        if (System.getProperty(DEBUG_PROPERTY_NAME) != null) {
            debug = true;
        }
    }

    protected class DeferredRegistry
    extends EPackageRegistryImpl {
        private static final long serialVersionUID = 1L;

        protected DeferredRegistry(EPackage.Registry delegateRegistry) {
            super(delegateRegistry);
        }

        public EPackage getEPackage(String nsUri) {
            EPackage result = super.getEPackage(nsUri);
            if (result == null && WASResourceSetImpl.this.initModelMgr()) {
                result = super.getEPackage(nsUri);
            }
            return result;
        }
    }
}

