/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.product.xml.efix;

import com.ibm.websphere.product.xml.BaseWriter;
import com.ibm.websphere.product.xml.efix.efix;
import com.ibm.websphere.product.xml.efix.ptf;
import java.util.Iterator;
import java.util.List;

public class EFixWriter
extends BaseWriter {
    public static final String pgmVersion = "1.4";
    public static final String pgmUpdate = "8/8/08";

    public String getDefaultDocTypeString(List rootElements) {
        Iterator roots = rootElements.iterator();
        if (!roots.hasNext()) {
            return null;
        }
        Object firstRootElement = roots.next();
        if (firstRootElement instanceof efix) {
            return this.getDefaultEFixDocTypeString();
        }
        if (firstRootElement instanceof ptf) {
            return this.getDefaultPTFDocTypeString();
        }
        return null;
    }

    public String getDefaultEFixDocTypeString() {
        return "<!DOCTYPE efix SYSTEM \"update.dtd\">";
    }

    public String getDefaultPTFDocTypeString() {
        return "<!DOCTYPE ptf SYSTEM \"update.dtd\">";
    }

    public void emitEFix(efix efix2) {
        this.beginDocument();
        this.printIndent();
        this.beginElementOpening("efix");
        this.println();
        this.indentIn();
        this.emitAttributeOnLine("id", efix2.getId());
        this.emitAttributeOnLine("short-description", efix2.getShortDescription());
        this.printIndent();
        this.emitAttribute("build-date", efix2.getBuildDate());
        this.endElementOpening(false);
        this.println();
        int numNames = efix2.getComponentNameCount();
        for (int nameNo = 0; nameNo < numNames; ++nameNo) {
            String nextName = efix2.getComponentName(nameNo);
            this.emitElement("component-name", nextName);
        }
        this.indentOut();
        this.printIndent();
        this.emitElementClosure("efix");
        this.println();
    }

    public void emitPTF(ptf ptf2) {
        this.beginDocument();
        this.printIndent();
        this.beginElementOpening("ptf");
        this.println();
        this.indentIn();
        this.emitAttributeOnLine("id", ptf2.getId());
        this.emitAttributeOnLine("short-description", ptf2.getShortDescription());
        this.printIndent();
        this.emitAttribute("build-date", ptf2.getBuildDate());
        this.endElementOpening(false);
        this.println();
        int numNames = ptf2.getComponentNameCount();
        for (int nameNo = 0; nameNo < numNames; ++nameNo) {
            String nextName = ptf2.getComponentName(nameNo);
            this.emitElement("component-name", nextName);
        }
        this.indentOut();
        this.printIndent();
        this.emitElementClosure("ptf");
        this.println();
    }

    public void baseEmit(List rootElements) {
        Object root = rootElements.iterator().next();
        if (root instanceof efix) {
            this.emitEFix((efix)root);
        } else if (root instanceof ptf) {
            this.emitPTF((ptf)root);
        }
    }
}

