/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.product.xml;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class CalendarUtil {
    public static final String pgmVersion = "1.2";
    public static final String pgmUpdate = "8/8/08";
    public static final int HOURS_OFFSET = 0;
    public static final int MINUTES_OFFSET = 1;
    public static final int SECONDS_OFFSET = 2;
    public static final String XML_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    public static final int XML_DATE_FORMAT_LENGTH = 19;
    public static final DateFormat XML_DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    public static final String FILE_DATE_FORMAT = "yyyyMMdd_HHmmss";
    public static final DateFormat FILE_DATE_FORMATTER = new SimpleDateFormat("yyyyMMdd_HHmmss");
    public static final String SIMPLE_DATE_FORMAT = "yyyy-MM-dd";
    public static final SimpleDateFormat SIMPLE_DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd");

    public static Calendar getTimeStamp() {
        return Calendar.getInstance();
    }

    public static String getTimeStampAsString() {
        return CalendarUtil.formatXMLTimeStamp(CalendarUtil.getTimeStamp());
    }

    public static int[] splitMillisec(int millisec) {
        int seconds;
        if ((millisec -= (seconds = millisec / 1000) * 1000) >= 500) {
            ++seconds;
        }
        int hours = seconds / 3600;
        int minutes = (seconds -= hours * 3600) / 60;
        return new int[]{hours, minutes, seconds -= minutes * 60};
    }

    public static void adjustByMillisec(Calendar calendar, int deltaMillisec) {
        if (deltaMillisec == 0) {
            return;
        }
        boolean didNegate = deltaMillisec < 0;
        if (didNegate) {
            deltaMillisec *= -1;
        }
        int[] deltaValues = CalendarUtil.splitMillisec(deltaMillisec);
        int deltaHours = deltaValues[0];
        int deltaMinutes = deltaValues[1];
        int deltaSeconds = deltaValues[2];
        if (didNegate) {
            deltaMillisec *= -1;
            deltaSeconds *= -1;
            deltaMinutes *= -1;
            deltaHours *= -1;
        }
        calendar.add(13, deltaSeconds);
        calendar.add(12, deltaMinutes);
        calendar.add(10, deltaHours);
    }

    public static String formatXMLZone(int millisec) {
        String xmlZone;
        if (millisec == 0) {
            return "Z";
        }
        if (millisec < 0) {
            xmlZone = "-";
            millisec *= -1;
        } else {
            xmlZone = "+";
        }
        int[] millisecValues = CalendarUtil.splitMillisec(millisec);
        int hours = millisecValues[0];
        int minutes = millisecValues[1];
        int seconds = millisecValues[2];
        String hoursText = Integer.toString(hours);
        if (hours < 10) {
            hoursText = "0" + hoursText;
        }
        xmlZone = xmlZone + hoursText;
        String minutesText = Integer.toString(minutes);
        if (minutes < 10) {
            minutesText = "0" + minutesText;
        }
        xmlZone = xmlZone + ':' + minutesText;
        if (seconds > 0) {
            String secondsText = Integer.toString(seconds);
            if (seconds < 10) {
                secondsText = "0" + secondsText;
            }
            xmlZone = xmlZone + ':' + secondsText;
        }
        return xmlZone;
    }

    public static int[] parseXMLZone(String xmlZoneText) {
        int zoneSeconds;
        int zoneMinutes;
        int zoneHours;
        String hoursText = null;
        String minutesText = null;
        String secondsText = null;
        if (!xmlZoneText.startsWith("Z")) {
            int firstColonOffset = xmlZoneText.indexOf(58);
            if (firstColonOffset == -1) {
                hoursText = xmlZoneText;
            } else {
                hoursText = xmlZoneText.substring(0, firstColonOffset);
                int secondColonOffset = (xmlZoneText = xmlZoneText.substring(firstColonOffset, xmlZoneText.length())).indexOf(58);
                if (secondColonOffset == -1) {
                    minutesText = xmlZoneText;
                } else {
                    minutesText = xmlZoneText.substring(0, secondColonOffset);
                    secondsText = xmlZoneText.substring(secondColonOffset, xmlZoneText.length());
                }
            }
        }
        if (hoursText != null) {
            try {
                zoneHours = Integer.parseInt(hoursText);
            }
            catch (NumberFormatException e) {
                zoneHours = 0;
            }
        } else {
            zoneHours = 0;
        }
        if (minutesText != null) {
            try {
                zoneMinutes = Integer.parseInt(minutesText);
            }
            catch (NumberFormatException e) {
                zoneMinutes = 0;
            }
        } else {
            zoneMinutes = 0;
        }
        if (secondsText != null) {
            try {
                zoneSeconds = Integer.parseInt(secondsText);
            }
            catch (NumberFormatException e) {
                zoneSeconds = 0;
            }
        } else {
            zoneSeconds = 0;
        }
        return new int[]{zoneHours, zoneMinutes, zoneSeconds};
    }

    public static String formatXMLTimeStamp(Calendar calendar) {
        Date dateTime = calendar.getTime();
        String xmlDate = XML_DATE_FORMATTER.format(dateTime);
        int zoneMillisec = calendar.get(15) + calendar.get(16);
        String xmlZone = CalendarUtil.formatXMLZone(zoneMillisec);
        xmlDate = xmlDate + xmlZone;
        return xmlDate;
    }

    public static Calendar recoverCalendar(String xmlTimeStamp) {
        Date recoveredDate;
        if (xmlTimeStamp == null) {
            return null;
        }
        int zoneOffset = 19;
        String baseText = xmlTimeStamp.substring(0, zoneOffset);
        String zoneText = xmlTimeStamp.substring(zoneOffset, xmlTimeStamp.length());
        try {
            recoveredDate = XML_DATE_FORMATTER.parse(baseText);
        }
        catch (ParseException e) {
            return null;
        }
        Calendar recoveredCalendar = Calendar.getInstance();
        recoveredCalendar.setTime(recoveredDate);
        int currentZone = recoveredCalendar.get(15) + recoveredCalendar.get(16);
        int[] zoneValues = CalendarUtil.parseXMLZone(zoneText);
        int zoneHours = zoneValues[0];
        int zoneMinutes = zoneValues[1];
        int zoneSeconds = zoneValues[2];
        int recoveredZone = ((zoneHours * 60 + zoneMinutes) * 60 + zoneSeconds) * 1000;
        int deltaZone = currentZone - recoveredZone;
        CalendarUtil.adjustByMillisec(recoveredCalendar, deltaZone);
        return recoveredCalendar;
    }

    public static String fileFormat(Calendar calendar) {
        Calendar scratchCalendar = (Calendar)calendar.clone();
        int currentZone = scratchCalendar.get(15) + scratchCalendar.get(16);
        CalendarUtil.adjustByMillisec(scratchCalendar, -1 * currentZone);
        Date scratchDate = scratchCalendar.getTime();
        String fileFormat = FILE_DATE_FORMATTER.format(scratchDate);
        return fileFormat;
    }

    public static String fileFormat(String xmlTimeStamp) {
        Calendar recoveredCalendar = CalendarUtil.recoverCalendar(xmlTimeStamp);
        String fileName = recoveredCalendar == null ? null : CalendarUtil.fileFormat(recoveredCalendar);
        return fileName;
    }

    public static String formatSimple(Calendar timeStamp) {
        return SIMPLE_DATE_FORMATTER.format(timeStamp);
    }

    public static Calendar recoverSimple(String timeStampText) {
        Date recoveredDate;
        try {
            recoveredDate = SIMPLE_DATE_FORMATTER.parse(timeStampText);
        }
        catch (ParseException e) {
            return null;
        }
        Calendar recoveredCalendar = Calendar.getInstance();
        recoveredCalendar.setTime(recoveredDate);
        return recoveredCalendar;
    }
}

