/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.product.xml;

import com.ibm.websphere.product.xml.BaseFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class BaseEntityResolver
implements EntityResolver {
    public static final String pgmVersion = "1.3";
    public static final String pgmUpdate = "8/8/08";
    protected BaseFactory factory;
    protected String dtdDir;

    public BaseEntityResolver(BaseFactory factory, String dtdDir) {
        this.factory = factory;
        this.dtdDir = dtdDir;
    }

    protected BaseFactory getFactory() {
        return this.factory;
    }

    protected void setException(String publicId, String systemId, String systemName, Exception ex) {
        this.getFactory().setException("WVER0108E", new String[]{publicId, systemId, systemName}, ex);
    }

    public String getDTDDir() {
        return this.dtdDir;
    }

    public String resolveSystemId(String systemId) {
        int slashLoc = systemId.lastIndexOf("/");
        String dtdFileName = slashLoc == -1 ? systemId : systemId.substring(slashLoc + 1);
        return this.getDTDDir() + File.separator + dtdFileName;
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        String systemName = this.resolveSystemId(systemId);
        try {
            FileInputStream inputStream = new FileInputStream(systemName);
            return new InputSource(inputStream);
        }
        catch (FileNotFoundException e) {
            this.setException(publicId, systemId, systemName, e);
            return null;
        }
    }
}

