/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.product.utils;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.regex.Pattern;

public class WASPlatformConstants {
    public static final int N_UNKNOWN = 0;
    public static final int N_AIX = 1;
    public static final int N_HPUX = 2;
    public static final int N_SOLARIS = 3;
    public static final int N_LINUX = 4;
    public static final int N_WINDOWS = 5;
    public static final int N_Z_OS = 6;
    public static final int N_OS400 = 7;
    public static final int N_OS400_REMOTE = 8;
    public static final String S_PLATFORM_TYPE_UNKNOWN = "NA";
    public static final String S_PLATFORM_TYPE_AIX = "aix";
    public static final String S_PLATFORM_TYPE_HPUX = "hpux";
    public static final String S_PLATFORM_TYPE_SOLARIS = "solaris";
    public static final String S_PLATFORM_TYPE_LINUX = "linux";
    public static final String S_PLATFORM_TYPE_WINDOWS = "windows";
    public static final String S_PLATFORM_TYPE_OS400 = "os400";
    public static final String S_PLATFORM_TYPE_ZOS = "zos";
    public static final String S_PARAM_LIST_SEPARATOR = ";";
    public static final String S_PPC = "ppc";
    public static final String S_PPC32 = "ppc32";
    public static final String S_PPC64 = "ppc64";
    public static final String S_IA64 = "ia64";
    public static final String S_IA32 = "ia32";
    public static final String S_AMD64 = "x86_64";
    public static final String S_PARISC = "pa-risc";
    public static final String S_S390_32 = "s390_32";
    public static final String S_S390 = "s390";
    public static final String S_S390_64 = "s390_64";
    public static final String S_SPARC = "sparc";
    public static final String S_SPARC64 = "sparc64";
    public static final String S_ARCH_NAME_IA32 = "Intel (32 bit)";
    public static final String S_ARCH_NAME_AMD64 = "AMD (64 bit)";
    public static final String S_ARCH_NAME_PPC32 = "PPC32";
    public static final String S_ARCH_NAME_PPC64 = "PPC64";
    public static final String S_ARCH_NAME_IA64 = "Itanium (64 bit)";
    public static final String S_ARCH_NAME_PARISC = "PARISC (32 bit)";
    public static final String S_ARCH_NAME_SPARC = "SPARC (32 bit)";
    public static final String S_ARCH_NAME_SPARC64 = "SPARC (64 bit)";
    public static final String S_ARCH_NAME_OS400_PPC64 = "System i";
    public static final String S_ARCH_NAME_OS390_32 = "System z (31 bit)";
    public static final String S_ARCH_NAME_OS390_64 = "System z (64 bit)";
    public static final String S_ARCH_NAME_OS390 = "System z";
    public static final String S_LIB_EXT_WINDOWS = ".dll";
    public static final String S_LIB_EXT_AIX_SOLARIS_LINUX_HP64 = ".so";
    public static final String S_LIB_EXT_HP32 = ".sl";
    private static HashMap platformArchNameMap = new HashMap();
    private static final int N_UNDEFINED = -1;
    private static int nPlatformNumber;
    private static final String S_JAVA_OS_PROPERTY = "os.name";
    private static final String S_JAVA_OS_VERSION_PROPERTY = "os.version";
    private static final String S_AIX_PATTERN = "^.*aix.*$";
    private static final String S_HPUX_PATTERN = "^.*hp-ux.*$";
    private static final String S_SOLARIS_PATTERN = "^.*sunos.*$";
    private static final String S_LINUX_PATTERN = "^.*linux.*$";
    private static final String S_WINDOWS_PATTERN = "^.*windows.*$";
    private static final String S_Z_OS_PATTERN = "^.*z/os.*$";
    private static final String S_OS400_PATTERN = "^.*os/400.*$";
    private static final String S_WINDOWS_XP = "windows xp";
    private static final String S_WINDOWS_2000 = "windows 2000";
    private static final String S_WINDOWS_SERVER_2003 = "windows server 2003";
    private static final String S_WINDOWS_VISTA_VERSION = "6.0";
    private static final String[] AS_SHELL_EXEC_WIN;
    private static final String[] AS_SHELL_EXEC_UNIX;
    private static final String[] AS_SHELL_EXEC_OS400;
    private static final String[] AS_EMPTY;
    private static final String S_QUOTE = "\"";
    private static final String S_EMPTY = "";
    private static final String S_DOLLAR = "$";
    private static final String S_PERCENTAGE = "%";
    private static final String S_UNIX_SHELL_VARIABLE_BRACKET_START = "{";
    private static final String S_UNIX_SHELL_VARIABLE_BRACKET_STOP = "}";
    private static final String S_PATTERN_CHECK_IF_STRING_HAS_ANY_SPACES = "^.*\\s.*$";
    private static final char C_QUOTE = '\"';
    private static final char C_SPACE = ' ';
    private static final String S_WINDOWS_FS_PATH_SEPARATOR = "\\";
    private static final String S_UNIX_FS_PATH_SEPARATOR = "/";
    private static final String S_OS400_FS_PATH_SEPARATOR = "/";
    private static final String[] AS_WINOSNAME_VERSION_MAPPING;

    public static String[] getShellExecPrefixForCurrentPlatform() {
        if (WASPlatformConstants.isCurrentPlatformUNIX()) {
            return AS_SHELL_EXEC_UNIX;
        }
        if (WASPlatformConstants.isCurrentPlatformWindows()) {
            return AS_SHELL_EXEC_WIN;
        }
        if (WASPlatformConstants.isCurrentPlatformOS400()) {
            return AS_SHELL_EXEC_OS400;
        }
        return AS_EMPTY;
    }

    public static boolean isCurrentPlatformUNIX() {
        int nCurrentPlatform = WASPlatformConstants.getCurrentPlatform();
        return nCurrentPlatform == 1 || nCurrentPlatform == 2 || nCurrentPlatform == 3 || nCurrentPlatform == 4 || nCurrentPlatform == 6;
    }

    public static boolean isCurrentPlatformAIX() {
        int nCurrentPlatform = WASPlatformConstants.getCurrentPlatform();
        return nCurrentPlatform == 1;
    }

    public static boolean isCurrentPlatformHPUnix() {
        int nCurrentPlatform = WASPlatformConstants.getCurrentPlatform();
        return nCurrentPlatform == 2;
    }

    public static boolean isCurrentPlatformWindows() {
        return WASPlatformConstants.getCurrentPlatform() == 5;
    }

    public static boolean isCurrentPlatformWindowsVista() {
        String sOSVersion;
        return WASPlatformConstants.isCurrentPlatformWindows() && (sOSVersion = System.getProperty(S_JAVA_OS_VERSION_PROPERTY)).trim().startsWith(S_WINDOWS_VISTA_VERSION);
    }

    public static boolean isCurrentPlatformWindowsServer2003() {
        String sOSName;
        return WASPlatformConstants.getCurrentPlatform() == 5 && (sOSName = System.getProperty(S_JAVA_OS_PROPERTY).toLowerCase()).indexOf(S_WINDOWS_SERVER_2003) != -1;
    }

    public static boolean isCurrentPlatformWindows2000orXP() {
        if (WASPlatformConstants.getCurrentPlatform() == 5) {
            String sOSName = System.getProperty(S_JAVA_OS_PROPERTY).toLowerCase();
            if (sOSName.indexOf(S_WINDOWS_XP) != -1) {
                return true;
            }
            return sOSName.indexOf(S_WINDOWS_2000) != -1;
        }
        return false;
    }

    public static boolean isCurrentPlatformOS400() {
        int nCurrentPlatform = WASPlatformConstants.getCurrentPlatform();
        return nCurrentPlatform == 7;
    }

    public static int getCurrentPlatform() {
        if (nPlatformNumber != -1) {
            return nPlatformNumber;
        }
        String sOSName = System.getProperty(S_JAVA_OS_PROPERTY).toLowerCase();
        if (Pattern.matches(S_AIX_PATTERN, sOSName)) {
            nPlatformNumber = 1;
            return 1;
        }
        if (Pattern.matches(S_HPUX_PATTERN, sOSName)) {
            nPlatformNumber = 2;
            return 2;
        }
        if (Pattern.matches(S_SOLARIS_PATTERN, sOSName)) {
            nPlatformNumber = 3;
            return 3;
        }
        if (Pattern.matches(S_LINUX_PATTERN, sOSName)) {
            nPlatformNumber = 4;
            return 4;
        }
        if (Pattern.matches(S_WINDOWS_PATTERN, sOSName)) {
            nPlatformNumber = 5;
            return 5;
        }
        if (Pattern.matches(S_Z_OS_PATTERN, sOSName)) {
            nPlatformNumber = 6;
            return 6;
        }
        if (Pattern.matches(S_OS400_PATTERN, sOSName)) {
            nPlatformNumber = 7;
            return 7;
        }
        nPlatformNumber = 0;
        return 0;
    }

    public static String getCurrentPlatformCode() {
        String sOSName = System.getProperty(S_JAVA_OS_PROPERTY).toLowerCase();
        if (Pattern.matches(S_AIX_PATTERN, sOSName)) {
            return S_PLATFORM_TYPE_AIX;
        }
        if (Pattern.matches(S_HPUX_PATTERN, sOSName)) {
            return S_PLATFORM_TYPE_HPUX;
        }
        if (Pattern.matches(S_SOLARIS_PATTERN, sOSName)) {
            return S_PLATFORM_TYPE_SOLARIS;
        }
        if (Pattern.matches(S_LINUX_PATTERN, sOSName)) {
            return S_PLATFORM_TYPE_LINUX;
        }
        if (Pattern.matches(S_WINDOWS_PATTERN, sOSName)) {
            return S_PLATFORM_TYPE_WINDOWS;
        }
        if (Pattern.matches(S_Z_OS_PATTERN, sOSName)) {
            return S_PLATFORM_TYPE_ZOS;
        }
        if (Pattern.matches(S_OS400_PATTERN, sOSName)) {
            return S_PLATFORM_TYPE_OS400;
        }
        return S_PLATFORM_TYPE_UNKNOWN;
    }

    public static String convertToShellVariable(String sName) {
        if (WASPlatformConstants.isCurrentPlatformUNIX() || WASPlatformConstants.isCurrentPlatformOS400()) {
            return "${" + sName + S_UNIX_SHELL_VARIABLE_BRACKET_STOP;
        }
        if (WASPlatformConstants.isCurrentPlatformWindows()) {
            return S_PERCENTAGE + sName + S_PERCENTAGE;
        }
        return sName;
    }

    public static String convertToShellParam(String sParam) {
        if (sParam.matches(S_PATTERN_CHECK_IF_STRING_HAS_ANY_SPACES) && !WASPlatformConstants.isQuoted(sParam)) {
            String sReturn = S_QUOTE + sParam + S_QUOTE;
            return sReturn;
        }
        return sParam;
    }

    public static String getCurrentOSFSPathSeparator() {
        if (WASPlatformConstants.isCurrentPlatformOS400()) {
            return "/";
        }
        if (WASPlatformConstants.isCurrentPlatformUNIX()) {
            return "/";
        }
        if (WASPlatformConstants.isCurrentPlatformWindows()) {
            return S_WINDOWS_FS_PATH_SEPARATOR;
        }
        return "/";
    }

    public static String getWindowsOSName(String sVersion) {
        String[] asWinOSNameVersionMapping = AS_WINOSNAME_VERSION_MAPPING;
        for (int i = 0; i < asWinOSNameVersionMapping.length; ++i) {
            String sWinOSName = asWinOSNameVersionMapping[i].substring(0, asWinOSNameVersionMapping[i].indexOf(S_PARAM_LIST_SEPARATOR));
            String sVersionThis = asWinOSNameVersionMapping[i].substring(asWinOSNameVersionMapping[i].indexOf(S_PARAM_LIST_SEPARATOR) + 1);
            if (!sVersionThis.equals(sVersion)) continue;
            return sWinOSName;
        }
        return S_EMPTY;
    }

    public static String getOfficialArchNameByOSArchKeyword(String os, String arch) {
        String sReturn = (String)platformArchNameMap.get(os + S_PARAM_LIST_SEPARATOR + arch);
        if (sReturn == null) {
            return arch;
        }
        return sReturn;
    }

    public static String getArchByXcoffDecoder(String XcoffFilePath) throws IOException {
        String arch = null;
        FileInputStream fis = new FileInputStream(XcoffFilePath);
        int archHi = fis.read() & 0xFF;
        int archLo = fis.read() & 0xFF;
        int archB = archLo + (archHi << 8);
        fis.close();
        switch (archB) {
            case 479: {
                arch = S_PPC32;
                break;
            }
            case 495: {
                arch = S_PPC64;
                break;
            }
            case 503: {
                arch = S_PPC64;
                break;
            }
            default: {
                arch = null;
            }
        }
        return arch;
    }

    public static String getArchByElfDecoder(String elfFilePath) throws IOException {
        String arch = null;
        FileInputStream fis = new FileInputStream(elfFilePath);
        int b1 = fis.read();
        int b2 = fis.read();
        int b3 = fis.read();
        int b4 = fis.read();
        if (b1 != 127 || b2 != 69 || b3 != 76 || b4 != 70) {
            // empty if block
        }
        int b5 = fis.read();
        fis.skip(13L);
        int archB = fis.read();
        if (archB == 0) {
            archB = fis.read();
        }
        fis.close();
        switch (archB) {
            case 2: {
                arch = S_SPARC;
                break;
            }
            case 3: {
                arch = S_IA32;
                break;
            }
            case 15: {
                arch = S_PARISC;
                break;
            }
            case 20: {
                arch = S_PPC32;
                break;
            }
            case 21: {
                arch = S_PPC64;
                break;
            }
            case 43: {
                arch = S_SPARC64;
                break;
            }
            case 50: {
                arch = S_IA64;
                break;
            }
            case 62: {
                arch = S_AMD64;
                break;
            }
            case 22: {
                arch = S_S390_32;
                if (b5 != 2) break;
                arch = S_S390_64;
                break;
            }
            default: {
                arch = null;
            }
        }
        return arch;
    }

    public static String getArchByDllDecoder(String dllFilePath) throws IOException {
        String arch = S_EMPTY;
        FileInputStream fis = new FileInputStream(dllFilePath);
        fis.skip(60L);
        int offsetLo = fis.read() & 0xFF;
        int offsetHigh = fis.read() & 0xFF;
        int fileOffset = offsetLo + (offsetHigh << 8);
        fis.skip(fileOffset - 62);
        int pByte = fis.read();
        int eByte = fis.read();
        fis.skip(2L);
        if (pByte != 80 || eByte != 69) {
            return arch;
        }
        int archLo = fis.read() & 0xFF;
        int archHi = fis.read() & 0xFF;
        int archB = archLo + (archHi << 8);
        fis.close();
        switch (archB) {
            case 332: {
                arch = S_IA32;
                break;
            }
            case 496: {
                arch = S_PPC32;
                break;
            }
            case 512: {
                arch = S_IA64;
                break;
            }
            case 34404: {
                arch = S_AMD64;
                break;
            }
            default: {
                arch = null;
            }
        }
        return arch;
    }

    private static boolean isQuoted(String sToCheck) {
        boolean fQuoted = false;
        for (int i = 0; i < sToCheck.length(); ++i) {
            if (sToCheck.charAt(i) == '\"') {
                boolean bl = fQuoted = !fQuoted;
            }
            if (sToCheck.charAt(i) != ' ' || fQuoted) continue;
            return false;
        }
        return true;
    }

    static {
        platformArchNameMap.put("windows;ia32", S_ARCH_NAME_IA32);
        platformArchNameMap.put("windows;x86_64", S_ARCH_NAME_AMD64);
        platformArchNameMap.put("aix;ppc32", S_ARCH_NAME_PPC32);
        platformArchNameMap.put("aix;ppc64", S_ARCH_NAME_PPC64);
        platformArchNameMap.put("hpux;pa-risc", S_ARCH_NAME_PARISC);
        platformArchNameMap.put("hpux;ia64", S_ARCH_NAME_IA64);
        platformArchNameMap.put("solaris;sparc", S_ARCH_NAME_SPARC);
        platformArchNameMap.put("solaris;sparc64", S_ARCH_NAME_SPARC64);
        platformArchNameMap.put("solaris;x86_64", S_ARCH_NAME_AMD64);
        platformArchNameMap.put("os400;ppc64", S_ARCH_NAME_OS400_PPC64);
        platformArchNameMap.put("linux;ia32", S_ARCH_NAME_IA32);
        platformArchNameMap.put("linux;x86_64", S_ARCH_NAME_AMD64);
        platformArchNameMap.put("linux;ppc32", S_ARCH_NAME_PPC32);
        platformArchNameMap.put("linux;ppc64", S_ARCH_NAME_PPC64);
        platformArchNameMap.put("linux;s390_32", S_ARCH_NAME_OS390_32);
        platformArchNameMap.put("linux;s390_64", S_ARCH_NAME_OS390_64);
        platformArchNameMap.put("zos;s390", S_ARCH_NAME_OS390);
        nPlatformNumber = -1;
        AS_SHELL_EXEC_WIN = new String[]{"cmd.exe", "/c"};
        AS_SHELL_EXEC_UNIX = new String[]{"sh", "-c"};
        AS_SHELL_EXEC_OS400 = new String[]{"sh", "-c"};
        AS_EMPTY = new String[0];
        AS_WINOSNAME_VERSION_MAPPING = new String[]{"Windows 2000;5.0", "Windows XP;5.1", "Windows 2003;5.2"};
    }
}

