/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.product.utils;

import com.ibm.websphere.product.WASDirectoryException;
import java.io.File;
import java.text.DateFormat;
import java.util.Date;

public class WASDirectoryHelper {
    public static final String ID_BASE = "BASE";
    public static final String ID_EXPRESS = "EXPRESS";
    public static final String ID_ND = "ND";
    public static final String ID_PME = "PME";
    public static final String ID_WBI = "WBI";
    public static final String ID_JDK = "JDK";
    public static final String ID_EMBEDDED_EXPRESS = "embeddedEXPRESS";
    public static final String ID_XD = "XD";
    public static final String ID_CLIENT = "CLIENT";
    public static final String ID_PLUGIN = "PLG";
    public static final String ID_IHS = "IHS";
    public static final String ID_WXD = "WXD";
    public static final String ID_NDDMZ = "NDDMZ";
    private static final String ID_SUFFIX_TRIAL = "TRIAL";
    private static final String ID_SUFFIX_NONV61 = "_NONV61";
    public static final String ID_BASE_NONV61 = "BASE_NONV61";
    public static final String ID_BASETRIAL = "BASETRIAL";
    public static final String ID_BASETRIAL_NONV61 = "BASETRIAL_NONV61";
    public static final String ID_EXPRESS_NONV61 = "EXPRESS_NONV61";
    public static final String ID_EXPRESSTRIAL = "EXPRESSTRIAL";
    public static final String ID_EXPRESSTRIAL_NONV61 = "EXPRESSTRIAL_NONV61";
    public static final String ID_ND_NONV61 = "ND_NONV61";
    public static final String ID_CLIENT_NONV61 = "CLIENT_NONV61";
    private static final char C_WINDOWS_FILE_SEPARATOR = '\\';
    private static final char C_LINUX_FILE_SEPARATOR = '/';
    private static final String S_URI_PATH_SEPARATOR = "/";
    public static final String INSTALL_ROOT_PROPERTY_NAME = "was.install.root";
    public static final String VERSION_DIR_PROPERTY_NAME = "was.version.dir";
    public static final String DTD_DIR_PROPERTY_NAME = "was.version.dtd.dir";
    public static final String LOG_DIR_PROPERTY_NAME = "was.version.log.dir";
    public static final String BACKUP_DIR_PROPERTY_NAME = "was.version.backup.dir";
    public static final String TMP_DIR_PROPERTY_NAME = "was.version.tmp.dir";
    public static final String JAVA_TMP_DIR_PROPERTY_NAME = "java.io.tmpdir";
    public static final String PROPERTIES_DIR_NAME = "properties";
    public static final String VERSION_DIR_NAME = "version";
    public static final String HISTORY_DIR_NAME = "history";
    public static final String DTD_DIR_NAME = "dtd";
    public static final String LOG_DIR_NAME = "logs";
    public static final String UPDATE_DIR_NAME = "update";
    public static final String BACKUP_DIR_NAME = "backup";
    public static final String DEFAULT_TMP_DIR_NAME = "tmp";
    public static final String FULL_INSTALL_DIR_NAME = "install";
    public static final String NIF_DIR_NAME = "nif";
    public static final String NIF_HISTORY_XML_FILENAME = "NIFHistory.xml";
    public static final String MAINTENANCE_HISTORY_XML_FILENAME = "maintenanceHistory.xml";
    public static final String S_DOT = ".";
    public static final String S_UPDATE_LOG_FILE_NAME = "updatelog";
    public static final String S_TEXT_FILE_EXT = ".txt";

    public static String normalizedProductID(String id) {
        if (ID_BASETRIAL.equalsIgnoreCase(id) || ID_BASE_NONV61.equalsIgnoreCase(id) || ID_BASETRIAL_NONV61.equalsIgnoreCase(id)) {
            return ID_BASE;
        }
        if (ID_EXPRESSTRIAL.equalsIgnoreCase(id) || ID_EXPRESS_NONV61.equalsIgnoreCase(id) || ID_EXPRESSTRIAL_NONV61.equalsIgnoreCase(id)) {
            return ID_EXPRESS;
        }
        if (ID_ND_NONV61.equalsIgnoreCase(id)) {
            return ID_ND;
        }
        if (ID_CLIENT_NONV61.equalsIgnoreCase(id)) {
            return ID_CLIENT;
        }
        return id;
    }

    public static String normalizeLocation(String sLocation, boolean trailSeparator) {
        if (sLocation != null) {
            if ((sLocation = sLocation.replace('\\', '/')).endsWith(S_URI_PATH_SEPARATOR)) {
                if (!trailSeparator) {
                    sLocation = sLocation.substring(0, sLocation.length() - S_URI_PATH_SEPARATOR.length());
                }
            } else if (trailSeparator) {
                sLocation = sLocation + S_URI_PATH_SEPARATOR;
            }
            return sLocation;
        }
        return null;
    }

    public static String normalizeLocationNoEndingSlash(String sLocation) {
        return WASDirectoryHelper.normalizeLocation(sLocation, false);
    }

    public static String normalizeLocationAccordingToPlatform(String sLocation, boolean trailSeparator) {
        if (sLocation != null) {
            sLocation = sLocation.replace('\\', File.separatorChar);
            if ((sLocation = sLocation.replace('/', File.separatorChar)).endsWith(File.separator)) {
                if (!trailSeparator) {
                    sLocation = sLocation.substring(0, sLocation.length() - File.separator.length());
                }
            } else if (trailSeparator) {
                sLocation = sLocation + File.separator;
            }
        }
        return sLocation;
    }

    public static String getInstallRootPath() throws WASDirectoryException {
        String productDirName = System.getProperty(INSTALL_ROOT_PROPERTY_NAME);
        if (productDirName == null) {
            throw new WASDirectoryException("WVER0001E", null, null);
        }
        productDirName = WASDirectoryHelper.normalizeLocationAccordingToPlatform(productDirName, false);
        return productDirName;
    }

    public static String getVersionDirPath(String installRoot) {
        if (installRoot != null) {
            return WASDirectoryHelper.normalizeLocationAccordingToPlatform(installRoot, true) + PROPERTIES_DIR_NAME + File.separator + VERSION_DIR_NAME;
        }
        return null;
    }

    public static String getLogDirPath(String installRoot) {
        if (installRoot != null) {
            return WASDirectoryHelper.normalizeLocationAccordingToPlatform(installRoot, true) + LOG_DIR_NAME;
        }
        return null;
    }

    public static String getBackupDirPath(String installRoot) {
        if (installRoot != null) {
            String versionDirPath = WASDirectoryHelper.getVersionDirPath(installRoot);
            String sBackupDirName = versionDirPath + File.separator + UPDATE_DIR_NAME + File.separator + BACKUP_DIR_NAME;
            if (new File(sBackupDirName).exists()) {
                return sBackupDirName;
            }
            return versionDirPath + File.separator + NIF_DIR_NAME + File.separator + BACKUP_DIR_NAME;
        }
        return null;
    }

    public static String getHistoryDirPath(String installRoot) {
        if (installRoot != null) {
            String versionDirPath = WASDirectoryHelper.getVersionDirPath(installRoot);
            return versionDirPath + File.separator + HISTORY_DIR_NAME;
        }
        return null;
    }

    public static String getDTDDirPath(String installRoot) {
        if (installRoot != null) {
            String versionDirPath = WASDirectoryHelper.getVersionDirPath(installRoot);
            return versionDirPath + File.separator + DTD_DIR_NAME;
        }
        return null;
    }

    public static String getTmpDirPath() {
        String tmpDirName = System.getProperty(TMP_DIR_PROPERTY_NAME);
        if (tmpDirName == null && (tmpDirName = System.getProperty(JAVA_TMP_DIR_PROPERTY_NAME)) == null) {
            tmpDirName = DEFAULT_TMP_DIR_NAME;
        }
        tmpDirName = WASDirectoryHelper.normalizeLocationAccordingToPlatform(tmpDirName, false);
        return tmpDirName;
    }

    public static String getCurrentTimestamp() {
        Date dateCurrentDate = new Date(System.currentTimeMillis());
        return DateFormat.getDateTimeInstance(1, 1).format(dateCurrentDate);
    }
}

