/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.product.metadata;

import com.ibm.websphere.product.utils.WASDirectoryHelper;
import java.io.File;
import java.util.Iterator;
import java.util.Vector;

public class WASMetadataHelper {
    public static final String S_PARAM_NODE_NAME = "param";
    public static final String S_PARAM_NAME_ATTRIBUTE_NAME = "name";
    public static final String S_PARAM_VALUE_ATTRIBUTE_NAME = "value";
    public static final String S_HISTORY_XML_FILENAME = "NIFHistory.xml";
    public static final String S_HISTORY_XML_FILENAME_LEGACY = "maintenanceHistory.xml";
    public static final String S_HISTORY_ROOT_ELEMENT = "maintenance-history";
    public static final String S_HISTORY_ELEMENT_PACKAGE = "maintenance";
    public static final String S_HISTORY_ATTRIBUTE_NAME = "name";
    public static final String S_HISTORY_ATTRIBUTE_ORDER = "order";
    public static final String S_HISTORY_PARAM_FEATURE = "feature";
    public static final String S_HISTORY_PARAM_COMPONENT = "component";
    public static final String S_HISTORY_PARAM_ACTION = "action";
    public static final String S_HISTORY_PARAM_STATUS = "status";
    public static final String S_HISTORY_PARAM_TIMESTAMP = "timestamp";
    public static final String S_HISTORY_PARAM_APAR = "apar";
    public static final String S_HISTORY_PARAM_INFO = "info";
    public static final String S_HISTORY_PARAM_ISOFFICIALFIX = "isofficialfix";
    public static final String S_HISTORY_PARAM_APARS = "apars";
    public static final String S_HISTORY_PARAM_ISBACKUPPACKAGE = "isbackuppackage";
    public static final String S_HISTORY_PARAM_BUILDDATE = "builddate";
    public static final String S_HISTORY_PARAM_FILENAME = "filename";
    public static final String S_HISTORY_PARAM_WASINSTALLEDASPRIMARY = "wasinstalledasprimary";
    public static final String S_HISTORY_PARAM_PACKAGETYPE = "packagetype";
    public static final String S_HISTORY_PARAM_PAKVERSION = "pakversion";
    public static final String S_HISTORY_PARAM_WASINSTALLEDASMAINTENANCE = "wasinstalledasmaintenance";
    public static final String S_HISTORY_PARAM_ISENABLINGIFIX = "isenablingifix";
    public static final String S_HISTORY_ACTION_INSTALL = "install";
    public static final String S_HISTORY_ACTION_UNINSTALL = "uninstall";
    public static final String S_HISTORY_UPDATE_EFFECT_REPLACE = "replace";
    public static final String S_HISTORY_UPDATE_TYPE_MAINTENANCE_PACKAGE = "maintenance package";
    public static final String S_HISTORY_STATUS_SUCCESS = "success";
    public static final String S_HISTORY_STATUS_PARTIALSUCCESS = "partialSuccess";
    public static final String S_HISTORY_STATUS_FAILURE = "failure";
    public static final String S_HISTORY_BACKUP_FILENAME_NOT_APPLICABLE = "not applicable";
    public static final String S_TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ssZ";
    public static final String S_COMPONENT_FILE_EXTENSION = ".component";
    public static final String S_EMPTY = "";
    public static final String S_SEPARATOR_MESSAGE_TEXT = "----------------------------------------------------------------------------";
    public static final String S_SPACE_PADDINGS_80 = "                                                                                ";
    private static final int N_INDENT_AMOUNT = 4;

    public static String getHistoryXmlPath(String installRoot) {
        if (installRoot == null) {
            return null;
        }
        String backupDirPath = WASDirectoryHelper.getBackupDirPath(installRoot);
        String sHistoryXmlFullPath = null;
        if (backupDirPath.endsWith("nif" + File.separator + "backup")) {
            sHistoryXmlFullPath = WASDirectoryHelper.normalizeLocationAccordingToPlatform(backupDirPath, true) + S_HISTORY_XML_FILENAME;
        } else if (backupDirPath.endsWith("update" + File.separator + "backup")) {
            sHistoryXmlFullPath = WASDirectoryHelper.normalizeLocationAccordingToPlatform(backupDirPath, true) + S_HISTORY_XML_FILENAME_LEGACY;
        }
        return sHistoryXmlFullPath;
    }

    public static Vector calculateAllocations(Vector table) {
        Vector<int[]> tableAllocation = new Vector<int[]>(1);
        Iterator tableRows = table.iterator();
        int totalNumColumn = 0;
        int[] columnWidths = null;
        while (tableRows.hasNext()) {
            Object[] currentRow = (Object[])tableRows.next();
            if (columnWidths == null) {
                totalNumColumn = currentRow.length;
                columnWidths = new int[totalNumColumn];
                for (int i = 0; i < totalNumColumn; ++i) {
                    columnWidths[i] = 0;
                }
            }
            for (int columnNo = 0; columnNo < totalNumColumn; ++columnNo) {
                String currentColumnText;
                Object currentColumnValue = currentRow[columnNo];
                String string = currentColumnText = currentColumnValue == null ? S_EMPTY : currentColumnValue.toString();
                if (currentColumnText.length() <= columnWidths[columnNo]) continue;
                columnWidths[columnNo] = currentColumnText.length();
            }
        }
        for (int columnNo = 0; columnNo < totalNumColumn; ++columnNo) {
            if (columnNo == totalNumColumn - 1) continue;
            int n = columnNo;
            columnWidths[n] = columnWidths[n] + 4;
        }
        tableAllocation.add(columnWidths);
        return tableAllocation;
    }
}

