/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.product.metadata;

import com.ibm.websphere.product.history.xml.eventHistory;
import com.ibm.websphere.product.logger.WASDirectoryLogger;
import com.ibm.websphere.product.metadata.WASComponent;
import com.ibm.websphere.product.metadata.WASComponentUpdate;
import com.ibm.websphere.product.metadata.WASMaintenancePackage;
import com.ibm.websphere.product.metadata.WASMetadataHelper;
import com.ibm.websphere.product.utils.HistoryInfoEntityResolver;
import com.ibm.websphere.product.utils.SimpleXMLParser;
import com.ibm.websphere.product.utils.WASDirectoryHelper;
import com.ibm.websphere.product.xml.component.component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Vector;
import java.util.logging.Level;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class WASMetadata {
    private static HashMap wasMetadataInstances = new HashMap();
    private static final String S_PATH_MAINTENANCE = "maintenance-history/maintenance";
    private String installRoot = null;
    private WASDirectoryLogger logger = null;
    private long lastModifyHistoryFile = 0L;
    private eventHistory eventHistoryInstance = new eventHistory();
    private Vector historyMaintenancePackages = new Vector();
    private LinkedHashMap installedMaintenancesMap = new LinkedHashMap();
    private LinkedHashMap installedComponentsMap = new LinkedHashMap();
    private LinkedHashMap installedPTFsMap = new LinkedHashMap();
    private LinkedHashMap installedPTFAppliedMap = new LinkedHashMap();
    private LinkedHashMap installedPTFDriverMap = new LinkedHashMap();

    public static WASMetadata getWASMetadataInstance(String installRoot) throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        if ((installRoot = WASDirectoryHelper.normalizeLocationAccordingToPlatform(installRoot, false)) == null || !new File(installRoot).exists()) {
            return null;
        }
        WASMetadata instanceReturn = (WASMetadata)wasMetadataInstances.get(installRoot);
        if (instanceReturn == null) {
            instanceReturn = new WASMetadata(installRoot);
            wasMetadataInstances.put(installRoot, instanceReturn);
        }
        return instanceReturn;
    }

    public WASMaintenancePackage[] getHistoryMaintenancePackageList() throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        return this.historyMaintenancePackages.toArray(new WASMaintenancePackage[this.historyMaintenancePackages.size()]);
    }

    public WASComponent[] getInstalledComponentList() throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        Vector componentVector = new Vector(this.installedComponentsMap.values());
        return componentVector.toArray(new WASComponent[componentVector.size()]);
    }

    public WASMaintenancePackage[] getInstalledMaintenancePackageList() throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        Vector maintenancePackagesVector = new Vector(this.installedMaintenancesMap.values());
        return maintenancePackagesVector.toArray(new WASMaintenancePackage[maintenancePackagesVector.size()]);
    }

    public WASComponent getInstalledComponentByName(String componentName) throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        return (WASComponent)this.installedComponentsMap.get(componentName);
    }

    public WASMaintenancePackage getInstalledMaintenancePackageByID(String mpID) throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        return (WASMaintenancePackage)this.installedMaintenancesMap.get(mpID);
    }

    public String getInstallRoot() {
        return this.installRoot;
    }

    public Vector getComponentVector() throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        Vector<component> componentVector = new Vector<component>();
        for (int i = 0; i < this.getInstalledComponentList().length; ++i) {
            componentVector.add(this.getInstalledComponentList()[i].getComponent());
        }
        componentVector.trimToSize();
        return componentVector;
    }

    public eventHistory getEventHistory() throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        return this.eventHistoryInstance;
    }

    public Vector getPTFVector() throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        return new Vector(this.installedPTFsMap.values());
    }

    public Vector getPTFAppliedVector() throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        return new Vector(this.installedPTFAppliedMap.values());
    }

    public Vector getPTFDriverVector() throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        return new Vector(this.installedPTFDriverMap.values());
    }

    public void resetCachedData() {
        this.historyMaintenancePackages.clear();
        this.installedComponentsMap.clear();
        this.installedMaintenancesMap.clear();
        this.installedPTFAppliedMap.clear();
        this.installedPTFDriverMap.clear();
        this.installedPTFsMap.clear();
        this.eventHistoryInstance = new eventHistory();
        this.logger.logThisMessage(Level.INFO, this.getClass().getName(), "resetCachedData", "Reset cached data.");
    }

    protected WASMetadata(String installRoot) throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        this.setInstallRoot(installRoot);
        this.setLogger(WASDirectoryLogger.getWASDirectoryLogger(installRoot));
        this.logger.entering(this.getClass().getName(), "WASMetadata");
        this.parseMetadataFiles();
        this.logger.exiting(this.getClass().getName(), "WASMetadata");
    }

    protected void assignComponentUpdatesToComponent() throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        this.logger.entering(this.getClass().getName(), "assignComponentUpdatesToComponent");
        WASMaintenancePackage[] maintenancePackageList = this.getInstalledMaintenancePackageList();
        for (int i = 0; i < maintenancePackageList.length; ++i) {
            WASMaintenancePackage maintenanceThis = maintenancePackageList[i];
            WASComponentUpdate[] componentUpdatesFromThisMaintenance = maintenanceThis.getComponentUpdateList();
            for (int j = 0; j < componentUpdatesFromThisMaintenance.length; ++j) {
                String componentNameFromComponentUpdate = componentUpdatesFromThisMaintenance[j].getComponentName();
                if (componentNameFromComponentUpdate == null) continue;
                WASComponent componentWithThisName = this.getInstalledComponentByName(componentNameFromComponentUpdate);
                if (componentWithThisName != null) {
                    componentWithThisName.addComponentUpdateToList(componentUpdatesFromThisMaintenance[j]);
                    continue;
                }
                this.logger.logThisMessage(Level.WARNING, this.getClass().getName(), "assignComponentUpdatesToComponent", "Component Update with this name: " + componentNameFromComponentUpdate + " could not associate with an existing component");
            }
        }
        this.logger.exiting(this.getClass().getName(), "assignComponentUpdatesToComponent");
    }

    protected void parseMetadataFiles() throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        this.logger.entering(this.getClass().getName(), "parseMetadataFiles");
        try {
            this.resetCachedData();
            File historyXmlFile = new File(WASMetadataHelper.getHistoryXmlPath(this.installRoot));
            if (!historyXmlFile.exists()) {
                return;
            }
            FileInputStream historyFileInputStream = new FileInputStream(historyXmlFile);
            this.parseHistoryXmlFile(this.installRoot, historyFileInputStream);
            this.parseComponentFiles(this.installRoot);
            this.assignComponentUpdatesToComponent();
            historyFileInputStream.close();
        }
        catch (FileNotFoundException fnfe) {
            this.logger.logThisException(Level.SEVERE, this.getClass().getName(), "parseMetadataFiles", fnfe.getMessage(), fnfe);
            throw fnfe;
        }
        catch (IOException ioe) {
            this.logger.logThisException(Level.SEVERE, this.getClass().getName(), "parseMetadataFiles", ioe.getMessage(), ioe);
            throw ioe;
        }
        catch (ParserConfigurationException pce) {
            this.logger.logThisException(Level.SEVERE, this.getClass().getName(), "parseMetadataFiles", pce.getMessage(), pce);
            throw pce;
        }
        catch (SAXException saxe) {
            this.logger.logThisException(Level.SEVERE, this.getClass().getName(), "parseMetadataFiles", saxe.getMessage(), saxe);
            throw saxe;
        }
        this.logger.exiting(this.getClass().getName(), "parseMetadataFiles");
    }

    protected void parseHistoryXmlFile(String installRoot, InputStream inputStream) throws IOException, ParserConfigurationException, SAXException {
        this.logger.entering(this.getClass().getName(), "parseHistoryXmlFile");
        if (inputStream != null) {
            try {
                SimpleXMLParser sxpFile = new SimpleXMLParser(inputStream, false);
                Vector nodeContainer = sxpFile.getNodes(S_PATH_MAINTENANCE);
                for (int i = 0; i < nodeContainer.size(); ++i) {
                    Node nodeThis = (Node)nodeContainer.elementAt(i);
                    WASMaintenancePackage currentMaintenancePackage = new WASMaintenancePackage(installRoot, nodeThis);
                    this.eventHistoryInstance.addUpdateEvent(currentMaintenancePackage.getUpdateEventForThisMaintenancePackage());
                    if (!currentMaintenancePackage.isInstallAsMaintenance()) continue;
                    this.historyMaintenancePackages.addElement(currentMaintenancePackage);
                    if (currentMaintenancePackage.getAction().equals("install") && !currentMaintenancePackage.getResult().equals("failure")) {
                        this.logger.logThisMessage(Level.INFO, this.getClass().getName(), "parseHistoryXmlFile", "This maintenance is installed: " + currentMaintenancePackage.getMaintenancePackageID() + " with status: " + currentMaintenancePackage.getResult());
                        this.installedMaintenancesMap.put(currentMaintenancePackage.getMaintenancePackageID(), currentMaintenancePackage);
                        this.installedPTFsMap.put(currentMaintenancePackage.getMaintenancePackageID(), currentMaintenancePackage.getPTFForThisMaintenancePackage());
                        this.installedPTFAppliedMap.put(currentMaintenancePackage.getMaintenancePackageID(), currentMaintenancePackage.getPTFAppliedForThisMaintenancePackage());
                        this.installedPTFDriverMap.put(currentMaintenancePackage.getMaintenancePackageID(), currentMaintenancePackage.getPTFDriverForThisMaintenancePackage());
                        continue;
                    }
                    if (!currentMaintenancePackage.getAction().equals("uninstall") || currentMaintenancePackage.getResult().equals("failure")) continue;
                    this.logger.logThisMessage(Level.INFO, this.getClass().getName(), "parseHistoryXmlFile", "This maintenance is uninstalled: " + currentMaintenancePackage.getMaintenancePackageID() + " with status: " + currentMaintenancePackage.getResult());
                    this.installedMaintenancesMap.remove(currentMaintenancePackage.getMaintenancePackageID());
                    this.installedPTFsMap.remove(currentMaintenancePackage.getMaintenancePackageID());
                    this.installedPTFAppliedMap.remove(currentMaintenancePackage.getMaintenancePackageID());
                    this.installedPTFDriverMap.remove(currentMaintenancePackage.getMaintenancePackageID());
                }
                SimpleXMLParser.deleteChildNodes(sxpFile.getDocument().getDocumentElement(), nodeContainer);
                nodeContainer.clear();
                sxpFile = null;
            }
            catch (IOException ioe) {
                this.logger.logThisException(Level.SEVERE, this.getClass().getName(), "parseHistoryXmlFile", ioe.getMessage(), ioe);
                throw ioe;
            }
            catch (ParserConfigurationException pce) {
                this.logger.logThisException(Level.SEVERE, this.getClass().getName(), "parseHistoryXmlFile", pce.getMessage(), pce);
                throw pce;
            }
            catch (SAXException saxe) {
                this.logger.logThisException(Level.SEVERE, this.getClass().getName(), "parseHistoryXmlFile", saxe.getMessage(), saxe);
                throw saxe;
            }
        } else {
            this.logger.logThisMessage(Level.SEVERE, this.getClass().getName(), "parseHistoryXmlFile", "FileInputStream for history xml file is null!");
        }
        this.logger.exiting(this.getClass().getName(), "parseHistoryXmlFile");
    }

    protected void parseComponentFiles(String installRoot) throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        this.logger.entering(this.getClass().getName(), "parseComponentFiles");
        File[] componentFiles = new File(WASDirectoryHelper.getVersionDirPath(installRoot)).listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".component");
            }
        });
        int i = 0;
        try {
            String dtdDirPath = WASDirectoryHelper.getDTDDirPath(installRoot);
            HistoryInfoEntityResolver entityResolver = new HistoryInfoEntityResolver(dtdDirPath);
            for (i = 0; i < componentFiles.length; ++i) {
                FileInputStream inputStream = new FileInputStream(componentFiles[i]);
                WASComponent wasComponentThis = new WASComponent(inputStream, entityResolver, installRoot);
                this.installedComponentsMap.put(wasComponentThis.getComponentName(), wasComponentThis);
                ((InputStream)inputStream).close();
            }
        }
        catch (FileNotFoundException fnfe) {
            this.logger.logThisException(Level.SEVERE, this.getClass().getName(), "parseComponentFiles", fnfe.getMessage(), fnfe);
            throw fnfe;
        }
        catch (IOException ioe) {
            if (i != componentFiles.length) {
                this.logger.logThisMessage(Level.SEVERE, this.getClass().getName(), "parseComponentFiles", "Can not close FileInputStream of component file: " + componentFiles[i]);
            }
            this.logger.logThisException(Level.SEVERE, this.getClass().getName(), "parseComponentFiles", ioe.getMessage(), ioe);
            throw ioe;
        }
        catch (ParserConfigurationException pce) {
            this.logger.logThisException(Level.SEVERE, this.getClass().getName(), "parseComponentFiles", pce.getMessage(), pce);
            throw pce;
        }
        catch (SAXException saxe) {
            this.logger.logThisException(Level.SEVERE, this.getClass().getName(), "parseComponentFiles", saxe.getMessage(), saxe);
            throw saxe;
        }
        this.logger.exiting(this.getClass().getName(), "parseComponentFiles");
    }

    protected void setInstallRoot(String installRoot) {
        this.installRoot = installRoot;
    }

    protected void setLogger(WASDirectoryLogger logger) {
        this.logger = logger;
    }
}

