/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.product.history.xml;

import com.ibm.websphere.product.history.xml.componentVersion;
import com.ibm.websphere.product.history.xml.eventHistory;
import com.ibm.websphere.product.history.xml.updateEvent;
import com.ibm.websphere.product.xml.BaseWriter;
import java.util.List;

public class EventWriter
extends BaseWriter {
    public static final String pgmVersion = "%I";
    public static final String pgmUpdate = "8/8/08";

    public String getDefaultDocTypeString(List rootElements) {
        return "<!DOCTYPE event-history SYSTEM \"eventHistory.dtd\">";
    }

    public void baseEmit(List rootElements) {
        eventHistory rootHistory = (eventHistory)rootElements.iterator().next();
        this.emitEventHistory(rootHistory);
    }

    public void emitEventHistory(eventHistory history) {
        this.beginDocument();
        this.printIndent();
        this.beginElementOpening("event-history");
        this.endElementOpening(false);
        this.println();
        this.indentIn();
        int numEvents = history.getUpdateEventCount();
        for (int eventNo = 0; eventNo < numEvents; ++eventNo) {
            updateEvent nextEvent = history.getUpdateEvent(eventNo);
            this.emitUpdateEvent(nextEvent);
        }
        this.indentOut();
        this.printIndent();
        this.emitElementClosure("event-history");
        this.println();
    }

    public void emitUpdateEvent(updateEvent event2) {
        componentVersion finalVersion;
        this.printIndent();
        this.beginElementOpening("update-event");
        this.println();
        this.indentIn();
        this.emitAttributeOnLine("event-type", event2.getEventType());
        this.emitAttributeOnLine("parent-id", event2.getParentId());
        this.emitAttributeOnLine("id", event2.getId());
        this.emitAttributeOnLine("primary-content", event2.getPrimaryContent());
        this.emitAttributeOnLine("update-action", event2.getUpdateAction());
        this.emitAttributeOnLine("update-type", event2.getUpdateType());
        this.emitAttributeOnLine("root-property-file", event2.getRootPropertyFile());
        this.emitAttributeOnLine("root-property-name", event2.getRootPropertyName());
        this.emitAttributeOnLine("root-property-value", event2.getRootPropertyValue());
        this.emitAttributeOnLine("log-name", event2.getLogName());
        this.emitAttributeOnLine("backup-name", event2.getBackupName());
        this.emitAttributeOnLine("start-time-stamp", event2.getStartTimeStamp());
        this.emitAttributeOnLine("result", event2.getResult());
        this.printIndent();
        this.emitAttribute("result-message", event2.getResultMessage());
        this.endElementOpening(false);
        this.println();
        int numEvents = event2.getUpdateEventCount();
        for (int eventNo = 0; eventNo < numEvents; ++eventNo) {
            updateEvent nextEvent = event2.getUpdateEvent(eventNo);
            this.emitUpdateEvent(nextEvent);
        }
        componentVersion initialVersion = event2.getInitialVersion();
        if (initialVersion != null) {
            this.emitInitialVersion(initialVersion);
        }
        if ((finalVersion = event2.getFinalVersion()) != null) {
            this.emitFinalVersion(finalVersion);
        }
        this.indentOut();
        this.printIndent();
        this.emitElementClosure("update-event");
        this.println();
    }

    public void emitInitialVersion(componentVersion initialVersion) {
        this.emitComponentVersion("initial-version", initialVersion);
    }

    public void emitFinalVersion(componentVersion finalVersion) {
        this.emitComponentVersion("initial-version", finalVersion);
    }

    public void emitComponentVersion(String elementName, componentVersion componentVersion2) {
        this.printIndent();
        this.beginElementOpening(elementName);
        this.println();
        this.indentIn();
        this.emitAttributeOnLine("component-name", componentVersion2.getComponentName());
        this.emitAttributeOnLine("spec-version", componentVersion2.getSpecVersion());
        this.emitAttributeOnLine("build-version", componentVersion2.getBuildVersion());
        this.printIndent();
        this.emitAttribute("build-date", componentVersion2.getBuildDate());
        this.endElementOpening(true);
        this.println();
        this.indentOut();
    }
}

