/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.product.history.xml;

import com.ibm.websphere.product.history.xml.aparInfo;
import com.ibm.websphere.product.history.xml.componentApplied;
import com.ibm.websphere.product.history.xml.componentUpdate;
import com.ibm.websphere.product.history.xml.componentVersion;
import com.ibm.websphere.product.history.xml.customProperty;
import com.ibm.websphere.product.history.xml.efixApplied;
import com.ibm.websphere.product.history.xml.efixDriver;
import com.ibm.websphere.product.history.xml.efixPrereq;
import com.ibm.websphere.product.history.xml.includedEFix;
import com.ibm.websphere.product.history.xml.platformPrereq;
import com.ibm.websphere.product.history.xml.productPrereq;
import com.ibm.websphere.product.history.xml.productUpdate;
import com.ibm.websphere.product.history.xml.ptfApplied;
import com.ibm.websphere.product.history.xml.ptfDriver;
import com.ibm.websphere.product.xml.BaseType;
import com.ibm.websphere.product.xml.BaseWriter;
import java.util.Iterator;
import java.util.List;

public class AppliedWriter
extends BaseWriter {
    public static final String pgmVersion = "1.6";
    public static final String pgmUpdate = "8/8/08";

    public String getDefaultDocTypeString(List rootElements) {
        Iterator roots = rootElements.iterator();
        if (!roots.hasNext()) {
            return null;
        }
        Object firstRootElement = roots.next();
        if (firstRootElement instanceof efixDriver) {
            return this.getDefaultEFixDriverDocTypeString();
        }
        if (firstRootElement instanceof efixApplied) {
            return this.getDefaultEFixAppliedDocTypeString();
        }
        if (firstRootElement instanceof ptfDriver) {
            return this.getDefaultPTFDriverDocTypeString();
        }
        if (firstRootElement instanceof ptfApplied) {
            return this.getDefaultPTFAppliedDocTypeString();
        }
        return null;
    }

    public String getDefaultEFixDriverDocTypeString() {
        return "<!DOCTYPE efix-driver SYSTEM \"applied.dtd\">";
    }

    public String getDefaultPTFDriverDocTypeString() {
        return "<!DOCTYPE ptf-driver SYSTEM \"applied.dtd\">";
    }

    public String getDefaultEFixAppliedDocTypeString() {
        return "<!DOCTYPE efix-applied SYSTEM \"applied.dtd\">";
    }

    public String getDefaultPTFAppliedDocTypeString() {
        return "<!DOCTYPE ptf-applied SYSTEM \"applied.dtd\">";
    }

    public void emitEFixDriver(efixDriver efixDriver2) {
        BaseType nextPrereq;
        int prereqNo;
        this.beginDocument();
        this.printIndent();
        this.beginElementOpening("efix-driver");
        this.println();
        this.indentIn();
        this.emitAttributeOnLine("id", efixDriver2.getId());
        this.emitAttributeOnLine("short-description", efixDriver2.getShortDescription());
        this.emitAttributeOnLine("build-version", efixDriver2.getBuildVersion());
        this.printIndent();
        this.emitAttribute("build-date", efixDriver2.getBuildDate());
        this.endElementOpening(false);
        this.println();
        int numApars = efixDriver2.getAparInfoCount();
        for (int aparNo = 0; aparNo < numApars; ++aparNo) {
            aparInfo nextApar = efixDriver2.getAparInfo(aparNo);
            this.emitAparInfo(nextApar);
        }
        int numComps = efixDriver2.getComponentUpdateCount();
        for (int compNo = 0; compNo < numComps; ++compNo) {
            componentUpdate nextComponent = efixDriver2.getComponentUpdate(compNo);
            this.emitComponentUpdate(nextComponent);
        }
        int numPrereqs = efixDriver2.getPlatformPrereqCount();
        for (prereqNo = 0; prereqNo < numPrereqs; ++prereqNo) {
            nextPrereq = efixDriver2.getPlatformPrereq(prereqNo);
            this.emitPlatformPrereq((platformPrereq)nextPrereq);
        }
        numPrereqs = efixDriver2.getProductPrereqCount();
        for (prereqNo = 0; prereqNo < numPrereqs; ++prereqNo) {
            nextPrereq = efixDriver2.getProductPrereq(prereqNo);
            this.emitProductPrereq((productPrereq)nextPrereq);
        }
        numPrereqs = efixDriver2.getEFixPrereqCount();
        for (prereqNo = 0; prereqNo < numPrereqs; ++prereqNo) {
            nextPrereq = efixDriver2.getEFixPrereq(prereqNo);
            this.emitEFixPrereq((efixPrereq)nextPrereq);
        }
        int numProperties = efixDriver2.getCustomPropertyCount();
        for (int propertyNo = 0; propertyNo < numProperties; ++propertyNo) {
            customProperty nextProperty = efixDriver2.getCustomProperty(propertyNo);
            this.emitCustomProperty(nextProperty);
        }
        this.indentOut();
        this.printIndent();
        this.emitElementClosure("efix-driver");
        this.println();
    }

    public void emitEFixApplied(efixApplied efixApplied2) {
        this.beginDocument();
        this.printIndent();
        this.beginElementOpening("efix-applied");
        this.println();
        this.indentIn();
        this.printIndent();
        this.emitAttribute("efix-id", efixApplied2.getEFixId());
        this.endElementOpening(false);
        this.println();
        int numApplieds = efixApplied2.getComponentAppliedCount();
        for (int appliedNo = 0; appliedNo < numApplieds; ++appliedNo) {
            componentApplied nextApplied = efixApplied2.getComponentApplied(appliedNo);
            this.emitComponentApplied(nextApplied);
        }
        this.indentOut();
        this.printIndent();
        this.emitElementClosure("efix-applied");
        this.println();
    }

    public void emitPTFDriver(ptfDriver ptfDriver2) {
        BaseType nextPrereq;
        int prereqNo;
        this.beginDocument();
        this.printIndent();
        this.beginElementOpening("ptf-driver");
        this.println();
        this.indentIn();
        this.emitAttributeOnLine("id", ptfDriver2.getId());
        this.emitAttributeOnLine("short-description", ptfDriver2.getShortDescription());
        this.printIndent();
        this.emitAttribute("build-date", ptfDriver2.getBuildDate());
        this.endElementOpening(false);
        this.println();
        int numComps = ptfDriver2.getComponentUpdateCount();
        for (int compNo = 0; compNo < numComps; ++compNo) {
            componentUpdate nextComponent = ptfDriver2.getComponentUpdate(compNo);
            this.emitComponentUpdate(nextComponent);
        }
        int numUpdates = ptfDriver2.getProductUpdateCount();
        for (int updateNo = 0; updateNo < numUpdates; ++updateNo) {
            productUpdate nextUpdate = ptfDriver2.getProductUpdate(updateNo);
            this.emitProductUpdate(nextUpdate);
        }
        int numPrereqs = ptfDriver2.getPlatformPrereqCount();
        for (prereqNo = 0; prereqNo < numPrereqs; ++prereqNo) {
            nextPrereq = ptfDriver2.getPlatformPrereq(prereqNo);
            this.emitPlatformPrereq((platformPrereq)nextPrereq);
        }
        numPrereqs = ptfDriver2.getProductPrereqCount();
        for (prereqNo = 0; prereqNo < numPrereqs; ++prereqNo) {
            nextPrereq = ptfDriver2.getProductPrereq(prereqNo);
            this.emitProductPrereq((productPrereq)nextPrereq);
        }
        int numIncluded = ptfDriver2.getIncludedEFixCount();
        for (int efixNo = 0; efixNo < numIncluded; ++efixNo) {
            includedEFix nextEFix = ptfDriver2.getIncludedEFix(efixNo);
            this.emitIncludedEFix(nextEFix);
        }
        int numProperties = ptfDriver2.getCustomPropertyCount();
        for (int propertyNo = 0; propertyNo < numProperties; ++propertyNo) {
            customProperty nextProperty = ptfDriver2.getCustomProperty(propertyNo);
            this.emitCustomProperty(nextProperty);
        }
        this.indentOut();
        this.printIndent();
        this.emitElementClosure("ptf-driver");
        this.println();
    }

    public void emitPTFApplied(ptfApplied ptfApplied2) {
        this.beginDocument();
        this.printIndent();
        this.beginElementOpening("ptf-applied");
        this.println();
        this.indentIn();
        this.printIndent();
        this.emitAttribute("ptf-id", ptfApplied2.getPTFId());
        this.endElementOpening(false);
        this.println();
        int numApplieds = ptfApplied2.getComponentAppliedCount();
        for (int appliedNo = 0; appliedNo < numApplieds; ++appliedNo) {
            componentApplied nextApplied = ptfApplied2.getComponentApplied(appliedNo);
            this.emitComponentApplied(nextApplied);
        }
        this.indentOut();
        this.printIndent();
        this.emitElementClosure("ptf-applied");
        this.println();
    }

    public void emitAparInfo(aparInfo apar) {
        this.printIndent();
        this.beginElementOpening("apar-info");
        this.println();
        this.indentIn();
        this.emitAttributeOnLine("number", apar.getNumber());
        this.emitAttributeOnLine("date", apar.getDate());
        this.emitAttributeOnLine("short-description", apar.getShortDescription());
        this.printIndent();
        int numProperties = apar.getCustomPropertyCount();
        if (numProperties == 0) {
            this.endElementOpening(true);
            this.println();
        } else {
            this.endElementOpening(false);
            this.println();
            this.indentIn();
            for (int propertyNo = 0; propertyNo < numProperties; ++propertyNo) {
                customProperty nextProperty = apar.getCustomProperty(propertyNo);
                this.emitCustomProperty(nextProperty);
            }
            this.indentOut();
            this.printIndent();
            this.emitElementClosure("component-update");
            this.println();
        }
    }

    public void emitComponentUpdate(componentUpdate componentUpdate2) {
        this.printIndent();
        this.beginElementOpening("component-update");
        this.println();
        this.indentIn();
        this.emitAttributeOnLine("component-name", componentUpdate2.getComponentName());
        this.emitAttributeOnLine("update-type", componentUpdate2.getUpdateType());
        this.printIndent();
        this.emitAttribute("primary-content", componentUpdate2.getPrimaryContent());
        this.endElementOpening(false);
        this.println();
        int numPrereqs = componentUpdate2.getComponentPrereqCount();
        for (int prereqNo = 0; prereqNo < numPrereqs; ++prereqNo) {
            componentVersion nextPrereq = componentUpdate2.getComponentPrereq(prereqNo);
            this.emitComponentPrereq(nextPrereq);
        }
        componentVersion finalVersion = componentUpdate2.getFinalVersion();
        if (finalVersion != null) {
            this.emitFinalVersion(finalVersion);
        }
        int numProperties = componentUpdate2.getCustomPropertyCount();
        for (int propertyNo = 0; propertyNo < numProperties; ++propertyNo) {
            customProperty nextProperty = componentUpdate2.getCustomProperty(propertyNo);
            this.emitCustomProperty(nextProperty);
        }
        this.indentOut();
        this.printIndent();
        this.emitElementClosure("component-update");
        this.println();
    }

    public void emitPlatformPrereq(platformPrereq platformPrereq2) {
        this.printIndent();
        this.beginElementOpening("platform-prereq");
        this.println();
        this.indentIn();
        this.emitAttributeOnLine("architecture", platformPrereq2.getArchitecture());
        this.emitAttributeOnLine("os-platform", platformPrereq2.getOSPlatform());
        this.printIndent();
        this.emitAttribute("os-version", platformPrereq2.getOSVersion());
        this.endElementOpening(true);
        this.println();
        this.indentOut();
    }

    public void emitProductPrereq(productPrereq productPrereq2) {
        this.printIndent();
        this.beginElementOpening("product-prereq");
        this.println();
        this.indentIn();
        this.emitAttributeOnLine("product-id", productPrereq2.getProductId());
        this.emitAttributeOnLine("build-version", productPrereq2.getBuildVersion());
        this.emitAttributeOnLine("build-date", productPrereq2.getBuildDate());
        this.printIndent();
        this.emitAttribute("build-level", productPrereq2.getBuildLevel());
        this.endElementOpening(true);
        this.println();
        this.indentOut();
    }

    public void emitEFixPrereq(efixPrereq efixPrereq2) {
        this.printIndent();
        this.beginElementOpening("efix-prereq");
        this.println();
        this.indentIn();
        this.emitAttributeOnLine("efix-id", efixPrereq2.getEFixId());
        this.emitAttributeOnLine("is-negative", efixPrereq2.getIsNegative());
        this.printIndent();
        this.emitAttribute("install-index", efixPrereq2.getInstallIndex());
        this.endElementOpening(true);
        this.println();
        this.indentOut();
    }

    public void emitCustomProperty(customProperty customProperty2) {
        this.printIndent();
        this.beginElementOpening("custom-property");
        this.println();
        this.indentIn();
        this.emitAttributeOnLine("property-name", customProperty2.getPropertyName());
        this.emitAttributeOnLine("property-type", customProperty2.getPropertyType());
        this.printIndent();
        this.emitAttribute("property-value", customProperty2.getPropertyValue());
        this.endElementOpening(true);
        this.println();
        this.indentOut();
    }

    public void emitProductUpdate(productUpdate productUpdate2) {
        this.printIndent();
        this.beginElementOpening("product-update");
        this.println();
        this.indentIn();
        this.emitAttributeOnLine("product-id", productUpdate2.getProductId());
        this.emitAttributeOnLine("product-name", productUpdate2.getProductName());
        this.emitAttributeOnLine("build-version", productUpdate2.getBuildVersion());
        this.emitAttributeOnLine("build-date", productUpdate2.getBuildDate());
        this.printIndent();
        this.emitAttribute("build-level", productUpdate2.getBuildLevel());
        this.endElementOpening(true);
        this.println();
        this.indentOut();
    }

    public void emitIncludedEFix(includedEFix includedEFix2) {
        this.printIndent();
        this.beginElementOpening("included-efix");
        this.print(" ");
        this.emitAttribute("efix-id", includedEFix2.getEFixId());
        this.endElementOpening(true);
        this.println();
    }

    public void emitComponentPrereq(componentVersion componentPrereq) {
        this.emitComponentVersion("component-prereq", componentPrereq);
    }

    public void emitInitialVersion(componentVersion initialVersion) {
        this.emitComponentVersion("initial-version", initialVersion);
    }

    public void emitFinalVersion(componentVersion finalVersion) {
        this.emitComponentVersion("final-version", finalVersion);
    }

    public void emitComponentVersion(String elementName, componentVersion componentVersion2) {
        this.printIndent();
        this.beginElementOpening(elementName);
        this.println();
        this.indentIn();
        this.emitAttributeOnLine("component-name", componentVersion2.getComponentName());
        this.emitAttributeOnLine("spec-version", componentVersion2.getSpecVersion());
        this.emitAttributeOnLine("build-version", componentVersion2.getBuildVersion());
        this.printIndent();
        this.emitAttribute("build-date", componentVersion2.getBuildDate());
        this.endElementOpening(true);
        this.println();
        this.indentOut();
    }

    public void emitComponentApplied(componentApplied componentApplied2) {
        componentVersion finalVersion;
        this.printIndent();
        this.beginElementOpening("component-applied");
        this.println();
        this.indentIn();
        this.emitAttributeOnLine("component-name", componentApplied2.getComponentName());
        this.emitAttributeOnLine("update-type", componentApplied2.getUpdateType());
        this.emitAttributeOnLine("log-name", componentApplied2.getLogName());
        this.emitAttributeOnLine("backup-name", componentApplied2.getBackupName());
        this.printIndent();
        this.emitAttribute("time-stamp", componentApplied2.getTimeStamp());
        this.endElementOpening(false);
        this.println();
        componentVersion initialVersion = componentApplied2.getInitialVersion();
        if (initialVersion != null) {
            this.emitInitialVersion(initialVersion);
        }
        if ((finalVersion = componentApplied2.getFinalVersion()) != null) {
            this.emitFinalVersion(finalVersion);
        }
        this.indentOut();
        this.printIndent();
        this.emitElementClosure("component-applied");
        this.println();
    }

    public void baseEmit(List rootElements) {
        Object root = rootElements.iterator().next();
        if (root instanceof efixDriver) {
            this.emitEFixDriver((efixDriver)root);
        } else if (root instanceof efixApplied) {
            this.emitEFixApplied((efixApplied)root);
        } else if (root instanceof ptfDriver) {
            this.emitPTFDriver((ptfDriver)root);
        } else if (root instanceof ptfApplied) {
            this.emitPTFApplied((ptfApplied)root);
        }
    }
}

