/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.pmi.stat;

import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.pmi.PmiModuleConfig;
import com.ibm.websphere.pmi.stat.Statistic;
import com.ibm.websphere.pmi.stat.Stats;
import com.ibm.ws.pmi.server.PmiUtil;
import com.ibm.ws.pmi.stat.StatsConfigHelper;
import com.ibm.ws.pmi.wire.WpdCollection;
import com.ibm.ws.pmi.wire.WpdData;
import java.io.Serializable;
import java.util.ArrayList;

public class StatsImpl
implements Stats,
WpdCollection,
PmiConstants,
Serializable {
    private static final long serialVersionUID = -5812710047173154854L;
    protected String statsType;
    protected String name;
    protected int type;
    protected int instrumentationLevel = -1;
    protected ArrayList dataMembers;
    protected ArrayList subCollections;
    protected long time = PmiUtil.currentTime();
    private transient boolean bInitStaticInfo = false;

    public StatsImpl(String string, int n) {
        this(string, n, -1, null, null);
    }

    public StatsImpl(String string, int n, int n2) {
        this(string, n, n2, null, null);
    }

    public StatsImpl(String string, int n, int n2, ArrayList arrayList, ArrayList arrayList2) {
        if (string == null) {
            string = "Undefined";
        }
        this.name = string;
        this.type = n == 11 || n == 12 || n == 13 ? n : 17;
        this.instrumentationLevel = n2;
        this.dataMembers = arrayList;
        this.subCollections = arrayList2;
    }

    public StatsImpl(String string, String string2, int n, int n2, ArrayList arrayList, ArrayList arrayList2) {
        this(string2, n, n2, arrayList, arrayList2);
        this.statsType = string;
    }

    public String getName() {
        return this.name;
    }

    public String getStatsType() {
        return this.statsType;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setStatsType(String string) {
        this.statsType = string;
    }

    public int getType() {
        return this.type;
    }

    public long getTime() {
        return this.time;
    }

    public int getLevel() {
        return this.instrumentationLevel;
    }

    public void setLevel(int n) {
        this.instrumentationLevel = n;
    }

    public void setStatistics(ArrayList arrayList) {
        this.dataMembers = arrayList;
    }

    public void setSubStats(ArrayList arrayList) {
        this.subCollections = arrayList;
    }

    public Statistic getStatistic(int n) {
        if (this.dataMembers == null || this.dataMembers.size() <= 0) {
            return null;
        }
        if (!this.bInitStaticInfo) {
            this.initPmiModuleConfig();
        }
        for (int i = 0; i < this.dataMembers.size(); ++i) {
            Statistic statistic = (Statistic)this.dataMembers.get(i);
            if (statistic.getId() != n) continue;
            return statistic;
        }
        return null;
    }

    public com.ibm.websphere.management.statistics.Statistic getStatistic(String string) {
        if (this.dataMembers == null) {
            return null;
        }
        if (!this.bInitStaticInfo) {
            this.initPmiModuleConfig();
        }
        Statistic statistic = null;
        for (int i = 0; i < this.dataMembers.size(); ++i) {
            statistic = (Statistic)this.dataMembers.get(i);
            if (!statistic.getName().equals(string)) continue;
            return statistic;
        }
        return null;
    }

    public com.ibm.websphere.management.statistics.Statistic[] getStatistics() {
        if (this.dataMembers == null || this.dataMembers.size() == 0) {
            return new Statistic[0];
        }
        if (!this.bInitStaticInfo) {
            this.initPmiModuleConfig();
        }
        com.ibm.websphere.management.statistics.Statistic[] statisticArray = new Statistic[this.dataMembers.size()];
        for (int i = 0; i < statisticArray.length; ++i) {
            statisticArray[i] = (Statistic)this.dataMembers.get(i);
        }
        return statisticArray;
    }

    public String[] getStatisticNames() {
        if (this.dataMembers == null) {
            return new String[0];
        }
        if (!this.bInitStaticInfo) {
            this.initPmiModuleConfig();
        }
        String[] stringArray = new String[this.dataMembers.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.dataMembers.get(i) == null) continue;
            stringArray[i] = ((Statistic)this.dataMembers.get(i)).getName();
        }
        return stringArray;
    }

    public Stats getStats(String string) {
        if (this.subCollections == null) {
            return null;
        }
        Stats stats = null;
        for (int i = 0; i < this.subCollections.size(); ++i) {
            stats = (Stats)this.subCollections.get(i);
            if (!stats.getName().equals(string)) continue;
            return stats;
        }
        return null;
    }

    public Stats[] getSubStats() {
        return this.listSubStats();
    }

    public String[] listStatisticNames() {
        if (this.dataMembers == null) {
            return new String[0];
        }
        if (!this.bInitStaticInfo) {
            this.initPmiModuleConfig();
        }
        String[] stringArray = new String[this.dataMembers.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.dataMembers.get(i) == null) continue;
            stringArray[i] = ((Statistic)this.dataMembers.get(i)).getName();
        }
        return stringArray;
    }

    public Statistic[] listStatistics() {
        if (this.dataMembers == null || this.dataMembers.size() == 0) {
            return new Statistic[0];
        }
        if (!this.bInitStaticInfo) {
            this.initPmiModuleConfig();
        }
        Statistic[] statisticArray = new Statistic[this.dataMembers.size()];
        for (int i = 0; i < statisticArray.length; ++i) {
            statisticArray[i] = (Statistic)this.dataMembers.get(i);
        }
        return statisticArray;
    }

    public Stats[] listSubStats() {
        if (this.subCollections == null || this.subCollections.size() == 0) {
            return new Stats[0];
        }
        Stats[] statsArray = new Stats[this.subCollections.size()];
        for (int i = 0; i < statsArray.length; ++i) {
            statsArray[i] = (Stats)this.subCollections.get(i);
        }
        return statsArray;
    }

    public synchronized boolean add(Statistic statistic) {
        if (this.dataMembers == null) {
            this.dataMembers = new ArrayList();
        }
        if (statistic == null) {
            return false;
        }
        this.dataMembers.add(statistic);
        return true;
    }

    public synchronized boolean add(Stats stats) {
        if (this.subCollections == null) {
            this.subCollections = new ArrayList();
        }
        if (stats == null) {
            return false;
        }
        this.subCollections.add(stats);
        return true;
    }

    public synchronized boolean remove(int n) {
        if (this.dataMembers == null || this.dataMembers.size() <= 0) {
            return false;
        }
        for (int i = this.dataMembers.size() - 1; i >= 0; --i) {
            if (((Statistic)this.dataMembers.get(i)).getId() != n) continue;
            this.dataMembers.remove(i);
            return true;
        }
        return false;
    }

    public synchronized boolean remove(String string) {
        if (this.subCollections == null || this.subCollections.size() <= 0) {
            return false;
        }
        for (int i = this.subCollections.size() - 1; i >= 0; --i) {
            Stats stats = (Stats)this.subCollections.get(i);
            if (!stats.getName().equals(string)) continue;
            this.subCollections.remove(i);
            return true;
        }
        return false;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String string) {
        Object object;
        int n;
        if (!this.bInitStaticInfo) {
            this.initPmiModuleConfig();
        }
        String string2 = string + "  ";
        String string3 = null;
        switch (this.type) {
            case 10: {
                string3 = "PMIROOT";
                break;
            }
            case 11: {
                string3 = "NODE";
                break;
            }
            case 12: {
                string3 = "SERVER";
                break;
            }
            case 13: {
                string3 = "MODULE";
                break;
            }
            case 15: {
                string3 = "SUBMODULE";
                break;
            }
            case 14: {
                string3 = "INSTANCE";
                break;
            }
            case 16: {
                string3 = "SUBINSTANCE";
                break;
            }
            case 17: {
                string3 = "COLLECTION";
                break;
            }
            default: {
                string3 = "WRONG_TYPE";
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("Stats name=");
        stringBuffer.append(this.name);
        stringBuffer.append(" type=");
        stringBuffer.append(string3);
        stringBuffer.append("\n");
        if (this.dataMembers != null) {
            for (n = 0; n < this.dataMembers.size(); ++n) {
                object = (Statistic)this.dataMembers.get(n);
                if (object == null) continue;
                stringBuffer.append(string2);
                stringBuffer.append(object.toString());
                stringBuffer.append("\n");
            }
        }
        if (this.subCollections != null) {
            for (n = 0; n < this.subCollections.size(); ++n) {
                object = (Stats)this.subCollections.get(n);
                if (object == null) continue;
                stringBuffer.append(object.toString(string2));
            }
        }
        return stringBuffer.toString();
    }

    public void setConfig(PmiModuleConfig pmiModuleConfig) {
        Object object;
        int n;
        if (pmiModuleConfig == null) {
            return;
        }
        this.bInitStaticInfo = true;
        if (this.dataMembers != null) {
            for (n = 0; n < this.dataMembers.size(); ++n) {
                object = (Statistic)this.dataMembers.get(n);
                if (object == null) continue;
                object.setDataInfo(pmiModuleConfig);
            }
        }
        if (this.subCollections != null) {
            for (n = 0; n < this.subCollections.size(); ++n) {
                object = (Stats)this.subCollections.get(n);
                if (object == null) continue;
                object.setConfig(pmiModuleConfig);
            }
        }
    }

    public boolean add(WpdData wpdData) {
        return false;
    }

    public boolean add(WpdCollection wpdCollection) {
        if (wpdCollection instanceof Stats) {
            return this.add((Stats)wpdCollection);
        }
        return false;
    }

    public String toXML() {
        return null;
    }

    public void setDataMembers(ArrayList arrayList) {
        this.setStatistics(arrayList);
    }

    public void setSubcollections(ArrayList arrayList) {
        this.setSubStats(arrayList);
    }

    public ArrayList dataMembers() {
        return this.dataMembers;
    }

    public ArrayList subCollections() {
        return this.subCollections;
    }

    public WpdData getData(int n) {
        System.err.println("Warning: this method is defunc'ed - call getStatistic(dataId) instead");
        return null;
    }

    public WpdCollection getSubcollection(String string) {
        System.err.println("Warning: this method is defunc'ed - call getStats(name) instead");
        return null;
    }

    public synchronized void update(Stats stats, boolean bl, boolean bl2) {
        if (stats == null) {
            return;
        }
        if (!this.name.equals(stats.getName()) || this.type != stats.getType()) {
            return;
        }
        this.myupdate(stats, bl, bl2);
    }

    private synchronized void myupdate(Stats stats, boolean bl, boolean bl2) {
        if (stats == null) {
            return;
        }
        this.instrumentationLevel = stats.getLevel();
        this.updateMembers(stats, bl);
        if (bl2) {
            this.updateSubcollection(stats, bl, bl2);
        }
    }

    private synchronized void updateMembers(Stats stats, boolean bl) {
        if (!bl) {
            this.dataMembers = null;
        }
        if (stats == null) {
            return;
        }
        if (this.dataMembers == null || this.dataMembers.size() == 0) {
            this.dataMembers = ((StatsImpl)stats).dataMembers;
        } else {
            Statistic[] statisticArray = stats.listStatistics();
            if (statisticArray == null || statisticArray.length == 0) {
                return;
            }
            for (int i = 0; i < statisticArray.length; ++i) {
                boolean bl2 = false;
                Statistic statistic = null;
                for (int j = 0; j < this.dataMembers.size(); ++j) {
                    statistic = (Statistic)this.dataMembers.get(j);
                    if (statisticArray[i].getId() != statistic.getId()) continue;
                    bl2 = true;
                    statistic.update(statisticArray[i]);
                    break;
                }
                if (bl2) continue;
                this.dataMembers.add(statisticArray[i]);
            }
        }
    }

    private synchronized void updateSubcollection(Stats stats, boolean bl, boolean bl2) {
        if (!bl) {
            this.subCollections = null;
        }
        if (stats == null) {
            return;
        }
        if (this.subCollections == null || this.subCollections.size() == 0) {
            this.subCollections = ((StatsImpl)stats).subCollections;
        } else {
            Stats[] statsArray = stats.listSubStats();
            if (statsArray == null || statsArray.length == 0) {
                return;
            }
            Stats stats2 = null;
            for (int i = 0; i < statsArray.length; ++i) {
                boolean bl3 = false;
                int n = 0;
                int n2 = -1;
                for (int j = 0; j < this.subCollections.size(); ++j) {
                    stats2 = (Stats)this.subCollections.get(j);
                    n = statsArray[i].getName().compareTo(stats2.getName());
                    if (n == 0) {
                        bl3 = true;
                        stats2.update(statsArray[i], bl, bl2);
                        break;
                    }
                    if (n >= 0) continue;
                    n2 = i;
                    break;
                }
                if (!bl3 && n2 > 0) {
                    this.subCollections.add(n2, statsArray[i]);
                    continue;
                }
                if (bl3 || n2 != -1) continue;
                this.subCollections.add(statsArray[i]);
            }
        }
    }

    public void resetOnClient(boolean bl) {
        int n;
        Object object;
        if (this.dataMembers != null) {
            object = null;
            for (n = 0; n < this.dataMembers.size(); ++n) {
                object = (Statistic)this.dataMembers.get(n);
                object.resetOnClient(null);
            }
        }
        if (!bl) {
            return;
        }
        if (this.subCollections != null) {
            object = null;
            for (n = 0; n < this.subCollections.size(); ++n) {
                object = (Stats)this.subCollections.get(n);
                object.resetOnClient(bl);
            }
        }
    }

    protected void initPmiModuleConfig() {
        PmiModuleConfig pmiModuleConfig = StatsConfigHelper.getStatsConfig((String)this.getStatsType());
        if (pmiModuleConfig != null) {
            this.setConfig(pmiModuleConfig);
        }
    }
}

