/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.pmi.stat;

import com.ibm.websphere.pmi.stat.Statistic;
import com.ibm.websphere.pmi.stat.StatisticImpl;

public class DoubleStatisticImpl
extends StatisticImpl {
    private static final long serialVersionUID = 6508148569801698815L;
    protected double count = 0.0;
    private DoubleStatisticImpl baseValue = null;

    public DoubleStatisticImpl(int n) {
        super(n);
    }

    public DoubleStatisticImpl(int n, double d, long l, long l2) {
        super(n, null, null, null, l, l2);
        this.count = d;
    }

    public DoubleStatisticImpl(int n, String string, String string2, String string3, long l, long l2) {
        super(n, string, string2, string3, l, l2);
    }

    public void reset() {
        this.reset(true);
    }

    public void reset(boolean bl) {
        if (bl) {
            super.reset();
        }
        this.count = 0.0;
    }

    public void set(double d, long l, long l2) {
        this.count = d;
        this.startTime = l;
        this.lastSampleTime = l2;
    }

    public double getDouble() {
        if (this.baseValue == null) {
            return this.count;
        }
        return this.count - this.baseValue.getDouble();
    }

    public void combine(Statistic statistic) {
        if (!this.validate(statistic)) {
            return;
        }
        DoubleStatisticImpl doubleStatisticImpl = (DoubleStatisticImpl)statistic;
        this.count += doubleStatisticImpl.count;
    }

    public void setDouble(double d) {
        if (!this.enabled) {
            return;
        }
        this.lastSampleTime = System.currentTimeMillis();
        this.count = d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increment() {
        if (!this.enabled) {
            return;
        }
        this.lastSampleTime = System.currentTimeMillis();
        if (!this.sync) {
            this.count += 1.0;
        } else {
            Object object = this.syncObj;
            synchronized (object) {
                this.count += 1.0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increment(double d) {
        if (!this.enabled) {
            return;
        }
        this.lastSampleTime = System.currentTimeMillis();
        if (!this.sync) {
            this.count += d;
        } else {
            Object object = this.syncObj;
            synchronized (object) {
                this.count += d;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrement() {
        if (!this.enabled) {
            return;
        }
        this.lastSampleTime = System.currentTimeMillis();
        if (!this.sync) {
            this.count -= 1.0;
        } else {
            Object object = this.syncObj;
            synchronized (object) {
                this.count -= 1.0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrement(double d) {
        if (!this.enabled) {
            return;
        }
        this.lastSampleTime = System.currentTimeMillis();
        if (!this.sync) {
            this.count -= d;
        } else {
            Object object = this.syncObj;
            synchronized (object) {
                this.count -= d;
            }
        }
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append("DoubleStatisticImpl: ");
        stringBuffer.append(super.toString(""));
        stringBuffer.append(" count=");
        stringBuffer.append(this.count);
        return stringBuffer.toString();
    }

    public void update(Statistic statistic) {
        if (!this.validate(statistic)) {
            return;
        }
        DoubleStatisticImpl doubleStatisticImpl = (DoubleStatisticImpl)statistic;
        if (this.baseValue == null) {
            this.count = doubleStatisticImpl.getDouble();
            this.startTime = doubleStatisticImpl.getStartTime();
        } else {
            this.count = doubleStatisticImpl.count - this.baseValue.count;
            this.startTime = this.baseValue.lastSampleTime;
        }
        this.lastSampleTime = doubleStatisticImpl.lastSampleTime;
    }

    public Statistic delta(Statistic statistic) {
        if (!this.validate(statistic)) {
            return null;
        }
        DoubleStatisticImpl doubleStatisticImpl = (DoubleStatisticImpl)statistic;
        DoubleStatisticImpl doubleStatisticImpl2 = new DoubleStatisticImpl(this.id);
        doubleStatisticImpl2.count = this.count - doubleStatisticImpl.getDouble();
        doubleStatisticImpl2.startTime = this.startTime;
        doubleStatisticImpl2.lastSampleTime = this.lastSampleTime;
        return doubleStatisticImpl2;
    }

    public void resetOnClient(Statistic statistic) {
        if (statistic == null) {
            if (this.baseValue == null) {
                this.baseValue = new DoubleStatisticImpl(this.id);
            }
            this.baseValue.set(this.count, this.startTime, this.lastSampleTime);
            this.update(this.baseValue);
        } else if (!this.validate(statistic)) {
            this.baseValue = (DoubleStatisticImpl)statistic;
            this.update(this.baseValue);
        }
    }

    private boolean validate(Statistic statistic) {
        if (statistic == null) {
            return false;
        }
        if (!(statistic instanceof DoubleStatisticImpl)) {
            System.out.println("WARNING: wrong data type: must be DoubleStatisticImpl");
            return false;
        }
        if (statistic.getId() != this.id) {
            System.out.println("WARNING: wrong data Id: expect dataId=" + this.id + ", got dataId=" + statistic.getId());
            return false;
        }
        return true;
    }
}

