/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.pmi;

import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.pmi.PmiDataInfo;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

public class PmiModuleConfig
implements Serializable,
PmiConstants {
    private static final long serialVersionUID = 9139791110927568058L;
    private String UID;
    private String description;
    private String mbeanType = null;
    private HashMap perfData;
    private String statsNLSFile;
    private int[] dependList = null;
    private boolean hasSubMod = false;
    private boolean hasSubModInit = false;

    public PmiModuleConfig(String string) {
        this.UID = string;
        this.perfData = new HashMap();
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setMbeanType(String string) {
        this.mbeanType = string;
    }

    public void setResourceBundle(String string) {
        this.statsNLSFile = string;
    }

    public synchronized void addData(PmiDataInfo pmiDataInfo) {
        if (pmiDataInfo != null) {
            this.perfData.put(new Integer(pmiDataInfo.getId()), pmiDataInfo);
        }
    }

    public synchronized void removeData(PmiDataInfo pmiDataInfo) {
        if (pmiDataInfo != null && this.perfData != null) {
            this.perfData.remove(new Integer(pmiDataInfo.getId()));
        }
    }

    public String getResourceBundle() {
        return this.statsNLSFile;
    }

    public int getNumData() {
        return this.perfData.size();
    }

    public String getUID() {
        return this.UID;
    }

    public String getShortName() {
        int n = this.UID.lastIndexOf(".");
        return this.UID.substring(n + 1);
    }

    public String getDescription() {
        return this.description;
    }

    public String getMbeanType() {
        return this.mbeanType;
    }

    public int getDataId(String string) {
        for (PmiDataInfo pmiDataInfo : this.perfData.values()) {
            if (!pmiDataInfo.getName().equalsIgnoreCase(string)) continue;
            return pmiDataInfo.getId();
        }
        return -1;
    }

    public PmiDataInfo getDataInfo(int n) {
        return (PmiDataInfo)this.perfData.get(new Integer(n));
    }

    public PmiDataInfo[] submoduleMembers(String string) {
        return this.submoduleMembers(string, 15);
    }

    public PmiDataInfo[] submoduleMembers(String string, int n) {
        PmiDataInfo[] pmiDataInfoArray2;
        if (string == null) {
            return this.listLevelData(n);
        }
        ArrayList<PmiDataInfo[]> arrayList = new ArrayList<PmiDataInfo[]>();
        boolean bl = false;
        if (string.startsWith("ejb.")) {
            bl = true;
        }
        for (PmiDataInfo[] pmiDataInfoArray2 : this.perfData.values()) {
            if (bl) {
                if (!pmiDataInfoArray2.getCategory().equals("all") && !this.isInCategory(string, pmiDataInfoArray2.getCategory())) continue;
                arrayList.add(pmiDataInfoArray2);
                continue;
            }
            if (pmiDataInfoArray2.getSubmoduleName() == null || !pmiDataInfoArray2.getSubmoduleName().equals(string) || pmiDataInfoArray2.getLevel() > n) continue;
            arrayList.add(pmiDataInfoArray2);
        }
        pmiDataInfoArray2 = new PmiDataInfo[arrayList.size()];
        for (int i = 0; i < pmiDataInfoArray2.length; ++i) {
            pmiDataInfoArray2[i] = (PmiDataInfo)arrayList.get(i);
        }
        return pmiDataInfoArray2;
    }

    public PmiDataInfo[] listData(String string) {
        if (string == null) {
            return this.listAllData();
        }
        return this.submoduleMembers(string);
    }

    public PmiDataInfo[] listAllData() {
        return this.listLevelData(15);
    }

    public PmiDataInfo[] listLevelData(int n) {
        PmiDataInfo[] pmiDataInfoArray2;
        ArrayList<PmiDataInfo[]> arrayList = new ArrayList<PmiDataInfo[]>();
        for (PmiDataInfo[] pmiDataInfoArray2 : this.perfData.values()) {
            if (pmiDataInfoArray2.getLevel() > n) continue;
            arrayList.add(pmiDataInfoArray2);
        }
        pmiDataInfoArray2 = new PmiDataInfo[arrayList.size()];
        for (int i = 0; i < pmiDataInfoArray2.length; ++i) {
            pmiDataInfoArray2[i] = (PmiDataInfo)arrayList.get(i);
        }
        return pmiDataInfoArray2;
    }

    public PmiDataInfo[] listMyLevelData(int n) {
        ArrayList<PmiDataInfo> arrayList = new ArrayList<PmiDataInfo>();
        for (PmiDataInfo pmiDataInfo : this.perfData.values()) {
            if (pmiDataInfo.getLevel() != n) continue;
            arrayList.add(pmiDataInfo);
        }
        return (PmiDataInfo[])arrayList.toArray();
    }

    public void print(PrintWriter printWriter) {
        printWriter.println("UID:" + this.UID);
        printWriter.println("description:" + this.description);
        PmiDataInfo[] pmiDataInfoArray = this.listAllData();
        for (int i = 0; i < pmiDataInfoArray.length; ++i) {
            pmiDataInfoArray[i].print(printWriter);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Stats type=").append(this.UID);
        stringBuffer.append(", Description=").append(this.description).append("\n");
        PmiDataInfo[] pmiDataInfoArray = this.listAllData();
        for (int i = 0; i < pmiDataInfoArray.length; ++i) {
            stringBuffer.append("\n").append(pmiDataInfoArray[i].toString()).append("\n");
        }
        return stringBuffer.toString();
    }

    private boolean isInCategory(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "+");
        while (stringTokenizer.hasMoreTokens()) {
            if (!string.equals(stringTokenizer.nextToken())) continue;
            return true;
        }
        return false;
    }

    public int[] listStatisticsWithDependents() {
        if (this.dependList == null) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (PmiDataInfo pmiDataInfo : this.perfData.values()) {
                if (pmiDataInfo.getDependency() == null) continue;
                arrayList.add(new Integer(pmiDataInfo.getId()));
            }
            this.dependList = new int[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                this.dependList[i] = (Integer)arrayList.get(i);
            }
        }
        return this.dependList;
    }

    public int[] listStatisticsBySet(String string) {
        Object object2;
        if (string.equals("none") || string.equals("custom")) {
            return new int[0];
        }
        int n = 0;
        if (string.equals("basic")) {
            n = 1;
        } else if (string.equals("extended")) {
            n = 2;
        } else if (string.equals("all")) {
            n = 3;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(3);
        for (Object object2 : this.perfData.values()) {
            String string2 = ((PmiDataInfo)object2).getStatisticSet();
            if (string2.equals("basic")) {
                if (n <= 0) continue;
                arrayList.add(new Integer(((PmiDataInfo)object2).getId()));
                continue;
            }
            if (string2.equals("extended")) {
                if (n <= 1) continue;
                arrayList.add(new Integer(((PmiDataInfo)object2).getId()));
                continue;
            }
            if (!string2.equals("all") || n <= 2) continue;
            arrayList.add(new Integer(((PmiDataInfo)object2).getId()));
        }
        object2 = new int[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            object2[i] = (Integer)arrayList.get(i);
        }
        return object2;
    }

    public boolean hasSubModule() {
        if (!this.hasSubModInit) {
            this.hasSubModInit = true;
            if (this.perfData != null) {
                for (PmiDataInfo pmiDataInfo : this.perfData.values()) {
                    if (pmiDataInfo.getSubmoduleName() == null) continue;
                    this.hasSubMod = true;
                    break;
                }
            }
        }
        return this.hasSubMod;
    }

    public PmiModuleConfig copy() {
        PmiModuleConfig pmiModuleConfig = new PmiModuleConfig(this.UID);
        if (this.description != null) {
            pmiModuleConfig.description = new String(this.description);
        }
        pmiModuleConfig.mbeanType = this.mbeanType;
        pmiModuleConfig.statsNLSFile = this.statsNLSFile;
        pmiModuleConfig.hasSubMod = this.hasSubMod;
        pmiModuleConfig.dependList = this.dependList;
        if (this.perfData != null) {
            for (PmiDataInfo pmiDataInfo : this.perfData.values()) {
                pmiModuleConfig.perfData.put(new Integer(pmiDataInfo.getId()), pmiDataInfo.copy());
            }
        }
        return pmiModuleConfig;
    }
}

