/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.naming;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.naming.HostnameNormalizer;
import com.ibm.websphere.naming.WsnBatchModeContext;
import com.ibm.websphere.naming.WsnBatchResult;
import com.ibm.websphere.naming.WsnOptimizedJndiContext;
import com.ibm.ws.naming.jbatch.BatchModeNotSupported;
import com.ibm.ws.naming.util.CommonHelpers;
import com.ibm.ws.naming.util.NameFormatHelper;
import com.ibm.ws.naming.util.RasUtil;
import com.ibm.ws.security.util.AccessController;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingException;
import javax.naming.NotContextException;

public class JndiHelper {
    private static final TraceComponent _tc = Tr.register(JndiHelper.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    private static final String CLASS_NAME;
    private static HostnameNormalizer _hostnameNormalizer;

    protected JndiHelper() {
    }

    public static Context recursiveCreateSubcontext(Context context, String string) throws NamingException {
        NameParser nameParser = context.getNameParser("");
        Name name = nameParser.parse(string);
        return JndiHelper.recursiveCreateSubcontext(context, name);
    }

    public static Context recursiveCreateSubcontext(Context context, Name name) throws NamingException {
        Object object;
        Object object2;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "recursiveCreateSubcontext", new String[]{"startingContext=" + context, "name=" + name});
        }
        Context context2 = null;
        boolean bl = false;
        WsnBatchModeContext wsnBatchModeContext = null;
        context = (Context)CommonHelpers.extractCtxImplFromInitCtx((Object)context);
        try {
            object2 = CommonHelpers.getContextIfUrlName((Name)name, context.getEnvironment());
            if (object2 != null) {
                context = object2;
                object = object2.getNameParser("");
                String string = NameFormatHelper.getUrlScheme((Name)name);
                String string2 = name.toString();
                string2 = string2.substring(string.length() + 1);
                name = object.parse(string2);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "recursiveCreateSubcontext", "URL name: new starting context=" + context.getNameInNamespace() + ", nameString=" + string2);
                }
            }
        }
        catch (NamingException namingException) {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "recursiveCreateSubcontext", "Could not process URL.  Rethrowing NamingException: " + namingException);
            }
            throw namingException;
        }
        if (context instanceof WsnBatchModeContext) {
            wsnBatchModeContext = (WsnBatchModeContext)context;
            context = wsnBatchModeContext.getNonBatchModeContext();
        }
        if (context instanceof WsnOptimizedJndiContext && !((WsnOptimizedJndiContext)((Object)context)).isLocal()) {
            bl = true;
            if (wsnBatchModeContext == null) {
                try {
                    wsnBatchModeContext = ((WsnOptimizedJndiContext)((Object)context)).getBatchModeContext();
                }
                catch (BatchModeNotSupported batchModeNotSupported) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "recursiveCreateSubcontext", new Object[]{"Batch mode not supported", batchModeNotSupported});
                    }
                    wsnBatchModeContext = null;
                    bl = false;
                }
            }
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "recursiveCreateSubcontext", "useBatch=" + bl);
        }
        if (bl) {
            JndiHelper.batchCreateSubcontextsDriver(wsnBatchModeContext, name);
            object2 = wsnBatchModeContext.executeBatchedOperations();
            object = object2.getResultEnumeration();
            context2 = JndiHelper.getSubcontextFromBatchResults(context, (Enumeration)object, name.size());
        } else {
            context2 = JndiHelper.createSubcontextsDriver(context, name);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "recursiveCreateSubcontext", context2);
        }
        return context2;
    }

    protected static void batchCreateSubcontextsDriver(WsnBatchModeContext wsnBatchModeContext, Name name) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "batchCreateSubcontextsDriver", new String[]{"startingContext=" + wsnBatchModeContext, "name=" + name});
        }
        Name name2 = null;
        wsnBatchModeContext.lookup(name);
        for (int i = 1; i <= name.size(); ++i) {
            name2 = name.getPrefix(i);
            wsnBatchModeContext.createSubcontext(name2);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "batchCreateSubcontextsDriver");
        }
    }

    protected static Context createSubcontextsDriver(Context context, Name name) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "createSubcontextsDriver", new String[]{"startingContext=" + context, "name=" + name});
        }
        Context context2 = null;
        context2 = JndiHelper.createSubcontexts(context, name);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "createSubcontextsDriver", context2);
        }
        return context2;
    }

    private static Context createSubcontexts(Context context, Name name) throws NamingException {
        Context context2;
        block9: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "createSubcontexts", new String[]{"startingContext=" + context, "name=" + name});
            }
            context2 = null;
            try {
                context2 = context.createSubcontext(name);
            }
            catch (NameAlreadyBoundException nameAlreadyBoundException) {
                Object object;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "createSubcontexts", "caught NameAlreadyBoundException: " + nameAlreadyBoundException);
                }
                if (!((object = context.lookup(name)) instanceof Context)) {
                    NotContextException notContextException = new NotContextException("Name \"" + name + "\", relative to context \"" + context.getNameInNamespace() + "\" is already bound to an object which is not a context.");
                    notContextException.initCause(nameAlreadyBoundException);
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "createSubcontexts", "Throwing NotContextException: " + notContextException);
                    }
                    throw notContextException;
                }
                context2 = (Context)object;
            }
            catch (NameNotFoundException nameNotFoundException) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "createSubcontexts", "caught NameNotFoundException: " + nameNotFoundException);
                }
                if (name.size() <= 1) break block9;
                Name name2 = name.getPrefix(name.size() - 1);
                context2 = JndiHelper.createSubcontexts(context, name2);
                context2 = context.createSubcontext(name);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "createSubcontexts", context2);
        }
        return context2;
    }

    public static void recursiveRebind(Context context, String string, Object object) throws NamingException {
        NameParser nameParser = context.getNameParser("");
        Name name = nameParser.parse(string);
        JndiHelper.recursiveBind(context, name, object, Operation.REBIND);
    }

    public static void recursiveRebind(Context context, Name name, Object object) throws NamingException {
        JndiHelper.recursiveBind(context, name, object, Operation.REBIND);
    }

    public static void recursiveBind(Context context, String string, Object object) throws NamingException {
        NameParser nameParser = context.getNameParser("");
        Name name = nameParser.parse(string);
        JndiHelper.recursiveBind(context, name, object, Operation.BIND);
    }

    public static void recursiveBind(Context context, Name name, Object object) throws NamingException {
        JndiHelper.recursiveBind(context, name, object, Operation.BIND);
    }

    private static void recursiveBind(Context context, Name name, Object object, Operation operation) throws NamingException {
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "recursiveBind", new String[]{"startingContext=" + context, "name=" + name, "obj=" + object, "operation=" + (Object)((Object)operation)});
        }
        boolean bl = false;
        WsnBatchModeContext wsnBatchModeContext = null;
        context = (Context)CommonHelpers.extractCtxImplFromInitCtx((Object)context);
        try {
            object5 = CommonHelpers.getContextIfUrlName((Name)name, context.getEnvironment());
            if (object5 != null) {
                context = object5;
                object4 = object5.getNameParser("");
                object3 = NameFormatHelper.getUrlScheme((Name)name);
                object2 = name.toString();
                object2 = ((String)object2).substring(((String)object3).length() + 1);
                name = object4.parse((String)object2);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "recursiveBind", "URL name: new starting context=" + context.getNameInNamespace() + ", name=" + (String)object2);
                }
            }
        }
        catch (NamingException namingException) {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "recursiveBind", "Could not process URL.  Rethrowing NamingException: " + namingException);
            }
            throw namingException;
        }
        if (context instanceof WsnBatchModeContext) {
            wsnBatchModeContext = (WsnBatchModeContext)context;
            context = wsnBatchModeContext.getNonBatchModeContext();
        }
        if (context instanceof WsnOptimizedJndiContext && !((WsnOptimizedJndiContext)((Object)context)).isLocal()) {
            bl = true;
            if (wsnBatchModeContext == null) {
                try {
                    wsnBatchModeContext = ((WsnOptimizedJndiContext)((Object)context)).getBatchModeContext();
                }
                catch (BatchModeNotSupported batchModeNotSupported) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "recursiveBind", new Object[]{"Batch mode not supported", batchModeNotSupported});
                    }
                    wsnBatchModeContext = null;
                    bl = false;
                }
            }
        }
        object5 = name.getPrefix(name.size() - 1);
        object4 = null;
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "recursiveBind", "useBatch=" + bl);
        }
        if (bl) {
            WsnBatchResult wsnBatchResult;
            if (object5.size() > 0) {
                JndiHelper.batchCreateSubcontextsDriver(wsnBatchModeContext, (Name)object5);
            }
            if (operation == Operation.BIND) {
                wsnBatchModeContext.bind(name, object);
            } else {
                wsnBatchModeContext.rebind(name, object);
            }
            object3 = wsnBatchModeContext.executeBatchedOperations();
            object2 = object3.getResultEnumeration();
            if (object5.size() > 0) {
                object4 = JndiHelper.getSubcontextFromBatchResults(context, (Enumeration)object2, object5.size());
            }
            if (!(wsnBatchResult = (WsnBatchResult)object2.nextElement()).getResult()) {
                throw wsnBatchResult.getException();
            }
        } else {
            if (object5.size() > 0) {
                object4 = JndiHelper.createSubcontextsDriver(context, (Name)object5);
            }
            if (operation == Operation.BIND) {
                context.bind(name, object);
            } else {
                context.rebind(name, object);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "recursiveBind");
        }
    }

    protected static Context getSubcontextFromBatchResults(Context context, Enumeration enumeration, int n) throws NamingException {
        Context context2 = null;
        WsnBatchResult wsnBatchResult = (WsnBatchResult)enumeration.nextElement();
        if (wsnBatchResult.getResult()) {
            Object object = wsnBatchResult.getOutputObject();
            if (!(object instanceof Context)) {
                throw new NotContextException("Name \"" + wsnBatchResult.getName() + "\", relative to context \"" + context.getNameInNamespace() + "\" is already bound to an object which is not a context.");
            }
            context2 = (Context)object;
            for (int i = 0; i < n; ++i) {
                wsnBatchResult = (WsnBatchResult)enumeration.nextElement();
            }
            return context2;
        }
        for (int i = 0; enumeration.hasMoreElements() && i < n; ++i) {
            wsnBatchResult = (WsnBatchResult)enumeration.nextElement();
            if (wsnBatchResult.getResult()) continue;
            NamingException namingException = wsnBatchResult.getException();
            if (namingException instanceof NameAlreadyBoundException) continue;
            throw namingException;
        }
        return context2;
    }

    public static String normalizeHostname(Hashtable hashtable) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "normalizeHostname", "env=" + hashtable);
        }
        if (hashtable == null) {
            hashtable = CommonHelpers.getWsnJndiProperties();
        }
        JndiHelper.initializeHostnameNormalizer(hashtable);
        boolean bl = JndiHelper.needToEscapeDots(hashtable);
        String string = _hostnameNormalizer.normalizeHostname(bl);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "normalizeHostname", string);
        }
        return string;
    }

    public static String normalizeHostname(Hashtable hashtable, String string) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "normalizeHostname", new String[]{"env=" + hashtable, "hostname=" + string});
        }
        if (string == null) {
            JndiHelper.nullParam("normalizeHostname", "hostname");
        }
        if (hashtable == null) {
            hashtable = CommonHelpers.getWsnJndiProperties();
        }
        JndiHelper.initializeHostnameNormalizer(hashtable);
        boolean bl = JndiHelper.needToEscapeDots(hashtable);
        String string2 = _hostnameNormalizer.normalizeHostname(bl, string);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "normalizeHostname", string2);
        }
        return string2;
    }

    public static String normalizeHostname(Hashtable hashtable, InetAddress inetAddress) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "normalizeHostname", new String[]{"env=" + hashtable, "ipAddress=" + inetAddress});
        }
        if (inetAddress == null) {
            JndiHelper.nullParam("normalizeHostname", "ipAddress");
        }
        if (hashtable == null) {
            hashtable = CommonHelpers.getWsnJndiProperties();
        }
        JndiHelper.initializeHostnameNormalizer(hashtable);
        boolean bl = JndiHelper.needToEscapeDots(hashtable);
        String string = _hostnameNormalizer.normalizeHostname(bl, inetAddress);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "normalizeHostname", string);
        }
        return string;
    }

    private static Hashtable nullParam(String string, String string2) throws NamingException {
        String string3 = "Parameter \"" + string2 + "\" is null.  Null is not a valid value for this call.";
        NamingException namingException = new NamingException(string3);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, string, namingException);
        }
        throw namingException;
    }

    private static boolean needToEscapeDots(Hashtable hashtable) throws NamingException {
        Object v;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "needToEscapeDots");
        }
        if (!((v = hashtable.get("com.ibm.websphere.naming.name.syntax")) instanceof String)) {
            String string = "Failed to get com.ibm.websphere.naming.name.syntax from environment.  Please ensure that the environment parameter  has been obtained by a getEnvironment() call on a valid Context. ";
            NamingException namingException = new NamingException(string);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "needToExcapeDots", namingException);
            }
            throw namingException;
        }
        String string = (String)v;
        boolean bl = string.equals("ins");
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "needToEscapeDots", Boolean.toString(bl));
        }
        return bl;
    }

    private static void initializeHostnameNormalizer(Hashtable hashtable) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "initializeHostnameNormalizer");
        }
        if (_hostnameNormalizer == null) {
            Object object;
            Object object2;
            Object v = hashtable.get("com.ibm.websphere.naming.hostname.normalizer");
            if (!(v instanceof String)) {
                String string = "Failed to get com.ibm.websphere.naming.hostname.normalizer from environment.  Please ensure that the environment parameter  has been obtained by a getEnvironment() call on a valid Context. ";
                NamingException namingException = new NamingException(string);
                if (_tc.isDebugEnabled()) {
                    Tr.exit(_tc, "initializeHostnameNormalizer", namingException);
                }
                throw namingException;
            }
            String string = (String)v;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "initializeHostnameNormalizer", "normalizerName=" + string);
            }
            Throwable throwable = null;
            Class clazz = null;
            try {
                object2 = string;
                try {
                    clazz = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction((String)object2){
                        final /* synthetic */ String val$tmpName;
                        {
                            this.val$tmpName = string;
                        }

                        public Object run() throws Exception, LinkageError {
                            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                            if (classLoader == null) {
                                throw new NullPointerException("Context class loader is null");
                            }
                            return Class.forName(this.val$tmpName, true, classLoader);
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw privilegedActionException.getException();
                }
            }
            catch (Exception exception) {
                throwable = exception;
            }
            catch (LinkageError linkageError) {
                throwable = linkageError;
            }
            if (throwable != null) {
                RasUtil.logException((Throwable)throwable, (TraceComponent)_tc, (String)CLASS_NAME, (String)"initializeHostnameNormalizer", (String)"917");
                Tr.warning(_tc, "cannotGetClassObj", string);
                object2 = "Failed to create Class object for the class " + string + ".";
                NamingException namingException = new NamingException((String)object2 + "Please get the root cause Throwable contained in this NamingException " + "for more information.");
                namingException.initCause(throwable);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "initializeHostnameNormalizer", namingException);
                }
                throw namingException;
            }
            try {
                object2 = clazz.getConstructor(null);
                object = ((Constructor)object2).newInstance(null);
                _hostnameNormalizer = (HostnameNormalizer)object;
            }
            catch (Exception exception) {
                throwable = exception;
            }
            catch (LinkageError linkageError) {
                throwable = linkageError;
            }
            if (throwable != null) {
                RasUtil.logException((Throwable)throwable, (TraceComponent)_tc, (String)CLASS_NAME, (String)"initializeHostnameNormalizer", (String)"947");
                Tr.warning(_tc, "cannotCreateObj", string);
                object2 = "Could not create an instance of the class " + string + ".";
                object = new NamingException((String)object2 + "Please get the root cause Throwable contained in this NamingException " + "for more information.");
                ((NamingException)object).initCause(throwable);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "initializeHostnameNormalizer", object);
                }
                throw object;
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "initializeHostnameNormalizer");
        }
    }

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOURCE CODE INFO: SERV1/ws/code/naming/src/com/ibm/websphere/naming/JndiHelper.java, WAS.naming, WAS70.SERV1, q0834.18, ver. 1.39");
        }
        CLASS_NAME = JndiHelper.class.getName();
        _hostnameNormalizer = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Operation {
        BIND,
        REBIND,
        CREATE_SUBCONTEXT;

    }
}

