/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.naming;

import com.ibm.WsnOptimizedNaming.WsnBindingCategory;
import com.ibm.ejs.ras.ManagerAdmin;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.naming.CannotInstantiateObjectException;
import com.ibm.ws.naming.ipbase.UuidContext;
import com.ibm.ws.naming.jndicos.CNContext;
import com.ibm.ws.naming.util.CommonHelpers;
import com.ibm.ws.naming.util.InvalidObjectException;
import com.ibm.ws.naming.util.RetryableAction;
import com.ibm.ws.naming.util.UnresolvedURLException;
import com.ibm.ws.naming.util.WsnBinding;
import com.ibm.ws.util.StringUtils;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import org.omg.CosNaming.BindingType;
import org.omg.CosNaming.NamingContext;

public class DumpNameSpace {
    private static final TraceComponent _tc = Tr.register(DumpNameSpace.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    @Deprecated
    public static final int SHORT = 1;
    @Deprecated
    public static final int LONG = 2;
    public static final int NORMAL_EXIT_STATUS = 0;
    public static final int BAD_EXIT_STATUS_NO_STARTING_CONTEXT = 1;
    public static final int BAD_EXIT_STATUS_WITH_ERROR = 2;
    public static final int BAD_EXIT_STATUS_WITH_BAD_OPTION = 3;
    private static final int NS_TYPE_GENERIC = -1;
    private static final int NS_TYPE_WS40 = 0;
    private static final int NS_TYPE_WS50 = 1;
    private static final String DEFAULT_HOSTNAME = "localhost";
    private static final String DEFAULT_PORT = "2809";
    private static final String PARAM_PREFIX = "-";
    private static final String BLANK_LINE = " ";
    private static final String INDENT_AMOUNT = "   ";
    private static final String COMPONENT_SEPARATOR = "/";
    public static final String BUNDLE_NAME = "com.ibm.websphere.naming.DumpNameSpaceMessages";
    private static ResourceBundle _resourceBundle;
    private static Mode _mode;
    private PrintStream _out = null;
    private String _factory = "com.ibm.websphere.naming.WsnInitialContextFactory";
    private String _providerUrl = null;
    private String _hostname = "localhost";
    private String _port = "2809";
    private String _url = "";
    private String _principal = null;
    private String _credentials = null;
    private String _startAt = "";
    private boolean _rootOpt = false;
    private String _root = "cellroot";
    private String _rootMsg = "cell";
    private String _nameSyntax = "jndi";
    private ReportFormat _reportFormat = ReportFormat.SHORT;
    private String _topLabel = null;
    private long _seq = 0L;
    private String _seqNum = null;
    private Map<String, ContextInfo> _visitedCxtNames = null;
    private Map<String, ContextInfo> _visitedCxtUuids = null;

    public static void main(String[] stringArray) {
        int n = 0;
        DumpNameSpace.setResourceBundle();
        DumpNameSpace dumpNameSpace = new DumpNameSpace();
        if (dumpNameSpace.parseArguments(stringArray)) {
            Context context = dumpNameSpace.getStartingContext();
            if (context != null) {
                try {
                    dumpNameSpace.printCmdLineHeader();
                    dumpNameSpace.doGenerateDump(context);
                }
                catch (Exception exception) {
                    dumpNameSpace.writeException(exception);
                    n = 2;
                }
            } else {
                n = 1;
            }
        } else {
            n = 3;
        }
        System.exit(n);
    }

    private static int getNameServerType(Context context) {
        CNContext cNContext;
        NamingContext namingContext;
        int n = -1;
        if (context instanceof CNContext && (namingContext = (cNContext = (CNContext)context).getCosContext()) instanceof com.ibm.WsnOptimizedNaming.NamingContext) {
            final com.ibm.WsnOptimizedNaming.NamingContext namingContext2 = (com.ibm.WsnOptimizedNaming.NamingContext)namingContext;
            n = (Integer)CommonHelpers.retry((RetryableAction)new RetryableAction<Integer>(){

                public Integer run() {
                    return namingContext2.get_compatibility_level();
                }
            });
        }
        return n;
    }

    private static void setResourceBundle() {
        if (_resourceBundle == null) {
            _resourceBundle = ResourceBundle.getBundle(BUNDLE_NAME);
        }
    }

    public DumpNameSpace() {
        this(System.out, ReportFormat.SHORT);
    }

    @Deprecated
    public DumpNameSpace(PrintStream printStream, int n) {
        this(printStream, n == 2 ? ReportFormat.LONG : ReportFormat.SHORT);
    }

    public DumpNameSpace(PrintStream printStream, ReportFormat reportFormat) {
        this._out = printStream != null ? printStream : System.out;
        this._reportFormat = reportFormat;
        DumpNameSpace.setResourceBundle();
        this._topLabel = DumpNameSpace.fmtMsg("top");
        this.initForEachDump();
    }

    private void initForEachDump() {
        this._visitedCxtNames = new HashMap<String, ContextInfo>();
        this._visitedCxtUuids = new HashMap<String, ContextInfo>();
        this._seq = 0L;
        this._seqNum = null;
    }

    private boolean parseArguments(String[] stringArray) {
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-host")) {
                if (i + 1 >= stringArray.length || stringArray[i + 1].startsWith(PARAM_PREFIX)) continue;
                this._hostname = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-port")) {
                if (i + 1 >= stringArray.length || stringArray[i + 1].startsWith(PARAM_PREFIX)) continue;
                this._port = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-user") || stringArray[i].equals("-username")) {
                if (i + 1 >= stringArray.length || stringArray[i + 1].startsWith(PARAM_PREFIX)) continue;
                this._principal = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-password")) {
                if (i + 1 >= stringArray.length || stringArray[i + 1].startsWith(PARAM_PREFIX)) continue;
                this._credentials = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-url")) {
                if (i + 1 >= stringArray.length || stringArray[i + 1].startsWith(PARAM_PREFIX)) continue;
                this._url = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-factory")) {
                if (i + 1 >= stringArray.length || stringArray[i + 1].startsWith(PARAM_PREFIX)) continue;
                this._factory = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-startAt")) {
                if (i + 1 >= stringArray.length || stringArray[i + 1].startsWith(PARAM_PREFIX)) continue;
                this._startAt = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-report")) {
                if (i + 1 >= stringArray.length || stringArray[i + 1].startsWith(PARAM_PREFIX)) {
                    this.println(DumpNameSpace.fmtMsg("reportOptBad"));
                    continue;
                }
                if (stringArray[++i].equals("short")) {
                    this._reportFormat = ReportFormat.SHORT;
                    continue;
                }
                if (stringArray[i].equals("long")) {
                    this._reportFormat = ReportFormat.LONG;
                    continue;
                }
                this.println(DumpNameSpace.fmtMsg("reportOptBad"));
                continue;
            }
            if (stringArray[i].equals("-mode")) {
                if (i + 1 >= stringArray.length || stringArray[i + 1].startsWith(PARAM_PREFIX)) continue;
                if (stringArray[++i].equals("ws40")) {
                    _mode = Mode.WS40;
                    continue;
                }
                if (stringArray[i].equals("ws50")) {
                    _mode = Mode.WS50;
                    continue;
                }
                this.println(DumpNameSpace.fmtMsg("modeOptBad"));
                continue;
            }
            if (stringArray[i].equals("-root")) {
                if (i + 1 >= stringArray.length || stringArray[i + 1].startsWith(PARAM_PREFIX)) {
                    this.println(DumpNameSpace.fmtMsg("treeOptBad"));
                    continue;
                }
                this._rootOpt = true;
                if (stringArray[++i].equals("tree")) {
                    this._root = "treeinfrastructureroot";
                    this._rootMsg = "tree";
                    continue;
                }
                if (stringArray[i].equals("host")) {
                    this._root = "bootstraphostroot";
                    this._rootMsg = "host";
                    continue;
                }
                if (stringArray[i].equals("legacy")) {
                    this._root = "legacydomainroot";
                    this._rootMsg = "legacy";
                    continue;
                }
                if (stringArray[i].equals("node")) {
                    this._root = "bootstraphostroot";
                    this._rootMsg = "node";
                    continue;
                }
                if (stringArray[i].equals("server")) {
                    this._root = "bootstrapserverroot";
                    this._rootMsg = "server";
                    continue;
                }
                if (stringArray[i].equals("cell")) {
                    this._root = "cellroot";
                    this._rootMsg = "cell";
                    continue;
                }
                if (stringArray[i].equals("default")) {
                    this._root = "defaultroot";
                    this._rootMsg = "default";
                    continue;
                }
                this.println(DumpNameSpace.fmtMsg("treeOptBad"));
                this._rootOpt = false;
                continue;
            }
            if (stringArray[i].equals("-format")) {
                if (i + 1 >= stringArray.length || stringArray[i + 1].startsWith(PARAM_PREFIX)) {
                    this.println(DumpNameSpace.fmtMsg("formatOptBad", new String[]{"jndi", "ins"}));
                    continue;
                }
                if (stringArray[++i].equals("jndi") || stringArray[i].equals("ins")) {
                    this._nameSyntax = stringArray[i];
                    continue;
                }
                this.println(DumpNameSpace.fmtMsg("formatOptBad", new String[]{"jndi", "ins"}));
                continue;
            }
            if (stringArray[i].equals("-traceString")) {
                if (i + 1 >= stringArray.length || stringArray[i + 1].startsWith(PARAM_PREFIX)) continue;
                ManagerAdmin.configureClientTrace(stringArray[++i], "named file", "DumpNameSpaceTrace.out", false, "basic", false);
                continue;
            }
            if (stringArray[i].equals("-?") || stringArray[i].equals("?") || stringArray[i].equals("-help") || stringArray[i].equals("help")) {
                DumpNameSpace.printHelp();
                bl = false;
                continue;
            }
            this.println("\n" + DumpNameSpace.fmtMsg("optionBad", new String[]{stringArray[i]}));
            bl = false;
        }
        if (this._url.length() > 0) {
            this._rootMsg = BLANK_LINE;
        }
        if (this._url.length() > 0) {
            this._providerUrl = this._url;
        } else {
            StringBuilder stringBuilder = new StringBuilder(64);
            stringBuilder.append("corbaloc:iiop:");
            stringBuilder.append(CommonHelpers.normalizeHostForUrl((String)this._hostname));
            stringBuilder.append(':');
            stringBuilder.append(this._port);
            this._providerUrl = stringBuilder.toString();
        }
        if (_mode == Mode.WS40 && (this._root == "bootstrapserverroot" || this._root == "cellroot")) {
            this._root = "legacydomainroot";
            this._rootMsg = "legacy";
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Context getStartingContext() {
        Context context = null;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("java.naming.factory.initial", this._factory);
        hashtable.put("java.naming.provider.url", this._providerUrl);
        if (this._principal != null) {
            hashtable.put("java.naming.security.principal", this._principal);
        }
        if (this._credentials != null) {
            hashtable.put("java.naming.security.credentials", this._credentials);
        }
        hashtable.put("com.ibm.websphere.naming.namespaceroot", this._root);
        hashtable.put("com.ibm.websphere.naming.name.syntax", this._nameSyntax);
        hashtable.put("com.ibm.websphere.naming.namespace.connection", "eager");
        this.println("");
        this.println(DumpNameSpace.fmtMsg("gettingInitCtx"));
        InitialContext initialContext = null;
        try {
            initialContext = new InitialContext(hashtable);
            if (_mode == Mode.NOT_SET) {
                int n = DumpNameSpace.getNameServerType((Context)initialContext.lookup(""));
                switch (n) {
                    case -1: 
                    case 0: {
                        _mode = Mode.WS40;
                        if (!this._rootOpt) {
                            this._root = "legacydomainroot";
                            this._rootMsg = "legacy";
                        }
                        hashtable.put("com.ibm.websphere.naming.namespaceroot", this._root);
                        CommonHelpers.closeIfContext((Object)initialContext);
                        initialContext = new InitialContext(hashtable);
                        break;
                    }
                    case 1: {
                        _mode = Mode.WS50;
                        break;
                    }
                    default: {
                        _mode = Mode.WS50;
                    }
                }
            }
            this.println(DumpNameSpace.fmtMsg("gettingStartCtx"));
            context = (Context)initialContext.lookup(this._startAt);
            try {
                this._startAt = context.getNameInNamespace();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        catch (Exception exception) {
            try {
                this.writeException(exception);
            }
            catch (Throwable throwable) {
                CommonHelpers.closeIfContext(initialContext);
                throw throwable;
            }
            CommonHelpers.closeIfContext((Object)initialContext);
        }
        CommonHelpers.closeIfContext((Object)initialContext);
        return context;
    }

    private void printCmdLineHeader() {
        String string = INDENT_AMOUNT;
        this.println(BLANK_LINE);
        this.println(DumpNameSpace.fmtMsg("sepLine"));
        this.println(DumpNameSpace.fmtMsg("nsDump"));
        this.println(string + DumpNameSpace.fmtMsg("ctxFactory", new String[]{this._factory}));
        this.println(string + DumpNameSpace.fmtMsg("providerUrl", new String[]{this._providerUrl}));
        this.println(string + DumpNameSpace.fmtMsg("rootCtx", new String[]{this._rootMsg}));
        if (this._startAt.equals("")) {
            this.println(string + DumpNameSpace.fmtMsg("startingCtxRoot"));
        } else {
            this.println(string + DumpNameSpace.fmtMsg("startingCtx", new String[]{this._startAt}));
        }
        this.println(string + DumpNameSpace.fmtMsg("fmtRules", new String[]{this._nameSyntax}));
        this.println(string + DumpNameSpace.fmtMsg("dumpTime", new String[]{new Date().toString()}));
        this.println(DumpNameSpace.fmtMsg("sepLine"));
        this.println(BLANK_LINE);
    }

    public void generateDump(Context context) {
        this.printApiHeader(context);
        this.doGenerateDump(context);
    }

    private void doGenerateDump(Context context) {
        this.initForEachDump();
        this.println(BLANK_LINE);
        this.println(DumpNameSpace.fmtMsg("sepLine"));
        this.println(DumpNameSpace.fmtMsg("startDump"));
        this.println(DumpNameSpace.fmtMsg("sepLine"));
        this.println(BLANK_LINE);
        this.dumpContext(this._topLabel, context, "", null, null, null);
        this.println(BLANK_LINE);
        this.println(DumpNameSpace.fmtMsg("sepLine"));
        this.println(DumpNameSpace.fmtMsg("endDump"));
        this.println(DumpNameSpace.fmtMsg("sepLine"));
        this.println(BLANK_LINE);
    }

    private void printApiHeader(Context context) {
        String string = INDENT_AMOUNT;
        this.println(BLANK_LINE);
        this.println(DumpNameSpace.fmtMsg("sepLine"));
        this.println(DumpNameSpace.fmtMsg("nsDump"));
        String string2 = DumpNameSpace.fmtMsg("topNotAvail");
        try {
            string2 = context.getNameInNamespace();
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        this.println(string + DumpNameSpace.fmtMsg("startingCtx", new String[]{string2}));
        this.println(string + DumpNameSpace.fmtMsg("dumpTime", new String[]{new Date().toString()}));
        this.println(DumpNameSpace.fmtMsg("sepLine"));
        this.println(BLANK_LINE);
    }

    private void dumpContext(String string, Context context, String string2, String string3, BindingType bindingType, String string4) {
        Object object;
        boolean bl = false;
        if (context instanceof CNContext) {
            CNContext cNContext = (CNContext)context;
            object = cNContext.getCosContext();
            try {
                bl = CommonHelpers.isDistributedNC((NamingContext)object);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.printBinding(string, context, string2, string4, string3, BindingType.ncontext, null);
        boolean bl2 = this.contextWasAlreadyDumped(context, string);
        if (!bl2) {
            try {
                object = context.listBindings("");
                while (object.hasMore()) {
                    Object object2;
                    String string5;
                    Binding binding = null;
                    String string6 = null;
                    String string7 = null;
                    Object object3 = null;
                    bindingType = null;
                    WsnBinding wsnBinding = null;
                    int n = -1;
                    WsnBindingCategory wsnBindingCategory = null;
                    Reference reference = null;
                    string4 = null;
                    string3 = null;
                    try {
                        binding = (Binding)object.next();
                        string6 = binding.getName();
                        string7 = binding.getClassName();
                        object3 = binding.getObject();
                        if (binding instanceof WsnBinding) {
                            wsnBinding = (WsnBinding)binding;
                            bindingType = wsnBinding.getCorbaBindingType();
                            n = wsnBinding.getWsnContextBindingType();
                            reference = wsnBinding.getBoundReference();
                            if (bl) {
                                wsnBindingCategory = wsnBinding.getBindingCategory();
                                if (wsnBindingCategory == WsnBindingCategory.CONTEXT_LINKED && object3 instanceof Context) {
                                    string5 = ((Context)object3).getNameInNamespace();
                                    string3 = DumpNameSpace.fmtMsg("linkedto", new String[]{string5});
                                }
                                if (wsnBindingCategory == WsnBindingCategory.CONTEXT_URL) {
                                    string5 = wsnBinding.getBindingURL();
                                    string3 = DumpNameSpace.fmtMsg("linkedtourl", new String[]{string5});
                                }
                            }
                        }
                    }
                    catch (CannotInstantiateObjectException cannotInstantiateObjectException) {
                        if (this._reportFormat != ReportFormat.SHORT) {
                            string4 = DumpNameSpace.fmtMsg("noInstErr");
                        }
                        if ((object2 = cannotInstantiateObjectException.getNameClassPair()) != null) {
                            string6 = ((NameClassPair)object2).getName();
                            string7 = ((NameClassPair)object2).getClassName();
                        }
                        reference = cannotInstantiateObjectException.getReference();
                    }
                    catch (InvalidObjectException invalidObjectException) {
                        string4 = DumpNameSpace.fmtMsg("namingErr", new String[]{invalidObjectException.toString()});
                        object2 = invalidObjectException;
                        NameClassPair nameClassPair = object2.getNameClassPair();
                        if (nameClassPair != null) {
                            string6 = nameClassPair.getName();
                            string7 = nameClassPair.getClassName();
                        }
                    }
                    catch (UnresolvedURLException unresolvedURLException) {
                        if (this._reportFormat == ReportFormat.SHORT) {
                            string3 = DumpNameSpace.fmtMsg("linkedtourl", new String[]{unresolvedURLException.getURL()});
                        } else {
                            string4 = DumpNameSpace.fmtMsg("unresolvedURLErr", new String[]{unresolvedURLException.getURL(), string6});
                        }
                        object2 = unresolvedURLException.getNameClassPair();
                        if (object2 != null) {
                            string6 = ((NameClassPair)object2).getName();
                            string7 = ((NameClassPair)object2).getClassName();
                        }
                    }
                    catch (NamingException namingException) {
                        string4 = DumpNameSpace.fmtMsg("namingErr", new String[]{namingException.toString()});
                    }
                    string5 = null;
                    string5 = string6 != null ? string + COMPONENT_SEPARATOR + string6 : DumpNameSpace.fmtMsg("bindingNameNotAvail");
                    if (string7 == null || string7.length() == 0) {
                        string7 = DumpNameSpace.fmtMsg("classNameNotAvail");
                    }
                    if (object3 instanceof Context && ((bindingType == null || bindingType == BindingType.ncontext) && n != 1 || _mode == Mode.WS40)) {
                        this.dumpContext(string5, (Context)object3, string7, string3, bindingType, string4);
                        continue;
                    }
                    this.printBinding(string5, object3, string7, string4, string3, bindingType, reference);
                }
            }
            catch (NamingException namingException) {
                this.println(DumpNameSpace.fmtMsg("listErr", new String[]{string, namingException.toString()}));
            }
        }
    }

    private boolean contextWasAlreadyDumped(Context context, String string) {
        if (string.endsWith("nodeSystemNameSpaceRoot")) {
            this.println(this._seqNum + INDENT_AMOUNT + DumpNameSpace.fmtMsg("nodeSNSRoot"));
            return true;
        }
        if (context instanceof UuidContext) {
            UuidContext uuidContext = (UuidContext)context;
            String string2 = uuidContext.getContextID().toString();
            ContextInfo contextInfo = this._visitedCxtUuids.get(string2);
            if (contextInfo == null) {
                contextInfo = new ContextInfo(this._seqNum, string);
                this._visitedCxtUuids.put(string2.toString(), contextInfo);
                return false;
            }
            this.println(this._seqNum + INDENT_AMOUNT + DumpNameSpace.fmtMsg("revisitedCtx"));
            this.println(this._seqNum + INDENT_AMOUNT + DumpNameSpace.fmtMsg("forCtxInfoSee", new String[]{contextInfo._sequence, contextInfo._contextName}));
            return true;
        }
        String string3 = null;
        try {
            string3 = context.getNameInNamespace();
        }
        catch (Exception exception) {
            this.println(DumpNameSpace.fmtMsg("getNameErr", new String[]{exception.toString()}));
        }
        ContextInfo contextInfo = this._visitedCxtNames.get(string3);
        if (contextInfo == null) {
            contextInfo = new ContextInfo(this._seqNum, string);
            this._visitedCxtNames.put(string3, contextInfo);
            return false;
        }
        this.println(this._seqNum + INDENT_AMOUNT + DumpNameSpace.fmtMsg("revisitedCtx"));
        this.println(this._seqNum + INDENT_AMOUNT + DumpNameSpace.fmtMsg("forCtxInfoSee", new String[]{contextInfo._sequence, contextInfo._contextName}));
        return true;
    }

    private void printBinding(String string, Object object, String string2, String string3, String string4, BindingType bindingType, Reference reference) {
        this._seqNum = this.getNextSeqNum();
        if (this._reportFormat == ReportFormat.SHORT) {
            String string5 = this.getPaddedString(string, 50);
            if (string5.length() <= 50) {
                this.println(this._seqNum + string5 + BLANK_LINE + string2);
            } else {
                this.println(this._seqNum + string5);
                this.println(this._seqNum + this.getPaddedString(BLANK_LINE, 51) + string2);
            }
            if (string3 != null) {
                this.println(this._seqNum + INDENT_AMOUNT + string3);
            }
            if (string4 != null && string4.length() > 0) {
                this.println(this._seqNum + INDENT_AMOUNT + string4);
            }
        } else if (this._reportFormat == ReportFormat.LONG) {
            String string6;
            Object object2;
            String string7 = DumpNameSpace.fmtMsg("null");
            String string8 = "";
            if (object != null) {
                string7 = object.getClass().getName();
                string8 = object.toString();
            }
            this.println(BLANK_LINE);
            this.println(this._seqNum + string);
            if (string3 != null) {
                this.println(this._seqNum + INDENT_AMOUNT + string3);
            }
            if (string4 != null && string4.length() > 0) {
                this.println(this._seqNum + INDENT_AMOUNT + string4);
            }
            this.println(this._seqNum + INDENT_AMOUNT + DumpNameSpace.fmtMsg("boundType", new String[]{string2}));
            this.println(this._seqNum + INDENT_AMOUNT + DumpNameSpace.fmtMsg("localType", new String[]{string7}));
            if (bindingType != null) {
                object2 = null;
                object2 = bindingType == BindingType.ncontext ? "org.omg.CosNaming.BindingType.ncontext" : "org.omg.CosNaming.BindingType.nobject";
                this.println(this._seqNum + INDENT_AMOUNT + DumpNameSpace.fmtMsg("corbaType", new String[]{object2}));
            }
            if (object instanceof UuidContext) {
                object2 = (UuidContext)object;
                string6 = object2.getContextID().toString();
                this.println(this._seqNum + INDENT_AMOUNT + DumpNameSpace.fmtMsg("ctxId", new String[]{string6}));
            }
            this.println(this._seqNum + INDENT_AMOUNT + DumpNameSpace.fmtMsg("objToString", new String[]{string8}));
            if (reference != null) {
                this.println(this._seqNum + INDENT_AMOUNT + DumpNameSpace.fmtMsg("srcObjIsRef"));
                object2 = reference.getFactoryClassName();
                if (object2 != null && ((String)object2).length() > 0) {
                    this.println(this._seqNum + INDENT_AMOUNT + INDENT_AMOUNT + DumpNameSpace.fmtMsg("refFactClass", new String[]{object2}));
                }
                if ((string6 = reference.getFactoryClassLocation()) != null && string6.length() > 0) {
                    this.println(this._seqNum + INDENT_AMOUNT + INDENT_AMOUNT + DumpNameSpace.fmtMsg("refFactLoc", new String[]{string6}));
                }
                Enumeration<RefAddr> enumeration = reference.getAll();
                int n = 0;
                while (enumeration.hasMoreElements()) {
                    RefAddr refAddr = enumeration.nextElement();
                    if (refAddr != null) {
                        this.println(this._seqNum + INDENT_AMOUNT + INDENT_AMOUNT + DumpNameSpace.fmtMsg("refAddrString", new String[]{Integer.toString(n), refAddr.toString()}));
                    } else {
                        this.println(this._seqNum + INDENT_AMOUNT + INDENT_AMOUNT + DumpNameSpace.fmtMsg("refAddrNull", new String[]{Integer.toString(n)}));
                    }
                    ++n;
                }
            }
        }
    }

    private String getNextSeqNum() {
        ++this._seq;
        if (this._seq > 99999L) {
            this._seq = 0L;
        }
        StringBuilder stringBuilder = new StringBuilder(6);
        stringBuilder.insert(0, BLANK_LINE);
        stringBuilder.insert(0, this._seq);
        while (stringBuilder.length() < 6) {
            stringBuilder.insert(0, BLANK_LINE);
        }
        return stringBuilder.toString();
    }

    private String getPaddedString(String string, int n) {
        int n2 = string.length();
        if (n2 >= n) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        stringBuilder.insert(0, string);
        for (int i = n2; i < n; ++i) {
            stringBuilder.insert(i, BLANK_LINE);
        }
        return stringBuilder.toString();
    }

    private void writeException(Exception exception) {
        this.println(DumpNameSpace.fmtMsg("icErr"));
        this.println(DumpNameSpace.fmtMsg("xcptInfo", new String[]{exception.toString()}));
        exception.printStackTrace(this._out);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append('@');
        stringBuilder.append(Integer.toHexString(this.hashCode()));
        stringBuilder.append("[_factory=");
        stringBuilder.append(this._factory);
        stringBuilder.append(", _providerUrl=");
        stringBuilder.append(this._providerUrl);
        stringBuilder.append(", _hostname=");
        stringBuilder.append(this._hostname);
        stringBuilder.append(", _port=");
        stringBuilder.append(this._port);
        stringBuilder.append(", _url=");
        stringBuilder.append(this._url);
        stringBuilder.append(", _principal=");
        stringBuilder.append(this._principal);
        stringBuilder.append(", _credentials=");
        stringBuilder.append(StringUtils.maskPassword((String)this._credentials));
        stringBuilder.append(", _startAt=");
        stringBuilder.append(this._startAt);
        stringBuilder.append(", _rootOpt=");
        stringBuilder.append(this._rootOpt);
        stringBuilder.append(", _root=");
        stringBuilder.append(this._root);
        stringBuilder.append(", _rootMsg=");
        stringBuilder.append(this._rootMsg);
        stringBuilder.append(", _nameSyntax=");
        stringBuilder.append(this._nameSyntax);
        stringBuilder.append(", _reportFormat=");
        stringBuilder.append((Object)this._reportFormat);
        stringBuilder.append(", _topLabel=");
        stringBuilder.append(this._topLabel);
        stringBuilder.append(", _seq=");
        stringBuilder.append(this._seq);
        stringBuilder.append(", _seqNum=");
        stringBuilder.append(this._seqNum);
        stringBuilder.append(", _visitedCxtNames=");
        stringBuilder.append(this._visitedCxtNames);
        stringBuilder.append(", _visitedCxtUuids=");
        stringBuilder.append(this._visitedCxtUuids);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private static String fmtMsg(String string) {
        return DumpNameSpace.fmtMsg(string, null);
    }

    private static String fmtMsg(String string, String[] stringArray) {
        String string2 = null;
        try {
            if (_resourceBundle != null) {
                return MessageFormat.format(_resourceBundle.getString(string), stringArray);
            }
            string2 = "Message table not found.";
        }
        catch (MissingResourceException missingResourceException) {
            string2 = "Message or message table not found.";
        }
        return string2;
    }

    private static void printHelp() {
        System.out.println(BLANK_LINE);
        System.out.println(DumpNameSpace.fmtMsg("sepLine"));
        System.out.println(DumpNameSpace.fmtMsg("cmdLineUsage"));
        System.out.println(DumpNameSpace.fmtMsg("sepLine"));
    }

    private void println(String string) {
        this._out.println(string);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "println", string);
        }
    }

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOURCE CODE INFO: SERV1/ws/code/naming/src/com/ibm/websphere/naming/DumpNameSpace.java, WAS.naming, WAS70.SERV1, q0834.18, ver. 1.57");
        }
        _resourceBundle = null;
        _mode = Mode.NOT_SET;
    }

    private static class ContextInfo {
        final String _contextName;
        final String _sequence;

        ContextInfo(String string, String string2) {
            this._contextName = string2;
            this._sequence = string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Mode {
        NOT_SET,
        WS40,
        WS50;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ReportFormat {
        LONG,
        SHORT;

    }
}

