/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.models.extensions.helpers.impl;

import com.ibm.ejs.models.base.extensions.applicationext.ApplicationExtension;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.websphere.models.base.serialization.PMEXMLResourceImpl;
import com.ibm.websphere.models.extensions.appprofileapplicationext.ApplicationProfileExtension;
import com.ibm.websphere.models.extensions.appprofileapplicationext.AppprofileapplicationextFactory;
import com.ibm.websphere.models.extensions.appprofileapplicationext.AppprofileapplicationextPackage;
import com.ibm.websphere.models.extensions.helpers.PMEApplicationExtensionHelper;
import com.ibm.websphere.models.extensions.helpers.impl.PMEHelperUtils;
import com.ibm.websphere.models.extensions.helpers.impl.ResourceAndExtent;
import com.ibm.websphere.models.extensions.lpsapplicationext.LastParticipantSupportExtension;
import com.ibm.websphere.models.extensions.lpsapplicationext.LpsapplicationextFactory;
import com.ibm.websphere.models.extensions.lpsapplicationext.LpsapplicationextPackage;
import com.ibm.websphere.models.extensions.pmeext.PMEApplicationExtension;
import com.ibm.websphere.models.extensions.pmeext.PmeextFactory;
import com.ibm.websphere.models.extensions.pmeext.PmeextPackage;
import java.io.FileNotFoundException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;

public class PMEApplicationExtensionHelperImpl
implements PMEApplicationExtensionHelper {
    private Resource resource = null;
    private ResourceSet resourceSet = null;
    private Archive ear = null;
    private EList extent = null;
    private ApplicationExtension baseext = null;
    private PMEApplicationExtension pmeApplicationExtension = null;
    private boolean create = true;
    private boolean useXML = false;

    public PMEApplicationExtensionHelperImpl(EARFile ear) {
        this(ear, true);
    }

    public PMEApplicationExtensionHelperImpl(EARFile ear, boolean create) {
        this.ear = ear;
        this.create = create;
        PMEHelperUtils.init();
        String extUri = null;
        boolean needToConvertPMEXMI = false;
        Application deploymentDescriptor = ear.getDeploymentDescriptor();
        if (deploymentDescriptor != null) {
            Resource res = deploymentDescriptor.eResource();
            if (res != null) {
                this.resourceSet = res.getResourceSet();
            }
            if (this.resourceSet != null) {
                this.resourceSet.getLoadOptions().put("Merged Deployment Descriptor", deploymentDescriptor);
            }
            this.useXML = this.shouldUseXMLBindingOrExtension(deploymentDescriptor);
        }
        if (this.useXML) {
            extUri = "META-INF/ibm-application-ext-pme.xml";
            needToConvertPMEXMI = this.needToConvertXMI2XML("META-INF/ibm-application-ext-pme.xmi");
        } else {
            extUri = "META-INF/ibm-application-ext-pme.xmi";
        }
        ResourceAndExtent resAndExt = PMEHelperUtils.getResourceAndExtent(ear, extUri, create || needToConvertPMEXMI);
        this.resource = resAndExt.resource;
        this.extent = resAndExt.extent;
        if (needToConvertPMEXMI) {
            this.convertPMEWebExtensionXMIToXML();
        }
        this.baseext = ear.getExtensions();
        this.init();
    }

    protected boolean shouldUseXMLBindingOrExtension(EObject deploymentDescriptor) {
        Application application = (Application)deploymentDescriptor;
        int version = application.getVersionID();
        return version >= 50;
    }

    protected boolean needToConvertXMI2XML(String xmiUri) {
        boolean XMLExists = false;
        boolean XMIExists = false;
        try {
            this.ear.getMofResource("META-INF/ibm-application-ext-pme.xml");
            XMLExists = true;
        }
        catch (FileNotFoundException ex) {
            // empty catch block
        }
        if (!XMLExists) {
            try {
                this.ear.getMofResource(xmiUri);
                XMIExists = true;
            }
            catch (FileNotFoundException fnf) {
                // empty catch block
            }
        }
        return !XMLExists && XMIExists;
    }

    protected void convertPMEWebExtensionXMIToXML() {
        ResourceAndExtent XMIresAndExt = PMEHelperUtils.getResourceAndExtent(this.ear, "META-INF/ibm-application-ext-pme.xmi", false);
        PMEApplicationExtension ext = (PMEApplicationExtension)XMIresAndExt.resource.getContents().get(0);
        ((PMEXMLResourceImpl)this.resource).setRootChild("pmeAppExt", ext);
    }

    public PMEApplicationExtensionHelperImpl(ResourceSet resourceSet) {
        this(resourceSet, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PMEApplicationExtensionHelperImpl(ResourceSet resourceSet, boolean create) {
        this.create = create;
        PMEHelperUtils.init();
        URI uri = URI.createURI("META-INF/ibm-application-ext-pme.xml");
        this.resource = resourceSet.getResource(uri, true);
        if (this.resource != null) {
            this.pmeApplicationExtension = (PMEApplicationExtension)((PMEXMLResourceImpl)this.resource).getRootChild("pmeAppExt");
        } else {
            ResourceAndExtent resAndExt = PMEHelperUtils.getResourceAndExtent(resourceSet, "META-INF/ibm-application-ext-pme.xmi", create);
            this.resource = resAndExt.resource;
            this.extent = resAndExt.extent;
            ResourceAndExtent baseResAndExt = PMEHelperUtils.getResourceAndExtent(resourceSet, "META-INF/ibm-application-ext.xmi", create);
            if (baseResAndExt.extent != null) {
                if (baseResAndExt.extent.size() == 1) {
                    EObject refobj = (EObject)baseResAndExt.extent.get(0);
                    if (!(refobj instanceof ApplicationExtension)) throw new IllegalStateException("unknown EObject type: " + refobj.getClass().getName());
                    this.baseext = (ApplicationExtension)refobj;
                } else if (baseResAndExt.extent.size() > 1) {
                    throw new IllegalStateException("More than one EObject!");
                }
            }
        }
        this.init();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init() {
        if (this.useXML) {
            if (this.resource != null) {
                this.pmeApplicationExtension = (PMEApplicationExtension)((PMEXMLResourceImpl)this.resource).getRootChild("pmeAppExt");
            }
            this.getPMEApplicationExtension();
            return;
        } else {
            if (this.extent == null) return;
            if (this.extent.size() == 1) {
                EObject refobj = (EObject)this.extent.get(0);
                if (!(refobj instanceof PMEApplicationExtension)) throw new IllegalStateException("unknown EObject type: " + refobj.getClass().getName());
                this.pmeApplicationExtension = (PMEApplicationExtension)refobj;
                return;
            } else {
                if (this.extent.size() > 1) {
                    throw new IllegalStateException("More than one EObject!");
                }
                this.getPMEApplicationExtension();
            }
        }
    }

    public PMEApplicationExtension getPMEApplicationExtension() {
        if (this.pmeApplicationExtension == null && this.create) {
            PmeextFactory f = PmeextPackage.eINSTANCE.getPmeextFactory();
            this.setPMEApplicationExtension(f.createPMEApplicationExtension());
        }
        return this.pmeApplicationExtension;
    }

    public void setPMEApplicationExtension(PMEApplicationExtension ext) {
        this.pmeApplicationExtension = ext;
        if (this.useXML) {
            if (this.resource != null) {
                ((PMEXMLResourceImpl)this.resource).setRootChild("pmeAppExt", this.pmeApplicationExtension);
            }
        } else if (this.extent != null) {
            if (this.extent.size() > 0) {
                this.extent.set(0, this.pmeApplicationExtension);
            } else {
                this.extent.add(this.pmeApplicationExtension);
            }
        }
    }

    public ApplicationProfileExtension getApplicationProfileExtension() {
        PMEApplicationExtension pmeExt = this.getPMEApplicationExtension();
        ApplicationProfileExtension ext = null;
        if (pmeExt != null && (ext = pmeExt.getApplicationProfileExtension()) == null && this.create) {
            AppprofileapplicationextFactory f = AppprofileapplicationextPackage.eINSTANCE.getAppprofileapplicationextFactory();
            ext = f.createApplicationProfileExtension();
            ext.setApplicationExtension(this.baseext);
            this.setApplicationProfileExtension(ext);
        }
        return ext;
    }

    public void setApplicationProfileExtension(ApplicationProfileExtension ext) {
        PMEApplicationExtension pmeExt = this.getPMEApplicationExtension();
        if (pmeExt != null) {
            ApplicationProfileExtension oldext = pmeExt.getApplicationProfileExtension();
            if (oldext != null) {
                // empty if block
            }
            pmeExt.setApplicationProfileExtension(ext);
        }
    }

    public LastParticipantSupportExtension getLastParticipantSupportExtension() {
        PMEApplicationExtension pmeExt = this.getPMEApplicationExtension();
        LastParticipantSupportExtension ext = null;
        if (pmeExt != null && (ext = this.getPMEApplicationExtension().getLastParticipantSupportExtension()) == null && this.create) {
            LpsapplicationextFactory f = LpsapplicationextPackage.eINSTANCE.getLpsapplicationextFactory();
            ext = f.createLastParticipantSupportExtension();
            ext.setApplicationExtension(this.baseext);
            this.setLastParticipantSupportExtension(ext);
        }
        return ext;
    }

    public void setLastParticipantSupportExtension(LastParticipantSupportExtension ext) {
        PMEApplicationExtension pmeExt = this.getPMEApplicationExtension();
        if (pmeExt != null) {
            LastParticipantSupportExtension oldext = pmeExt.getLastParticipantSupportExtension();
            if (oldext != null) {
                // empty if block
            }
            this.pmeApplicationExtension.setLastParticipantSupportExtension(ext);
        }
    }

    public void releaseResources() {
        this.extent = null;
        this.resource = null;
    }
}

