/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.models.config.ipc.ssl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.AbstractEnumerator;

public final class SSLSecurityLevel
extends AbstractEnumerator {
    public static final int HIGH = 0;
    public static final int MEDIUM = 1;
    public static final int LOW = 2;
    public static final int CUSTOM = 3;
    public static final SSLSecurityLevel HIGH_LITERAL = new SSLSecurityLevel(0, "HIGH", "HIGH");
    public static final SSLSecurityLevel MEDIUM_LITERAL = new SSLSecurityLevel(1, "MEDIUM", "MEDIUM");
    public static final SSLSecurityLevel LOW_LITERAL = new SSLSecurityLevel(2, "LOW", "LOW");
    public static final SSLSecurityLevel CUSTOM_LITERAL = new SSLSecurityLevel(3, "CUSTOM", "CUSTOM");
    private static final SSLSecurityLevel[] VALUES_ARRAY = new SSLSecurityLevel[]{HIGH_LITERAL, MEDIUM_LITERAL, LOW_LITERAL, CUSTOM_LITERAL};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

    public static SSLSecurityLevel get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            SSLSecurityLevel result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static SSLSecurityLevel getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            SSLSecurityLevel result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static SSLSecurityLevel get(int value) {
        switch (value) {
            case 0: {
                return HIGH_LITERAL;
            }
            case 1: {
                return MEDIUM_LITERAL;
            }
            case 2: {
                return LOW_LITERAL;
            }
            case 3: {
                return CUSTOM_LITERAL;
            }
        }
        return null;
    }

    private SSLSecurityLevel(int value, String name, String literal) {
        super(value, name, literal);
    }
}

