/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.models.config.init;

import com.ibm.websphere.models.config.init.ConfigInitDebug;
import com.ibm.websphere.models.config.proxy.impl.ProxyPackageImpl;
import java.util.Map;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;

public class ProxyServerInit {
    protected static boolean initialized;
    protected static boolean plugin_initialized;

    public static boolean getInitialized() {
        return initialized;
    }

    public static void init() {
        ProxyServerInit.defaultInit();
    }

    public static void defaultInit() {
        ProxyServerInit.debug("Model initialization ...");
        ProxyServerInit.dumpStack("Model initialization ...");
        if (initialized) {
            ProxyServerInit.debug("Model initialization ... already complete");
            return;
        }
        ProxyPackageImpl.init();
        initialized = true;
        ProxyServerInit.debug("Model initialization ... complete");
    }

    protected static void setDefaultResourceFactory() {
        ProxyServerInit.debug("Setting default resource factory ...");
        ProxyServerInit.dumpStack("Setting default resource factory ...");
        Map extensionToFactoryMap = Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap();
        String defaultExtension = "*";
        Resource.Factory resourceFactory = (Resource.Factory)extensionToFactoryMap.get(defaultExtension);
        if (resourceFactory == null) {
            ProxyServerInit.debug("No factory on extension [ " + defaultExtension + " ]");
            resourceFactory = new XMIResourceFactoryImpl();
            ProxyServerInit.debug("Setting resource factory to [ " + resourceFactory + " ]");
            extensionToFactoryMap.put(defaultExtension, resourceFactory);
        } else {
            ProxyServerInit.debug("Detected factory on extension [ " + defaultExtension + " ]");
            ProxyServerInit.debug("Already set factory [ " + resourceFactory + " ]");
        }
        ProxyServerInit.debug("Setting default resource factory ... complete");
    }

    public static void debug(String text) {
        ConfigInitDebug.debug(ProxyServerInit.class.getName(), text);
    }

    public static void dumpStack(String text) {
        ConfigInitDebug.dumpStack(ProxyServerInit.class.getName(), text);
    }

    static {
        ProxyServerInit.debug("Class Initialization");
        initialized = false;
        plugin_initialized = false;
    }
}

