/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.metadata;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.MetadataNotAvailableException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessor;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;

public class ManagedObjectMetadataHelper {
    private static final String BASE_PROD_ID = "base";
    private static final String PROD_VER_PREFIX = "com.ibm.websphere.";
    private static final String PROD_VER_SUFFIX = "ProductVersion";
    public static final String BASE_WAS_PRODUCT_VERSION = "com.ibm.websphere.baseProductVersion";
    private static final String PROD_SHORT_NAME_PREFIX = "com.ibm.websphere.";
    private static final String PROD_SHORT_NAME_SUFFIX = "ProductShortName";
    public static final String BASE_WAS_PRODUCT_SHORT_NAME = "com.ibm.websphere.baseProductShortName";
    private static final String APP_ACTIVATION_PLANS_PREFIX = "com.ibm.websphere.";
    private static final String APP_ACTIVATION_PLANS_SUFFIX = "RuntimeComponents";
    public static final String BASE_WAS_APP_ACTIVATION_PLANS = "com.ibm.websphere.baseRuntimeComponents";
    public static final String NODE_OS = "com.ibm.websphere.nodeOperatingSystem";
    public static final String NODE_OS_AS400 = "os400";
    public static final String NODE_OS_AIX = "aix";
    public static final String NODE_OS_HPUX = "hpux";
    public static final String NODE_OS_LINUX = "linux";
    public static final String NODE_OS_SOLARIS = "solaris";
    public static final String NODE_OS_WINDOWS = "windows";
    public static final String NODE_OS_ZOS = "os390";
    public static final String NODE_SYSPLEX_NAME = "com.ibm.websphere.nodeSysplexName";
    public static final String NODE_DEPLOYED_FEATURES = "com.ibm.websphere.deployed.features";
    private static TraceComponent _tc = Tr.register(ManagedObjectMetadataHelper.class, "Admin", null);
    private static final char FEATURE_DELIMITER = ',';
    private static final char RUNTIME_COMPONENT_DELIMITER = ';';
    private static final String ND_SHORT_NAME = "ND";
    private ManagedObjectMetadataAccessor _metadataAccessor = null;

    public ManagedObjectMetadataHelper(ManagedObjectMetadataAccessor managedObjectMetadataAccessor) throws AdminException {
        if (managedObjectMetadataAccessor == null) {
            throw new AdminException("Invalid parameter: null ManagedObjectMetadataAccessor.");
        }
        this._metadataAccessor = managedObjectMetadataAccessor;
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "ManagedObjectMetadataHelper", "accessor=" + this._metadataAccessor.toString());
        }
    }

    public ManagedObjectMetadataAccessor getAccessor() throws AdminException {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "getAccessor", "accessor=" + this._metadataAccessor.toString());
        }
        return this._metadataAccessor;
    }

    public String getNodeMajorVersion(String string) throws AdminException {
        Properties properties;
        String string2;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getNodeMajorVersion", new Object[]{"nodeName=" + string, "accessor=" + this._metadataAccessor.toString()});
        }
        if ((string2 = (properties = this._metadataAccessor.getMetadataProperties(string)).getProperty(BASE_WAS_PRODUCT_VERSION)) == null) {
            throw new MetadataNotAvailableException("Version for node \"" + string + "\" is not available.");
        }
        String string3 = null;
        if (string2 != null) {
            int n = string2.indexOf(46);
            string3 = n == -1 ? string2 : string2.substring(0, n);
        }
        if (string3 == null || string3.length() == 0) {
            throw new MetadataNotAvailableException("Major version for node \"" + string + "\" is not available.");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getNodeMajorVersion", "majorVersion=" + string3);
        }
        return string3;
    }

    public String getNodeMinorVersion(String string) throws AdminException {
        int n;
        Properties properties;
        String string2;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getNodeMinorVersion", new Object[]{"nodeName=" + string, "accessor=" + this._metadataAccessor.toString()});
        }
        if ((string2 = (properties = this._metadataAccessor.getMetadataProperties(string)).getProperty(BASE_WAS_PRODUCT_VERSION)) == null) {
            throw new MetadataNotAvailableException("Version for node \"" + string + "\" is not available.");
        }
        String string3 = null;
        if (string2 != null && (n = string2.indexOf(46)) != -1) {
            int n2 = string2.indexOf(46, n + 1);
            string3 = n2 == -1 ? string2.substring(n + 1) : string2.substring(n + 1, n2);
        }
        if (string3 == null || string3.length() == 0) {
            throw new MetadataNotAvailableException("Minor version for node \"" + string + "\" is not available.");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getNodeMinorVersion", "minorVersion=" + string3);
        }
        return string3;
    }

    public String getNodeUpdateVersion(String string) throws AdminException {
        Properties properties;
        String string2;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getNodeUpdateVersion", new Object[]{"nodeName=" + string, "accessor=" + this._metadataAccessor.toString()});
        }
        if ((string2 = (properties = this._metadataAccessor.getMetadataProperties(string)).getProperty(BASE_WAS_PRODUCT_VERSION)) == null) {
            throw new MetadataNotAvailableException("Version for node \"" + string + "\" is not available.");
        }
        String string3 = null;
        if (string2 != null) {
            int n = string2.indexOf(46);
            if (n != -1) {
                n = string2.indexOf(46, n + 1);
            }
            if (n != -1) {
                int n2 = string2.indexOf(46, n + 1);
                string3 = n2 == -1 ? string2.substring(n + 1) : string2.substring(n + 1, n2);
            }
        }
        if (string3 == null || string3.length() == 0) {
            throw new MetadataNotAvailableException("Update version for node \"" + string + "\" is not available.");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getNodeUpdateVersion", "updateVersion=" + string3);
        }
        return string3;
    }

    public String getNodeServiceVersion(String string) throws AdminException {
        Properties properties;
        String string2;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getNodeServiceVersion", new Object[]{"nodeName=" + string, "accessor=" + this._metadataAccessor.toString()});
        }
        if ((string2 = (properties = this._metadataAccessor.getMetadataProperties(string)).getProperty(BASE_WAS_PRODUCT_VERSION)) == null) {
            throw new MetadataNotAvailableException("Version for node \"" + string + "\" is not available.");
        }
        String string3 = null;
        if (string2 != null) {
            int n = string2.indexOf(46);
            if (n != -1) {
                n = string2.indexOf(46, n + 1);
            }
            if (n != -1) {
                n = string2.indexOf(46, n + 1);
            }
            if (n != -1) {
                int n2 = string2.indexOf(46, n + 1);
                string3 = n2 == -1 ? string2.substring(n + 1) : string2.substring(n + 1, n2);
            }
        }
        if (string3 == null || string3.length() == 0) {
            throw new MetadataNotAvailableException("Service version for node \"" + string + "\" is not available.");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getNodeServiceVersion", "serviceVersion=" + string3);
        }
        return string3;
    }

    public String getNodeBaseProductVersion(String string) throws AdminException {
        Properties properties;
        String string2;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getNodeBaseProductVersion", new Object[]{"nodeName=" + string, "accessor=" + this._metadataAccessor.toString()});
        }
        if ((string2 = (properties = this._metadataAccessor.getMetadataProperties(string)).getProperty(BASE_WAS_PRODUCT_VERSION)) == null) {
            throw new MetadataNotAvailableException("Base product version for node \"" + string + "\" is not available.");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getNodeBaseProductVersion", "baseProdVersion=" + string2);
        }
        return string2;
    }

    public String getNodeBaseProductShortName(String string) throws AdminException {
        Properties properties;
        String string2;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getNodeBaseProductShortName", new Object[]{"nodeName=" + string, "accessor=" + this._metadataAccessor.toString()});
        }
        if ((string2 = (properties = this._metadataAccessor.getMetadataProperties(string)).getProperty(BASE_WAS_PRODUCT_SHORT_NAME)) == null) {
            string2 = ND_SHORT_NAME;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getNodeBaseProductShortName", "baseProdShortName=" + string2);
        }
        return string2;
    }

    public int compareNodeVersion(String string, String string2) throws AdminException {
        Properties properties;
        String string3;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "compareNodeVersion", new Object[]{"nodeName=" + string, "version=" + string2, "accessor=" + this._metadataAccessor.toString()});
        }
        if ((string3 = (properties = this._metadataAccessor.getMetadataProperties(string)).getProperty(BASE_WAS_PRODUCT_VERSION)) == null) {
            throw new MetadataNotAvailableException("Base product version info for node \"" + string + "\" is not available.");
        }
        int n = 0;
        try {
            VersionParser versionParser = new VersionParser(string2);
            VersionParser versionParser2 = new VersionParser(string3);
            while (versionParser.hasMoreComponents() && n == 0) {
                int n2 = versionParser.nextComponent();
                if (versionParser2.hasMoreComponents()) {
                    int n3 = versionParser2.nextComponent();
                    if (n3 < n2) {
                        n = -1;
                        continue;
                    }
                    if (n3 <= n2) continue;
                    n = 1;
                    continue;
                }
                throw new AdminException("Specified version contains more components than available version info.");
            }
        }
        catch (AdminException adminException) {
            throw adminException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new AdminException(illegalArgumentException, "Invalid input.  See nested exception for more information.");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "compareNodeVersion", "comparison=" + n);
        }
        return n;
    }

    public boolean isNodeZOS(String string) throws AdminException {
        boolean bl;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "isNodeZOS", new Object[]{"nodeName=" + string, "accessor=" + this._metadataAccessor.toString()});
        }
        Properties properties = this._metadataAccessor.getMetadataProperties(string);
        String string2 = properties.getProperty(NODE_OS);
        String string3 = null;
        try {
            string3 = this.getNodeMajorVersion(string);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (string2 != null) {
            bl = string2.equals(NODE_OS_ZOS);
        } else if (string3 != null && string3.equals("5")) {
            bl = false;
        } else {
            throw new MetadataNotAvailableException("OS for node \"" + string + "\" is not available.");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "isNodeZOS", "nodeIsZOS=" + bl);
        }
        return bl;
    }

    public String getNodePlatformOS(String string) throws AdminException {
        Properties properties;
        String string2;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getNodePlatformOS", new Object[]{"nodeName=" + string, "accessor=" + this._metadataAccessor.toString()});
        }
        if ((string2 = (properties = this._metadataAccessor.getMetadataProperties(string)).getProperty(NODE_OS)) == null) {
            throw new MetadataNotAvailableException("OS for node \"" + string + "\" is not available.");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getNodePlatformOS", "nodeOS=" + string2);
        }
        return string2;
    }

    public String getNodeSysplexName(String string) throws AdminException {
        Properties properties;
        String string2;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getNodeSysplexName", new Object[]{"nodeName=" + string, "accessor=" + this._metadataAccessor.toString()});
        }
        if ((string2 = (properties = this._metadataAccessor.getMetadataProperties(string)).getProperty(NODE_SYSPLEX_NAME)) == null) {
            throw new MetadataNotAvailableException("Sysplex for node \"" + string + "\" is not available.");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getNodeSysplexName", "nodeSysplex=" + string2);
        }
        return string2;
    }

    public SortedMap getNodeProductVersions(String string) throws AdminException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getNodeProductVersions", new Object[]{"nodeName=" + string, "accessor=" + this._metadataAccessor.toString()});
        }
        Properties properties = this._metadataAccessor.getMetadataProperties(string);
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String string2;
            String string3 = (String)entry.getKey();
            if (!string3.endsWith(PROD_VER_SUFFIX) || !string3.startsWith("com.ibm.websphere.") || (string2 = string3.substring("com.ibm.websphere.".length(), string3.length() - PROD_VER_SUFFIX.length())) == null || string2.length() <= 0) continue;
            String string4 = properties.getProperty("com.ibm.websphere." + string2 + PROD_SHORT_NAME_SUFFIX);
            if (string4 != null && string4.length() > 0) {
                treeMap.put(string4, entry.getValue());
                continue;
            }
            if (!string2.equals(BASE_PROD_ID)) continue;
            treeMap.put(ND_SHORT_NAME, entry.getValue());
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getNodeProductVersions", "prodVersions=" + treeMap);
        }
        return treeMap;
    }

    public ArrayList getNodeDeployedFeatures(String string) throws AdminException {
        int n;
        Properties properties;
        String string2;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getNodeDeployedFeatures", new Object[]{"nodeName=" + string, "accessor=" + this._metadataAccessor.toString()});
        }
        if ((string2 = (properties = this._metadataAccessor.getMetadataProperties(string)).getProperty(NODE_DEPLOYED_FEATURES)) == null) {
            throw new MetadataNotAvailableException("List of deployed features for node \"" + string + "\" is not available.");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        do {
            String string3;
            if ((n = string2.indexOf(44, n2)) == -1) {
                string3 = string2.substring(n2).trim();
            } else {
                string3 = string2.substring(n2, n).trim();
                n2 = n + 1;
            }
            if (string3 == null || string3.length() == 0) continue;
            arrayList.add(string3);
        } while (n != -1);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getNodeDeployedFeatures", "featuresList=" + arrayList);
        }
        return arrayList;
    }

    public Properties getNodeProductsAndVersions(String string) throws AdminException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getNodeProductsAndVersions, node name = " + string);
        }
        Properties properties = null;
        Properties properties2 = this._metadataAccessor.getMetadataProperties(string);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "nodeProperties = " + properties2);
        }
        if (properties2 != null) {
            properties = new Properties();
            Enumeration<?> enumeration = properties2.propertyNames();
            String string2 = null;
            String string3 = null;
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                string3 = properties2.getProperty(string2);
                int n = string2.indexOf(PROD_VER_SUFFIX);
                if (n == -1) continue;
                int n2 = string2.lastIndexOf(46);
                String string4 = string2.substring(n2 + 1, n);
                properties.put(string4, string3);
            }
        } else {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getNodeProductsAndVersions, node name = " + string);
            }
            throw new AdminException("No metadata properties for node " + string);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getNodeProductsAndVersions, node name = " + string);
        }
        return properties;
    }

    public ArrayList listRuntimeComponents(String string) throws AdminException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "listRuntimeComponents", new Object[]{"nodeName=" + string, "accessor=" + this._metadataAccessor.toString()});
        }
        Properties properties = this._metadataAccessor.getMetadataProperties(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : properties.keySet()) {
            int n;
            String string3;
            if (!string2.endsWith(APP_ACTIVATION_PLANS_SUFFIX) || !string2.startsWith("com.ibm.websphere.") || (string3 = string2.substring("com.ibm.websphere.".length(), string2.length() - APP_ACTIVATION_PLANS_SUFFIX.length())) == null || string3.length() <= 0) continue;
            String string4 = properties.getProperty("com.ibm.websphere." + string3 + APP_ACTIVATION_PLANS_SUFFIX);
            Tr.debug(_tc, "rtComponents for com.ibm.websphere." + string3 + APP_ACTIVATION_PLANS_SUFFIX + "is: " + string4);
            if (string4 == null || string4.length() <= 0) continue;
            int n2 = 0;
            do {
                String string5;
                if ((n = string4.indexOf(59, n2)) == -1) {
                    string5 = string4.substring(n2).trim();
                } else {
                    string5 = string4.substring(n2, n).trim();
                    n2 = n + 1;
                }
                if (string5 == null || string5.length() == 0) continue;
                arrayList.add(string5);
            } while (n != -1);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "listRuntimeComponents", "=" + arrayList);
        }
        return arrayList;
    }

    private class VersionParser {
        String _inputString;
        int _inputStringLength;
        int _currIndex;
        private static final char VERSION_DELIMITER = '.';

        public VersionParser(String string) throws IllegalArgumentException {
            if (string == null || string.length() == 0) {
                throw new IllegalArgumentException("Invalid version: Null or empty version number.");
            }
            this._inputString = string;
            this._inputStringLength = string.length();
            this._currIndex = 0;
        }

        public boolean hasMoreComponents() {
            return this._currIndex < this._inputStringLength;
        }

        public int nextComponent() throws IllegalArgumentException, NoSuchElementException {
            String string;
            int n;
            if (this._currIndex < this._inputStringLength) {
                n = this._inputString.indexOf(46, this._currIndex);
                if (n != -1) {
                    string = this._inputString.substring(this._currIndex, n);
                    this._currIndex = n + 1;
                } else {
                    string = this._inputString.substring(this._currIndex);
                    this._currIndex = this._inputStringLength;
                }
            } else {
                throw new NoSuchElementException();
            }
            if (string.length() == 0) {
                throw new IllegalArgumentException("Invalid version: Empty component in version number.");
            }
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("ERROR: Component in version is not a number.");
            }
            return n;
        }
    }
}

