/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.metadata;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessor;
import com.ibm.websphere.management.repository.client.ConfigRepositoryClientFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ManagedObjectMetadataAccessorFactory {
    private static TraceComponent _tc = Tr.register(ManagedObjectMetadataAccessorFactory.class, "Admin", null);
    private static final String DEFAULT_ACCESSOR_IMPL_CLASS_NAME = "com.ibm.ws.management.metadata.ManagedObjectMetadataAccessorImpl";
    private static final String WORKSPACE_ACCESSOR_PROP = "CONFIG_SESSION";
    private static final String WORKSPACE_ACCESSOR_FACTORY_CLASS_NAME = "com.ibm.ws.sm.workspace.impl.WorkspaceMetadataAccessor";
    private static HashMap _accessorCache = new HashMap();

    public static ManagedObjectMetadataAccessor createAccessor(Properties properties) throws AdminException {
        String[] stringArray;
        ManagedObjectMetadataAccessor managedObjectMetadataAccessor;
        Map<Object, Object> map;
        Object object;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "createAccessor", "Input props: " + properties);
        }
        IllegalArgumentException illegalArgumentException = null;
        String string = (properties = properties == null ? new Properties() : (Properties)properties.clone()).getProperty(WORKSPACE_ACCESSOR_PROP);
        if (string != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "configSession", string);
            }
            try {
                Class<?> clazz = Class.forName(WORKSPACE_ACCESSOR_FACTORY_CLASS_NAME);
                Method method = clazz.getMethod("createAccessor", String.class);
                ManagedObjectMetadataAccessor managedObjectMetadataAccessor2 = (ManagedObjectMetadataAccessor)method.invoke(null, string);
                if (_tc.isEntryEnabled()) {
                    Tr.debug(_tc, "createAccessor", managedObjectMetadataAccessor2);
                }
                return managedObjectMetadataAccessor2;
            }
            catch (Exception exception) {
                throw new AdminException(exception, "Encountered an error while attempting to create a ManagedObjectMetadataAccessor instance.");
            }
        }
        AdminService adminService = AdminServiceFactory.getAdminService();
        String string2 = properties.getProperty("was.repository.root");
        if (string2 == null || string2.length() == 0) {
            string2 = System.getProperty("was.repository.root");
            if (string2 == null || string2.length() == 0) {
                if (adminService == null) {
                    illegalArgumentException = new IllegalArgumentException("The property \"was.repository.root\" setting does not exist in the set of input properties or system properties or has a zero-length value.");
                }
            } else {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "createAccessor: Using repository root from sys props: " + string2);
                }
                properties.setProperty("was.repository.root", string2);
            }
        }
        if (string2 != null && (string2.endsWith("/") || string2.endsWith("\\"))) {
            string2 = string2.substring(0, string2.length() - 1);
            properties.setProperty("was.repository.root", string2);
        }
        String string3 = string2;
        string2 = properties.getProperty("local.cell");
        if (illegalArgumentException == null && (string2 == null || string2.length() == 0)) {
            string2 = System.getProperty("local.cell");
            if (string2 == null || string2.length() == 0) {
                if (adminService != null) {
                    string2 = adminService.getCellName();
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "createAccessor: Using cell name from AdminService.");
                    }
                } else {
                    object = null;
                    try {
                        map = new Properties();
                        ((Properties)map).setProperty("location", "local");
                        ((Properties)map).setProperty("was.repository.root", string3);
                        managedObjectMetadataAccessor = ConfigRepositoryClientFactory.getConfigRepositoryClient(map);
                        stringArray = managedObjectMetadataAccessor.listResourceNames("cells", 2, 1);
                        if (stringArray.length == 1) {
                            string2 = stringArray[0].substring(6);
                            Tr.debug(_tc, "createAccessor: Using cell name from repository.");
                        } else {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "ManagedObjectMetadataAccessorImpl", "Mult cells in repo");
                            }
                            object = "Property \"local.cell\" not defined or has a zero-length value, and could not uniquely determine the cell name because more than one cell name was found in the configuration repository.";
                        }
                    }
                    catch (AdminException adminException) {
                        if (_tc.isEventEnabled()) {
                            Tr.event(_tc, "Could not get ConfigRepository reference.", adminException);
                        }
                        object = "Property \"local.cell\" not defined or has a zero-length value, and could not access configuration repository to determine the cell name.";
                    }
                    if (object != null) {
                        illegalArgumentException = new IllegalArgumentException((String)object);
                    }
                }
            } else if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "createAccessor: Using cell name system environment.");
            }
            if (string2 != null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "createAccessor: cellName=" + string2);
                }
                properties.setProperty("local.cell", string2);
            }
        }
        if (illegalArgumentException != null) {
            throw new AdminException(illegalArgumentException, "Invalid input.  See nested exception for more information.");
        }
        object = new AccessorCacheKey(properties.getProperty("was.repository.root"), properties.getProperty("local.cell"));
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Accessor cache key: " + object);
        }
        map = _accessorCache;
        synchronized (map) {
            managedObjectMetadataAccessor = (ManagedObjectMetadataAccessor)_accessorCache.get(object);
            if (managedObjectMetadataAccessor != null) {
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "createAccessor: Returning cached accessor.");
                }
                return managedObjectMetadataAccessor;
            }
            try {
                stringArray = Class.forName(DEFAULT_ACCESSOR_IMPL_CLASS_NAME);
                Constructor constructor = stringArray.getConstructor(Properties.class);
                managedObjectMetadataAccessor = (ManagedObjectMetadataAccessor)constructor.newInstance(properties);
                _accessorCache.put(object, managedObjectMetadataAccessor);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "createAccessor");
                }
                return managedObjectMetadataAccessor;
            }
            catch (Exception exception) {
                throw new AdminException(exception, "Encountered an error while attempting to create a ManagedObjectMetadataAccessor instance.");
            }
        }
    }

    private static class AccessorCacheKey {
        private static String SERVER_PROC = "///THIS_SERVER_REPO///";
        private String _repoRoot;
        private String _cellName;

        public AccessorCacheKey(String string, String string2) {
            this._repoRoot = string != null ? string : SERVER_PROC;
            this._cellName = string2;
        }

        public boolean equals(Object object) {
            if (object instanceof AccessorCacheKey) {
                AccessorCacheKey accessorCacheKey = (AccessorCacheKey)object;
                return this._repoRoot.equals(accessorCacheKey._repoRoot) && this._cellName.equals(accessorCacheKey._cellName);
            }
            return super.equals(object);
        }

        public int hashCode() {
            return 31 * this._repoRoot.hashCode() + this._cellName.hashCode();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(64);
            stringBuffer.append(this._repoRoot);
            stringBuffer.append(":");
            stringBuffer.append(this._cellName);
            return stringBuffer.toString();
        }
    }
}

