/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.configservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.configservice.ValidationResult;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;

public class ConfigServiceProxy
implements ConfigService {
    private static TraceComponent tc = Tr.register(ConfigServiceProxy.class, "management", "com.ibm.ws.management.resources.configservice");
    private AdminClient client;
    private ObjectName configServiceMBean;

    public ConfigServiceProxy(AdminClient adminClient) throws InstanceNotFoundException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ConfigServiceProxy", adminClient);
        }
        this.client = adminClient;
        ObjectName objectName = null;
        ObjectName objectName2 = this.client.getServerMBean();
        if (objectName2 == null) {
            throw new InstanceNotFoundException(objectName.getCanonicalName());
        }
        String string = objectName2.getKeyProperty("process");
        String string2 = "WebSphere:type=ConfigService,process=" + string + ",*";
        try {
            objectName = new ObjectName(string2);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            Manager.Ffdc.log((Throwable)malformedObjectNameException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.ConfigServiceProxy", "39", new Object[]{this});
            Tr.error(tc, "ADMG0011E", malformedObjectNameException);
        }
        Set set = this.client.queryNames(objectName, null);
        if (set.size() == 0) {
            throw new InstanceNotFoundException(objectName.getCanonicalName());
        }
        this.configServiceMBean = (ObjectName)set.iterator().next();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ConfigServiceProxy", this.configServiceMBean);
        }
    }

    public AdminClient getAdminClient() {
        return this.client;
    }

    public void setProperties(Session session, HashMap hashMap) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setProperties", new Object[]{session, hashMap});
        }
        try {
            this.client.invoke(this.configServiceMBean, "setProperties", new Object[]{session, hashMap}, new String[]{"com.ibm.websphere.management.Session", "java.util.HashMap"});
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            Manager.Ffdc.log((Throwable)instanceNotFoundException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.setProperties", "58", new Object[]{this});
            Tr.error(tc, "ADMG0011E", instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            Manager.Ffdc.log((Throwable)reflectionException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.setProperties", "61", new Object[]{this});
            Tr.error(tc, "ADMG0011E", reflectionException);
        }
        catch (MBeanException mBeanException) {
            Manager.Ffdc.log((Throwable)mBeanException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.setProperties", "64", new Object[]{this});
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)exception;
            }
            throw new ConfigServiceException(exception);
        }
        catch (Exception exception) {
            Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.setAttributes", "400", new Object[]{this});
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setProperties");
        }
    }

    public ValidationResult validate(Session session, ObjectName objectName) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate", new Object[]{session, objectName});
        }
        ValidationResult validationResult = null;
        try {
            validationResult = (ValidationResult)this.client.invoke(this.configServiceMBean, "validate", new Object[]{session, objectName}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName"});
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            Manager.Ffdc.log((Throwable)instanceNotFoundException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.validate", "87", new Object[]{this});
            Tr.error(tc, "ADMG0011E", instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            Manager.Ffdc.log((Throwable)reflectionException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.validate", "90", new Object[]{this});
            Tr.error(tc, "ADMG0011E", reflectionException);
        }
        catch (MBeanException mBeanException) {
            Manager.Ffdc.log((Throwable)mBeanException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.validate", "93", new Object[]{this});
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)exception;
            }
            throw new ConfigServiceException(exception);
        }
        catch (Exception exception) {
            Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.validate", "101", new Object[]{this});
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate", validationResult);
        }
        return validationResult;
    }

    public void save(Session session, boolean bl) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "save", new Object[]{session, new Boolean(bl)});
        }
        try {
            this.client.invoke(this.configServiceMBean, "save", new Object[]{session, new Boolean(bl)}, new String[]{"com.ibm.websphere.management.Session", "boolean"});
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            Manager.Ffdc.log((Throwable)instanceNotFoundException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.save", "55", new Object[]{this});
            Tr.error(tc, "ADMG0011E", instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            Manager.Ffdc.log((Throwable)reflectionException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.save", "58", new Object[]{this});
            Tr.error(tc, "ADMG0011E", reflectionException);
        }
        catch (MBeanException mBeanException) {
            Manager.Ffdc.log((Throwable)mBeanException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.save", "61", new Object[]{this});
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)exception;
            }
            throw new ConfigServiceException(exception);
        }
        catch (Exception exception) {
            Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.save", "69", new Object[]{this});
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "save", session);
        }
    }

    public void discard(Session session) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "discard", session);
        }
        try {
            this.client.invoke(this.configServiceMBean, "discard", new Object[]{session}, new String[]{"com.ibm.websphere.management.Session"});
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            Manager.Ffdc.log((Throwable)instanceNotFoundException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.discard", "80", new Object[]{this});
            Tr.error(tc, "ADMG0011E", instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            Manager.Ffdc.log((Throwable)reflectionException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.discard", "83", new Object[]{this});
            Tr.error(tc, "ADMG0011E", reflectionException);
        }
        catch (MBeanException mBeanException) {
            Manager.Ffdc.log((Throwable)mBeanException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.discard", "86", new Object[]{this});
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)exception;
            }
            throw new ConfigServiceException(exception);
        }
        catch (Exception exception) {
            Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.discard", "94", new Object[]{this});
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "discard", session);
        }
    }

    public String[] getUnsavedChanges(Session session) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUnsavedChanges", session);
        }
        String[] stringArray = null;
        try {
            stringArray = (String[])this.client.invoke(this.configServiceMBean, "getUnsavedChanges", new Object[]{session}, new String[]{"com.ibm.websphere.management.Session"});
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            Manager.Ffdc.log((Throwable)instanceNotFoundException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getUnsavedChanges", "106", new Object[]{this});
            Tr.error(tc, "ADMG0011E", instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            Manager.Ffdc.log((Throwable)reflectionException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getUnsavedChanges", "109", new Object[]{this});
            Tr.error(tc, "ADMG0011E", reflectionException);
        }
        catch (MBeanException mBeanException) {
            Manager.Ffdc.log((Throwable)mBeanException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getUnsavedChanges", "112", new Object[]{this});
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)exception;
            }
            throw new ConfigServiceException(exception);
        }
        catch (Exception exception) {
            Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getUnsavedChanges", "120", new Object[]{this});
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUnsavedChanges", stringArray);
        }
        return stringArray;
    }

    public Map getConflictDocuments(Session session) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConflictDocuments", session);
        }
        Map map = null;
        try {
            map = (Map)this.client.invoke(this.configServiceMBean, "getConflictDocuments", new Object[]{session}, new String[]{"com.ibm.websphere.management.Session"});
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            Manager.Ffdc.log((Throwable)instanceNotFoundException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getConflictDocuments", "133", new Object[]{this});
            Tr.error(tc, "ADMG0011E", instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            Manager.Ffdc.log((Throwable)reflectionException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getConflictDocuments", "136", new Object[]{this});
            Tr.error(tc, "ADMG0011E", reflectionException);
        }
        catch (MBeanException mBeanException) {
            Manager.Ffdc.log((Throwable)mBeanException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getConflictDocuments", "139", new Object[]{this});
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)exception;
            }
            throw new ConfigServiceException(exception);
        }
        catch (Exception exception) {
            Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getConflictDocuments", "147", new Object[]{this});
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConflictDocuments", map);
        }
        return map;
    }

    public String[] getSupportedConfigObjectTypes() throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSupportedConfigObjectTypes");
        }
        String[] stringArray = null;
        try {
            stringArray = (String[])this.client.invoke(this.configServiceMBean, "getSupportedConfigObjectTypes", null, null);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            Manager.Ffdc.log((Throwable)instanceNotFoundException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getSupportedConfigObjectTypes", "163", new Object[]{this});
            Tr.error(tc, "ADMG0011E", instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            Manager.Ffdc.log((Throwable)reflectionException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getSupportedConfigObjectTypes", "166", new Object[]{this});
            Tr.error(tc, "ADMG0011E", reflectionException);
        }
        catch (MBeanException mBeanException) {
            Manager.Ffdc.log((Throwable)mBeanException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getSupportedConfigObjectTypes", "169", new Object[]{this});
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)exception;
            }
            throw new ConfigServiceException(exception);
        }
        catch (Exception exception) {
            Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getSupportedConfigObjectTypes", "177", new Object[]{this});
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSupportedConfigObjectTypes", stringArray);
        }
        return stringArray;
    }

    public AttributeList getAttributesMetaInfo(String string) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributesMetaInfo", string);
        }
        AttributeList attributeList = null;
        try {
            attributeList = (AttributeList)this.client.invoke(this.configServiceMBean, "getAttributesMetaInfo", new Object[]{string}, new String[]{"java.lang.String"});
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            Manager.Ffdc.log((Throwable)instanceNotFoundException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getAttributesMetaInfo", "191", new Object[]{this});
            Tr.error(tc, "ADMG0011E", instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            Manager.Ffdc.log((Throwable)reflectionException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getAttributesMetaInfo", "194", new Object[]{this});
            Tr.error(tc, "ADMG0011E", reflectionException);
        }
        catch (MBeanException mBeanException) {
            Manager.Ffdc.log((Throwable)mBeanException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getAttributesMetaInfo", "197", new Object[]{this});
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)exception;
            }
            throw new ConfigServiceException(exception);
        }
        catch (Exception exception) {
            Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getAttributesMetaInfo", "205", new Object[]{this});
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributesMetaInfo", attributeList);
        }
        return attributeList;
    }

    public AttributeList getRelationshipsMetaInfo(String string) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRelationshipsMetaInfo", string);
        }
        AttributeList attributeList = null;
        try {
            attributeList = (AttributeList)this.client.invoke(this.configServiceMBean, "getRelationshipsMetaInfo", new Object[]{string}, new String[]{"java.lang.String"});
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            Manager.Ffdc.log((Throwable)instanceNotFoundException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getRelationshipsMetaInfo", "219", new Object[]{this});
            Tr.error(tc, "ADMG0011E", instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            Manager.Ffdc.log((Throwable)reflectionException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getRelationshipsMetaInfo", "222", new Object[]{this});
            Tr.error(tc, "ADMG0011E", reflectionException);
        }
        catch (MBeanException mBeanException) {
            Manager.Ffdc.log((Throwable)mBeanException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getRelationshipsMetaInfo", "225", new Object[]{this});
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)exception;
            }
            throw new ConfigServiceException(exception);
        }
        catch (Exception exception) {
            Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getRelationshipsMetaInfo", "233", new Object[]{this});
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRelationshipsMetaInfo", attributeList);
        }
        return attributeList;
    }

    public ObjectName[] queryConfigObjects(Session session, ObjectName objectName, ObjectName objectName2, QueryExp queryExp) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "queryConfigObjects", new Object[]{session, objectName, objectName2, queryExp});
        }
        ObjectName[] objectNameArray = null;
        try {
            objectNameArray = (ObjectName[])this.client.invoke(this.configServiceMBean, "queryConfigObjects", new Object[]{session, objectName, objectName2, queryExp}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "javax.management.ObjectName", "javax.management.QueryExp"});
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            Manager.Ffdc.log((Throwable)instanceNotFoundException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.queryConfigObjects", "253", new Object[]{this});
            Tr.error(tc, "ADMG0011E", instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            Manager.Ffdc.log((Throwable)reflectionException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.queryConfigObjects", "256", new Object[]{this});
            Tr.error(tc, "ADMG0011E", reflectionException);
        }
        catch (MBeanException mBeanException) {
            Manager.Ffdc.log((Throwable)mBeanException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.queryConfigObjects", "259", new Object[]{this});
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)exception;
            }
            throw new ConfigServiceException(exception);
        }
        catch (Exception exception) {
            Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.queryConfigObjects", "267", new Object[]{this});
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "queryConfigObjects", objectNameArray);
        }
        return objectNameArray;
    }

    public ObjectName[] queryTemplates(Session session, String string) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "queryTemplates", new Object[]{session, string});
        }
        ObjectName[] objectNameArray = null;
        try {
            objectNameArray = (ObjectName[])this.client.invoke(this.configServiceMBean, "queryTemplates", new Object[]{session, string}, new String[]{"com.ibm.websphere.management.Session", "java.lang.String"});
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            Manager.Ffdc.log((Throwable)instanceNotFoundException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.queryConfigObjects", "342", new Object[]{this});
            Tr.error(tc, "ADMG0011E", instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            Manager.Ffdc.log((Throwable)reflectionException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.queryConfigObjects", "345", new Object[]{this});
            Tr.error(tc, "ADMG0011E", reflectionException);
        }
        catch (MBeanException mBeanException) {
            Manager.Ffdc.log((Throwable)mBeanException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.queryConfigObjects", "348", new Object[]{this});
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)exception;
            }
            throw new ConfigServiceException(exception);
        }
        catch (Exception exception) {
            Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.queryConfigObjects", "267", new Object[]{this});
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "queryTemplates", objectNameArray);
        }
        return objectNameArray;
    }

    public ObjectName[] resolve(Session session, String string) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolve", new Object[]{session, string});
        }
        ObjectName[] objectNameArray = null;
        try {
            objectNameArray = (ObjectName[])this.client.invoke(this.configServiceMBean, "resolve", new Object[]{session, string}, new String[]{"com.ibm.websphere.management.Session", "java.lang.String"});
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            Manager.Ffdc.log((Throwable)instanceNotFoundException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.resolve", "283", new Object[]{this});
            Tr.error(tc, "ADMG0011E", instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            Manager.Ffdc.log((Throwable)reflectionException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.resolve", "286", new Object[]{this});
            Tr.error(tc, "ADMG0011E", reflectionException);
        }
        catch (MBeanException mBeanException) {
            Manager.Ffdc.log((Throwable)mBeanException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.resolve", "289", new Object[]{this});
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)exception;
            }
            throw new ConfigServiceException(exception);
        }
        catch (Exception exception) {
            Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.resolve", "297", new Object[]{this});
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolve", objectNameArray);
        }
        return objectNameArray;
    }

    public ObjectName[] resolve(Session session, ObjectName objectName, String string) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolve", new Object[]{session, string});
        }
        ObjectName[] objectNameArray = null;
        try {
            objectNameArray = (ObjectName[])this.client.invoke(this.configServiceMBean, "resolve", new Object[]{session, objectName, string}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "java.lang.String"});
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            Manager.Ffdc.log((Throwable)instanceNotFoundException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.resolve", "283", new Object[]{this});
            Tr.error(tc, "ADMG0011E", instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            Manager.Ffdc.log((Throwable)reflectionException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.resolve", "286", new Object[]{this});
            Tr.error(tc, "ADMG0011E", reflectionException);
        }
        catch (MBeanException mBeanException) {
            Manager.Ffdc.log((Throwable)mBeanException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.resolve", "289", new Object[]{this});
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)exception;
            }
            throw new ConfigServiceException(exception);
        }
        catch (Exception exception) {
            Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.resolve", "297", new Object[]{this});
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolve", objectNameArray);
        }
        return objectNameArray;
    }

    public ObjectName createConfigDataByTemplate(Session session, ObjectName objectName, String string, AttributeList attributeList, ObjectName objectName2) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConfigDataByTemplate", new Object[]{session, objectName, string, attributeList, objectName2});
        }
        ObjectName objectName3 = null;
        try {
            objectName3 = (ObjectName)this.client.invoke(this.configServiceMBean, "createConfigDataByTemplate", new Object[]{session, objectName, string, attributeList, objectName2}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "java.lang.String", "javax.management.AttributeList", "javax.management.ObjectName"});
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            Manager.Ffdc.log((Throwable)instanceNotFoundException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.createConfigDataByTemplate", "318", new Object[]{this});
            Tr.error(tc, "ADMG0011E", instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            Manager.Ffdc.log((Throwable)reflectionException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.createConfigDataByTemplate", "321", new Object[]{this});
            Tr.error(tc, "ADMG0011E", reflectionException);
        }
        catch (MBeanException mBeanException) {
            Manager.Ffdc.log((Throwable)mBeanException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.createConfigDataByTemplate", "324", new Object[]{this});
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)exception;
            }
            throw new ConfigServiceException(exception);
        }
        catch (Exception exception) {
            Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.createConfigDataByTemplate", "332", new Object[]{this});
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createConfigDataByTemplate", objectName3);
        }
        return objectName3;
    }

    public ObjectName createConfigData(Session session, ObjectName objectName, String string, String string2, AttributeList attributeList) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConfigData", new Object[]{session, objectName, string, string2, attributeList});
        }
        ObjectName objectName2 = null;
        try {
            objectName2 = (ObjectName)this.client.invoke(this.configServiceMBean, "createConfigData", new Object[]{session, objectName, string, string2, attributeList}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "java.lang.String", "java.lang.String", "javax.management.AttributeList"});
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            Manager.Ffdc.log((Throwable)instanceNotFoundException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.createConfigData", "354", new Object[]{this});
            Tr.error(tc, "ADMG0011E", instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            Manager.Ffdc.log((Throwable)reflectionException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.createConfigData", "357", new Object[]{this});
            Tr.error(tc, "ADMG0011E", reflectionException);
        }
        catch (MBeanException mBeanException) {
            Manager.Ffdc.log((Throwable)mBeanException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.createConfigData", "360", new Object[]{this});
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)exception;
            }
            throw new ConfigServiceException(exception);
        }
        catch (Exception exception) {
            Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.createConfigData", "368", new Object[]{this});
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createConfigData", objectName2);
        }
        return objectName2;
    }

    public void setAttributes(Session session, ObjectName objectName, AttributeList attributeList) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAttributes", new Object[]{session, objectName, attributeList});
        }
        try {
            this.client.invoke(this.configServiceMBean, "setAttributes", new Object[]{session, objectName, attributeList}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "javax.management.AttributeList"});
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            Manager.Ffdc.log((Throwable)instanceNotFoundException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.setAttributes", "386", new Object[]{this});
            Tr.error(tc, "ADMG0011E", instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            Manager.Ffdc.log((Throwable)reflectionException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.setAttributes", "389", new Object[]{this});
            Tr.error(tc, "ADMG0011E", reflectionException);
        }
        catch (MBeanException mBeanException) {
            Manager.Ffdc.log((Throwable)mBeanException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.setAttributes", "392", new Object[]{this});
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)exception;
            }
            throw new ConfigServiceException(exception);
        }
        catch (Exception exception) {
            Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.setAttributes", "400", new Object[]{this});
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAttributes");
        }
    }

    public void addElement(Session session, ObjectName objectName, String string, Object object, int n) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addElement", new Object[]{session, objectName, string, object, new Integer(n)});
        }
        try {
            this.client.invoke(this.configServiceMBean, "addElement", new Object[]{session, objectName, string, object, new Integer(n)}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "java.lang.String", "java.lang.Object", "int"});
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            Manager.Ffdc.log((Throwable)instanceNotFoundException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.addElement", "420", new Object[]{this});
            Tr.error(tc, "ADMG0011E", instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            Manager.Ffdc.log((Throwable)reflectionException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.addElement", "423", new Object[]{this});
            Tr.error(tc, "ADMG0011E", reflectionException);
        }
        catch (MBeanException mBeanException) {
            Manager.Ffdc.log((Throwable)mBeanException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.addElement", "426", new Object[]{this});
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)exception;
            }
            throw new ConfigServiceException(exception);
        }
        catch (Exception exception) {
            Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.addElement", "434", new Object[]{this});
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addElement");
        }
    }

    public void removeElement(Session session, ObjectName objectName, String string, Object object) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeElement", new Object[]{session, objectName, string, object});
        }
        try {
            this.client.invoke(this.configServiceMBean, "removeElement", new Object[]{session, objectName, string, object}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "java.lang.String", "java.lang.Object"});
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            Manager.Ffdc.log((Throwable)instanceNotFoundException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.removeElement", "452", new Object[]{this});
            Tr.error(tc, "ADMG0011E", instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            Manager.Ffdc.log((Throwable)reflectionException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.removeElement", "455", new Object[]{this});
            Tr.error(tc, "ADMG0011E", reflectionException);
        }
        catch (MBeanException mBeanException) {
            Manager.Ffdc.log((Throwable)mBeanException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.removeElement", "458", new Object[]{this});
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)exception;
            }
            throw new ConfigServiceException(exception);
        }
        catch (Exception exception) {
            Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.removeElement", "466", new Object[]{this});
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeElement");
        }
    }

    public void unsetAttributes(Session session, ObjectName objectName, String[] stringArray) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unsetAttributes", new Object[]{session, objectName, stringArray});
        }
        try {
            this.client.invoke(this.configServiceMBean, "unsetAttributes", new Object[]{session, objectName, stringArray}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "[Ljava.lang.String;"});
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            Manager.Ffdc.log((Throwable)instanceNotFoundException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.unsetAttributes", "483", new Object[]{this});
            Tr.error(tc, "ADMG0011E", instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            Manager.Ffdc.log((Throwable)reflectionException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.unsetAttributes", "486", new Object[]{this});
            Tr.error(tc, "ADMG0011E", reflectionException);
        }
        catch (MBeanException mBeanException) {
            Manager.Ffdc.log((Throwable)mBeanException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.unsetAttributes", "489", new Object[]{this});
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)exception;
            }
            throw new ConfigServiceException(exception);
        }
        catch (Exception exception) {
            Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.unsetAttributes", "497", new Object[]{this});
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "unsetAttributes");
        }
    }

    public void resetAttributes(Session session, ObjectName objectName, AttributeList attributeList) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resetAttributes", new Object[]{session, objectName, attributeList});
        }
        try {
            this.client.invoke(this.configServiceMBean, "resetAttributes", new Object[]{session, objectName, attributeList}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "javax.management.AttributeList"});
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            Manager.Ffdc.log((Throwable)instanceNotFoundException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.resetAttributes", "514", new Object[]{this});
            Tr.error(tc, "ADMG0011E", instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            Manager.Ffdc.log((Throwable)reflectionException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.resetAttributes", "517", new Object[]{this});
            Tr.error(tc, "ADMG0011E", reflectionException);
        }
        catch (MBeanException mBeanException) {
            Manager.Ffdc.log((Throwable)mBeanException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.resetAttributes", "520", new Object[]{this});
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)exception;
            }
            throw new ConfigServiceException(exception);
        }
        catch (Exception exception) {
            Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.resetAttributes", "528", new Object[]{this});
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resetAttributes");
        }
    }

    public AttributeList getAttributes(Session session, ObjectName objectName, String[] stringArray, boolean bl) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributes", new Object[]{session, objectName, stringArray, new Boolean(bl)});
        }
        AttributeList attributeList = null;
        try {
            attributeList = (AttributeList)this.client.invoke(this.configServiceMBean, "getAttributes", new Object[]{session, objectName, stringArray, new Boolean(bl)}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "[Ljava.lang.String;", "boolean"});
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            Manager.Ffdc.log((Throwable)instanceNotFoundException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getAttributes", "547", new Object[]{this});
            Tr.error(tc, "ADMG0011E", instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            Manager.Ffdc.log((Throwable)reflectionException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getAttributes", "550", new Object[]{this});
            Tr.error(tc, "ADMG0011E", reflectionException);
        }
        catch (MBeanException mBeanException) {
            Manager.Ffdc.log((Throwable)mBeanException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getAttributes", "553", new Object[]{this});
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)exception;
            }
            throw new ConfigServiceException(exception);
        }
        catch (Exception exception) {
            Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getAttributes", "561", new Object[]{this});
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributes", attributeList);
        }
        return attributeList;
    }

    public Object getAttribute(Session session, ObjectName objectName, String string) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttribute", new Object[]{session, objectName, string});
        }
        Object object = null;
        try {
            object = this.client.invoke(this.configServiceMBean, "getAttribute", new Object[]{session, objectName, string}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "java.lang.String"});
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            Manager.Ffdc.log((Throwable)instanceNotFoundException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getAttribute", "580", new Object[]{this});
            Tr.error(tc, "ADMG0011E", instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            Manager.Ffdc.log((Throwable)reflectionException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getAttribute", "583", new Object[]{this});
            Tr.error(tc, "ADMG0011E", reflectionException);
        }
        catch (MBeanException mBeanException) {
            Manager.Ffdc.log((Throwable)mBeanException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getAttribute", "586", new Object[]{this});
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)exception;
            }
            throw new ConfigServiceException(exception);
        }
        catch (Exception exception) {
            Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getAttribute", "594", new Object[]{this});
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttribute", object);
        }
        return object;
    }

    public Object getAttribute(Session session, ObjectName objectName, String string, boolean bl) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Enter - ConfigureServiceProxy.getAttribute", new Object[]{session, objectName, string, new Boolean(bl)});
        }
        if (bl) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "Exit - ConfigureServiceProxy.getAttribute");
            }
            return this.getAttribute(session, objectName, string);
        }
        AttributeList attributeList = this.getAttributes(session, objectName, new String[]{string}, false);
        Object object = null;
        try {
            object = ConfigServiceHelper.getAttributeValue(attributeList, string);
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            Manager.Ffdc.log((Throwable)attributeNotFoundException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceHelper.getConfigDataId", "39");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Exit - ConfigureServiceProxy.getAttribute");
        }
        return object;
    }

    public void deleteConfigData(Session session, ObjectName objectName) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteConfigData", new Object[]{session, objectName});
        }
        try {
            this.client.invoke(this.configServiceMBean, "deleteConfigData", new Object[]{session, objectName}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName"});
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            Manager.Ffdc.log((Throwable)instanceNotFoundException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.deleteConfigData", "611", new Object[]{this});
            Tr.error(tc, "ADMG0011E", instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            Manager.Ffdc.log((Throwable)reflectionException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.deleteConfigData", "614", new Object[]{this});
            Tr.error(tc, "ADMG0011E", reflectionException);
        }
        catch (MBeanException mBeanException) {
            Manager.Ffdc.log((Throwable)mBeanException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.deleteConfigData", "617", new Object[]{this});
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)exception;
            }
            throw new ConfigServiceException(exception);
        }
        catch (Exception exception) {
            Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.deleteConfigData", "625", new Object[]{this});
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteConfigData");
        }
    }

    public AttributeList getRelationships(Session session, ObjectName objectName, String[] stringArray) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRelationships", new Object[]{session, objectName, stringArray});
        }
        AttributeList attributeList = null;
        try {
            attributeList = (AttributeList)this.client.invoke(this.configServiceMBean, "getRelationships", new Object[]{session, objectName, stringArray}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "[Ljava.lang.String;"});
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            Manager.Ffdc.log((Throwable)instanceNotFoundException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getRelationships", "642", new Object[]{this});
            Tr.error(tc, "ADMG0011E", instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            Manager.Ffdc.log((Throwable)reflectionException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getRelationships", "645", new Object[]{this});
            Tr.error(tc, "ADMG0011E", reflectionException);
        }
        catch (MBeanException mBeanException) {
            Manager.Ffdc.log((Throwable)mBeanException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getRelationships", "648", new Object[]{this});
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)exception;
            }
            throw new ConfigServiceException(exception);
        }
        catch (Exception exception) {
            Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getRelationships", "656", new Object[]{this});
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRelationships", attributeList);
        }
        return attributeList;
    }

    public ObjectName[] getRelationship(Session session, ObjectName objectName, String string) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRelationship", new Object[]{session, objectName, string});
        }
        ObjectName[] objectNameArray = null;
        try {
            objectNameArray = (ObjectName[])this.client.invoke(this.configServiceMBean, "getRelationship", new Object[]{session, objectName, string}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "java.lang.String"});
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            Manager.Ffdc.log((Throwable)instanceNotFoundException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getRelationship", "675", new Object[]{this});
            Tr.error(tc, "ADMG0011E", instanceNotFoundException);
        }
        catch (ReflectionException reflectionException) {
            Manager.Ffdc.log((Throwable)reflectionException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getRelationship", "678", new Object[]{this});
            Tr.error(tc, "ADMG0011E", reflectionException);
        }
        catch (MBeanException mBeanException) {
            Manager.Ffdc.log((Throwable)mBeanException, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getRelationship", "681", new Object[]{this});
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof ConfigServiceException) {
                throw (ConfigServiceException)exception;
            }
            throw new ConfigServiceException(exception);
        }
        catch (Exception exception) {
            Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.websphere.management.configservice.ConfigServiceProxy.getRelationship", "689", new Object[]{this});
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRelationship", objectNameArray);
        }
        return objectNameArray;
    }
}

