/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.configservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.ws.management.AdminServiceFactoryInitializer;
import com.ibm.ws.management.configservice.ConfigServiceFactoryInitializer;
import java.util.Properties;

public class ConfigServiceFactory {
    private static TraceComponent tc = Tr.register(ConfigServiceFactory.class, "management", "com.ibm.ws.management.resources.configservice");
    private static WebSphereRuntimePermission adminPermission = new WebSphereRuntimePermission("AdminPermission");

    public static ConfigService createConfigService(boolean bl, Properties properties) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConfigService");
        }
        ConfigService configService = ConfigServiceFactoryInitializer.createConfigService((boolean)bl, (Properties)properties);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createConfigService", configService);
        }
        return configService;
    }

    public static synchronized ConfigService getConfigService() {
        ConfigService configService;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigService");
        }
        if ((configService = ConfigServiceFactoryInitializer.getConfigService()) == null) {
            return configService;
        }
        String string = AdminServiceFactoryInitializer.getAdminType();
        if ("AdminAgent".equals(string)) {
            configService = ConfigServiceFactoryInitializer.getProxy();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigService", configService);
        }
        return configService;
    }
}

