/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.cmdframework.provider;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandProvider;
import com.ibm.websphere.management.cmdframework.provider.CommandResultImpl;
import com.ibm.websphere.management.cmdframework.provider.SimpleAdminCommand;
import com.ibm.ws.management.cmdframework.impl.CommandSecurityUtil;
import com.ibm.ws.security.core.ContextManagerFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import javax.security.auth.Subject;

public abstract class SimpleCommandProvider
extends CommandProvider {
    private static TraceComponent tc = Tr.register(SimpleCommandProvider.class, "SimpleCommandProvider", "com.ibm.websphere.management.cmdframework.provider");
    protected HashMap methodTable;

    protected SimpleCommandProvider() {
        Class<?> clazz = this.getClass();
        Method[] methodArray = clazz.getMethods();
        this.methodTable = new HashMap(methodArray.length);
        for (int i = 0; i < methodArray.length; ++i) {
            this.methodTable.put(methodArray[i].getName(), methodArray[i]);
        }
    }

    public AbstractAdminCommand createCommand(CommandMetadata commandMetadata) throws CommandNotFoundException {
        String string = commandMetadata.getName();
        if (!this.methodTable.containsKey(string)) {
            throw new CommandNotFoundException(string);
        }
        return new SimpleAdminCommand(commandMetadata);
    }

    public AbstractAdminCommand loadCommand(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        SimpleAdminCommand simpleAdminCommand;
        try {
            simpleAdminCommand = new SimpleAdminCommand(commandData);
        }
        catch (CommandNotFoundException commandNotFoundException) {
            throw commandNotFoundException;
        }
        catch (CommandLoadException commandLoadException) {
            throw commandLoadException;
        }
        catch (Exception exception) {
            throw new CommandLoadException(exception);
        }
        return simpleAdminCommand;
    }

    protected void execute(SimpleAdminCommand simpleAdminCommand) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute");
        }
        CommandResultImpl commandResultImpl = new CommandResultImpl();
        simpleAdminCommand.setCommandResult(commandResultImpl);
        CommandSecurityUtil commandSecurityUtil = CommandSecurityUtil.getInstance();
        boolean bl = commandSecurityUtil.checkAccess((AdminCommand)simpleAdminCommand, "execute command");
        if (!bl) {
            String string = "Access denied for this command " + simpleAdminCommand.getName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string);
            }
            Exception exception = new Exception(string);
            commandResultImpl.setException(exception);
            return;
        }
        String string = commandSecurityUtil.getDelegationMode((AdminCommand)simpleAdminCommand);
        if (string != null && string.equals("System")) {
            final SimpleAdminCommand simpleAdminCommand2 = simpleAdminCommand;
            try {
                Subject subject = ContextManagerFactory.getInstance().getServerSubject();
                ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        SimpleCommandProvider.this.executeReal(simpleAdminCommand2);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                commandResultImpl.setException(exception);
            }
            catch (Exception exception) {
                commandResultImpl.setException(exception);
            }
        } else {
            this.executeReal(simpleAdminCommand);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute");
        }
    }

    protected void executeReal(SimpleAdminCommand simpleAdminCommand) {
        CommandResultImpl commandResultImpl = (CommandResultImpl)simpleAdminCommand.getCommandResult();
        try {
            simpleAdminCommand.validate();
            CommandMetadata commandMetadata = simpleAdminCommand.getCommandMetadata();
            Method method = (Method)this.methodTable.get(simpleAdminCommand.getName());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Method to execute is " + method.getName());
            }
            Object object = method.invoke((Object)this, simpleAdminCommand);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Result is " + object);
            }
            if (object != null && tc.isDebugEnabled()) {
                Tr.debug(tc, "Class of Result is " + object.getClass());
            }
            commandResultImpl.setResult(object);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown when invocation command");
            }
            commandResultImpl.setException(invocationTargetException.getTargetException());
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown when execute command");
            }
            commandResultImpl.setException(throwable);
        }
        simpleAdminCommand.setCommandResult(commandResultImpl);
    }
}

