/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.application.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentMessages;
import com.ibm.websphere.management.application.client.AppDeploymentTaskInfo;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.management.connector.interop.JMXVersionValidation;
import com.ibm.ws.management.util.RasUtils;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AppDeploymentTask
implements Serializable {
    private static final long serialVersionUID = -2021644844665692021L;
    private static final TraceComponent tc = Tr.register(AppDeploymentTask.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;
    public static final int VERSION_HIGHEST = 999999;
    public static final String HIGHEST_VERSION;
    protected transient AppDeploymentController appController;
    protected String name = null;
    protected boolean isTaskEmpty = false;
    protected boolean isSufficientlyDone = true;
    protected boolean isTaskDisabled = false;
    protected boolean isValidationEnabled = true;
    protected String[][] taskData = null;
    protected String[] colNames = null;
    protected String[] taskValidateErrorMessages = null;
    protected boolean[] mutables = null;
    protected boolean[] requiredColumns = null;
    protected boolean[] hiddenColumns = null;
    protected boolean hasHiddenColumns = false;

    public AppDeploymentTask(AppDeploymentController appDeploymentController) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", "controller=" + appDeploymentController);
        }
        this.appController = appDeploymentController;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public AppDeploymentController getAppDeploymentController() {
        return this.appController;
    }

    public void setAppDeploymentController(AppDeploymentController appDeploymentController) {
        this.appController = appDeploymentController;
    }

    public String getName() {
        return this.name;
    }

    public String[] getColumnNames() {
        return this.colNames;
    }

    public boolean isTaskEmpty() {
        return this.isTaskEmpty;
    }

    public boolean isTaskDisabled() {
        return this.isTaskDisabled;
    }

    public void setIsTaskDisabled(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setIsTaskDisabled", "taskDisabled=" + bl);
        }
        this.isTaskDisabled = bl;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setIsTaskDisabled");
        }
    }

    public boolean isSufficientlyDone() {
        return this.isSufficientlyDone;
    }

    public void setIsSufficientlyDone(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setIsSufficientlyDone", "sufficientlyDone=" + bl);
        }
        this.isSufficientlyDone = bl;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setIsSufficientlyDone");
        }
    }

    public boolean[] getMutableColumns() {
        return this.mutables;
    }

    public boolean isMutableColumn(int n) {
        boolean bl = false;
        if (this.mutables != null && n >= 0 && n < this.mutables.length) {
            bl = this.mutables[n];
        }
        return bl;
    }

    @Deprecated
    public boolean getMutableColumns(int n) {
        return this.isMutableColumn(n);
    }

    public boolean[] getRequiredColumns() {
        return this.requiredColumns;
    }

    @Deprecated
    public boolean isRequiredColumn(int n) {
        boolean bl = false;
        if (this.requiredColumns != null && n >= 0 && n < this.requiredColumns.length) {
            bl = this.requiredColumns[n];
        }
        return bl;
    }

    @Deprecated
    public boolean getRequiredColumns(int n) {
        return this.isRequiredColumn(n);
    }

    public boolean isHiddenColumn(int n) {
        boolean bl = false;
        if (this.hasHiddenColumns && this.hiddenColumns != null && n >= 0 && n < this.hiddenColumns.length) {
            bl = this.hiddenColumns[n];
        }
        return bl;
    }

    public boolean isValidationEnabled() {
        return this.isValidationEnabled;
    }

    public void setValidationEnabled(boolean bl) {
        this.isValidationEnabled = bl;
    }

    public String[][] getTaskData() {
        String[][] stringArray = null;
        if (this.taskData != null) {
            stringArray = new String[this.taskData.length][];
            for (int i = 0; i < this.taskData.length; ++i) {
                stringArray[i] = new String[this.taskData[i].length];
                for (int j = 0; j < this.taskData[i].length; ++j) {
                    stringArray[i][j] = this.taskData[i][j];
                }
            }
        }
        return stringArray;
    }

    public void setTaskData(String[][] stringArray) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTaskData", "data=" + stringArray);
        }
        this.verifyTaskData(stringArray);
        if (this.taskData != null && this.appController != null) {
            this.appController.getDependencyTask(this.name);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setTaskData");
        }
    }

    protected void verifyTaskData(String[][] stringArray) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "verifyTaskData", "data=" + stringArray);
        }
        this.taskData = stringArray;
        if (this.taskData == null) {
            this.isTaskEmpty = true;
            this.isSufficientlyDone = true;
        } else {
            this.isTaskEmpty = false;
            this.isSufficientlyDone = true;
            for (int i = 0; i < this.taskData.length; ++i) {
                if (this.taskData[i].length != this.colNames.length) {
                    this.isSufficientlyDone = false;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "verifyTaskData", "wrong task data format; colNames.length=" + this.colNames.length + ", taskData[" + i + "].length=" + this.taskData[i].length);
                    }
                    String string = util.getMessage((AppDeploymentTask)this, (String)"ADMA0015E");
                    String string2 = MessageFormat.format(string, Integer.toString(this.taskData.length));
                    throw new AppDeploymentException(string2, null);
                }
                for (int j = 0; this.isSufficientlyDone && j < this.taskData[i].length; ++j) {
                    if (!this.mutables[j] || !this.requiredColumns[j] || this.taskData[i][j] != null && !this.taskData[i][j].trim().equals("")) continue;
                    this.isSufficientlyDone = false;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "verifyTaskData");
        }
    }

    public String[] validate() {
        return null;
    }

    protected void buildErrorMessages(Vector<String> vector) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildErrorMessages", "errors=" + vector);
        }
        this.taskValidateErrorMessages = null;
        if (vector != null && vector.size() > 0) {
            this.taskValidateErrorMessages = new String[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                this.taskValidateErrorMessages[i] = vector.elementAt(i);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildErrorMessages");
        }
    }

    public AppDeploymentMessages getTaskMessages() {
        AppDeploymentTaskInfo appDeploymentTaskInfo;
        AppDeploymentMessages appDeploymentMessages = null;
        if (this.appController != null && (appDeploymentTaskInfo = this.appController.getTaskInfo(this.name)) != null) {
            appDeploymentMessages = appDeploymentTaskInfo.appMessages;
        }
        return appDeploymentMessages;
    }

    public String getCallerVersion() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCallerVersion");
        }
        String string = HIGHEST_VERSION;
        if (this.appController != null && (this.appController.getDeploymentMode() & 0x110L) != 0L && AdminServiceFactory.getAdminService() != null) {
            JMXVersionValidation jMXVersionValidation = new JMXVersionValidation();
            String string2 = jMXVersionValidation.getClientVersion();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getCallerVersion", "clientVersion=" + string2);
            }
            if (string2 != null) {
                String string3 = null;
                int n = string2.indexOf(46);
                string3 = n < 0 ? string2 : string2.substring(0, n);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getCallerVersion", "clientMajorVersion=" + string3);
                }
                string = string3;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCallerVersion", string);
        }
        return string;
    }

    public int getClientMajorVersion() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClientMajorVersion");
        }
        int n = 999999;
        String string = this.getCallerVersion();
        try {
            n = Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            RasUtils.logException((Throwable)numberFormatException, tc, CLASS_NAME, "getClientMajorVersion", "595", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClientMajorVersion", Integer.toString(n));
        }
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append('@');
        stringBuilder.append(Integer.toHexString(this.hashCode()));
        stringBuilder.append("[appController=");
        stringBuilder.append(this.appController);
        stringBuilder.append(", name=");
        stringBuilder.append(this.name);
        stringBuilder.append(", isTaskEmpty=");
        stringBuilder.append(this.isTaskEmpty);
        stringBuilder.append(", isSufficientlyDone=");
        stringBuilder.append(this.isSufficientlyDone);
        stringBuilder.append(", isTaskDisabled=");
        stringBuilder.append(this.isTaskDisabled);
        stringBuilder.append(", isValidationEnabled=");
        stringBuilder.append(this.isValidationEnabled);
        stringBuilder.append(", hasHiddenColumns=");
        stringBuilder.append(this.hasHiddenColumns);
        stringBuilder.append(", colNames=");
        stringBuilder.append(Arrays.toString(this.colNames));
        stringBuilder.append(", mutables=");
        stringBuilder.append(Arrays.toString(this.mutables));
        stringBuilder.append(", requiredColumns=");
        stringBuilder.append(Arrays.toString(this.requiredColumns));
        stringBuilder.append(", hiddenColumns=");
        stringBuilder.append(Arrays.toString(this.hiddenColumns));
        stringBuilder.append(", taskValidateErrorMessages=");
        stringBuilder.append(Arrays.toString(this.taskValidateErrorMessages));
        stringBuilder.append(", taskData=");
        stringBuilder.append(Arrays.toString((Object[])this.taskData));
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/websphere/management/application/client/AppDeploymentTask.java, WAS.admin.installapp.client, WAS70.SERV1, q0834.18, ver. 1.19");
        }
        CLASS_NAME = AppDeploymentTask.class.getName();
        HIGHEST_VERSION = Integer.toString(999999);
    }
}

