/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.application.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.AppManagementFactory;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.application.client.AppDeploymentTaskHelper;
import com.ibm.websphere.management.application.client.AppDeploymentTaskInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTaskListener;
import com.ibm.websphere.management.application.client.AppDeploymentTaskValidate;
import com.ibm.websphere.management.application.client.ArchiveDeploymentInfo;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.DefaultTaskProvider;
import com.ibm.ws.management.application.ExtensionHelper;
import com.ibm.ws.management.application.PartialDeploymentInfo;
import com.ibm.ws.management.application.client.AppDeploymentOptions;
import com.ibm.ws.management.application.client.DataHolder;
import com.ibm.ws.management.application.client.DefaultBinding;
import com.ibm.ws.management.application.client.DefaultBindingHelper;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.management.application.dfltbndngs.Preferences;
import com.ibm.ws.management.commands.properties.ConfigPropertiesHelper;
import com.ibm.ws.management.util.RasUtils;
import com.ibm.ws.util.ImplFactory;
import com.ibm.ws.util.WsObjectInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.application.WebModule;
import org.eclipse.jst.j2ee.internal.common.XMLResource;
import org.eclipse.jst.j2ee.jca.Connector;
import org.eclipse.wst.common.internal.emf.utilities.EncoderDecoder;
import org.eclipse.wst.common.internal.emf.utilities.EncoderDecoderRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppDeploymentController
implements Serializable {
    private static final long serialVersionUID = -3828436921961863062L;
    private static TraceComponent tc = Tr.register(AppDeploymentController.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME;
    private static final String taskPackageName = "com.ibm.ws.management.application.client.";
    public static final String taskHelperSuffix = "Helper";
    private static boolean encoderInit;
    private static boolean propBasedConfig;
    private DataHolder dh = DataHolder.getInstance();
    protected Vector taskInfo = null;
    protected Vector taskNames = null;
    protected Vector tasks = null;
    protected int currentTask;
    protected Hashtable preferences = new Hashtable();
    protected transient AppDeploymentInfo deploymentInfo;
    protected transient ResourceBundle resBundle;
    protected long _deploymentMode;
    protected ConfigService configService;
    protected Session configSession;
    protected AdminClient adminClient;
    protected Hashtable taskDataChangeListeners;
    protected List changedTaskProcessList;
    private static int[][] versionTable;

    public static AppDeploymentController readArchive(String string, Hashtable hashtable) throws AppDeploymentException {
        return AppManagementFactory.readArchive((String)string, (Hashtable)hashtable);
    }

    public static AppDeploymentController readArchive(String string, Hashtable hashtable, Vector vector) throws AppDeploymentException {
        return AppManagementFactory.readArchive((String)string, (Hashtable)hashtable, (Vector)vector);
    }

    public AppDeploymentController(AppDeploymentInfo appDeploymentInfo, Hashtable hashtable, Vector vector) throws AppDeploymentException {
        this(appDeploymentInfo, null, hashtable, vector);
    }

    public AppDeploymentController(Vector vector, Vector vector2, Hashtable hashtable) throws AppDeploymentException {
        this(null, vector, hashtable, vector2);
    }

    public AppDeploymentController(AppDeploymentInfo appDeploymentInfo, Vector vector, Hashtable hashtable, Vector vector2) throws AppDeploymentException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AppDeploymentController");
        }
        this.deploymentInfo = appDeploymentInfo;
        this.taskInfo = vector2;
        this.preferences = hashtable;
        this.taskNames = new Vector();
        for (int i = 0; i < this.taskInfo.size(); ++i) {
            this.taskNames.addElement(((AppDeploymentTaskInfo)this.taskInfo.elementAt((int)i)).name);
        }
        this.taskDataChangeListeners = ExtensionHelper.processAppDeploymentTaskListenerExtensions((Hashtable)this.preferences);
        Hashtable hashtable2 = new Hashtable();
        try {
            hashtable2 = new DefaultTaskProvider().provideAppDeploymentTaskListeners(this.preferences);
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception in getting default task listeners: " + throwable);
            }
            RasUtils.logException(throwable, tc, CLASS_NAME, "AppDeploymentCtonroller", "306");
        }
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            object = (AppDeploymentTaskListener)hashtable2.get(string);
            ArrayList<AppDeploymentTaskListener> arrayList = (ArrayList<AppDeploymentTaskListener>)this.taskDataChangeListeners.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<AppDeploymentTaskListener>();
                this.taskDataChangeListeners.put(string, arrayList);
            }
            arrayList.add((AppDeploymentTaskListener)object);
        }
        this.changedTaskProcessList = new ArrayList();
        this.setDeploymentMode(hashtable);
        this.handlePreferences(hashtable);
        this.initializeEncoderDecoder();
        if (vector == null) {
            this.createAppDeploymentTasks();
        } else {
            this.tasks = vector;
            for (int i = 0; i < this.tasks.size(); ++i) {
                object = this.tasks.elementAt(i);
                if (object == null || !(object instanceof AppDeploymentTask)) continue;
                ((AppDeploymentTask)object).setAppDeploymentController(this);
            }
        }
        Locale locale = null;
        if (hashtable != null) {
            locale = (Locale)hashtable.get("app.client.locale");
        }
        this.resBundle = AppUtils.getBundle((String)"com.ibm.ws.management.resources.AppDeploymentMessages", locale);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AppDeploymentController");
        }
    }

    protected void setDeploymentMode(Hashtable hashtable) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setDeploymentMode");
        }
        this._deploymentMode = 1L;
        if (this.deploymentInfo != null && this.deploymentInfo instanceof PartialDeploymentInfo) {
            long l = this._deploymentMode = ((PartialDeploymentInfo)this.deploymentInfo).isApp() ? 16L : 256L;
        }
        if ("modulefile".equals(hashtable.get("contenttype"))) {
            this._deploymentMode = 0x100000L;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setDeploymentMode:" + this._deploymentMode);
        }
    }

    public long getDeploymentMode() {
        return this._deploymentMode;
    }

    protected void handlePreferences(Hashtable hashtable) throws AppDeploymentException {
        Object v;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handlePreferences");
        }
        if (hashtable == null || this.deploymentInfo == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handlePreferences");
            }
            return;
        }
        this.configService = (ConfigService)hashtable.get("configservice");
        this.configSession = (Session)hashtable.get("configsession");
        this.adminClient = (AdminClient)hashtable.get("adminclient");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "config service: " + this.configService + ", " + this.configSession + ", " + this.adminClient);
        }
        if ((v = hashtable.get("usedefaultbindings")) != null) {
            this.handleDefaultBindings(v);
        } else {
            ((ArchiveDeploymentInfo)this.deploymentInfo).createDefaultBindings(null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handlePreferences");
        }
    }

    private void handleDefaultBindings(Object object) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleDefaultBindings");
        }
        if (!(this.deploymentInfo instanceof ArchiveDeploymentInfo)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Deployment not from an ear file.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handleDefaultBindings");
            }
            return;
        }
        Preferences preferences = null;
        if (object instanceof Preferences) {
            preferences = (Preferences)object;
        } else if (object instanceof DefaultBinding) {
            preferences = DefaultBindingHelper.getPreferences((DefaultBinding)((DefaultBinding)object));
        } else if (object instanceof Properties) {
            preferences = DefaultBindingHelper.getPreferencesFromHashtable((Properties)((Properties)object));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Default bndg prefs: " + preferences);
        }
        if (preferences == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No preference data for default bindings " + object);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handleDefaultBindings");
            }
            return;
        }
        ((ArchiveDeploymentInfo)this.deploymentInfo).createDefaultBindings(preferences);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleDefaultBindings");
        }
    }

    protected void initializeEncoderDecoder() throws AppDeploymentException {
        if (encoderInit) {
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeEncoderDecoder");
        }
        try {
            EncoderDecoder encoderDecoder = (EncoderDecoder)ImplFactory.loadImplFromKey(EncoderDecoder.class);
            EncoderDecoderRegistry.getDefaultRegistry().setDefaultEncoderDecoder(encoderDecoder);
            encoderInit = true;
        }
        catch (Throwable throwable) {
            throw new AppDeploymentException("", throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeEncoderDecoder");
        }
    }

    protected void createAppDeploymentTasks() throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createAppDeploymentTasks");
        }
        this.tasks = new Vector();
        for (int i = 0; i < this.taskNames.size(); ++i) {
            this.tasks.addElement(((AppDeploymentTaskInfo)this.taskInfo.elementAt((int)i)).helper.createTask(this, (String)this.taskNames.elementAt(i)));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createAppDeploymentTasks");
        }
    }

    protected static AppDeploymentTaskHelper getTaskHelper(String string) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTaskHelper");
        }
        try {
            Class<?> clazz = string.indexOf(".") < 0 ? Class.forName(taskPackageName + string + taskHelperSuffix) : Class.forName(string + taskHelperSuffix);
            AppDeploymentTaskHelper appDeploymentTaskHelper = (AppDeploymentTaskHelper)clazz.newInstance();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getTaskHelper");
            }
            return appDeploymentTaskHelper;
        }
        catch (Throwable throwable) {
            throw new AppDeploymentException("", throwable);
        }
    }

    protected AppDeploymentTaskHelper getTaskHelper(int n) throws AppDeploymentException {
        if (n < this.taskInfo.size() && ((AppDeploymentTaskInfo)this.taskInfo.elementAt((int)n)).helper != null) {
            return ((AppDeploymentTaskInfo)this.taskInfo.elementAt((int)n)).helper;
        }
        throw new AppDeploymentException(AppUtils.getMessage((ResourceBundle)this.resBundle, (String)"ADMA0012E", (Object[])new Object[]{(String)this.tasks.elementAt(n)}), null);
    }

    public String[] getAppDeploymentTaskNames() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppDeploymentTaskNames");
        }
        Object[] objectArray = new String[this.taskNames.size()];
        this.taskNames.copyInto(objectArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAppDeploymentTaskNames");
        }
        return objectArray;
    }

    public AppDeploymentTask getFirstTask() throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFirstTask");
        }
        this.currentTask = 0;
        return this.getNthTask(this.currentTask);
    }

    protected AppDeploymentTask getNthTask(int n) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNthTask");
        }
        AppDeploymentTask appDeploymentTask = (AppDeploymentTask)this.tasks.elementAt(n);
        try {
            if (appDeploymentTask.getTaskData() == null && !appDeploymentTask.isTaskEmpty()) {
                this.prepareTask(n, appDeploymentTask);
            }
        }
        catch (Throwable throwable) {
            String string = (String)this.taskNames.elementAt(n);
            throw new AppDeploymentException(AppUtils.getMessage((ResourceBundle)this.resBundle, (String)"ADMA0092E", (Object[])new Object[]{string}), throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNthTask");
        }
        return appDeploymentTask;
    }

    protected void prepareTask(int n, AppDeploymentTask appDeploymentTask) throws AppDeploymentException {
        this.getTaskHelper(n).prepareTask(this.deploymentInfo, appDeploymentTask);
        this.callListeners(appDeploymentTask.getName(), appDeploymentTask, "afterPrepare");
        this.callListeners("*", appDeploymentTask, "afterPrepare");
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "taskName:  ", appDeploymentTask.getName());
        }
        if (!this.isPartialDeploymentInfo()) {
            this.postAllPrepareTask(this.deploymentInfo, appDeploymentTask);
        }
    }

    public AppDeploymentTask getNextTask() throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNextTask");
        }
        if (this.currentTask < 0) {
            return null;
        }
        if (this.currentTask + 1 >= this.tasks.size()) {
            return null;
        }
        return this.getNthTask(++this.currentTask);
    }

    public AppDeploymentTask getTaskByName(String string, boolean bl) throws AppDeploymentException {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTaskByName");
        }
        if ((n = this.taskNames.indexOf(string)) < 0) {
            return null;
        }
        if (bl) {
            this.currentTask = n;
        }
        return this.getNthTask(n);
    }

    public Vector getAllTasks() {
        return this.tasks;
    }

    public AppDeploymentTask getTaskByName(String string) throws AppDeploymentException {
        return this.getTaskByName(string, true);
    }

    protected void getDependencyTask(int n) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDependencyTask");
        }
        if (n < this.taskInfo.size()) {
            AppDeploymentTask appDeploymentTask;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "changed task: " + this.taskNames.elementAt(n));
            }
            if (!this.changedTaskProcessList.contains(appDeploymentTask = (AppDeploymentTask)this.tasks.elementAt(n))) {
                block9: {
                    this.changedTaskProcessList.add(appDeploymentTask);
                    try {
                        if (((AppDeploymentTaskInfo)this.taskInfo.elementAt((int)n)).dependency != null) {
                            ((AppDeploymentTaskInfo)this.taskInfo.elementAt((int)n)).dependency.setupDependency(this, (AppDeploymentTask)this.tasks.elementAt(n));
                        }
                    }
                    catch (Throwable throwable) {
                        if (!tc.isDebugEnabled()) break block9;
                        Tr.debug(tc, "Exception calling dependency for " + appDeploymentTask + ": " + throwable);
                    }
                }
                this.callListeners((String)this.taskNames.elementAt(n), appDeploymentTask, "taskDataChanged");
                this.callListeners("*", appDeploymentTask, "taskDataChanged");
                this.changedTaskProcessList.remove(appDeploymentTask);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Circular invocation avoided for " + this.taskNames.elementAt(n));
                }
                System.out.println("Circular invocation avoided for " + this.taskNames.elementAt(n));
            }
        }
    }

    private void callListeners(String string, AppDeploymentTask appDeploymentTask, String string2) {
        List list = (List)this.taskDataChangeListeners.get(string);
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            AppDeploymentTaskListener appDeploymentTaskListener = (AppDeploymentTaskListener)list.get(i);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking listener for key=" + string + " changedT=" + appDeploymentTask.getName() + " method=" + string2);
            }
            try {
                AppDeploymentTaskListener.class.getMethod(string2, AppDeploymentTask.class, AppDeploymentInfo.class).invoke((Object)appDeploymentTaskListener, appDeploymentTask, this.deploymentInfo);
                continue;
            }
            catch (Throwable throwable) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Exception calling listener " + appDeploymentTaskListener + " for " + appDeploymentTask + ": " + throwable);
            }
        }
    }

    public void getDependencyTask(String string) throws AppDeploymentException {
        this.getDependencyTask(this.taskNames.indexOf(string));
    }

    public void close(boolean bl, boolean bl2, boolean bl3) throws AppDeploymentException {
        CharSequence charSequence;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "close:" + bl + ", " + bl2 + ", " + bl3);
        }
        if (bl2) {
            String string = "WARNING";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "validating ..");
            }
            if ((object = this.validate()) != null) {
                for (int i = 0; i < ((String[])object).length; ++i) {
                    Pattern pattern = Pattern.compile("ADMA\\d\\d\\d\\dW");
                    Matcher matcher = pattern.matcher(object[i]);
                    if (matcher.find()) {
                        if (tc.isEntryEnabled()) {
                            Tr.debug(tc, "Message has pattern ADMA[0-9][0-9][0-9][0-9]W.  \nFollowing message is a warning message:  ", object[i]);
                        }
                        System.out.println((String)object[i]);
                        object[i] = string;
                        continue;
                    }
                    if (!tc.isEntryEnabled()) continue;
                    Tr.debug(tc, "Message:  " + (String)object[i] + "\nDoesn't not match pattern ADMA\\d\\d\\d\\dW (e.g. ADMA0000W)");
                }
                charSequence = new StringBuffer();
                for (int i = 0; i < ((String[])object).length; ++i) {
                    if (object[i].equals(string)) continue;
                    ((StringBuffer)charSequence).append((String)object[i]);
                    ((StringBuffer)charSequence).append("\n");
                }
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "Error Messages:  ", charSequence);
                }
                if (charSequence != null && ((StringBuffer)charSequence).length() > 0) {
                    throw new AppDeploymentException(AppUtils.getMessage((ResourceBundle)this.resBundle, (String)"ADMA0014E", (Object[])new Object[]{charSequence}), null);
                }
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "Validate only had warning messages.");
                }
            }
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "saving ..");
            }
            this.setVariableMap(this.tasks);
            for (int i = 0; i < this.tasks.size(); ++i) {
                try {
                    object = (AppDeploymentTask)this.tasks.elementAt(i);
                    if (!this.isPartialDeploymentInfo()) {
                        object = this.preAllCompleteTask((AppDeploymentTask)object);
                    }
                    this.callListeners(((AppDeploymentTask)object).getName(), (AppDeploymentTask)object, "beforeComplete");
                    this.callListeners("*", (AppDeploymentTask)object, "beforeComplete");
                    this.getTaskHelper(i).completeTask(this.deploymentInfo, (AppDeploymentTask)object);
                    this.callListeners(((AppDeploymentTask)object).getName(), (AppDeploymentTask)object, "afterComplete");
                    this.callListeners("*", (AppDeploymentTask)object, "afterComplete");
                    continue;
                }
                catch (Throwable throwable) {
                    charSequence = (String)this.taskNames.elementAt(i);
                    throw new AppDeploymentException(AppUtils.getMessage((ResourceBundle)this.resBundle, (String)"ADMA0093E", (Object[])new Object[]{charSequence}), throwable);
                }
            }
            this.resetDataHolder();
        }
        if (bl3 && this.deploymentInfo != null) {
            this.deploymentInfo.close(bl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "close");
        }
    }

    public void saveAndClose() throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "saveAndClose");
        }
        this.close(true, true, true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "saveAndClose");
        }
    }

    public String[] validate() throws AppDeploymentException {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        Vector<String> vector = new Vector<String>();
        String[] stringArray = null;
        for (n = 0; n < this.tasks.size(); ++n) {
            AppDeploymentTask appDeploymentTask;
            String[] stringArray2;
            AppDeploymentTaskHelper appDeploymentTaskHelper;
            String[] stringArray3 = this.getNthTask(n).validate();
            if (stringArray3 != null) {
                for (int i = 0; i < stringArray3.length; ++i) {
                    vector.addElement(stringArray3[i]);
                }
            }
            if ((appDeploymentTaskHelper = this.getTaskHelper(n)) == null || !(appDeploymentTaskHelper instanceof AppDeploymentTaskValidate) || (stringArray2 = ((AppDeploymentTaskValidate)appDeploymentTaskHelper).validate(appDeploymentTask = (AppDeploymentTask)this.tasks.elementAt(n), this.deploymentInfo)) == null) continue;
            for (int i = 0; i < stringArray2.length; ++i) {
                vector.addElement(stringArray2[i]);
            }
        }
        if (vector.size() > 0) {
            stringArray = new String[vector.size()];
            for (n = 0; n < vector.size(); ++n) {
                stringArray[n] = (String)vector.elementAt(n);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
        return stringArray;
    }

    public Hashtable getAppOptions() {
        return this.deploymentInfo.getAppOptions();
    }

    public void setAppOptions(Hashtable hashtable) {
        this.deploymentInfo.setAppOptions(hashtable);
    }

    public Hashtable getAppDeploymentSavedResults() {
        return this.deploymentInfo.getSavedResults();
    }

    public AppDeploymentTaskInfo getTaskInfo() {
        return (AppDeploymentTaskInfo)this.taskInfo.elementAt(this.currentTask);
    }

    public AppDeploymentTaskInfo getTaskInfo(String string) {
        int n = this.taskNames.indexOf(string);
        if (n < 0) {
            return null;
        }
        return (AppDeploymentTaskInfo)this.taskInfo.elementAt(n);
    }

    public boolean isPartialDeploymentInfo() {
        return this.deploymentInfo instanceof PartialDeploymentInfo;
    }

    public String getSecurityPolicyData() throws AppDeploymentException {
        return this.deploymentInfo.getSecurityPolicyData(this.resBundle);
    }

    public String getSecurityPolicyWarning() {
        return this.deploymentInfo.getSecurityPolicyWarning();
    }

    public void saveAsFile(String string, String string2, InputStream inputStream) throws AppDeploymentException {
        this.deploymentInfo.saveAsFile(string, string2, inputStream);
    }

    public void createDeploymentPlan(OutputStream outputStream) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDeploymentPlan");
        }
        if (outputStream == null) {
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "Null output stream for depl plan.");
            }
            return;
        }
        try {
            Vector<AppDeploymentTask> vector;
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
            Hashtable hashtable = this.getAppOptions();
            if (this.deploymentInfo.isStandaloneDeployment()) {
                vector = this.deploymentInfo.getAllURIStrings();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "standalone URI: " + vector);
                }
                if (vector.size() > 0) {
                    hashtable.put("appdeplStandaloneURI", vector.firstElement());
                }
            }
            objectOutputStream.writeObject(hashtable);
            vector = new Vector<AppDeploymentTask>();
            for (int i = 0; i < this.tasks.size(); ++i) {
                vector.addElement(this.getNthTask(i));
            }
            objectOutputStream.writeObject(vector);
            objectOutputStream.flush();
            outputStream.flush();
        }
        catch (Exception exception) {
            throw new AppDeploymentException(AppUtils.getMessage((ResourceBundle)this.resBundle, (String)"ADMA0099E", (Object[])new Object[]{exception}), (Throwable)exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDeploymentPlan");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readDeploymentPlan(File file) throws AppDeploymentException {
        if (file == null) {
            if (!tc.isDebugEnabled()) return;
            Tr.exit(tc, "Null depl plan.");
            return;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            this.readDeploymentPlan(fileInputStream);
            if (fileInputStream == null) return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                throw new AppDeploymentException("", (Throwable)fileNotFoundException);
            }
            catch (Throwable throwable) {
                if (fileInputStream == null) throw throwable;
                try {
                    fileInputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw new AppDeploymentException(AppUtils.getMessage((ResourceBundle)this.resBundle, (String)"ADMA0100E", (Object[])new Object[]{iOException}), (Throwable)iOException);
                }
            }
        }
        try {
            fileInputStream.close();
            return;
        }
        catch (IOException iOException) {
            throw new AppDeploymentException(AppUtils.getMessage((ResourceBundle)this.resBundle, (String)"ADMA0100E", (Object[])new Object[]{iOException}), (Throwable)iOException);
        }
    }

    public void readDeploymentPlan(InputStream inputStream) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readDeploymentPlan");
        }
        try {
            Module module;
            Object object;
            if (inputStream == null || inputStream.available() == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.exit(tc, "Null depl plan.");
                }
                return;
            }
            WsObjectInputStream wsObjectInputStream = new WsObjectInputStream(inputStream);
            Hashtable hashtable = (Hashtable)wsObjectInputStream.readObject();
            this.getAppOptions().putAll(hashtable);
            Vector vector = (Vector)wsObjectInputStream.readObject();
            String string = (String)hashtable.get("appdeplStandaloneURI");
            String string2 = null;
            if (string != null) {
                Vector vector2 = this.deploymentInfo.getAllURIStrings();
                if (vector2.size() > 0) {
                    string2 = (String)vector2.firstElement();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "oldStandaloneURI: " + string + " and newStandaloneURI: " + string2);
                }
            }
            for (int i = 0; i < vector.size(); ++i) {
                object = (AppDeploymentTask)vector.elementAt(i);
                AppDeploymentTask appDeploymentTask = null;
                for (int j = 0; j < this.tasks.size(); ++j) {
                    AppDeploymentTask appDeploymentTask2 = (AppDeploymentTask)this.tasks.elementAt(j);
                    if (!((AppDeploymentTask)object).getName().equals(appDeploymentTask2.getName())) continue;
                    appDeploymentTask = appDeploymentTask2;
                    break;
                }
                if (appDeploymentTask == null) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "No matching task for " + ((AppDeploymentTask)object).getName());
                    continue;
                }
                if (string != null && string2 != null) {
                    appDeploymentTask.setTaskData(this.patchStandaloneData(((AppDeploymentTask)object).getTaskData(), string, string2));
                    continue;
                }
                appDeploymentTask.setTaskData(((AppDeploymentTask)object).getTaskData());
            }
            if (string != null && this.deploymentInfo.getApplication().getModules().size() == 1 && this.getAppOptions().get("contextroot") != null && (module = (Module)this.deploymentInfo.getApplication().getModules().get(0)).isWebModule()) {
                object = (String)this.getAppOptions().get("contextroot");
                ((WebModule)module).setContextRoot((String)object);
            }
        }
        catch (Exception exception) {
            throw new AppDeploymentException(AppUtils.getMessage((ResourceBundle)this.resBundle, (String)"ADMA0100E", (Object[])new Object[]{exception}), (Throwable)exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readDeploymentPlan");
        }
    }

    private String[][] patchStandaloneData(String[][] stringArray, String string, String string2) {
        if (stringArray == null) {
            return null;
        }
        String string3 = null;
        String string4 = null;
        try {
            String[] stringArray2 = string.split(",");
            string3 = stringArray2[0];
            stringArray2 = string2.split(",");
            string4 = stringArray2[0];
        }
        catch (Exception exception) {
            string3 = null;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < stringArray[i].length; ++j) {
                if (string.equals(stringArray[i][j])) {
                    stringArray[i][j] = string2;
                    continue;
                }
                if (string3 == null || !string3.equals(stringArray[i][j])) continue;
                stringArray[i][j] = string4;
            }
        }
        return stringArray;
    }

    public List getSelectedOptions() {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        ArrayList<String> arrayList;
        block12: {
            arrayList = new ArrayList<String>();
            bl5 = false;
            bl4 = false;
            bl3 = false;
            bl2 = false;
            bl = true;
            try {
                AppDeploymentOptions appDeploymentOptions = (AppDeploymentOptions)this.getTaskByName("AppDeploymentOptions", false);
                if (!appDeploymentOptions.isTaskDisabled() && appDeploymentOptions.isEJBDeployEnabled()) {
                    bl5 = true;
                }
                if (!appDeploymentOptions.isTaskDisabled() && appDeploymentOptions.isPreCompileJSPEnabled()) {
                    bl4 = true;
                }
                if (!appDeploymentOptions.isTaskDisabled() && appDeploymentOptions.isWSDeployEnabled()) {
                    bl3 = true;
                }
                if (!appDeploymentOptions.isTaskDisabled() && appDeploymentOptions.isUseBinaryConfigEnabled()) {
                    bl2 = true;
                }
                if (!appDeploymentOptions.isTaskDisabled() && !appDeploymentOptions.isProcessEmbeddedCFG()) {
                    bl = false;
                }
            }
            catch (AppDeploymentException appDeploymentException) {
                if (!tc.isDebugEnabled()) break block12;
                Tr.debug(tc, "Exception when calling getTaskByName: " + (Object)((Object)appDeploymentException));
            }
        }
        if (bl5) {
            arrayList.add("deployejb");
        }
        if (bl4) {
            arrayList.add("preCompileJSPs");
        }
        if (bl3) {
            arrayList.add("deployws");
        }
        if (bl2) {
            arrayList.add("useMetaDataFromBinary");
        }
        if (bl) {
            arrayList.add("processEmbeddedConfig");
        }
        return arrayList;
    }

    public int getAppVersion() {
        int n = ((XMLResource)this.deploymentInfo.getApplication().eResource()).getVersionID();
        Tr.debug(tc, "AppVersion " + n);
        return n;
    }

    public int getAppVersion(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppVersion");
        }
        int n = this.getAppVersion();
        Tr.debug(tc, "AppVersion " + n);
        List list = this.getSelectedOptions();
        if (bl && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                String string = (String)list.get(i);
                if (!string.equals("deployejb") && !string.equals("preCompileJsp") && !((Object)list).equals("enhancedEar") && !((Object)list).equals("deployws") && !((Object)list).equals("useMetaDataFromBinary")) continue;
                return versionTable[versionTable.length - 1][0];
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAppVersion " + n);
        }
        return n;
    }

    public int getRarVersion() throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRarVersion");
        }
        int n = 99;
        int n2 = 15;
        Vector vector = this.deploymentInfo.getModuleConfig("RAR_DD");
        if (vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                Connector connector2 = (Connector)vector.elementAt(i);
                n = connector2.getVersionID();
                if (n < n2) continue;
                n = n2;
            }
        }
        Tr.debug(tc, "the highest rar version " + n);
        return n;
    }

    public Hashtable getServerTable() throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerTable");
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        int n = this.taskNames.indexOf("MapModulesToServers");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "index for mapmod task: " + n);
        }
        if (n < 0) {
            return hashtable;
        }
        AppDeploymentTask appDeploymentTask = (AppDeploymentTask)this.tasks.elementAt(n);
        if (appDeploymentTask.getTaskData() == null && !appDeploymentTask.isTaskEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Task not prepared .. return whats in options");
            }
            Hashtable<String, String> hashtable2 = (Hashtable<String, String>)this.getAppOptions().get("moduleToServer");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " table is : " + hashtable2);
            }
            return hashtable2 != null ? hashtable2 : hashtable;
        }
        if (appDeploymentTask.isTaskEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Task empty");
            }
            return hashtable;
        }
        String[][] stringArray = appDeploymentTask.getTaskData();
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            if (stringArray[i][2] == null || stringArray[i][2].equals("") || (string = stringArray[i][2]).indexOf(58) == -1 && string.indexOf(44) == -1) continue;
            hashtable.put(util.createUniqueModuleNameFromUriString((String)stringArray[i][1]), string);
        }
        Tr.debug(tc, "servertbl " + hashtable.toString());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerTable");
        }
        return hashtable;
    }

    public AdminClient getAdminClient() {
        return this.adminClient;
    }

    public Session getConfigSession() {
        return this.configSession;
    }

    public ConfigService getConfigService() throws Exception {
        if (this.configService == null && ConfigServiceFactory.getConfigService() != null) {
            this.configService = ConfigServiceFactory.getConfigService();
        }
        return this.configService;
    }

    public boolean checkIfEnhancedEar() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkIfEnhancedEar");
        }
        boolean bl = false;
        if (this.deploymentInfo instanceof ArchiveDeploymentInfo) {
            bl = ((ArchiveDeploymentInfo)this.deploymentInfo).checkIfEnhancedEar();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkIfEnhancedEar", new Object[]{new Boolean(bl)});
        }
        return bl;
    }

    public Resource getEnhancedEarDeploymentResource(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEnhancedEarDeploymentResource", new Object[]{string});
        }
        Resource resource = null;
        if (this.deploymentInfo instanceof ArchiveDeploymentInfo) {
            resource = ((ArchiveDeploymentInfo)this.deploymentInfo).getEnhancedEarDeploymentResource(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEnhancedEarDeploymentResource", new Object[]{resource});
        }
        return resource;
    }

    public void postAllPrepareTask(AppDeploymentInfo appDeploymentInfo, AppDeploymentTask appDeploymentTask) {
        String string;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "postAllPrepareTask", new Object[]{appDeploymentTask});
        }
        Hashtable hashtable = null;
        String string2 = appDeploymentTask.getName();
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "TaskName:  ", string2);
        }
        if (appDeploymentTask.getTaskData() == null && tc.isEntryEnabled()) {
            Tr.debug(tc, "TaskData is null for following task:  " + appDeploymentTask.getName() + "!!! NOTHING TO DO!!!  This task doesn't apply!!!");
        }
        if (this.dh == null || this.dh.getProps() == null || this.dh.getProps().isEmpty()) {
            try {
                if (!((ArchiveDeploymentInfo)appDeploymentInfo).containsURI(null, "META-INF/ibm-was-config.props") && tc.isEntryEnabled()) {
                    Tr.debug(tc, "No property based config file was found.");
                }
                object = ((ArchiveDeploymentInfo)appDeploymentInfo).getInputStream(null, "META-INF/ibm-was-config.props");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "property config file stored under META-INF/ibm-was-config.props");
                }
                string = "Application";
                this.dh.setProps(ConfigPropertiesHelper.getPropertiesByResourceType((InputStream)object, string));
                ((InputStream)object).close();
            }
            catch (AppDeploymentException appDeploymentException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "no property based config file was found in the archive!!!");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "postAllPrepareTask");
                }
            }
            catch (Throwable throwable) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Following throwable received in prepare task:", throwable);
                }
                return;
            }
        }
        if ((hashtable = (Hashtable)this.dh.getProps().get(string2)) != null && !hashtable.isEmpty()) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "TaskInfo:  ", hashtable);
            }
            if (string2.equals("AppDeploymentOptions")) {
                this.processSpecialTaskOption(appDeploymentTask, hashtable);
            } else {
                object = hashtable.keys();
                while (object.hasMoreElements()) {
                    string = (String)object.nextElement();
                    String[] stringArray = string.toLowerCase().split("row");
                    if (stringArray == null || stringArray.length != 2 || stringArray[1].equals("0")) continue;
                    try {
                        int n;
                        if (tc.isEntryEnabled()) {
                            Tr.debug(tc, "taskData length:  " + appDeploymentTask.getTaskData().length + "rowKey:" + stringArray[1]);
                        }
                        boolean[] blArray = appDeploymentTask.getMutableColumns();
                        String string3 = null;
                        for (n = 0; n < appDeploymentTask.getColumnNames().length; ++n) {
                            string3 = string3 + ", " + appDeploymentTask.getColumnNames()[n];
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.debug(tc, "taskData mutables:  ", string3);
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.debug(tc, "taskData mutables:  ", blArray);
                        }
                        n = 0;
                        for (n = blArray.length; n > 0 && blArray[n - 1]; --n) {
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.debug(tc, "mutalbes last column:  ", n - 1);
                        }
                        String[] stringArray2 = (String[])hashtable.get(string);
                        for (int i = 0; i < stringArray2.length; ++i) {
                            if (!tc.isEntryEnabled()) continue;
                            Tr.debug(tc, "Data found:  ", stringArray2[i]);
                        }
                        if (stringArray2.length < n) {
                            if (!tc.isEntryEnabled()) break;
                            Tr.debug(tc, "Incompatible length of config property data: " + stringArray2.length + " and mutable column: " + (n - 1));
                            break;
                        }
                        String[][] stringArray3 = appDeploymentTask.getTaskData();
                        int n2 = this.isRowMatch(blArray, stringArray2, stringArray3);
                        if (n2 == -1) continue;
                        for (int i = 0; i < stringArray2.length; ++i) {
                            if (blArray[i]) {
                                if (appDeploymentTask.getTaskData()[n2][i] == null || appDeploymentTask.getTaskData()[n2][i].trim().equals("") || appDeploymentTask.getTaskData()[n2][i].equals("null")) continue;
                                if (tc.isEntryEnabled()) {
                                    Tr.debug(tc, "Data modified from:  " + appDeploymentTask.getTaskData()[n2][i] + "  to: " + stringArray2[i]);
                                }
                                stringArray3[n2][i] = stringArray2[i];
                                appDeploymentTask.setTaskData(stringArray3);
                                continue;
                            }
                            if (!tc.isEntryEnabled()) continue;
                            Tr.debug(tc, "Data is not mutable!", stringArray2[i]);
                        }
                    }
                    catch (Throwable throwable) {
                        if (tc.isEntryEnabled()) {
                            Tr.debug(tc, "ignore following row:  ", stringArray[0]);
                        }
                        if (!tc.isEntryEnabled()) continue;
                        Tr.debug(tc, "EXCEPTION:  ", throwable);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "postAllPrepareTask");
        }
    }

    private void processSpecialTaskOption(AppDeploymentTask appDeploymentTask, Hashtable<String, String[]> hashtable) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processSpecialTaskOption", new Object[]{appDeploymentTask, hashtable});
        }
        String[] stringArray = this.storeColumnName(hashtable);
        String[] stringArray2 = appDeploymentTask.getColumnNames();
        List<String> list = this.getAllUnmutableColumns(appDeploymentTask);
        List<String> list2 = this.getUnmutableColumnNames(stringArray, list);
        Enumeration<String> enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            String[] stringArray3 = string.toLowerCase().split("row");
            if (stringArray3 == null || stringArray3.length != 2 || stringArray3[1].equals("0")) continue;
            try {
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "taskData length:  " + appDeploymentTask.getTaskData().length + "rowKey:" + stringArray3[1]);
                }
                String[] stringArray4 = hashtable.get(string);
                for (int i = 1; i < appDeploymentTask.getTaskData().length; ++i) {
                    for (int j = 0; j < stringArray.length; ++j) {
                        if (!list2.contains(stringArray[j])) {
                            if (tc.isEntryEnabled()) {
                                Tr.debug(tc, "Updating column name:  ", stringArray[j]);
                            }
                            for (int k = 0; k < stringArray2.length; ++k) {
                                if (stringArray2[k].equals(stringArray[j])) {
                                    if (stringArray4[j] != null && !stringArray4[j].trim().equals("*")) {
                                        if (tc.isEntryEnabled()) {
                                            Tr.debug(tc, "Data modified from:  " + appDeploymentTask.getTaskData()[i][k] + "  to: " + stringArray4[j]);
                                        }
                                        String[][] stringArray5 = appDeploymentTask.getTaskData();
                                        stringArray5[i][k] = stringArray4[j];
                                        appDeploymentTask.setTaskData(stringArray5);
                                    }
                                    appDeploymentTask.getTaskData()[i][k] = stringArray4[j];
                                    continue;
                                }
                                if (!tc.isEntryEnabled()) continue;
                                Tr.debug(tc, "Ignore following column:  ", stringArray2[k]);
                            }
                            continue;
                        }
                        if (!tc.isEntryEnabled()) continue;
                        Tr.debug(tc, "unmutable column encountered:  ", stringArray2[j]);
                    }
                }
            }
            catch (Throwable throwable) {
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "ignore following row:  ", stringArray3[0]);
                }
                if (!tc.isEntryEnabled()) continue;
                Tr.debug(tc, "EXCEPTION:  ", throwable);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processSpecialTaskOption");
        }
    }

    private List<String> getUnmutableColumnNames(String[] stringArray, List<String> list) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUnmutableColumnNames", new Object[]{stringArray, list});
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!list.contains(stringArray[i])) continue;
                arrayList.add(stringArray[i]);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUnmutableColumnNames", arrayList);
        }
        return arrayList;
    }

    private List<String> getAllUnmutableColumns(AppDeploymentTask appDeploymentTask) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllUnmutableColumns", appDeploymentTask);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = appDeploymentTask.getColumnNames();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (appDeploymentTask.getMutableColumns(i)) continue;
                arrayList.add(stringArray[i]);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllUnmutableColumns", arrayList);
        }
        return arrayList;
    }

    private String[] storeColumnName(Hashtable<String, String[]> hashtable) {
        String[] stringArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "storeColumnName", hashtable);
        }
        if ((stringArray = hashtable.get("row0")) == null) {
            stringArray = hashtable.get("ROW0");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processSpecialTaskOption", stringArray);
        }
        return stringArray;
    }

    private int isRowMatch(boolean[] blArray, String[] stringArray, String[][] stringArray2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isRowMatch", new Object[]{blArray, stringArray, stringArray2});
        }
        int n = -1;
        for (int i = 0; i < stringArray2.length; ++i) {
            for (int j = 0; j < blArray.length; ++j) {
                if (!blArray[j]) {
                    if (tc.isEntryEnabled()) {
                        Tr.debug(tc, "data found:  ", new Object[]{stringArray[j], stringArray2[i][j]});
                    }
                    if (!stringArray[j].trim().equals("*") && !stringArray[j].trim().equals(stringArray2[i][j].trim())) break;
                    if (!stringArray[j].trim().equals("*")) {
                        n = i;
                        continue;
                    }
                    if (i == 0 || j != blArray.length - 1) continue;
                    n = i;
                    continue;
                }
                if (!tc.isEntryEnabled()) continue;
                Tr.debug(tc, "This row is mutable, so ignore this one:  ", new Object[]{blArray[j], i});
            }
            if (n != -1) break;
            n = -1;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isRowMatch", new Object[]{n});
        }
        return n;
    }

    public void setVariableMap(Vector vector) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setVariableMap", new Object[]{vector});
        }
        if (vector != null && !vector.isEmpty() && this.dh != null && this.dh.getVariableMap() != null && !this.dh.getVariableMap().isEmpty()) {
            for (AppDeploymentTask appDeploymentTask : vector) {
                String[][] stringArray;
                if (!appDeploymentTask.getName().equals("PropertyBasedConfig") || (stringArray = appDeploymentTask.getTaskData()) == null) continue;
                HashMap hashMap = this.dh.getVariableMap();
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = "!{" + stringArray[i][0] + "}";
                    if (!hashMap.containsKey(string)) continue;
                    hashMap.put(string, stringArray[i][1]);
                }
                this.dh.setVariableMap(hashMap);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setVariableMap", new Object[]{this.dh.getVariableMap()});
        }
    }

    public AppDeploymentTask preAllCompleteTask(AppDeploymentTask appDeploymentTask) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "preAllCompleteTask", new Object[]{appDeploymentTask});
        }
        if (this.dh != null && !this.dh.getKeyVariableTuplet().isEmpty()) {
            int n;
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "task variable tuplet: ", this.dh.getKeyVariableTuplet());
            }
            HashMap hashMap = this.dh.getKeyVariableTuplet();
            Set set = hashMap.keySet();
            for (String[][] stringArray3 : set) {
                String[] stringArray2 = (String[])hashMap.get(stringArray3);
                for (n = 0; n < stringArray2.length; ++n) {
                    if (!tc.isEntryEnabled()) continue;
                    Tr.debug(tc, "Task Name: " + (String)stringArray3 + " value:  ", stringArray2[n]);
                }
            }
            String[] stringArray = (String[])hashMap.get(appDeploymentTask.getName());
            if (stringArray != null && stringArray.length > 0) {
                String[][] stringArray3;
                stringArray3 = appDeploymentTask.getTaskData();
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "TaskName:" + appDeploymentTask.getName() + " has variables: ", new Object[]{stringArray, stringArray3});
                }
                for (int i = 0; i < stringArray3.length; ++i) {
                    for (n = 0; n < stringArray3[i].length; ++n) {
                        for (int j = 0; j < stringArray.length; ++j) {
                            String string = stringArray3[i][n];
                            if (tc.isEntryEnabled()) {
                                Tr.debug(tc, "Data for task: ", string);
                            }
                            if (!string.contains(stringArray[j])) continue;
                            if (this.dh != null && this.dh.getVariableMap() != null) {
                                if (tc.isEntryEnabled()) {
                                    Tr.debug(tc, "replacing the variable:  :" + stringArray[j] + " with: " + (String)this.dh.getVariableMap().get(stringArray[j]));
                                }
                                stringArray3[i][n] = string.replace(stringArray[j], (CharSequence)this.dh.getVariableMap().get(stringArray[j]));
                                continue;
                            }
                            if (!tc.isEntryEnabled()) continue;
                            Tr.debug(tc, "Either dataHolder is null or variableMap is null");
                        }
                    }
                }
                appDeploymentTask.setTaskData(stringArray3);
            } else if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Task " + appDeploymentTask.getName() + " doesn't have any variables.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "preAllCompleteTask");
        }
        return appDeploymentTask;
    }

    public String[][] getModifiedTaskData(String string, String[][] stringArray) {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getModifiedTaskData", stringArray);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (AppDeploymentTask appDeploymentTask : this.tasks) {
            if (!appDeploymentTask.getName().equals("PropertyBasedConfig") || (object = appDeploymentTask.getTaskData()) == null) continue;
            for (int i = 0; i < ((String[][])object).length; ++i) {
                if (i == 0) continue;
                hashMap.put("!{" + (String)object[i][0] + "}", object[i][1]);
            }
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                for (int j = 0; j < stringArray[i].length; ++j) {
                    object = hashMap.keySet();
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        String string2 = stringArray[i][j];
                        String string3 = (String)iterator.next();
                        if (string2.contains(string3)) {
                            stringArray[i][j] = string2.replace(string3, (CharSequence)hashMap.get(string3));
                            continue;
                        }
                        if (!tc.isEntryEnabled()) continue;
                        Tr.debug(tc, "Either dataHolder is null or variableMap is null");
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getModifiedTaskData", stringArray);
        }
        return stringArray;
    }

    public void resetDataHolder() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resetDataHolder");
        }
        this.dh.setKeyVariableTuplet(new HashMap());
        this.dh.setPropFile(new Properties());
        this.dh.setProps(new Hashtable());
        this.dh.setVariableMap(new HashMap());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resetDataHolder");
        }
    }

    public DataHolder getDataHolder() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDataHolder");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDataHolder");
        }
        return this.dh;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SOURCE CODE INFO: SERV1/ws/code/admin.appmgmt/src/com/ibm/websphere/management/application/client/AppDeploymentController.java, WAS.admin.installapp.client, WAS70.SERV1, q0834.18, ver. 1.67.2.16");
        }
        CLASS_NAME = AppDeploymentController.class.getName();
        encoderInit = false;
        propBasedConfig = false;
        versionTable = new int[][]{{12, 5}, {13, 5}, {14, 6}, {50, 6}};
    }
}

