/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.ws.management.AdminServiceFactoryInitializer;
import java.security.Permission;

public class AdminServiceFactory {
    private static TraceComponent tc = Tr.register(AdminServiceFactory.class, null, null);
    private static AdminService instance = null;
    private static WebSphereRuntimePermission adminPermission = new WebSphereRuntimePermission("AdminPermission");

    public static AdminService getAdminService() {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAdminService");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission((Permission)adminPermission);
        }
        String string = AdminServiceFactoryInitializer.getAdminType();
        String string2 = AdminContext.peek();
        if ("AdminAgent".equals(string) || string2 != null) {
            AdminService adminService = AdminServiceFactoryInitializer.createAdminService();
            if (adminService == null) {
                return null;
            }
            return AdminServiceFactoryInitializer.getProxy();
        }
        if (instance == null) {
            instance = AdminServiceFactoryInitializer.createAdminService();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAdminService", instance);
        }
        return instance;
    }

    public static MBeanFactory getMBeanFactory() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission((Permission)adminPermission);
        }
        String string = AdminContext.peek();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Profile key ", string);
        }
        if (string != null) {
            AdminService adminService;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getMBeanFactory", string);
            }
            if ((adminService = AdminServiceFactoryInitializer.createAdminService()) == null) {
                return null;
            }
            return adminService.getMBeanFactory();
        }
        if (instance == null) {
            return null;
        }
        return instance.getMBeanFactory();
    }
}

