/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cache.Cache;
import com.ibm.websphere.cache.DistributedMap;
import com.ibm.websphere.cache.DistributedNioMap;
import com.ibm.websphere.cache.DistributedObjectCache;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.ffdc.FFDCFilter;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public final class DynamicCacheAccessor {
    private static TraceComponent tc = Trace.register(DynamicCacheAccessor.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");

    public static Cache getCache() {
        if (DynamicCacheAccessor.isServletCachingEnabled()) {
            return ServerCache.cache;
        }
        return null;
    }

    public static boolean isCachingEnabled() {
        return ServerCache.servletCacheEnabled || ServerCache.objectCacheEnabled;
    }

    public static boolean isServletCachingEnabled() {
        return ServerCache.servletCacheEnabled;
    }

    public static boolean isObjectCachingEnabled() {
        return ServerCache.objectCacheEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static DistributedMap getDistributedMap() {
        if (DynamicCacheAccessor.tc.isEntryEnabled()) {
            Tr.entry(DynamicCacheAccessor.tc, "getDistributedMap() isObjectCachingEnabled=" + DynamicCacheAccessor.isObjectCachingEnabled());
        }
        var1 = null;
        var2_1 = null;
        if (DynamicCacheAccessor.isObjectCachingEnabled()) {
            try {
                var2_1 = new InitialContext();
                var1 = (DistributedObjectCache)var2_1.lookup("services/cache/distributedmap");
            }
            catch (NamingException var3_3) {
                FFDCFilter.processException((Throwable)var3_3, (String)"com.ibm.websphere.cache.DynamicCacheAccessor.getDistributedMap", (String)"99", DynamicCacheAccessor.class);
                if (!DynamicCacheAccessor.tc.isDebugEnabled()) ** GOTO lbl27
                var3_3.printStackTrace();
            }
            finally {
                block16: {
                    try {
                        if (var2_1 != null) {
                            var2_1.close();
                        }
                    }
                    catch (NamingException var3_4) {
                        FFDCFilter.processException((Throwable)var3_4, (String)"com.ibm.websphere.cache.DynamicCacheAccessor.getDistributedMap", (String)"110", DynamicCacheAccessor.class);
                        if (!DynamicCacheAccessor.tc.isDebugEnabled()) break block16;
                        var3_4.printStackTrace();
                    }
                }
            }
        } else {
            Tr.error(DynamicCacheAccessor.tc, "DYNA1060E", new Object[]{"services/cache/distributedmap"});
        }
lbl27:
        // 4 sources

        if (DynamicCacheAccessor.tc.isEntryEnabled()) {
            Tr.exit(DynamicCacheAccessor.tc, "getDistributedMap() distributedMap=" + var1);
        }
        return var1;
    }

    public static DistributedNioMap getProxyCacheInstance(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProxyCacheInstance name: " + string);
        }
        DistributedNioMap distributedNioMap = null;
        if (DynamicCacheAccessor.isObjectCachingEnabled()) {
            String string2 = AdminServiceFactory.getAdminService().getServerType();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getProxyCacheInstance is executing in a " + string2 + ".");
            }
            if ("PROXY_SERVER".equals(string2) || "ONDEMAND_ROUTER".equals(string2)) {
                try {
                    distributedNioMap = (DistributedNioMap)ServerCache.cacheUnit.createObjectCache(string);
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Could not load the config from cacheName=" + string);
                    }
                    Tr.error(tc, "DYNA1003E", new Object[]{string, exception});
                }
            }
        } else {
            Tr.error(tc, "DYNA1060E", new Object[]{string});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProxyCacheInstance returning map:" + distributedNioMap);
        }
        return distributedNioMap;
    }
}

