/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.ant.tasks;

import com.ibm.websphere.ant.tasks.Messages;
import com.ibm.ws.ant.utils.OsUtils;
import com.ibm.ws.ant.utils.ProjectUtils;
import com.ibm.ws.ant.utils.StrUtils;
import com.ibm.ws.ant.utils.WasUtils;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;

public class WsAdmin
extends Task {
    String wasHome;
    boolean failonerror = false;
    String command;
    String properties;
    String profile;
    String profileName = null;
    String script;
    String lang;
    String conntype;
    String host;
    String port;
    String user;
    String password;
    String jvmMaxMemory = "256M";
    String fileEncoding = null;
    private boolean debug = false;
    private Commandline arguments = new Commandline();
    private Commandline jvmArguments = new Commandline();
    WasUtils wasUtils = new WasUtils();

    public void execute() throws BuildException {
        String[] stringArray;
        Object object;
        if (this.command == null && this.script == null) {
            ProjectUtils.reportError((Project)this.getProject(), (boolean)this.failonerror, (String)Messages.getString("Either_the_command_or_script_attribute_must_be_specified._1"));
            return;
        }
        if (this.command != null && this.script != null) {
            ProjectUtils.reportError((Project)this.getProject(), (boolean)this.failonerror, (String)Messages.getString("The_command_and_script_attributes_cannot_be_specified_at_the_same_time._2"));
            return;
        }
        if ((this.host != null || this.port != null) && this.conntype == null) {
            ProjectUtils.reportError((Project)this.getProject(), (boolean)this.failonerror, (String)Messages.getString("The_host/port_attributes_are_only_applicable_if_the_conntype_attribute_is_set._3"));
            return;
        }
        if (this.user == null && this.password != null || this.user != null && this.password == null) {
            ProjectUtils.reportError((Project)this.getProject(), (boolean)this.failonerror, (String)Messages.getString("If_one_of_userid_or_password_is_specified,_both_attributes_must_be_specified._4"));
            return;
        }
        if (!(this.conntype == null || this.conntype.equalsIgnoreCase("SOAP") || this.conntype.equalsIgnoreCase("RMI") || this.conntype.equalsIgnoreCase("JMS") || this.conntype.equalsIgnoreCase("NONE"))) {
            ProjectUtils.reportError((Project)this.getProject(), (boolean)this.failonerror, (String)Messages.getString("The_valid_values_for_the_conntype_attribute_are_SOAP,_RMI,_JMS,_or_NONE._9"));
            return;
        }
        if (this.wasHome == null) {
            this.wasHome = WasUtils.getDefaultWasInstallHome((Project)this.getProject());
            if (this.wasHome == null) {
                ProjectUtils.reportError((Project)this.getProject(), (boolean)this.failonerror, (String)Messages.getString("Unable_to_determine_WAS_Home_directory._Please_use_the_wasHome_task_attribute_or_set_the_was.root_System_property._21"));
                return;
            }
        }
        if (this.profileName != null) {
            WasUtils.setProfileHome((String)this.profileName.toString(), (String)this.wasHome);
            if (WasUtils.getProfileHome() == null) {
                ProjectUtils.reportError((Project)this.getProject(), (boolean)this.failonerror, (String)("WSProfileException profileName=" + this.profileName));
                return;
            }
        }
        Java java = new Java();
        java.setProject(this.getProject());
        java.setTaskName("wsadmin");
        java.setOwningTarget(this.getOwningTarget());
        java.setLocation(this.getLocation());
        this.wasUtils.parseSetupCmdLine(this.wasHome, this.profileName, this.getProject(), this.failonerror);
        this.wasHome = StrUtils.cleanPath((String)this.wasHome, (boolean)false);
        String string = System.getProperty("was.ant.extra.classpath");
        if (string == null || string.length() <= 0) {
            string = this.wasUtils.getSCLAttr("WAS_ANT_EXTRA_CLASSPATH");
        }
        String string2 = this.wasUtils.getSCLAttr("USER_INSTALL_ROOT");
        if (this.profileName != null) {
            string2 = WasUtils.getDefaultWasUserHome();
        }
        Path path = new Path(this.getProject(), string);
        if (string2 != null) {
            path.add(new Path(this.getProject(), new File(string2, "properties").toString()));
        }
        path.add(new Path(this.getProject(), this.wasUtils.getSCLAttr("WAS_CLASSPATH")));
        path.add(new Path(this.getProject(), new File(this.wasUtils.getSCLAttr("ITP_LOC"), "batchboot.jar").toString()));
        path.add(new Path(this.getProject(), new File(this.wasUtils.getSCLAttr("ITP_LOC"), "batch2.jar").toString()));
        java.setClasspath(path);
        java.setClassname("com.ibm.wsspi.bootstrap.WSPreLauncher");
        java.setDir(new File(this.getProject().getProperty("basedir")));
        java.setFailonerror(this.failonerror);
        java.setFork(true);
        if (!OsUtils.isOS400()) {
            java.setMaxmemory(this.jvmMaxMemory);
        }
        Commandline.Argument argument = null;
        if (OsUtils.isOS400()) {
            argument = java.createJvmarg();
            argument.setValue("-Dcom.ibm.ws.scripting.wsadminprops=" + this.wasUtils.getSCLAttr("USER_INSTALL_ROOT") + "/properties/wsadmin.properties");
        }
        argument = java.createJvmarg();
        argument.setValue("-Dlocal.cell=" + this.wasUtils.getSCLAttr("WAS_CELL"));
        argument = java.createJvmarg();
        argument.setValue("-Dlocal.node=" + this.wasUtils.getSCLAttr("WAS_NODE"));
        argument = java.createJvmarg();
        argument.setValue("-Dcom.ibm.etools.EJBDeploy.debug=true");
        argument = java.createJvmarg();
        argument.setValue("-Dcom.ibm.itp.location=" + this.wasUtils.getSCLAttr("ITP_LOC"));
        if (OsUtils.isOS400()) {
            argument = java.createJvmarg();
            argument.setValue("-Dcom.ibm.wsspi.bootstrap.script=wsadmin");
        }
        if (Boolean.getBoolean("debug.wsadmin.anttask")) {
            argument = java.createJvmarg();
            argument.setValue("-Djava.compiler=NONE");
            argument = java.createJvmarg();
            argument.setValue("-Xdebug");
            argument = java.createJvmarg();
            argument.setValue("-Xnoagent");
            argument = java.createJvmarg();
            argument.setValue("-Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=7777");
        }
        if (OsUtils.isZOS()) {
            argument = java.createJvmarg();
            argument.setValue("-Dwas.repository.root=" + this.wasUtils.getSCLAttr("CONFIG_ROOT"));
            argument = java.createJvmarg();
            argument.setValue("-Dserver.root=" + this.wasUtils.getSCLAttr("WAS_HOME"));
            argument = java.createJvmarg();
            argument.setValue("-Djava.home=" + this.wasUtils.getSCLAttr("JAVA_HOME"));
        }
        argument = java.createJvmarg();
        try {
            object = null;
            object = OsUtils.isOS400() ? this.wasUtils.getSCLAttr("COMPUTERNAME") : InetAddress.getLocalHost().getHostName();
            argument.setValue("-Dcom.ibm.CORBA.BootstrapHost=" + (String)object);
        }
        catch (UnknownHostException unknownHostException) {
            argument.setValue("-Dcom.ibm.CORBA.BootstrapHost=localhost");
        }
        argument = java.createJvmarg();
        argument.setValue("-Dcom.ibm.ws.management.standalone=true");
        this.wasUtils.addJVMArgs(java, this.wasHome, this.fileEncoding);
        object = java.createArg();
        ((Commandline.Argument)object).setValue("-nosplash");
        object = java.createArg();
        ((Commandline.Argument)object).setValue("-application");
        object = java.createArg();
        ((Commandline.Argument)object).setValue("com.ibm.ws.bootstrap.WSLauncher");
        object = java.createArg();
        ((Commandline.Argument)object).setValue("com.ibm.ws.admin.services.WsAdmin");
        Vector<String> vector = new Vector<String>();
        if (this.command != null) {
            vector.addElement("-c");
            vector.addElement(this.command.toString());
        }
        if (this.properties != null && !this.properties.equals("")) {
            vector.addElement("-p");
            vector.addElement(this.properties.toString());
        }
        if (this.profile != null && !this.profile.equals("")) {
            vector.addElement("-profile");
            vector.addElement(this.profile.toString());
        }
        if (this.script != null) {
            vector.addElement("-f");
            vector.addElement(this.script.toString());
        }
        if (this.lang != null && !this.lang.equals("")) {
            vector.addElement("-lang");
            vector.addElement(this.lang.toString());
        }
        if (this.conntype != null && !this.conntype.equals("")) {
            vector.addElement("-conntype");
            vector.addElement(this.conntype.toString());
            if (this.host != null && !this.host.equals("")) {
                vector.addElement("-host");
                vector.addElement(this.host.toString());
            }
            if (this.port != null && !this.port.equals("")) {
                vector.addElement("-port");
                vector.addElement(this.port.toString());
            }
        }
        if (this.user != null && !this.user.equals("")) {
            vector.addElement("-user");
            vector.addElement(this.user.toString());
        }
        if (this.password != null && !this.password.equals("")) {
            vector.addElement("-password");
            vector.addElement(this.password.toString());
        }
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            stringArray = java.createArg();
            stringArray.setValue((String)iterator.next());
        }
        stringArray = this.jvmArguments.getArguments();
        for (int i = 0; i < stringArray.length; ++i) {
            Commandline.Argument argument2 = java.createJvmarg();
            argument2.setValue(stringArray[i]);
        }
        String[] stringArray2 = this.arguments.getArguments();
        for (int i = 0; i < stringArray2.length; ++i) {
            Commandline.Argument argument3 = java.createArg();
            argument3.setValue(stringArray2[i]);
        }
        if (this.isDebug()) {
            String[] stringArray3 = java.getCommandLine().getCommandline();
            for (int i = 0; i < stringArray3.length; ++i) {
                System.out.println("jvm args > " + stringArray3[i]);
            }
        }
        java.execute();
    }

    public void setWasHome(String string) {
        this.wasHome = string;
    }

    public void setFailonerror(boolean bl) {
        this.failonerror = bl;
    }

    public void setCommand(String string) {
        this.command = string;
    }

    public void setProperties(String string) {
        this.properties = string;
    }

    public void setProfile(String string) {
        this.profile = string;
    }

    public void setProfileName(String string) {
        this.profileName = string;
    }

    public void setScript(String string) {
        this.script = string;
    }

    public void setLang(String string) {
        this.lang = string;
    }

    public void setConntype(String string) {
        this.conntype = string;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public void setPort(String string) {
        this.port = string;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public Commandline.Argument createArg() {
        return this.arguments.createArgument();
    }

    public Commandline.Argument createJvmarg() {
        return this.jvmArguments.createArgument();
    }

    public void setJvmMaxMemory(String string) {
        this.jvmMaxMemory = string;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setFileEncoding(String string) {
        this.fileEncoding = string;
    }
}

