/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.ant.tasks;

import com.ibm.websphere.ant.tasks.Messages;
import com.ibm.websphere.ant.tasks.WsAdmin;
import com.ibm.ws.ant.utils.OsUtils;
import com.ibm.ws.ant.utils.ProjectUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Commandline;

public class InstallApplication
extends WsAdmin {
    String ear;
    String options;

    public void setCommand(String string) {
    }

    public void setLang(String string) {
    }

    public void setScript(String string) {
    }

    public void setEar(String string) {
        this.ear = string;
    }

    public void execute() throws BuildException {
        if (this.ear == null) {
            ProjectUtils.reportError((Project)this.getProject(), (boolean)this.failonerror, (String)Messages.getString("WSANTMissing_required_attribute__ear_1"));
            return;
        }
        File file = new File(this.ear);
        if (!file.exists()) {
            ProjectUtils.reportError((Project)this.getProject(), (boolean)this.failonerror, (String)Messages.getString("WSANTThe_ear_attribute_must_reference_and_existing_EAR_file_2"));
            return;
        }
        if (file.isDirectory()) {
            ProjectUtils.reportError((Project)this.getProject(), (boolean)this.failonerror, (String)Messages.getString("WSANTThe_ear_attribute_must_reference_a_file,_not_a_directory_3"));
            return;
        }
        super.setLang("jacl");
        try {
            File file2 = File.createTempFile("wsant", "jacl");
            PrintWriter printWriter = OsUtils.isZOS() ? new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2), "ISO-8859-1")) : new PrintWriter(new FileWriter(file2));
            String string = file.getAbsolutePath();
            string = string.replace('\\', '/');
            if (this.options != null) {
                printWriter.println("$AdminApp install " + this.getEarFileProperlyQuoted() + " " + this.getOptionsProperlyQuoted());
            } else {
                printWriter.println("$AdminApp install " + this.getEarFileProperlyQuoted());
            }
            printWriter.println("$AdminConfig save");
            printWriter.flush();
            printWriter.close();
            super.setScript(file2.getAbsolutePath());
            this.log(Messages.getString("WSANTInstalling_Application_[_13") + file.getAbsolutePath() + "]...", 2);
            super.execute();
            this.log(Messages.getString("WSANTInstalled_Application_[_15") + file.getAbsolutePath() + "]", 2);
            file2.delete();
        }
        catch (IOException iOException) {
            ProjectUtils.reportError((Project)this.getProject(), (boolean)this.failonerror, (String)(Messages.getString("WSANTError_Installing_Application___17") + iOException.getMessage()));
        }
    }

    public void setOptions(String string) {
        this.options = string;
    }

    public Commandline.Argument createArg() {
        return null;
    }

    private String getEarFileProperlyQuoted() {
        String string = null;
        if (this.ear != null) {
            string = new File(this.ear).getAbsolutePath();
            if ((string = string.replace('\\', '/')).indexOf(" ") != -1) {
                string = "\"" + string + "\"";
            }
        }
        return string;
    }

    private String getOptionsProperlyQuoted() {
        String string = this.options;
        if (this.isParenClosureQuotingNeeded(string)) {
            string = "\"" + string + "\"";
        }
        return string;
    }

    private boolean isParenClosureQuotingNeeded(String string) {
        boolean bl = true;
        int n = 0;
        if (string.startsWith("{") && string.endsWith("}")) {
            int n2;
            for (n2 = 0; n2 < string.length(); ++n2) {
                if (string.charAt(n2) != '{' && string.charAt(n2) != '}') continue;
                ++n;
            }
            if (n % 2 != 0) {
                this.log(Messages.getString("WSANTInstalling_Application_closure_error_in_options"), 1);
            } else {
                n = 1;
                for (n2 = 1; n2 < string.length(); ++n2) {
                    if (string.charAt(n2) == '{') {
                        ++n;
                        continue;
                    }
                    if (string.charAt(n2) != '}') continue;
                    if (--n == 0 && n2 != string.length() - 1) {
                        bl = true;
                        break;
                    }
                    if (n != 0 || n2 != string.length() - 1) continue;
                    bl = false;
                    break;
                }
            }
        }
        return bl;
    }
}

