/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.als;

import com.ibm.ejs.ras.Tr;
import com.ibm.websphere.als.AnalysisLogger;
import com.ibm.websphere.als.LogRecord;
import com.ibm.websphere.als.Logger;
import com.ibm.ws.ffdc.FFDCFilter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import javax.sql.DataSource;

public class DatabaseLogger
implements Logger {
    DataSource myDS = null;
    String myInsertSQL = null;
    String myUID = null;
    String myPWD = null;
    boolean myAutoDate;
    int myHttpDataSize = 256;
    int myCookieSize = 256;
    int myAppDataSize = 256;

    public DatabaseLogger(DataSource dataSource) {
        this(dataSource, null);
    }

    public DatabaseLogger(DataSource dataSource, String string) {
        this(dataSource, string, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseLogger(DataSource dataSource, String string, String string2, String string3, String string4) {
        this.myDS = dataSource;
        this.myUID = string3;
        this.myPWD = string4;
        boolean bl = this.myAutoDate = string != null;
        if (string2 == null) {
            string2 = "ALS";
        }
        if (!this.myAutoDate) {
            string = "?";
        }
        this.myInsertSQL = "insert into " + string2 + " (TMSTP, APPID, REQID, HTTPDATA, COOKIE, APPDATA)" + " values (" + string + ", ?, ?, ?, ?, ?)";
        Connection connection = null;
        try {
            connection = this.myUID == null ? this.myDS.getConnection() : this.myDS.getConnection(this.myUID, this.myPWD);
            int n = string2.indexOf(46);
            String string5 = n > 0 ? string2.substring(0, n) : null;
            String string6 = n > 0 ? string2.substring(n + 1) : string2;
            ResultSet resultSet = connection.getMetaData().getColumns(null, string5, string6, "%");
            while (resultSet.next()) {
                String string7 = resultSet.getString(4);
                if (string7.equalsIgnoreCase("HTTPDATA")) {
                    this.myHttpDataSize = resultSet.getInt(7) - 1;
                    continue;
                }
                if (string7.equalsIgnoreCase("COOKIE")) {
                    this.myCookieSize = resultSet.getInt(7) - 1;
                    continue;
                }
                if (!string7.equalsIgnoreCase("APPDATA")) continue;
                this.myAppDataSize = resultSet.getInt(7) - 1;
            }
            resultSet.close();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.als.DatabaseLogger.DatabaseLogger", (String)"197", (Object)this);
            if (AnalysisLogger.myTracer.isDebugEnabled()) {
                Tr.debug(AnalysisLogger.myTracer, exception.toString());
            }
        }
        finally {
            try {
                connection.close();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.als.DatabaseLogger.DatabaseLogger", (String)"204", (Object)this);
            }
            if (AnalysisLogger.myTracer.isDebugEnabled()) {
                Tr.debug(AnalysisLogger.myTracer, "Created a DatabaseLogger with table = " + string2 + ", userID = " + string3 + ", password = " + string4 + ", SQL Date Function = " + string + ", HTTPDATA size = " + this.myHttpDataSize + ", COOKIE size = " + this.myCookieSize + ", APPDATA size = " + this.myAppDataSize);
            }
        }
    }

    public void write(LogRecord[] logRecordArray) throws Exception {
        Statement statement = null;
        Connection connection = null;
        try {
            connection = this.myUID == null ? this.myDS.getConnection() : this.myDS.getConnection(this.myUID, this.myPWD);
            connection.setAutoCommit(false);
            statement = connection.prepareStatement(this.myInsertSQL);
            for (int i = 0; i < logRecordArray.length; ++i) {
                if (logRecordArray[i].httpData != null && logRecordArray[i].httpData.length() > this.myHttpDataSize) {
                    logRecordArray[i].httpData = this.truncate(logRecordArray[i].httpData, this.myHttpDataSize);
                }
                if (logRecordArray[i].cookie != null && logRecordArray[i].cookie.length() > this.myCookieSize) {
                    logRecordArray[i].cookie = this.truncate(logRecordArray[i].cookie, this.myCookieSize);
                }
                if (logRecordArray[i].appData != null && logRecordArray[i].appData.length() > this.myAppDataSize) {
                    logRecordArray[i].appData = this.truncate(logRecordArray[i].appData, this.myAppDataSize);
                }
                if (this.myAutoDate) {
                    statement.setString(1, logRecordArray[i].appID);
                    statement.setString(2, logRecordArray[i].reqID);
                    statement.setString(3, logRecordArray[i].httpData);
                    statement.setString(4, logRecordArray[i].cookie);
                    statement.setString(5, logRecordArray[i].appData);
                } else {
                    statement.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
                    statement.setString(2, logRecordArray[i].appID);
                    statement.setString(3, logRecordArray[i].reqID);
                    statement.setString(4, logRecordArray[i].httpData);
                    statement.setString(5, logRecordArray[i].cookie);
                    statement.setString(6, logRecordArray[i].appData);
                }
                statement.execute();
            }
            connection.commit();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.als.DatabaseLogger.write", (String)"279", (Object)this);
            if (AnalysisLogger.myTracer.isDebugEnabled()) {
                AnalysisLogger.debug(exception);
            }
            throw exception;
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.als.DatabaseLogger.write", (String)"290", (Object)this);
            }
            try {
                connection.close();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.als.DatabaseLogger.write", (String)"293", (Object)this);
            }
        }
    }

    public Object getStorageSource() {
        return this.myDS;
    }

    private String truncate(String string, int n) {
        int n2 = string.lastIndexOf(59, n);
        if (n2 == -1) {
            n2 = n - 1;
        }
        return string.substring(0, n2 + 1);
    }
}

