/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.als;

import com.ibm.ejs.ras.Tr;
import com.ibm.websphere.als.AnalysisLogger;
import com.ibm.websphere.als.LogRecord;
import com.ibm.websphere.als.Logger;
import com.ibm.websphere.servlet.event.ApplicationEvent;
import com.ibm.websphere.servlet.event.ApplicationListener;
import com.ibm.websphere.servlet.event.ServletContextEventSource;
import com.ibm.websphere.servlet.event.ServletInvocationEvent;
import com.ibm.websphere.servlet.event.ServletInvocationListener;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.Serializable;
import java.util.HashMap;
import javax.servlet.ServletContext;

public class BufferManager
implements ApplicationListener,
ServletInvocationListener {
    private Logger myLogger = null;
    private ServletContext myContext = null;
    private Exception myLastX = null;
    private long myLastFlush = 0L;
    private int myMaxEntries;
    private HashMap myCache = null;
    private static final int MAX_WAIT = 60000;

    public BufferManager(ServletContext servletContext, Logger logger, int n) {
        this.myContext = servletContext;
        this.myLogger = logger;
        this.myMaxEntries = n;
        this.myCache = new HashMap(this.myMaxEntries + this.myMaxEntries / 3);
        if (this.myContext != null) {
            this.myLastFlush = System.currentTimeMillis();
            this.addContextListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(LogRecord logRecord) throws Exception {
        block11: {
            Serializable serializable;
            if (this.myLastX != null) {
                this.myCache.clear();
                serializable = this.myLastX;
                this.myLastX = null;
                if (serializable != null) {
                    throw serializable;
                }
            }
            try {
                serializable = this.myCache;
                synchronized (serializable) {
                    Object v = this.myCache.get(logRecord.reqID);
                    if (v != null) {
                        LogRecord logRecord2 = (LogRecord)v;
                        if (logRecord2.httpData == null) {
                            logRecord2.httpData = logRecord.httpData;
                        }
                        if (logRecord2.cookie == null) {
                            logRecord2.cookie = logRecord.cookie;
                        }
                        logRecord2.appData = logRecord2.appData + logRecord.appData;
                    } else {
                        this.myCache.put(logRecord.reqID, logRecord);
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.als.BufferManager.log", (String)"118", (Object)this);
                if (!AnalysisLogger.myTracer.isDebugEnabled()) break block11;
                AnalysisLogger.debug(exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws Exception {
        int n;
        if (AnalysisLogger.myTracer.isEntryEnabled()) {
            Tr.entry(AnalysisLogger.myTracer, "BufferManager.flush() entry");
        }
        Object[] objectArray = null;
        HashMap hashMap = this.myCache;
        synchronized (hashMap) {
            if (this.myCache.size() > 0) {
                objectArray = this.myCache.values().toArray();
                this.myCache.clear();
            }
        }
        if (objectArray != null && (n = objectArray.length) > 0) {
            if (AnalysisLogger.myTracer.isDebugEnabled()) {
                Tr.debug(AnalysisLogger.myTracer, "storing " + n + " items");
            }
            LogRecord[] logRecordArray = new LogRecord[n];
            for (int i = 0; i < n; ++i) {
                logRecordArray[i] = (LogRecord)objectArray[i];
            }
            this.myLastFlush = System.currentTimeMillis();
            this.myLogger.write(logRecordArray);
        }
        if (AnalysisLogger.myTracer.isEntryEnabled()) {
            Tr.exit(AnalysisLogger.myTracer, "BufferManager.flush() exit");
        }
    }

    private void addContextListeners() {
        if (this.myContext != null) {
            ServletContextEventSource servletContextEventSource = (ServletContextEventSource)this.myContext.getAttribute("com.ibm.websphere.servlet.event.ServletContextEventSource");
            servletContextEventSource.addApplicationListener(this);
            servletContextEventSource.addServletInvocationListener(this);
        }
    }

    private void removeContextListener() {
        if (this.myContext != null) {
            ServletContextEventSource servletContextEventSource = (ServletContextEventSource)this.myContext.getAttribute("com.ibm.websphere.servlet.event.ServletContextEventSource");
            servletContextEventSource.removeApplicationListener(this);
            servletContextEventSource.removeServletInvocationListener(this);
        }
    }

    public Logger getLogger() {
        return this.myLogger;
    }

    public void onApplicationAvailableForService(ApplicationEvent applicationEvent) {
    }

    public void onApplicationStart(ApplicationEvent applicationEvent) {
    }

    public void onApplicationUnavailableForService(ApplicationEvent applicationEvent) {
    }

    public void onApplicationEnd(ApplicationEvent applicationEvent) {
        if (AnalysisLogger.myTracer.isEntryEnabled()) {
            Tr.entry(AnalysisLogger.myTracer, "onApplicationEnd");
        }
        this.terminate();
        if (AnalysisLogger.myTracer.isEntryEnabled()) {
            Tr.exit(AnalysisLogger.myTracer, "onApplicationEnd");
        }
    }

    public void onServletStartService(ServletInvocationEvent servletInvocationEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onServletFinishService(ServletInvocationEvent servletInvocationEvent) {
        if (AnalysisLogger.myTracer.isEntryEnabled()) {
            Tr.entry(AnalysisLogger.myTracer, "onServletFinishService");
        }
        HashMap hashMap = this.myCache;
        synchronized (hashMap) {
            block10: {
                int n = this.myCache.size();
                if (n > this.myMaxEntries) {
                    new LogThread().start();
                } else if (n > 0 && System.currentTimeMillis() - this.myLastFlush > 60000L) {
                    try {
                        this.flush();
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.als.BufferManager.onServletFinishService", (String)"241", (Object)this);
                        this.myLastX = exception;
                        if (!AnalysisLogger.myTracer.isDebugEnabled()) break block10;
                        AnalysisLogger.debug(exception);
                    }
                }
            }
        }
        if (AnalysisLogger.myTracer.isEntryEnabled()) {
            Tr.exit(AnalysisLogger.myTracer, "onServletFinishService");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        try {
            this.flush();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.als.BufferManager.terminate", (String)"290", (Object)this);
        }
        finally {
            try {
                this.removeContextListener();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.als.BufferManager.terminate", (String)"295", (Object)this);
            }
            if (AnalysisLogger.myTracer.isDebugEnabled()) {
                Tr.debug(AnalysisLogger.myTracer, "Terminating Logger");
            }
        }
    }

    public int getSize() {
        return this.myCache.size();
    }

    class LogThread
    extends Thread {
        LogThread() {
        }

        public void run() {
            block4: {
                if (AnalysisLogger.myTracer.isEntryEnabled()) {
                    Tr.entry(AnalysisLogger.myTracer, "LogThread starting");
                }
                try {
                    BufferManager.this.flush();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.als.BufferManager.run", (String)"272", (Object)this);
                    BufferManager.this.myLastX = exception;
                    if (!AnalysisLogger.myTracer.isDebugEnabled()) break block4;
                    AnalysisLogger.debug(exception);
                }
            }
            if (AnalysisLogger.myTracer.isEntryEnabled()) {
                Tr.exit(AnalysisLogger.myTracer, "LogThread exit");
            }
        }
    }
}

