/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vap.converters.streams;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class ContextObjectInputStream
extends ObjectInputStream {
    protected ContextObjectInputStream() throws IOException, SecurityException {
    }

    public ContextObjectInputStream(InputStream inputStream) throws IOException, StreamCorruptedException {
        super(inputStream);
    }

    protected ClassLoader getContextClassLoader() {
        ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread thread = Thread.currentThread();
                return thread == null ? null : thread.getContextClassLoader();
            }
        });
        return classLoader;
    }

    protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        ClassLoader classLoader = this.getContextClassLoader();
        if (classLoader == null) {
            return super.resolveClass(objectStreamClass);
        }
        return classLoader.loadClass(objectStreamClass.getName());
    }
}

