/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vap.converters;

import com.ibm.vap.converters.VapAbstractConverter;

public class VapCharToBoolean
extends VapAbstractConverter {
    static VapCharToBoolean singleton = null;
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1999, 2000";

    private boolean compareTrueCharsTo(char c) {
        return c == 'Y' || c == 'y' || c == 'T' || c == 't' || c == '1';
    }

    public Object dataFrom(Object object) {
        if (object == null) {
            return null;
        }
        return (Boolean)object != false ? new String("Y") : new String("N");
    }

    public static String[] getSourceDatatype() {
        return VapCharToBoolean.getStringDatatypes();
    }

    public static String getTargetClassName() {
        return "java.lang.Boolean";
    }

    public Object objectFrom(Object object) {
        if (object == null) {
            return null;
        }
        String string = object.toString();
        return new Boolean(!string.equals(null) && string.length() != 0 && this.compareTrueCharsTo(string.charAt(0)));
    }

    public static void reset() {
        singleton = null;
    }

    public static VapCharToBoolean singleton() {
        if (singleton == null) {
            singleton = new VapCharToBoolean();
        }
        return singleton;
    }
}

