/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vap.composers;

import java.io.Serializable;

public class VapUSPhoneNumber
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String areaCode;
    private String zonePrefix;
    private String fourDigitNumber;

    public VapUSPhoneNumber(String string) {
        this.fromString(string);
    }

    public VapUSPhoneNumber(String string, String string2, String string3) {
        this.setAreaCode(string);
        this.setZonePrefix(string2);
        this.setFourDigitNumber(string3);
    }

    public String getAreaCode() {
        if (this.areaCode == null) {
            this.areaCode = this.defaultAreaCode();
        }
        return this.areaCode;
    }

    public void setAreaCode(String string) {
        this.areaCode = string;
    }

    public String defaultAreaCode() {
        return "xxx";
    }

    public String defaultPhoneNumber() {
        return "xxxxxxx";
    }

    public String getFourDigitNumber() {
        return this.fourDigitNumber;
    }

    public void fromString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (Character.isDigit(c)) {
                stringBuffer.append(c);
            }
            ++n;
        }
        String string2 = stringBuffer.toString();
        if (string2.length() == 10) {
            this.setAreaCode(string2.substring(0, 3));
            this.setZonePrefix(string2.substring(3, 7));
            this.setFourDigitNumber(string2.substring(7));
        }
        if (string2.length() == 7) {
            this.setZonePrefix(string2.substring(0, 3));
            this.setFourDigitNumber(string2.substring(3));
        }
    }

    public boolean isValid() {
        return !this.getAreaCode().equals(this.defaultAreaCode()) && !this.phoneNumber().equals(this.defaultPhoneNumber());
    }

    public String phoneNumber() {
        if (this.zonePrefix == null || this.fourDigitNumber == null) {
            return this.defaultPhoneNumber();
        }
        return String.valueOf(this.zonePrefix) + this.fourDigitNumber;
    }

    public String getZonePrefix() {
        return this.zonePrefix;
    }

    public String toHyphenDelimitedString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getAreaCode());
        stringBuffer.append("-");
        stringBuffer.append(this.getZonePrefix());
        stringBuffer.append("-");
        stringBuffer.append(this.getFourDigitNumber());
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        stringBuffer.append(this.getAreaCode());
        stringBuffer.append(")");
        stringBuffer.append(this.getZonePrefix());
        stringBuffer.append("-");
        stringBuffer.append(this.getFourDigitNumber());
        return stringBuffer.toString();
    }

    public void setFourDigitNumber(String string) {
        this.fourDigitNumber = string;
    }

    public void setZonePrefix(String string) {
        this.zonePrefix = string;
    }
}

