/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uddi.datatype.business;

import com.ibm.uddi.UDDIElement;
import com.ibm.uddi.UDDIException;
import com.ibm.uddi.datatype.business.AddressLine;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Address
extends UDDIElement {
    public static final String UDDI_TAG = "address";
    protected Element base = null;
    String useType = null;
    String sortCode = null;
    Vector addressLine = new Vector();

    public Address() {
    }

    public Address(Element element) throws UDDIException {
        super(element);
        this.useType = element.getAttribute("useType");
        this.sortCode = element.getAttribute("sortCode");
        NodeList nodeList = null;
        nodeList = this.getChildElementsByTagName(element, "addressLine");
        int n = 0;
        while (n < nodeList.getLength()) {
            this.addressLine.addElement(new AddressLine((Element)nodeList.item(n)));
            ++n;
        }
    }

    public Vector getAddressLineStrings() {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < this.addressLine.size()) {
            vector.addElement(((AddressLine)this.addressLine.elementAt(n)).getText());
            ++n;
        }
        return vector;
    }

    public Vector getAddressLineVector() {
        return this.addressLine;
    }

    public String getSortCode() {
        return this.sortCode;
    }

    public String getUseType() {
        return this.useType;
    }

    public void saveToXML(Element element) {
        this.base = element.getOwnerDocument().createElement(UDDI_TAG);
        if (this.useType != null) {
            this.base.setAttribute("useType", this.useType);
        }
        if (this.sortCode != null) {
            this.base.setAttribute("sortCode", this.sortCode);
        }
        int n = 0;
        while (n < this.addressLine.size()) {
            ((AddressLine)this.addressLine.elementAt(n)).saveToXML(this.base);
            ++n;
        }
        element.appendChild(this.base);
    }

    public void setAddressLineStrings(Vector vector) {
        this.addressLine = new Vector();
        int n = 0;
        while (n < vector.size()) {
            this.addressLine.addElement(new AddressLine((String)vector.elementAt(n)));
            ++n;
        }
    }

    public void setAddressLineVector(Vector vector) {
        this.addressLine = vector;
    }

    public void setSortCode(String string) {
        this.sortCode = string;
    }

    public void setUseType(String string) {
        this.useType = string;
    }
}

