/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ras;

import com.ibm.ras.RASHandler;
import com.ibm.ras.RASIEvent;
import com.ibm.ras.RASIFormatter;
import java.awt.Font;
import java.awt.TextArea;

public class RASTextAreaHandler
extends RASHandler {
    private static final String S = "(C) Copyright IBM Corp. 1998.";
    private static final long serialVersionUID = -4711050944704086220L;
    private transient TextArea textArea;

    public RASTextAreaHandler() {
    }

    public RASTextAreaHandler(String name) {
        super(name);
    }

    public RASTextAreaHandler(String name, String desc) {
        super(name, desc);
    }

    public RASTextAreaHandler(String name, String desc, TextArea textArea) {
        super(name, desc);
        this.setTextArea(textArea);
    }

    protected void init() {
        super.init();
        this.textArea = new TextArea();
        this.textArea.setFont(new Font("Monospaced", 0, 12));
    }

    public TextArea getTextArea() {
        return this.textArea;
    }

    public void setTextArea(TextArea textArea) {
        if (textArea != null) {
            this.textArea = textArea;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openDevice() {
        Object object = this.deviceLock;
        synchronized (object) {
            this.deviceOpen = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeDevice() {
        Object object = this.deviceLock;
        synchronized (object) {
            this.deviceOpen = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeEvent(RASIEvent event2) {
        Object object = this.deviceLock;
        synchronized (object) {
            RASIFormatter formatter;
            if (!this.deviceOpen) {
                this.openDevice();
            }
            if (this.deviceOpen && (formatter = this.findFormatter(event2)) != null) {
                String msg = formatter.format(event2);
                this.textArea.append(msg + "\n");
            }
        }
    }
}

