/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.marshall.util;

import com.ibm.etools.marshall.util.ConversionUtils;
import com.ibm.etools.marshall.util.MarshallResource;
import java.io.UnsupportedEncodingException;

public class MarshallStringUtils {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    public static final int STRING_JUSTIFICATION_LEFT = 0;
    public static final int STRING_JUSTIFICATION_RIGHT = 1;
    public static final int STRING_JUSTIFICATION_CENTER = 2;
    private static final char DBCS_SPACE_CHAR = '\u3000';
    private static final String DBCS_SPACE_STRING = "\u3000";

    public static void marshallCharInfoBuffer(char c, byte[] byArray, int n, int n2, String string) throws IllegalArgumentException {
        String string2 = new Character(c).toString();
        byte[] byArray2 = null;
        try {
            byArray2 = string2.getBytes(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_CODEPAGE_NOT_SUPPORTED", string));
        }
        if (byArray2.length > n2) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_LENGTH_NOT_VALID", string2, Integer.toString(n2)));
        }
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        for (int i = byArray2.length; i < n2; ++i) {
            byArray[n + i] = 0;
        }
    }

    public static int marshallFixedLengthDBCSStringIntoBuffer(String string, byte[] byArray, int n, String string2, int n2, int n3, int n4, String string3, boolean bl) throws IllegalArgumentException {
        int n5;
        if (bl) {
            string = string.replace(' ', '\u3000');
        }
        byte[] byArray2 = null;
        try {
            byArray2 = string.getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_CODEPAGE_NOT_SUPPORTED", string2));
        }
        int n6 = byArray2.length;
        int n7 = 0;
        if (bl && byArray2.length != 0) {
            if (byArray2[0] == 14) {
                if (n6 - 2 > n3) {
                    throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_LENGTH_NOT_VALID", string, Integer.toString(n3)));
                }
                n7 = 1;
                n6 -= 2;
            } else if (n6 > n3) {
                throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_LENGTH_NOT_VALID", string, Integer.toString(n3)));
            }
        } else if (n6 > n3) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_LENGTH_NOT_VALID", string, Integer.toString(n3)));
        }
        int n8 = n6;
        switch (n4) {
            case 0: {
                System.arraycopy(byArray2, n7, byArray, n, n8);
                break;
            }
            case 1: {
                n5 = n3 - n8;
                System.arraycopy(byArray2, n7, byArray, n + n5, n8);
                n6 = n3;
                break;
            }
            case 2: {
                n5 = (n3 - n8) / 2;
                System.arraycopy(byArray2, n7, byArray, n + n5, n8);
                n6 = n3;
                break;
            }
            default: {
                throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_JUSTIFICATION_NOT_VALID", Integer.toString(n4)));
            }
        }
        if (string3 != null && (n5 = n3 - n8) > 0) {
            int n9;
            int n10;
            n6 = n3;
            byte[] byArray3 = null;
            if (bl && " ".equals(string3)) {
                string3 = DBCS_SPACE_STRING;
            }
            try {
                byArray3 = string3.getBytes(string2);
                if (byArray3.length > 0 && byArray3[0] == 14) {
                    n10 = 1;
                    n9 = byArray3.length - 1;
                    if (byArray3[n9] == 15) {
                        --n9;
                    }
                    byte[] byArray4 = new byte[n9];
                    System.arraycopy(byArray3, n10, byArray4, 0, n9);
                    byArray3 = byArray4;
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            switch (n4) {
                case 0: {
                    ConversionUtils.fillBytes(byArray3, byArray, n + n8, n5);
                    break;
                }
                case 1: {
                    ConversionUtils.fillBytes(byArray3, byArray, n, n5);
                    break;
                }
                case 2: {
                    n10 = n5 / 2;
                    n9 = n5 - n10;
                    ConversionUtils.fillBytes(byArray3, byArray, n, n10);
                    ConversionUtils.fillBytes(byArray3, byArray, n + n8, n9);
                }
            }
        }
        return n6;
    }

    public static int marshallFixedLengthStringIntoBuffer(String string, byte[] byArray, int n, String string2, int n2, int n3, String string3) throws IllegalArgumentException {
        int n4;
        byte[] byArray2 = null;
        try {
            byArray2 = string.getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_CODEPAGE_NOT_SUPPORTED", string2));
        }
        int n5 = byArray2.length;
        if (n5 > n2) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_LENGTH_NOT_VALID", string, Integer.toString(n2)));
        }
        switch (n3) {
            case 0: {
                System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                break;
            }
            case 1: {
                n4 = n2 - byArray2.length;
                System.arraycopy(byArray2, 0, byArray, n + n4, byArray2.length);
                n5 = n2;
                break;
            }
            case 2: {
                n5 = n2;
                n4 = (n2 - byArray2.length) / 2;
                System.arraycopy(byArray2, 0, byArray, n + n4, byArray2.length);
                break;
            }
            default: {
                throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_JUSTIFICATION_NOT_VALID", Integer.toString(n3)));
            }
        }
        if (string3 != null && (n4 = n2 - byArray2.length) > 0) {
            n5 = n2;
            byte[] byArray3 = null;
            try {
                byArray3 = string3.getBytes(string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            switch (n3) {
                case 0: {
                    ConversionUtils.fillBytes(byArray3[0], byArray, n + byArray2.length, n4);
                    break;
                }
                case 1: {
                    ConversionUtils.fillBytes(byArray3[0], byArray, n, n4);
                    break;
                }
                case 2: {
                    int n6 = n4 / 2;
                    int n7 = n4 - n6;
                    ConversionUtils.fillBytes(byArray3[0], byArray, n, n6);
                    ConversionUtils.fillBytes(byArray3[0], byArray, n + byArray2.length, n7);
                }
            }
        }
        return n5;
    }

    public static void marshallLengthPrefixedDBCSStringIntoBuffer(String string, byte[] byArray, int n, String string2, int n2, int n3, int n4, String string3, boolean bl, int n5, boolean bl2) throws IllegalArgumentException {
        int n6 = MarshallStringUtils.marshallFixedLengthDBCSStringIntoBuffer(string, byArray, n + n5, string2, n2, n3 - n5, n4, string3, bl2);
        byte[] byArray2 = null;
        switch (n5) {
            case 4: {
                byArray2 = ConversionUtils.convertToByte(n6);
                break;
            }
            case 2: {
                byArray2 = ConversionUtils.convertToByte((short)n6);
                break;
            }
            case 8: {
                byArray2 = ConversionUtils.convertToByte((long)n6);
                break;
            }
            case 1: {
                byArray2 = new byte[]{(byte)n6};
                break;
            }
            default: {
                throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_PREFIX_LENGTH_NOT_VALID", Integer.toString(n5)));
            }
        }
        if (!bl) {
            ConversionUtils.endianSwap(byArray2);
        }
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
    }

    public static void marshallLengthPrefixedStringIntoBuffer(String string, byte[] byArray, int n, String string2, int n2, int n3, String string3, boolean bl, int n4) throws IllegalArgumentException {
        int n5 = MarshallStringUtils.marshallFixedLengthStringIntoBuffer(string, byArray, n + n4, string2, n2 - n4, n3, string3);
        byte[] byArray2 = null;
        switch (n4) {
            case 4: {
                byArray2 = ConversionUtils.convertToByte(n5);
                break;
            }
            case 2: {
                byArray2 = ConversionUtils.convertToByte((short)n5);
                break;
            }
            case 8: {
                byArray2 = ConversionUtils.convertToByte((long)n5);
                break;
            }
            case 1: {
                byArray2 = new byte[]{(byte)n5};
                break;
            }
            default: {
                throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_PREFIX_LENGTH_NOT_VALID", Integer.toString(n4)));
            }
        }
        if (!bl) {
            ConversionUtils.endianSwap(byArray2);
        }
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
    }

    public static void marshallNullTerminatedDBCSStringIntoBuffer(String string, byte[] byArray, int n, String string2, int n2, int n3, boolean bl) throws IllegalArgumentException {
        if (!bl) {
            MarshallStringUtils.marshallNullTerminatedDBCSStringCharByChar(string, byArray, n, string2, n2, n3);
            return;
        }
        int n4 = MarshallStringUtils.marshallFixedLengthDBCSStringIntoBuffer(string, byArray, n, string2, n2, n3, 0, null, bl);
        for (int i = 0; i < n2 && n4 + i < n3; ++i) {
            byArray[n + n4 + i] = 0;
        }
    }

    private static void marshallNullTerminatedDBCSStringCharByChar(String string, byte[] byArray, int n, String string2, int n2, int n3) throws IllegalArgumentException {
        int n4;
        char[] cArray = string.toCharArray();
        if (cArray.length > (n4 = n3 / n2)) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_LENGTH_NOT_VALID", string, Integer.toString(n3)));
        }
        byte[] byArray2 = new byte[n3];
        for (int i = 0; i < cArray.length; ++i) {
            Character c = new Character(cArray[i]);
            try {
                byte[] byArray3 = c.toString().getBytes(string2);
                int n5 = i * n2;
                System.arraycopy(byArray3, 0, byArray2, n5, byArray3.length);
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_CODEPAGE_NOT_SUPPORTED", string2));
            }
        }
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
    }

    public static void marshallNullTerminatedStringIntoBuffer(String string, byte[] byArray, int n, String string2, int n2) throws IllegalArgumentException {
        byte[] byArray2 = null;
        try {
            byArray2 = string.getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_CODEPAGE_NOT_SUPPORTED", string2));
        }
        if (byArray2.length >= n2) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_LENGTH_NOT_VALID", string, Integer.toString(n2)));
        }
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        byArray[n + byArray2.length] = 0;
    }

    public static char unmarshallCharFromBuffer(byte[] byArray, int n, int n2, String string) throws IllegalArgumentException {
        String string2 = null;
        try {
            string2 = new String(byArray, n, n2, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_CODEPAGE_NOT_SUPPORTED", string));
        }
        char[] cArray = string2.toCharArray();
        return cArray[0];
    }

    private static byte[] fixInboundDBCSBuffer(byte[] byArray, int n, String string, int n2) throws IllegalArgumentException {
        byte[] byArray2 = null;
        byte by = 0;
        try {
            String string2 = " ";
            by = string2.getBytes(string)[0];
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_CODEPAGE_NOT_SUPPORTED", string));
        }
        if (by == 64) {
            byArray2 = new byte[n2 + 2];
            System.arraycopy(byArray, n, byArray2, 1, n2);
            byArray2[0] = 14;
            byArray2[byArray2.length - 1] = 15;
        } else {
            byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
        }
        return byArray2;
    }

    public static String unmarshallFixedLengthDBCSStringFromBuffer(byte[] byArray, int n, String string, int n2, boolean bl) throws IllegalArgumentException {
        byte[] byArray2 = null;
        if (bl) {
            byArray2 = MarshallStringUtils.fixInboundDBCSBuffer(byArray, n, string, n2);
            n2 = byArray2.length;
            n = 0;
        } else {
            byArray2 = byArray;
        }
        String string2 = null;
        try {
            string2 = new String(byArray2, n, n2, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_CODEPAGE_NOT_SUPPORTED", string));
        }
        return string2;
    }

    public static String unmarshallFixedLengthStringFromBuffer(byte[] byArray, int n, String string, int n2) throws IllegalArgumentException {
        if (byArray[n] == 0) {
            return "";
        }
        String string2 = null;
        try {
            string2 = new String(byArray, n, n2, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_CODEPAGE_NOT_SUPPORTED", string));
        }
        return string2;
    }

    public static String unmarshallLengthPrefixedDBCSStringFromBuffer(byte[] byArray, int n, String string, int n2, boolean bl, int n3, boolean bl2) throws IllegalArgumentException {
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n, byArray2, 0, n3);
        if (!bl) {
            ConversionUtils.endianSwap(byArray2);
        }
        int n4 = 0;
        switch (n3) {
            case 4: {
                n4 = ConversionUtils.convertFromByteToInt(byArray2);
                break;
            }
            case 2: {
                n4 = ConversionUtils.convertFromByteToShort(byArray2);
                break;
            }
            case 8: {
                n4 = (int)ConversionUtils.convertFromByteToLong(byArray2);
                break;
            }
            case 1: {
                n4 = byArray2[0];
                break;
            }
            default: {
                throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_PREFIX_LENGTH_NOT_VALID", Integer.toString(n3)));
            }
        }
        if (n4 > n2 - n3) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_PREFIX_LENGTH_NOT_VALID", Integer.toString(n4)));
        }
        byte[] byArray3 = null;
        int n5 = 0;
        if (bl2) {
            byArray3 = MarshallStringUtils.fixInboundDBCSBuffer(byArray, n + n3, string, n4);
            n4 = byArray3.length;
        } else {
            byArray3 = byArray;
            n5 = n + n3;
        }
        String string2 = null;
        try {
            string2 = new String(byArray3, n5, n4, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_CODEPAGE_NOT_SUPPORTED", string));
        }
        return string2;
    }

    public static String unmarshallLengthPrefixedStringFromBuffer(byte[] byArray, int n, String string, int n2, boolean bl, int n3) throws IllegalArgumentException {
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n, byArray2, 0, n3);
        if (!bl) {
            ConversionUtils.endianSwap(byArray2);
        }
        int n4 = 0;
        switch (n3) {
            case 4: {
                n4 = ConversionUtils.convertFromByteToInt(byArray2);
                break;
            }
            case 2: {
                n4 = ConversionUtils.convertFromByteToShort(byArray2);
                break;
            }
            case 8: {
                n4 = (int)ConversionUtils.convertFromByteToLong(byArray2);
                break;
            }
            case 1: {
                n4 = byArray2[0];
                break;
            }
            default: {
                throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_PREFIX_LENGTH_NOT_VALID", Integer.toString(n3)));
            }
        }
        if (n4 > n2 - n3) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_PREFIX_LENGTH_NOT_VALID", Integer.toString(n4)));
        }
        String string2 = null;
        try {
            string2 = new String(byArray, n + n3, n4, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_CODEPAGE_NOT_SUPPORTED", string));
        }
        return string2;
    }

    public static String unmarshallNullTerminatedDBCSStringFromBuffer(byte[] byArray, int n, String string, int n2, boolean bl, int n3) throws IllegalArgumentException {
        byte[] byArray2 = null;
        if (!bl) {
            return MarshallStringUtils.unmarshallNullTerminatedDBCSStringCharByChar(byArray, n, string, n2, n3);
        }
        byArray2 = MarshallStringUtils.fixInboundDBCSBuffer(byArray, n, string, n2);
        n2 = byArray2.length;
        n = 0;
        String string2 = null;
        try {
            string2 = new String(byArray2, n, n2, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_CODEPAGE_NOT_SUPPORTED", string));
        }
        int n4 = string2.indexOf(0);
        if (n4 != -1) {
            string2 = string2.substring(0, n4);
        }
        return string2;
    }

    public static String unmarshallNullTerminatedDBCSStringFromBuffer(byte[] byArray, int n, String string, int n2, boolean bl) throws IllegalArgumentException {
        return MarshallStringUtils.unmarshallNullTerminatedDBCSStringFromBuffer(byArray, n, string, n2, bl, 2);
    }

    private static String unmarshallNullTerminatedDBCSStringCharByChar(byte[] byArray, int n, String string, int n2, int n3) throws IllegalArgumentException {
        int n4;
        int n5 = n2 / n3;
        StringBuffer stringBuffer = new StringBuffer(n5);
        for (int i = 0; i < n5; ++i) {
            try {
                n4 = n + i * n3;
                String string2 = new String(byArray, n4, n3, string);
                int n6 = string2.indexOf(0);
                if (n6 != -1) {
                    string2 = string2.substring(0, n6);
                }
                stringBuffer.append(string2);
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_CODEPAGE_NOT_SUPPORTED", string));
            }
        }
        String string3 = stringBuffer.toString();
        n4 = string3.indexOf(0);
        if (n4 != -1) {
            string3 = string3.substring(0, n4);
        }
        return string3;
    }

    public static String unmarshallNullTerminatedStringFromBuffer(byte[] byArray, int n, String string, int n2) throws IllegalArgumentException {
        String string2 = null;
        try {
            string2 = new String(byArray, n, n2, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_CODEPAGE_NOT_SUPPORTED", string));
        }
        int n3 = string2.indexOf(0);
        if (n3 != -1) {
            string2 = string2.substring(0, n3);
        }
        return string2;
    }

    public static int marshallFixedLengthUnicodeDBCSStringIntoBuffer(String string, byte[] byArray, int n, String string2, int n2, int n3, int n4, String string3, boolean bl) throws IllegalArgumentException {
        int n5;
        byte[] byArray2 = null;
        try {
            byArray2 = string.getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_CODEPAGE_NOT_SUPPORTED", string2));
        }
        int n6 = byArray2.length;
        int n7 = 0;
        if (n6 > n3) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_LENGTH_NOT_VALID", string, Integer.toString(n3)));
        }
        int n8 = n6;
        switch (n4) {
            case 0: {
                System.arraycopy(byArray2, n7, byArray, n, n8);
                break;
            }
            case 1: {
                n5 = n3 - n8;
                System.arraycopy(byArray2, n7, byArray, n + n5, n8);
                n6 = n3;
                break;
            }
            case 2: {
                n5 = (n3 - n8) / 2;
                System.arraycopy(byArray2, n7, byArray, n + n5, n8);
                n6 = n3;
                break;
            }
            default: {
                throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_JUSTIFICATION_NOT_VALID", Integer.toString(n4)));
            }
        }
        if (string3 != null && (n5 = n3 - n8) > 0) {
            n6 = n3;
            byte[] byArray3 = null;
            try {
                byArray3 = string3.getBytes(string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            switch (n4) {
                case 0: {
                    ConversionUtils.fillBytes(byArray3, byArray, n + n8, n5);
                    break;
                }
                case 1: {
                    ConversionUtils.fillBytes(byArray3, byArray, n, n5);
                    break;
                }
                case 2: {
                    int n9 = n5 / 2;
                    int n10 = n5 - n9;
                    ConversionUtils.fillBytes(byArray3, byArray, n, n9);
                    ConversionUtils.fillBytes(byArray3, byArray, n + n8, n10);
                }
            }
        }
        return n6;
    }

    public static void marshallLengthPrefixedUnicodeDBCSStringIntoBuffer(String string, byte[] byArray, int n, String string2, int n2, int n3, int n4, String string3, boolean bl, int n5, boolean bl2) throws IllegalArgumentException {
        int n6 = MarshallStringUtils.marshallFixedLengthUnicodeDBCSStringIntoBuffer(string, byArray, n + n5, string2, n2, n3 - n5, n4, string3, bl2);
        byte[] byArray2 = null;
        switch (n5) {
            case 4: {
                byArray2 = ConversionUtils.convertToByte(n6);
                break;
            }
            case 2: {
                byArray2 = ConversionUtils.convertToByte((short)n6);
                break;
            }
            case 8: {
                byArray2 = ConversionUtils.convertToByte((long)n6);
                break;
            }
            case 1: {
                byArray2 = new byte[]{(byte)n6};
                break;
            }
            default: {
                throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_PREFIX_LENGTH_NOT_VALID", Integer.toString(n5)));
            }
        }
        if (!bl) {
            ConversionUtils.endianSwap(byArray2);
        }
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
    }

    public static void marshallNullTerminatedUnicodeDBCSStringIntoBuffer(String string, byte[] byArray, int n, String string2, int n2, int n3, boolean bl) throws IllegalArgumentException {
        int n4 = MarshallStringUtils.marshallFixedLengthUnicodeDBCSStringIntoBuffer(string, byArray, n, string2, n2, n3, 0, null, bl);
        for (int i = 0; i < n2 && n4 + i < n3; ++i) {
            byArray[n + n4 + i] = 0;
        }
    }

    public static String unmarshallFixedLengthUnicodeDBCSStringFromBuffer(byte[] byArray, int n, String string, int n2, boolean bl) throws IllegalArgumentException {
        String string2 = null;
        try {
            string2 = new String(byArray, n, n2, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_CODEPAGE_NOT_SUPPORTED", string));
        }
        return string2;
    }

    public static String unmarshallLengthPrefixedUnicodeDBCSStringFromBuffer(byte[] byArray, int n, String string, int n2, boolean bl, int n3, boolean bl2) throws IllegalArgumentException {
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n, byArray2, 0, n3);
        if (!bl) {
            ConversionUtils.endianSwap(byArray2);
        }
        int n4 = 0;
        switch (n3) {
            case 4: {
                n4 = ConversionUtils.convertFromByteToInt(byArray2);
                break;
            }
            case 2: {
                n4 = ConversionUtils.convertFromByteToShort(byArray2);
                break;
            }
            case 8: {
                n4 = (int)ConversionUtils.convertFromByteToLong(byArray2);
                break;
            }
            case 1: {
                n4 = byArray2[0];
                break;
            }
            default: {
                throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_PREFIX_LENGTH_NOT_VALID", Integer.toString(n3)));
            }
        }
        if (n4 > n2 - n3) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_PREFIX_LENGTH_NOT_VALID", Integer.toString(n4)));
        }
        int n5 = n + n3;
        String string2 = null;
        try {
            string2 = new String(byArray, n5, n4, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_CODEPAGE_NOT_SUPPORTED", string));
        }
        return string2;
    }

    public static String unmarshallNullTerminatedUnicodeDBCSStringFromBuffer(byte[] byArray, int n, String string, int n2, boolean bl, int n3) throws IllegalArgumentException {
        String string2 = null;
        try {
            string2 = new String(byArray, n, n2, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_STR_CODEPAGE_NOT_SUPPORTED", string));
        }
        int n4 = string2.indexOf(0);
        if (n4 != -1) {
            string2 = string2.substring(0, n4);
        }
        return string2;
    }
}

