/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.marshall.util;

import com.ibm.etools.marshall.util.IRangeObject;

public class CharacterRange
implements IRangeObject {
    private static String copyright = "(c) Copyright IBM Corporation 1999, 2004.";
    static final long serialVersionUID = -4062258957317422887L;
    protected char lowerRange_;
    protected char upperRange_;

    public CharacterRange() {
        this.lowerRange_ = (char)65;
        this.upperRange_ = (char)65;
    }

    public CharacterRange(char c, char c2) throws IllegalArgumentException {
        if (!Character.isLetter(c)) {
            throw new IllegalArgumentException(new Character(c).toString());
        }
        if (!Character.isLetter(c2)) {
            throw new IllegalArgumentException(new Character(c2).toString());
        }
        if (c2 < c) {
            throw new IllegalArgumentException(new Character(c2).toString());
        }
        this.lowerRange_ = c;
        this.upperRange_ = c2;
    }

    public Object clone() {
        try {
            CharacterRange characterRange = (CharacterRange)super.clone();
            return characterRange;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.getMessage());
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof CharacterRange)) {
            return false;
        }
        CharacterRange characterRange = (CharacterRange)object;
        if (this.lowerRange_ != characterRange.lowerRange_) {
            return false;
        }
        return this.upperRange_ == characterRange.upperRange_;
    }

    public Object getLowerRange() {
        return new Character(this.lowerRange_);
    }

    public Object[] getRangeValues() {
        int n = 0;
        for (int i = this.lowerRange_; i <= this.upperRange_; ++i) {
            if (!Character.isLetter((char)i)) continue;
            ++n;
        }
        Object[] objectArray = new Character[n];
        int n2 = 0;
        for (int i = this.lowerRange_; i <= this.upperRange_; ++i) {
            if (!Character.isLetter((char)i)) continue;
            objectArray[n2] = new Character((char)i);
            ++n2;
        }
        return objectArray;
    }

    public Object getUpperRange() {
        return new Character(this.upperRange_);
    }

    public static boolean isInRange(char c, char c2, char c3) throws IllegalArgumentException {
        if (!Character.isLetter(c)) {
            throw new IllegalArgumentException(new Character(c).toString());
        }
        if (!Character.isLetter(c2)) {
            throw new IllegalArgumentException(new Character(c2).toString());
        }
        if (!Character.isLetter(c3)) {
            throw new IllegalArgumentException(new Character(c3).toString());
        }
        if (c2 < c) {
            throw new IllegalArgumentException(new Character(c2).toString());
        }
        return c3 >= c && c3 <= c2;
    }

    public boolean isInRange(Object object) {
        if (!(object instanceof Character)) {
            return false;
        }
        char c = ((Character)object).charValue();
        return CharacterRange.isInRange(this.lowerRange_, this.upperRange_, c);
    }

    public void setLowerRange(Object object) throws IllegalArgumentException {
        if (!(object instanceof Character)) {
            throw new IllegalArgumentException(object.toString());
        }
        this.lowerRange_ = ((Character)object).charValue();
    }

    public void setUpperRange(Object object) throws IllegalArgumentException {
        if (!(object instanceof Character)) {
            throw new IllegalArgumentException(object.toString());
        }
        this.upperRange_ = ((Character)object).charValue();
    }
}

